# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ObsBucketAclArgs', 'ObsBucketAcl']

@pulumi.input_type
class ObsBucketAclArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]]] = None,
                 log_delivery_user_permission: Optional[pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs']] = None,
                 owner_permission: Optional[pulumi.Input['ObsBucketAclOwnerPermissionArgs']] = None,
                 public_permission: Optional[pulumi.Input['ObsBucketAclPublicPermissionArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ObsBucketAcl resource.
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to set the acl.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]] account_permissions: Specifies the account permissions.
               The account_permission_struct structure is documented below.
               
               <a name="OBSBucketAcl_permission_struct"></a>
               The `permission_struct` block supports:
        :param pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs'] log_delivery_user_permission: Specifies the log delivery user permission.
               The permission_struct structure is documented below.
        :param pulumi.Input['ObsBucketAclOwnerPermissionArgs'] owner_permission: Specifies the bucket owner permission. If omitted, the current obs bucket acl
               owner permission will not be changed.
               The permission_struct structure is documented below.
        :param pulumi.Input['ObsBucketAclPublicPermissionArgs'] public_permission: Specifies the public permission.
               The permission_struct structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "bucket", bucket)
        if account_permissions is not None:
            pulumi.set(__self__, "account_permissions", account_permissions)
        if log_delivery_user_permission is not None:
            pulumi.set(__self__, "log_delivery_user_permission", log_delivery_user_permission)
        if owner_permission is not None:
            pulumi.set(__self__, "owner_permission", owner_permission)
        if public_permission is not None:
            pulumi.set(__self__, "public_permission", public_permission)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the bucket to which to set the acl.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="accountPermissions")
    def account_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]]]:
        """
        Specifies the account permissions.
        The account_permission_struct structure is documented below.

        <a name="OBSBucketAcl_permission_struct"></a>
        The `permission_struct` block supports:
        """
        return pulumi.get(self, "account_permissions")

    @account_permissions.setter
    def account_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]]]):
        pulumi.set(self, "account_permissions", value)

    @_builtins.property
    @pulumi.getter(name="logDeliveryUserPermission")
    def log_delivery_user_permission(self) -> Optional[pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs']]:
        """
        Specifies the log delivery user permission.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "log_delivery_user_permission")

    @log_delivery_user_permission.setter
    def log_delivery_user_permission(self, value: Optional[pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs']]):
        pulumi.set(self, "log_delivery_user_permission", value)

    @_builtins.property
    @pulumi.getter(name="ownerPermission")
    def owner_permission(self) -> Optional[pulumi.Input['ObsBucketAclOwnerPermissionArgs']]:
        """
        Specifies the bucket owner permission. If omitted, the current obs bucket acl
        owner permission will not be changed.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "owner_permission")

    @owner_permission.setter
    def owner_permission(self, value: Optional[pulumi.Input['ObsBucketAclOwnerPermissionArgs']]):
        pulumi.set(self, "owner_permission", value)

    @_builtins.property
    @pulumi.getter(name="publicPermission")
    def public_permission(self) -> Optional[pulumi.Input['ObsBucketAclPublicPermissionArgs']]:
        """
        Specifies the public permission.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "public_permission")

    @public_permission.setter
    def public_permission(self, value: Optional[pulumi.Input['ObsBucketAclPublicPermissionArgs']]):
        pulumi.set(self, "public_permission", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ObsBucketAclState:
    def __init__(__self__, *,
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_user_permission: Optional[pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs']] = None,
                 owner_permission: Optional[pulumi.Input['ObsBucketAclOwnerPermissionArgs']] = None,
                 public_permission: Optional[pulumi.Input['ObsBucketAclPublicPermissionArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ObsBucketAcl resources.
        :param pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]] account_permissions: Specifies the account permissions.
               The account_permission_struct structure is documented below.
               
               <a name="OBSBucketAcl_permission_struct"></a>
               The `permission_struct` block supports:
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to set the acl.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs'] log_delivery_user_permission: Specifies the log delivery user permission.
               The permission_struct structure is documented below.
        :param pulumi.Input['ObsBucketAclOwnerPermissionArgs'] owner_permission: Specifies the bucket owner permission. If omitted, the current obs bucket acl
               owner permission will not be changed.
               The permission_struct structure is documented below.
        :param pulumi.Input['ObsBucketAclPublicPermissionArgs'] public_permission: Specifies the public permission.
               The permission_struct structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               
               Changing this parameter will create a new resource.
        """
        if account_permissions is not None:
            pulumi.set(__self__, "account_permissions", account_permissions)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if log_delivery_user_permission is not None:
            pulumi.set(__self__, "log_delivery_user_permission", log_delivery_user_permission)
        if owner_permission is not None:
            pulumi.set(__self__, "owner_permission", owner_permission)
        if public_permission is not None:
            pulumi.set(__self__, "public_permission", public_permission)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="accountPermissions")
    def account_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]]]:
        """
        Specifies the account permissions.
        The account_permission_struct structure is documented below.

        <a name="OBSBucketAcl_permission_struct"></a>
        The `permission_struct` block supports:
        """
        return pulumi.get(self, "account_permissions")

    @account_permissions.setter
    def account_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ObsBucketAclAccountPermissionArgs']]]]):
        pulumi.set(self, "account_permissions", value)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the bucket to which to set the acl.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="logDeliveryUserPermission")
    def log_delivery_user_permission(self) -> Optional[pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs']]:
        """
        Specifies the log delivery user permission.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "log_delivery_user_permission")

    @log_delivery_user_permission.setter
    def log_delivery_user_permission(self, value: Optional[pulumi.Input['ObsBucketAclLogDeliveryUserPermissionArgs']]):
        pulumi.set(self, "log_delivery_user_permission", value)

    @_builtins.property
    @pulumi.getter(name="ownerPermission")
    def owner_permission(self) -> Optional[pulumi.Input['ObsBucketAclOwnerPermissionArgs']]:
        """
        Specifies the bucket owner permission. If omitted, the current obs bucket acl
        owner permission will not be changed.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "owner_permission")

    @owner_permission.setter
    def owner_permission(self, value: Optional[pulumi.Input['ObsBucketAclOwnerPermissionArgs']]):
        pulumi.set(self, "owner_permission", value)

    @_builtins.property
    @pulumi.getter(name="publicPermission")
    def public_permission(self) -> Optional[pulumi.Input['ObsBucketAclPublicPermissionArgs']]:
        """
        Specifies the public permission.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "public_permission")

    @public_permission.setter
    def public_permission(self, value: Optional[pulumi.Input['ObsBucketAclPublicPermissionArgs']]):
        pulumi.set(self, "public_permission", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/obsBucketAcl:ObsBucketAcl")
class ObsBucketAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObsBucketAclAccountPermissionArgs', 'ObsBucketAclAccountPermissionArgsDict']]]]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_user_permission: Optional[pulumi.Input[Union['ObsBucketAclLogDeliveryUserPermissionArgs', 'ObsBucketAclLogDeliveryUserPermissionArgsDict']]] = None,
                 owner_permission: Optional[pulumi.Input[Union['ObsBucketAclOwnerPermissionArgs', 'ObsBucketAclOwnerPermissionArgsDict']]] = None,
                 public_permission: Optional[pulumi.Input[Union['ObsBucketAclPublicPermissionArgs', 'ObsBucketAclPublicPermissionArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an OBS bucket acl resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        bucket = config.require_object("bucket")
        account1 = config.require_object("account1")
        account2 = config.require_object("account2")
        test = sbercloud.ObsBucketAcl("test",
            bucket=bucket,
            owner_permission={
                "access_to_buckets": [
                    "READ",
                    "WRITE",
                ],
                "access_to_acls": [
                    "READ_ACP",
                    "WRITE_ACP",
                ],
            },
            account_permissions=[
                {
                    "access_to_buckets": [
                        "READ",
                        "WRITE",
                    ],
                    "access_to_acls": [
                        "READ_ACP",
                        "WRITE_ACP",
                    ],
                    "account_id": account1,
                },
                {
                    "access_to_buckets": ["READ"],
                    "access_to_acls": [
                        "READ_ACP",
                        "WRITE_ACP",
                    ],
                    "account_id": account2,
                },
            ],
            public_permission={
                "access_to_buckets": [
                    "READ",
                    "WRITE",
                ],
            },
            log_delivery_user_permission={
                "access_to_buckets": [
                    "READ",
                    "WRITE",
                ],
                "access_to_acls": [
                    "READ_ACP",
                    "WRITE_ACP",
                ],
            })
        ```

        ## Import

        The obs bucket acl can be imported using the `bucket`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/obsBucketAcl:ObsBucketAcl test <bucket-name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObsBucketAclAccountPermissionArgs', 'ObsBucketAclAccountPermissionArgsDict']]]] account_permissions: Specifies the account permissions.
               The account_permission_struct structure is documented below.
               
               <a name="OBSBucketAcl_permission_struct"></a>
               The `permission_struct` block supports:
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to set the acl.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['ObsBucketAclLogDeliveryUserPermissionArgs', 'ObsBucketAclLogDeliveryUserPermissionArgsDict']] log_delivery_user_permission: Specifies the log delivery user permission.
               The permission_struct structure is documented below.
        :param pulumi.Input[Union['ObsBucketAclOwnerPermissionArgs', 'ObsBucketAclOwnerPermissionArgsDict']] owner_permission: Specifies the bucket owner permission. If omitted, the current obs bucket acl
               owner permission will not be changed.
               The permission_struct structure is documented below.
        :param pulumi.Input[Union['ObsBucketAclPublicPermissionArgs', 'ObsBucketAclPublicPermissionArgsDict']] public_permission: Specifies the public permission.
               The permission_struct structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ObsBucketAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an OBS bucket acl resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        bucket = config.require_object("bucket")
        account1 = config.require_object("account1")
        account2 = config.require_object("account2")
        test = sbercloud.ObsBucketAcl("test",
            bucket=bucket,
            owner_permission={
                "access_to_buckets": [
                    "READ",
                    "WRITE",
                ],
                "access_to_acls": [
                    "READ_ACP",
                    "WRITE_ACP",
                ],
            },
            account_permissions=[
                {
                    "access_to_buckets": [
                        "READ",
                        "WRITE",
                    ],
                    "access_to_acls": [
                        "READ_ACP",
                        "WRITE_ACP",
                    ],
                    "account_id": account1,
                },
                {
                    "access_to_buckets": ["READ"],
                    "access_to_acls": [
                        "READ_ACP",
                        "WRITE_ACP",
                    ],
                    "account_id": account2,
                },
            ],
            public_permission={
                "access_to_buckets": [
                    "READ",
                    "WRITE",
                ],
            },
            log_delivery_user_permission={
                "access_to_buckets": [
                    "READ",
                    "WRITE",
                ],
                "access_to_acls": [
                    "READ_ACP",
                    "WRITE_ACP",
                ],
            })
        ```

        ## Import

        The obs bucket acl can be imported using the `bucket`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/obsBucketAcl:ObsBucketAcl test <bucket-name>
        ```

        :param str resource_name: The name of the resource.
        :param ObsBucketAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ObsBucketAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObsBucketAclAccountPermissionArgs', 'ObsBucketAclAccountPermissionArgsDict']]]]] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 log_delivery_user_permission: Optional[pulumi.Input[Union['ObsBucketAclLogDeliveryUserPermissionArgs', 'ObsBucketAclLogDeliveryUserPermissionArgsDict']]] = None,
                 owner_permission: Optional[pulumi.Input[Union['ObsBucketAclOwnerPermissionArgs', 'ObsBucketAclOwnerPermissionArgsDict']]] = None,
                 public_permission: Optional[pulumi.Input[Union['ObsBucketAclPublicPermissionArgs', 'ObsBucketAclPublicPermissionArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ObsBucketAclArgs.__new__(ObsBucketAclArgs)

            __props__.__dict__["account_permissions"] = account_permissions
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["log_delivery_user_permission"] = log_delivery_user_permission
            __props__.__dict__["owner_permission"] = owner_permission
            __props__.__dict__["public_permission"] = public_permission
            __props__.__dict__["region"] = region
        super(ObsBucketAcl, __self__).__init__(
            'sbercloud:index/obsBucketAcl:ObsBucketAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ObsBucketAclAccountPermissionArgs', 'ObsBucketAclAccountPermissionArgsDict']]]]] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            log_delivery_user_permission: Optional[pulumi.Input[Union['ObsBucketAclLogDeliveryUserPermissionArgs', 'ObsBucketAclLogDeliveryUserPermissionArgsDict']]] = None,
            owner_permission: Optional[pulumi.Input[Union['ObsBucketAclOwnerPermissionArgs', 'ObsBucketAclOwnerPermissionArgsDict']]] = None,
            public_permission: Optional[pulumi.Input[Union['ObsBucketAclPublicPermissionArgs', 'ObsBucketAclPublicPermissionArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'ObsBucketAcl':
        """
        Get an existing ObsBucketAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ObsBucketAclAccountPermissionArgs', 'ObsBucketAclAccountPermissionArgsDict']]]] account_permissions: Specifies the account permissions.
               The account_permission_struct structure is documented below.
               
               <a name="OBSBucketAcl_permission_struct"></a>
               The `permission_struct` block supports:
        :param pulumi.Input[_builtins.str] bucket: Specifies the name of the bucket to which to set the acl.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['ObsBucketAclLogDeliveryUserPermissionArgs', 'ObsBucketAclLogDeliveryUserPermissionArgsDict']] log_delivery_user_permission: Specifies the log delivery user permission.
               The permission_struct structure is documented below.
        :param pulumi.Input[Union['ObsBucketAclOwnerPermissionArgs', 'ObsBucketAclOwnerPermissionArgsDict']] owner_permission: Specifies the bucket owner permission. If omitted, the current obs bucket acl
               owner permission will not be changed.
               The permission_struct structure is documented below.
        :param pulumi.Input[Union['ObsBucketAclPublicPermissionArgs', 'ObsBucketAclPublicPermissionArgsDict']] public_permission: Specifies the public permission.
               The permission_struct structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ObsBucketAclState.__new__(_ObsBucketAclState)

        __props__.__dict__["account_permissions"] = account_permissions
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["log_delivery_user_permission"] = log_delivery_user_permission
        __props__.__dict__["owner_permission"] = owner_permission
        __props__.__dict__["public_permission"] = public_permission
        __props__.__dict__["region"] = region
        return ObsBucketAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountPermissions")
    def account_permissions(self) -> pulumi.Output[Optional[Sequence['outputs.ObsBucketAclAccountPermission']]]:
        """
        Specifies the account permissions.
        The account_permission_struct structure is documented below.

        <a name="OBSBucketAcl_permission_struct"></a>
        The `permission_struct` block supports:
        """
        return pulumi.get(self, "account_permissions")

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the bucket to which to set the acl.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="logDeliveryUserPermission")
    def log_delivery_user_permission(self) -> pulumi.Output[Optional['outputs.ObsBucketAclLogDeliveryUserPermission']]:
        """
        Specifies the log delivery user permission.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "log_delivery_user_permission")

    @_builtins.property
    @pulumi.getter(name="ownerPermission")
    def owner_permission(self) -> pulumi.Output['outputs.ObsBucketAclOwnerPermission']:
        """
        Specifies the bucket owner permission. If omitted, the current obs bucket acl
        owner permission will not be changed.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "owner_permission")

    @_builtins.property
    @pulumi.getter(name="publicPermission")
    def public_permission(self) -> pulumi.Output[Optional['outputs.ObsBucketAclPublicPermission']]:
        """
        Specifies the public permission.
        The permission_struct structure is documented below.
        """
        return pulumi.get(self, "public_permission")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

