# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BackupDatabaseArgs',
    'BackupDatabaseArgsDict',
    'InstanceBackupStrategyArgs',
    'InstanceBackupStrategyArgsDict',
    'InstanceDbArgs',
    'InstanceDbArgsDict',
    'InstanceMsdtcHostArgs',
    'InstanceMsdtcHostArgsDict',
    'InstanceNodeArgs',
    'InstanceNodeArgsDict',
    'InstanceParameterArgs',
    'InstanceParameterArgsDict',
    'InstanceRestoreArgs',
    'InstanceRestoreArgsDict',
    'InstanceVolumeArgs',
    'InstanceVolumeArgsDict',
    'MysqlDatabasePrivilegeUserArgs',
    'MysqlDatabasePrivilegeUserArgsDict',
    'MysqlDatabaseTableRestoreDatabaseArgs',
    'MysqlDatabaseTableRestoreDatabaseArgsDict',
    'MysqlDatabaseTableRestoreRestoreTableArgs',
    'MysqlDatabaseTableRestoreRestoreTableArgsDict',
    'MysqlDatabaseTableRestoreRestoreTableTableArgs',
    'MysqlDatabaseTableRestoreRestoreTableTableArgsDict',
    'ParametergroupConfigurationParameterArgs',
    'ParametergroupConfigurationParameterArgsDict',
    'ParametergroupDatastoreArgs',
    'ParametergroupDatastoreArgsDict',
    'PgAccountAttributeArgs',
    'PgAccountAttributeArgsDict',
    'PgHbaHostBasedAuthenticationArgs',
    'PgHbaHostBasedAuthenticationArgsDict',
    'ReadReplicaInstanceDbArgs',
    'ReadReplicaInstanceDbArgsDict',
    'ReadReplicaInstanceParameterArgs',
    'ReadReplicaInstanceParameterArgsDict',
    'ReadReplicaInstanceVolumeArgs',
    'ReadReplicaInstanceVolumeArgsDict',
    'SqlserverDatabasePrivilegeUserArgs',
    'SqlserverDatabasePrivilegeUserArgsDict',
]

MYPY = False

if not MYPY:
    class BackupDatabaseArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Database to be backed up for Microsoft SQL Server.
        """
elif False:
    BackupDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BackupDatabaseArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Database to be backed up for Microsoft SQL Server.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Database to be backed up for Microsoft SQL Server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class InstanceBackupStrategyArgsDict(TypedDict):
        start_time: pulumi.Input[_builtins.str]
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the **hh:mm-HH:MM**
        format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
        MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
        00.
        """
        keep_days: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the retention days for specific backup files. The value range is from 0 to 732.

        > **NOTE:** Primary/standby DB instances of Microsoft SQL Server do not support disabling the automated backup
        policy.
        """
        period: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the backup cycle. Automatic backups will be performed on the specified days of
        the week, except when disabling the automatic backup policy. The value range is a comma-separated number, where each
        number represents a day of the week. For example, a value of 1,2,3,4 would set the backup cycle to Monday, Tuesday,
        Wednesday, and Thursday. The default value is 1,2,3,4,5,6,7.
        """
elif False:
    InstanceBackupStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceBackupStrategyArgs:
    def __init__(__self__, *,
                 start_time: pulumi.Input[_builtins.str],
                 keep_days: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the **hh:mm-HH:MM**
               format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
               MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
               00.
        :param pulumi.Input[_builtins.int] keep_days: Specifies the retention days for specific backup files. The value range is from 0 to 732.
               
               > **NOTE:** Primary/standby DB instances of Microsoft SQL Server do not support disabling the automated backup
               policy.
        :param pulumi.Input[_builtins.str] period: Specifies the backup cycle. Automatic backups will be performed on the specified days of
               the week, except when disabling the automatic backup policy. The value range is a comma-separated number, where each
               number represents a day of the week. For example, a value of 1,2,3,4 would set the backup cycle to Monday, Tuesday,
               Wednesday, and Thursday. The default value is 1,2,3,4,5,6,7.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the **hh:mm-HH:MM**
        format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
        MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
        00.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the retention days for specific backup files. The value range is from 0 to 732.

        > **NOTE:** Primary/standby DB instances of Microsoft SQL Server do not support disabling the automated backup
        policy.
        """
        return pulumi.get(self, "keep_days")

    @keep_days.setter
    def keep_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "keep_days", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the backup cycle. Automatic backups will be performed on the specified days of
        the week, except when disabling the automatic backup policy. The value range is a comma-separated number, where each
        number represents a day of the week. For example, a value of 1,2,3,4 would set the backup cycle to Monday, Tuesday,
        Wednesday, and Thursday. The default value is 1,2,3,4,5,6,7.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period", value)


if not MYPY:
    class InstanceDbArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the DB engine. Available value are **MySQL**, **PostgreSQL**
        and **SQLServer**. Changing this parameter will create a new resource.
        """
        version: pulumi.Input[_builtins.str]
        """
        Specifies the database version. Changing this parameter will create a new
        resource.
        """
        password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the database password. The value should contain 8 to 32 characters,
        including uppercase and lowercase letters, digits, and the following special characters: ~!@#%^*-_=+? You are advised
        to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the database port.
        + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
        + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
        default value is 1433.
        + The MariaDB database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        """
        user_name: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    InstanceDbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDbArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the DB engine. Available value are **MySQL**, **PostgreSQL**
               and **SQLServer**. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] version: Specifies the database version. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] password: Specifies the database password. The value should contain 8 to 32 characters,
               including uppercase and lowercase letters, digits, and the following special characters: ~!@#%^*-_=+? You are advised
               to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param pulumi.Input[_builtins.int] port: Specifies the database port.
               + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
               and cannot be used). The default value is 3306.
               + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
               + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
               default value is 1433.
               + The MariaDB database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
               and cannot be used). The default value is 3306.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the DB engine. Available value are **MySQL**, **PostgreSQL**
        and **SQLServer**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the database version. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database password. The value should contain 8 to 32 characters,
        including uppercase and lowercase letters, digits, and the following special characters: ~!@#%^*-_=+? You are advised
        to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the database port.
        + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
        + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
        default value is 1433.
        + The MariaDB database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)


if not MYPY:
    class InstanceMsdtcHostArgsDict(TypedDict):
        host_name: pulumi.Input[_builtins.str]
        """
        Specifies the host name.
        """
        ip: pulumi.Input[_builtins.str]
        """
        Specifies the host IP address.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the host ID.
        """
elif False:
    InstanceMsdtcHostArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceMsdtcHostArgs:
    def __init__(__self__, *,
                 host_name: pulumi.Input[_builtins.str],
                 ip: pulumi.Input[_builtins.str],
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] host_name: Specifies the host name.
        :param pulumi.Input[_builtins.str] ip: Specifies the host IP address.
        :param pulumi.Input[_builtins.str] id: Indicates the host ID.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "ip", ip)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the host name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the host IP address.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the host ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class InstanceNodeArgsDict(TypedDict):
        availability_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the host ID.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        role: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node type. The value can be master or slave, indicating the primary node or standby node
        respectively.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the node status.
        """
elif False:
    InstanceNodeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNodeArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] id: Indicates the host ID.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[_builtins.str] role: Indicates the node type. The value can be master or slave, indicating the primary node or standby node
               respectively.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the host ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node type. The value can be master or slave, indicating the primary node or standby node
        respectively.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class InstanceParameterArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the parameter name. Some of them needs the instance to be restarted
        to take effect.
        """
        value: pulumi.Input[_builtins.str]
        """
        Specifies the parameter value.

        <a name="RdsInstance_MsdtcHosts"></a>
        The `msdtc_hosts` block supports:
        """
elif False:
    InstanceParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the parameter name. Some of them needs the instance to be restarted
               to take effect.
        :param pulumi.Input[_builtins.str] value: Specifies the parameter value.
               
               <a name="RdsInstance_MsdtcHosts"></a>
               The `msdtc_hosts` block supports:
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the parameter name. Some of them needs the instance to be restarted
        to take effect.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the parameter value.

        <a name="RdsInstance_MsdtcHosts"></a>
        The `msdtc_hosts` block supports:
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class InstanceRestoreArgsDict(TypedDict):
        backup_id: pulumi.Input[_builtins.str]
        """
        Specifies the ID of the backup used to restore data. Changing this
        parameter will create a new resource.
        """
        instance_id: pulumi.Input[_builtins.str]
        """
        Specifies the source DB instance ID. Changing this parameter will create
        a new resource.
        """
        database_name: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Specifies the database to be restored. This parameter applies only to
        Microsoft SQL Server databases. Changing this parameter will create a new resource.
        """
elif False:
    InstanceRestoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceRestoreArgs:
    def __init__(__self__, *,
                 backup_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 database_name: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] backup_id: Specifies the ID of the backup used to restore data. Changing this
               parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the source DB instance ID. Changing this parameter will create
               a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] database_name: Specifies the database to be restored. This parameter applies only to
               Microsoft SQL Server databases. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the backup used to restore data. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the source DB instance ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the database to be restored. This parameter applies only to
        Microsoft SQL Server databases. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "database_name", value)


if not MYPY:
    class InstanceVolumeArgsDict(TypedDict):
        size: pulumi.Input[_builtins.int]
        """
        Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
        multiple of 10 and greater than the original size.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + **CLOUDSSD**: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances (MySQL and PostreSQL).
        + **ESSD**: extreme SSD storage. Supported by: MySQL primary/standby, PostgeSQL (both single and primary/standby).
        + **ULTRAHIGH** the only storage type for SQLServer, not supported by other DB engines.

        Changing this parameter will create a new resource.
        """
        disk_encryption_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the key ID for disk encryption.
        Changing this parameter will create a new resource.
        """
        limit_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the upper limit of automatic expansion of storage, in GB.
        """
        trigger_threshold: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the threshold to trigger automatic expansion.  
        If the available storage drops to this threshold or `10` GB, the automatic expansion is triggered.
        The valid values are as follows:
        + **10**
        + **15**
        + **20**
        """
elif False:
    InstanceVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceVolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 disk_encryption_id: Optional[pulumi.Input[_builtins.str]] = None,
                 limit_size: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] size: Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
               multiple of 10 and greater than the original size.
        :param pulumi.Input[_builtins.str] type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + **CLOUDSSD**: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances (MySQL and PostreSQL).
               + **ESSD**: extreme SSD storage. Supported by: MySQL primary/standby, PostgeSQL (both single and primary/standby).
               + **ULTRAHIGH** the only storage type for SQLServer, not supported by other DB engines.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] disk_encryption_id: Specifies the key ID for disk encryption.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] limit_size: Specifies the upper limit of automatic expansion of storage, in GB.
        :param pulumi.Input[_builtins.int] trigger_threshold: Specifies the threshold to trigger automatic expansion.  
               If the available storage drops to this threshold or `10` GB, the automatic expansion is triggered.
               The valid values are as follows:
               + **10**
               + **15**
               + **20**
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if limit_size is not None:
            pulumi.set(__self__, "limit_size", limit_size)
        if trigger_threshold is not None:
            pulumi.set(__self__, "trigger_threshold", trigger_threshold)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
        multiple of 10 and greater than the original size.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + **CLOUDSSD**: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances (MySQL and PostreSQL).
        + **ESSD**: extreme SSD storage. Supported by: MySQL primary/standby, PostgeSQL (both single and primary/standby).
        + **ULTRAHIGH** the only storage type for SQLServer, not supported by other DB engines.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key ID for disk encryption.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_id", value)

    @_builtins.property
    @pulumi.getter(name="limitSize")
    def limit_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the upper limit of automatic expansion of storage, in GB.
        """
        return pulumi.get(self, "limit_size")

    @limit_size.setter
    def limit_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "limit_size", value)

    @_builtins.property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the threshold to trigger automatic expansion.  
        If the available storage drops to this threshold or `10` GB, the automatic expansion is triggered.
        The valid values are as follows:
        + **10**
        + **15**
        + **20**
        """
        return pulumi.get(self, "trigger_threshold")

    @trigger_threshold.setter
    def trigger_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "trigger_threshold", value)


if not MYPY:
    class MysqlDatabasePrivilegeUserArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the username of the database account.
        """
        readonly: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies the read-only permission. The value can be:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.

        The default value is **false**.
        """
elif False:
    MysqlDatabasePrivilegeUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDatabasePrivilegeUserArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 readonly: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the username of the database account.
        :param pulumi.Input[_builtins.bool] readonly: Specifies the read-only permission. The value can be:
               + **true**: indicates the read-only permission.
               + **false**: indicates the read and write permission.
               
               The default value is **false**.
        """
        pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the username of the database account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def readonly(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the read-only permission. The value can be:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.

        The default value is **false**.
        """
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "readonly", value)


if not MYPY:
    class MysqlDatabaseTableRestoreDatabaseArgsDict(TypedDict):
        new_name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the table after restoration.

        Changing this creates a new resource.
        """
        old_name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the table before restoration.

        Changing this creates a new resource.
        """
elif False:
    MysqlDatabaseTableRestoreDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDatabaseTableRestoreDatabaseArgs:
    def __init__(__self__, *,
                 new_name: pulumi.Input[_builtins.str],
                 old_name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] new_name: Specifies the name of the table after restoration.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] old_name: Specifies the name of the table before restoration.
               
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "new_name", new_name)
        pulumi.set(__self__, "old_name", old_name)

    @_builtins.property
    @pulumi.getter(name="newName")
    def new_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the table after restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "new_name")

    @new_name.setter
    def new_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "new_name", value)

    @_builtins.property
    @pulumi.getter(name="oldName")
    def old_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the table before restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "old_name")

    @old_name.setter
    def old_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "old_name", value)


if not MYPY:
    class MysqlDatabaseTableRestoreRestoreTableArgsDict(TypedDict):
        database: pulumi.Input[_builtins.str]
        """
        Specifies the database name.

        Changing this creates a new resource.
        """
        tables: pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableTableArgsDict']]]
        """
        Specifies the tables.
        The tables structure is documented below.

        Changing this creates a new resource.

        <a name="tables_struct"></a>
        The `tables` block supports:
        """
elif False:
    MysqlDatabaseTableRestoreRestoreTableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDatabaseTableRestoreRestoreTableArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[_builtins.str],
                 tables: pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableTableArgs']]]):
        """
        :param pulumi.Input[_builtins.str] database: Specifies the database name.
               
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableTableArgs']]] tables: Specifies the tables.
               The tables structure is documented below.
               
               Changing this creates a new resource.
               
               <a name="tables_struct"></a>
               The `tables` block supports:
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "tables", tables)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the database name.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def tables(self) -> pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableTableArgs']]]:
        """
        Specifies the tables.
        The tables structure is documented below.

        Changing this creates a new resource.

        <a name="tables_struct"></a>
        The `tables` block supports:
        """
        return pulumi.get(self, "tables")

    @tables.setter
    def tables(self, value: pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableTableArgs']]]):
        pulumi.set(self, "tables", value)


if not MYPY:
    class MysqlDatabaseTableRestoreRestoreTableTableArgsDict(TypedDict):
        new_name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the table after restoration.

        Changing this creates a new resource.
        """
        old_name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the table before restoration.

        Changing this creates a new resource.
        """
elif False:
    MysqlDatabaseTableRestoreRestoreTableTableArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MysqlDatabaseTableRestoreRestoreTableTableArgs:
    def __init__(__self__, *,
                 new_name: pulumi.Input[_builtins.str],
                 old_name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] new_name: Specifies the name of the table after restoration.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] old_name: Specifies the name of the table before restoration.
               
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "new_name", new_name)
        pulumi.set(__self__, "old_name", old_name)

    @_builtins.property
    @pulumi.getter(name="newName")
    def new_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the table after restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "new_name")

    @new_name.setter
    def new_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "new_name", value)

    @_builtins.property
    @pulumi.getter(name="oldName")
    def old_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the table before restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "old_name")

    @old_name.setter
    def old_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "old_name", value)


if not MYPY:
    class ParametergroupConfigurationParameterArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        The parameter group description. It contains a maximum of 256 characters and cannot contain the following special characters:>!<"&'= the value is left blank by default.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        readonly: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether the parameter is read-only.
        """
        restart_required: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether a restart is required.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the parameter type.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the parameter value.
        """
        value_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the parameter value range.
        """
elif False:
    ParametergroupConfigurationParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ParametergroupConfigurationParameterArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 readonly: Optional[pulumi.Input[_builtins.bool]] = None,
                 restart_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 value: Optional[pulumi.Input[_builtins.str]] = None,
                 value_range: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] description: The parameter group description. It contains a maximum of 256 characters and cannot contain the following special characters:>!<"&'= the value is left blank by default.
        :param pulumi.Input[_builtins.str] name: The parameter group name. It contains a maximum of 64 characters.
        :param pulumi.Input[_builtins.bool] readonly: Indicates whether the parameter is read-only.
        :param pulumi.Input[_builtins.bool] restart_required: Indicates whether a restart is required.
        :param pulumi.Input[_builtins.str] type: Indicates the parameter type.
        :param pulumi.Input[_builtins.str] value: Indicates the parameter value.
        :param pulumi.Input[_builtins.str] value_range: Indicates the parameter value range.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if restart_required is not None:
            pulumi.set(__self__, "restart_required", restart_required)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_range is not None:
            pulumi.set(__self__, "value_range", value_range)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parameter group description. It contains a maximum of 256 characters and cannot contain the following special characters:>!<"&'= the value is left blank by default.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def readonly(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the parameter is read-only.
        """
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "readonly", value)

    @_builtins.property
    @pulumi.getter(name="restartRequired")
    def restart_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a restart is required.
        """
        return pulumi.get(self, "restart_required")

    @restart_required.setter
    def restart_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restart_required", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the parameter type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)

    @_builtins.property
    @pulumi.getter(name="valueRange")
    def value_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the parameter value range.
        """
        return pulumi.get(self, "value_range")

    @value_range.setter
    def value_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value_range", value)


if not MYPY:
    class ParametergroupDatastoreArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The value is case-insensitive and can be mysql, postgresql, or sqlserver.
        """
        version: pulumi.Input[_builtins.str]
        """
        Specifies the database version.

        * MySQL databases support MySQL 5.6, 5.7 and 8.0. Example value: 5.7.
        * PostgreSQL databases support PostgreSQL 9.5, 9.6, 10, 11 and 12. Example value: 9.5.
        * Microsoft SQL Server databases support 2012_SE, 2014_SE, 2016_SE, 2012_EE, 2014_EE, 2016_EE and 2017_EE. Example value: 2014_SE.
        """
elif False:
    ParametergroupDatastoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ParametergroupDatastoreArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] type: The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The value is case-insensitive and can be mysql, postgresql, or sqlserver.
        :param pulumi.Input[_builtins.str] version: Specifies the database version.
               
               * MySQL databases support MySQL 5.6, 5.7 and 8.0. Example value: 5.7.
               * PostgreSQL databases support PostgreSQL 9.5, 9.6, 10, 11 and 12. Example value: 9.5.
               * Microsoft SQL Server databases support 2012_SE, 2014_SE, 2016_SE, 2012_EE, 2014_EE, 2016_EE and 2017_EE. Example value: 2014_SE.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The value is case-insensitive and can be mysql, postgresql, or sqlserver.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the database version.

        * MySQL databases support MySQL 5.6, 5.7 and 8.0. Example value: 5.7.
        * PostgreSQL databases support PostgreSQL 9.5, 9.6, 10, 11 and 12. Example value: 9.5.
        * Microsoft SQL Server databases support 2012_SE, 2014_SE, 2016_SE, 2012_EE, 2014_EE, 2016_EE and 2017_EE. Example value: 2014_SE.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)


if not MYPY:
    class PgAccountAttributeArgsDict(TypedDict):
        rol_bypass_rls: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether a user bypasses each row-level security policy.
        """
        rol_can_login: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether a user can log in to the database.
        """
        rol_conn_limit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Indicates the maximum number of concurrent connections to a DB instance.
        """
        rol_create_db: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether a user can create a database.
        """
        rol_create_role: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether a user can create other sub-users.
        """
        rol_inherit: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether a user automatically inherits the permissions of the role to which the user belongs.
        """
        rol_replication: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether the user is a replication role.
        """
        rol_super: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates whether a user has the super-user permission.
        """
elif False:
    PgAccountAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PgAccountAttributeArgs:
    def __init__(__self__, *,
                 rol_bypass_rls: Optional[pulumi.Input[_builtins.bool]] = None,
                 rol_can_login: Optional[pulumi.Input[_builtins.bool]] = None,
                 rol_conn_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 rol_create_db: Optional[pulumi.Input[_builtins.bool]] = None,
                 rol_create_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 rol_inherit: Optional[pulumi.Input[_builtins.bool]] = None,
                 rol_replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 rol_super: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] rol_bypass_rls: Indicates whether a user bypasses each row-level security policy.
        :param pulumi.Input[_builtins.bool] rol_can_login: Indicates whether a user can log in to the database.
        :param pulumi.Input[_builtins.int] rol_conn_limit: Indicates the maximum number of concurrent connections to a DB instance.
        :param pulumi.Input[_builtins.bool] rol_create_db: Indicates whether a user can create a database.
        :param pulumi.Input[_builtins.bool] rol_create_role: Indicates whether a user can create other sub-users.
        :param pulumi.Input[_builtins.bool] rol_inherit: Indicates whether a user automatically inherits the permissions of the role to which the user belongs.
        :param pulumi.Input[_builtins.bool] rol_replication: Indicates whether the user is a replication role.
        :param pulumi.Input[_builtins.bool] rol_super: Indicates whether a user has the super-user permission.
        """
        if rol_bypass_rls is not None:
            pulumi.set(__self__, "rol_bypass_rls", rol_bypass_rls)
        if rol_can_login is not None:
            pulumi.set(__self__, "rol_can_login", rol_can_login)
        if rol_conn_limit is not None:
            pulumi.set(__self__, "rol_conn_limit", rol_conn_limit)
        if rol_create_db is not None:
            pulumi.set(__self__, "rol_create_db", rol_create_db)
        if rol_create_role is not None:
            pulumi.set(__self__, "rol_create_role", rol_create_role)
        if rol_inherit is not None:
            pulumi.set(__self__, "rol_inherit", rol_inherit)
        if rol_replication is not None:
            pulumi.set(__self__, "rol_replication", rol_replication)
        if rol_super is not None:
            pulumi.set(__self__, "rol_super", rol_super)

    @_builtins.property
    @pulumi.getter(name="rolBypassRls")
    def rol_bypass_rls(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a user bypasses each row-level security policy.
        """
        return pulumi.get(self, "rol_bypass_rls")

    @rol_bypass_rls.setter
    def rol_bypass_rls(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rol_bypass_rls", value)

    @_builtins.property
    @pulumi.getter(name="rolCanLogin")
    def rol_can_login(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a user can log in to the database.
        """
        return pulumi.get(self, "rol_can_login")

    @rol_can_login.setter
    def rol_can_login(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rol_can_login", value)

    @_builtins.property
    @pulumi.getter(name="rolConnLimit")
    def rol_conn_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the maximum number of concurrent connections to a DB instance.
        """
        return pulumi.get(self, "rol_conn_limit")

    @rol_conn_limit.setter
    def rol_conn_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rol_conn_limit", value)

    @_builtins.property
    @pulumi.getter(name="rolCreateDb")
    def rol_create_db(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a user can create a database.
        """
        return pulumi.get(self, "rol_create_db")

    @rol_create_db.setter
    def rol_create_db(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rol_create_db", value)

    @_builtins.property
    @pulumi.getter(name="rolCreateRole")
    def rol_create_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a user can create other sub-users.
        """
        return pulumi.get(self, "rol_create_role")

    @rol_create_role.setter
    def rol_create_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rol_create_role", value)

    @_builtins.property
    @pulumi.getter(name="rolInherit")
    def rol_inherit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a user automatically inherits the permissions of the role to which the user belongs.
        """
        return pulumi.get(self, "rol_inherit")

    @rol_inherit.setter
    def rol_inherit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rol_inherit", value)

    @_builtins.property
    @pulumi.getter(name="rolReplication")
    def rol_replication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the user is a replication role.
        """
        return pulumi.get(self, "rol_replication")

    @rol_replication.setter
    def rol_replication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rol_replication", value)

    @_builtins.property
    @pulumi.getter(name="rolSuper")
    def rol_super(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a user has the super-user permission.
        """
        return pulumi.get(self, "rol_super")

    @rol_super.setter
    def rol_super(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rol_super", value)


if not MYPY:
    class PgHbaHostBasedAuthenticationArgsDict(TypedDict):
        address: pulumi.Input[_builtins.str]
        """
        Specifies the client IP address.
        """
        database: pulumi.Input[_builtins.str]
        """
        Specifies the database name.
        """
        method: pulumi.Input[_builtins.str]
        """
        Specifies the authentication mode.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the connection type.
        """
        user: pulumi.Input[_builtins.str]
        """
        Specifies the Name of a user.
        """
        mask: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the subnet mask.
        """
elif False:
    PgHbaHostBasedAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PgHbaHostBasedAuthenticationArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[_builtins.str],
                 database: pulumi.Input[_builtins.str],
                 method: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 user: pulumi.Input[_builtins.str],
                 mask: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address: Specifies the client IP address.
        :param pulumi.Input[_builtins.str] database: Specifies the database name.
        :param pulumi.Input[_builtins.str] method: Specifies the authentication mode.
        :param pulumi.Input[_builtins.str] type: Specifies the connection type.
        :param pulumi.Input[_builtins.str] user: Specifies the Name of a user.
        :param pulumi.Input[_builtins.str] mask: Specifies the subnet mask.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the client IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def database(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the database name.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the authentication mode.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the connection type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Name of a user.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter
    def mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the subnet mask.
        """
        return pulumi.get(self, "mask")

    @mask.setter
    def mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mask", value)


if not MYPY:
    class ReadReplicaInstanceDbArgsDict(TypedDict):
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Indicates the database port information.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        """
        user_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the default user name of database.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates the database version.
        """
elif False:
    ReadReplicaInstanceDbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReadReplicaInstanceDbArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] port: Indicates the database port information.
        :param pulumi.Input[_builtins.str] type: Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        :param pulumi.Input[_builtins.str] user_name: Indicates the default user name of database.
        :param pulumi.Input[_builtins.str] version: Indicates the database version.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the database port information.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the default user name of database.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class ReadReplicaInstanceParameterArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the DB instance name. The DB instance name of the same type
        must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
        It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        value: pulumi.Input[_builtins.str]
elif False:
    ReadReplicaInstanceParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReadReplicaInstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type
               must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
               It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the DB instance name. The DB instance name of the same type
        must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
        It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ReadReplicaInstanceVolumeArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the volume type. Its value can be any of the following and is case-sensitive:
        - *ESSD* - ultrahigh I/O.
        - *CLOUDSSD* - high I/O.

        Changing this parameter will create a new resource.
        """
        disk_encryption_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the key ID for disk encryption.
        Changing this parameter will create a new resource.
        """
        limit_size: NotRequired[pulumi.Input[_builtins.int]]
        size: NotRequired[pulumi.Input[_builtins.int]]
        trigger_threshold: NotRequired[pulumi.Input[_builtins.int]]
elif False:
    ReadReplicaInstanceVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReadReplicaInstanceVolumeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 disk_encryption_id: Optional[pulumi.Input[_builtins.str]] = None,
                 limit_size: Optional[pulumi.Input[_builtins.int]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 trigger_threshold: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the volume type. Its value can be any of the following and is case-sensitive:
               - *ESSD* - ultrahigh I/O.
               - *CLOUDSSD* - high I/O.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] disk_encryption_id: Specifies the key ID for disk encryption.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if limit_size is not None:
            pulumi.set(__self__, "limit_size", limit_size)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if trigger_threshold is not None:
            pulumi.set(__self__, "trigger_threshold", trigger_threshold)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the volume type. Its value can be any of the following and is case-sensitive:
        - *ESSD* - ultrahigh I/O.
        - *CLOUDSSD* - high I/O.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key ID for disk encryption.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_id", value)

    @_builtins.property
    @pulumi.getter(name="limitSize")
    def limit_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "limit_size")

    @limit_size.setter
    def limit_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "limit_size", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "trigger_threshold")

    @trigger_threshold.setter
    def trigger_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "trigger_threshold", value)


if not MYPY:
    class SqlserverDatabasePrivilegeUserArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the username of the database account.
        """
        readonly: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies the read-only permission. Value options:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.

        Defaults to **false**.
        """
elif False:
    SqlserverDatabasePrivilegeUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlserverDatabasePrivilegeUserArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 readonly: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the username of the database account.
        :param pulumi.Input[_builtins.bool] readonly: Specifies the read-only permission. Value options:
               + **true**: indicates the read-only permission.
               + **false**: indicates the read and write permission.
               
               Defaults to **false**.
        """
        pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the username of the database account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def readonly(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the read-only permission. Value options:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.

        Defaults to **false**.
        """
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "readonly", value)


