# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupArgs', 'Backup']

@pulumi.input_type
class BackupArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Backup resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID. This resource works only with Postgre SQL databases.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]] databases: List of self-built Microsoft SQL Server databases that are partially
               backed up.
               (Only Microsoft SQL Server supports partial backups.).
               
               Changing this parameter will create a new resource.
               The BackupDatabase structure is documented below.
               
               <a name="Backup_BackupDatabase"></a>
               The `BackupDatabase` block supports:
        :param pulumi.Input[_builtins.str] description: The description about the backup.  
               It contains a maximum of 256 characters and cannot contain the following special characters: >!<"&'=.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Database to be backed up for Microsoft SQL Server.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Instance ID. This resource works only with Postgre SQL databases.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]]]:
        """
        List of self-built Microsoft SQL Server databases that are partially
        backed up.
        (Only Microsoft SQL Server supports partial backups.).

        Changing this parameter will create a new resource.
        The BackupDatabase structure is documented below.

        <a name="Backup_BackupDatabase"></a>
        The `BackupDatabase` block supports:
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description about the backup.  
        It contains a maximum of 256 characters and cannot contain the following special characters: >!<"&'=.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database to be backed up for Microsoft SQL Server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BackupState:
    def __init__(__self__, *,
                 associated_with_ddm: Optional[pulumi.Input[_builtins.bool]] = None,
                 begin_time: Optional[pulumi.Input[_builtins.str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Backup resources.
        :param pulumi.Input[_builtins.bool] associated_with_ddm: Whether a DDM instance has been associated.
        :param pulumi.Input[_builtins.str] begin_time: Backup start time in the "yyyy-mm-ddThh:mm:ssZ" format.
        :param pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]] databases: List of self-built Microsoft SQL Server databases that are partially
               backed up.
               (Only Microsoft SQL Server supports partial backups.).
               
               Changing this parameter will create a new resource.
               The BackupDatabase structure is documented below.
               
               <a name="Backup_BackupDatabase"></a>
               The `BackupDatabase` block supports:
        :param pulumi.Input[_builtins.str] description: The description about the backup.  
               It contains a maximum of 256 characters and cannot contain the following special characters: >!<"&'=.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] end_time: Backup end time in the "yyyy-mm-ddThh:mm:ssZ" format.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID. This resource works only with Postgre SQL databases.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Database to be backed up for Microsoft SQL Server.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] size: Backup size in KB.
        :param pulumi.Input[_builtins.str] status: Backup status.  
               The options are as follows:
               + **BUILDING**: Backup in progress.
               + **COMPLETED**: Backup completed.
               + **FAILED**: Backup failed.
               + **DELETING**: Backup being deleted.
        """
        if associated_with_ddm is not None:
            pulumi.set(__self__, "associated_with_ddm", associated_with_ddm)
        if begin_time is not None:
            pulumi.set(__self__, "begin_time", begin_time)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="associatedWithDdm")
    def associated_with_ddm(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether a DDM instance has been associated.
        """
        return pulumi.get(self, "associated_with_ddm")

    @associated_with_ddm.setter
    def associated_with_ddm(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "associated_with_ddm", value)

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup start time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "begin_time")

    @begin_time.setter
    def begin_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "begin_time", value)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]]]:
        """
        List of self-built Microsoft SQL Server databases that are partially
        backed up.
        (Only Microsoft SQL Server supports partial backups.).

        Changing this parameter will create a new resource.
        The BackupDatabase structure is documented below.

        <a name="Backup_BackupDatabase"></a>
        The `BackupDatabase` block supports:
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description about the backup.  
        It contains a maximum of 256 characters and cannot contain the following special characters: >!<"&'=.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup end time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance ID. This resource works only with Postgre SQL databases.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Database to be backed up for Microsoft SQL Server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Backup size in KB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup status.  
        The options are as follows:
        + **BUILDING**: Backup in progress.
        + **COMPLETED**: Backup completed.
        + **FAILED**: Backup failed.
        + **DELETING**: Backup being deleted.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.type_token("sbercloud:Rds/backup:Backup")
class Backup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupDatabaseArgs', 'BackupDatabaseArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a RDS manual backup resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        backup_name = config.require_object("backupName")
        test = sbercloud.rds.Backup("test",
            instance_id=instance_id,
            name=backup_name)
        ```

        ## Import

        The rds manual backup can be imported using the instance ID and the backup ID separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Rds/backup:Backup test 1ce123456a00f2591fabc00385ff1235/0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupDatabaseArgs', 'BackupDatabaseArgsDict']]]] databases: List of self-built Microsoft SQL Server databases that are partially
               backed up.
               (Only Microsoft SQL Server supports partial backups.).
               
               Changing this parameter will create a new resource.
               The BackupDatabase structure is documented below.
               
               <a name="Backup_BackupDatabase"></a>
               The `BackupDatabase` block supports:
        :param pulumi.Input[_builtins.str] description: The description about the backup.  
               It contains a maximum of 256 characters and cannot contain the following special characters: >!<"&'=.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID. This resource works only with Postgre SQL databases.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Database to be backed up for Microsoft SQL Server.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a RDS manual backup resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        backup_name = config.require_object("backupName")
        test = sbercloud.rds.Backup("test",
            instance_id=instance_id,
            name=backup_name)
        ```

        ## Import

        The rds manual backup can be imported using the instance ID and the backup ID separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Rds/backup:Backup test 1ce123456a00f2591fabc00385ff1235/0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param BackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupDatabaseArgs', 'BackupDatabaseArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupArgs.__new__(BackupArgs)

            __props__.__dict__["databases"] = databases
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["associated_with_ddm"] = None
            __props__.__dict__["begin_time"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
        super(Backup, __self__).__init__(
            'sbercloud:Rds/backup:Backup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_with_ddm: Optional[pulumi.Input[_builtins.bool]] = None,
            begin_time: Optional[pulumi.Input[_builtins.str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackupDatabaseArgs', 'BackupDatabaseArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            end_time: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None) -> 'Backup':
        """
        Get an existing Backup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] associated_with_ddm: Whether a DDM instance has been associated.
        :param pulumi.Input[_builtins.str] begin_time: Backup start time in the "yyyy-mm-ddThh:mm:ssZ" format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackupDatabaseArgs', 'BackupDatabaseArgsDict']]]] databases: List of self-built Microsoft SQL Server databases that are partially
               backed up.
               (Only Microsoft SQL Server supports partial backups.).
               
               Changing this parameter will create a new resource.
               The BackupDatabase structure is documented below.
               
               <a name="Backup_BackupDatabase"></a>
               The `BackupDatabase` block supports:
        :param pulumi.Input[_builtins.str] description: The description about the backup.  
               It contains a maximum of 256 characters and cannot contain the following special characters: >!<"&'=.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] end_time: Backup end time in the "yyyy-mm-ddThh:mm:ssZ" format.
        :param pulumi.Input[_builtins.str] instance_id: Instance ID. This resource works only with Postgre SQL databases.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Database to be backed up for Microsoft SQL Server.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] size: Backup size in KB.
        :param pulumi.Input[_builtins.str] status: Backup status.  
               The options are as follows:
               + **BUILDING**: Backup in progress.
               + **COMPLETED**: Backup completed.
               + **FAILED**: Backup failed.
               + **DELETING**: Backup being deleted.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupState.__new__(_BackupState)

        __props__.__dict__["associated_with_ddm"] = associated_with_ddm
        __props__.__dict__["begin_time"] = begin_time
        __props__.__dict__["databases"] = databases
        __props__.__dict__["description"] = description
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        return Backup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedWithDdm")
    def associated_with_ddm(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether a DDM instance has been associated.
        """
        return pulumi.get(self, "associated_with_ddm")

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> pulumi.Output[_builtins.str]:
        """
        Backup start time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "begin_time")

    @_builtins.property
    @pulumi.getter
    def databases(self) -> pulumi.Output[Sequence['outputs.BackupDatabase']]:
        """
        List of self-built Microsoft SQL Server databases that are partially
        backed up.
        (Only Microsoft SQL Server supports partial backups.).

        Changing this parameter will create a new resource.
        The BackupDatabase structure is documented below.

        <a name="Backup_BackupDatabase"></a>
        The `BackupDatabase` block supports:
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description about the backup.  
        It contains a maximum of 256 characters and cannot contain the following special characters: >!<"&'=.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[_builtins.str]:
        """
        Backup end time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Instance ID. This resource works only with Postgre SQL databases.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Database to be backed up for Microsoft SQL Server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Backup size in KB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Backup status.  
        The options are as follows:
        + **BUILDING**: Backup in progress.
        + **COMPLETED**: Backup completed.
        + **FAILED**: Backup failed.
        + **DELETING**: Backup being deleted.
        """
        return pulumi.get(self, "status")

