# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBackupsResult',
    'AwaitableGetBackupsResult',
    'get_backups',
    'get_backups_output',
]

@pulumi.output_type
class GetBackupsResult:
    """
    A collection of values returned by getBackups.
    """
    def __init__(__self__, backup_id=None, backup_type=None, backups=None, begin_time=None, end_time=None, id=None, instance_id=None, name=None, region=None):
        if backup_id and not isinstance(backup_id, str):
            raise TypeError("Expected argument 'backup_id' to be a str")
        pulumi.set(__self__, "backup_id", backup_id)
        if backup_type and not isinstance(backup_type, str):
            raise TypeError("Expected argument 'backup_type' to be a str")
        pulumi.set(__self__, "backup_type", backup_type)
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if begin_time and not isinstance(begin_time, str):
            raise TypeError("Expected argument 'begin_time' to be a str")
        pulumi.set(__self__, "begin_time", begin_time)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.GetBackupsBackupResult']:
        """
        Backup list. For details, see Data structure of the Backup field.
        The backups structure is documented below.
        """
        return pulumi.get(self, "backups")

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> Optional[_builtins.str]:
        """
        Backup start time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "begin_time")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        Backup end time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        RDS instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Database to be backed up for Microsoft SQL Server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetBackupsResult(GetBackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupsResult(
            backup_id=self.backup_id,
            backup_type=self.backup_type,
            backups=self.backups,
            begin_time=self.begin_time,
            end_time=self.end_time,
            id=self.id,
            instance_id=self.instance_id,
            name=self.name,
            region=self.region)


def get_backups(backup_id: Optional[_builtins.str] = None,
                backup_type: Optional[_builtins.str] = None,
                begin_time: Optional[_builtins.str] = None,
                end_time: Optional[_builtins.str] = None,
                instance_id: Optional[_builtins.str] = None,
                name: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupsResult:
    """
    Use this data source to get the list of RDS backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Rds.get_backups(instance_id=instance_id)
    ```


    :param _builtins.str backup_id: Backup ID.
    :param _builtins.str backup_type: Backup type.  
           The options are as follows:
           - **auto**: Automated full backup.
           - **manual**: Manual full backup.
           - **fragment**: Differential full backup.
           - **incremental**: Automated incremental backup.
    :param _builtins.str begin_time: Start time in the "yyyy-mm-ddThh:mm:ssZ" format.
    :param _builtins.str end_time: End time in the "yyyy-mm-ddThh:mm:ssZ" format.
    :param _builtins.str instance_id: Instance ID.
    :param _builtins.str name: Backup name.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['backupType'] = backup_type
    __args__['beginTime'] = begin_time
    __args__['endTime'] = end_time
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Rds/getBackups:getBackups', __args__, opts=opts, typ=GetBackupsResult).value

    return AwaitableGetBackupsResult(
        backup_id=pulumi.get(__ret__, 'backup_id'),
        backup_type=pulumi.get(__ret__, 'backup_type'),
        backups=pulumi.get(__ret__, 'backups'),
        begin_time=pulumi.get(__ret__, 'begin_time'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_backups_output(backup_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       backup_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       begin_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       end_time: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBackupsResult]:
    """
    Use this data source to get the list of RDS backups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Rds.get_backups(instance_id=instance_id)
    ```


    :param _builtins.str backup_id: Backup ID.
    :param _builtins.str backup_type: Backup type.  
           The options are as follows:
           - **auto**: Automated full backup.
           - **manual**: Manual full backup.
           - **fragment**: Differential full backup.
           - **incremental**: Automated incremental backup.
    :param _builtins.str begin_time: Start time in the "yyyy-mm-ddThh:mm:ssZ" format.
    :param _builtins.str end_time: End time in the "yyyy-mm-ddThh:mm:ssZ" format.
    :param _builtins.str instance_id: Instance ID.
    :param _builtins.str name: Backup name.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['backupType'] = backup_type
    __args__['beginTime'] = begin_time
    __args__['endTime'] = end_time
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Rds/getBackups:getBackups', __args__, opts=opts, typ=GetBackupsResult)
    return __ret__.apply(lambda __response__: GetBackupsResult(
        backup_id=pulumi.get(__response__, 'backup_id'),
        backup_type=pulumi.get(__response__, 'backup_type'),
        backups=pulumi.get(__response__, 'backups'),
        begin_time=pulumi.get(__response__, 'begin_time'),
        end_time=pulumi.get(__response__, 'end_time'),
        id=pulumi.get(__response__, 'id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
