# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEngineVersionsResult',
    'AwaitableGetEngineVersionsResult',
    'get_engine_versions',
    'get_engine_versions_output',
]

@pulumi.output_type
class GetEngineVersionsResult:
    """
    A collection of values returned by getEngineVersions.
    """
    def __init__(__self__, id=None, region=None, type=None, versions=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetEngineVersionsVersionResult']:
        """
        List of RDS versions. Structure is documented below.
        """
        return pulumi.get(self, "versions")


class AwaitableGetEngineVersionsResult(GetEngineVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEngineVersionsResult(
            id=self.id,
            region=self.region,
            type=self.type,
            versions=self.versions)


def get_engine_versions(region: Optional[_builtins.str] = None,
                        type: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEngineVersionsResult:
    """
    Use this data source to obtain all version information of the specified engine type of SberCloud RDS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Rds.get_engine_versions(type="SQLServer")
    ```


    :param _builtins.str region: The region in which to obtain the RDS engine versions.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the RDS engine type.
           The valid values are **MySQL**, **PostgreSQL** and **SQLServer**, default to **MySQL**.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Rds/getEngineVersions:getEngineVersions', __args__, opts=opts, typ=GetEngineVersionsResult).value

    return AwaitableGetEngineVersionsResult(
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'),
        versions=pulumi.get(__ret__, 'versions'))
def get_engine_versions_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEngineVersionsResult]:
    """
    Use this data source to obtain all version information of the specified engine type of SberCloud RDS.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Rds.get_engine_versions(type="SQLServer")
    ```


    :param _builtins.str region: The region in which to obtain the RDS engine versions.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the RDS engine type.
           The valid values are **MySQL**, **PostgreSQL** and **SQLServer**, default to **MySQL**.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Rds/getEngineVersions:getEngineVersions', __args__, opts=opts, typ=GetEngineVersionsResult)
    return __ret__.apply(lambda __response__: GetEngineVersionsResult(
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type'),
        versions=pulumi.get(__response__, 'versions')))
