# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, availability_zone=None, db_type=None, db_version=None, flavors=None, group_type=None, id=None, instance_mode=None, memory=None, region=None, vcpus=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if db_type and not isinstance(db_type, str):
            raise TypeError("Expected argument 'db_type' to be a str")
        pulumi.set(__self__, "db_type", db_type)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if group_type and not isinstance(group_type, str):
            raise TypeError("Expected argument 'group_type' to be a str")
        pulumi.set(__self__, "group_type", group_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_mode and not isinstance(instance_mode, str):
            raise TypeError("Expected argument 'instance_mode' to be a str")
        pulumi.set(__self__, "instance_mode", instance_mode)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> _builtins.str:
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[_builtins.str]:
        """
        The performance specification.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceMode")
    def instance_mode(self) -> Optional[_builtins.str]:
        """
        The mode of instance.
        """
        return pulumi.get(self, "instance_mode")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.int]:
        """
        Indicates the memory size in GB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> Optional[_builtins.int]:
        """
        Indicates the CPU size.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            availability_zone=self.availability_zone,
            db_type=self.db_type,
            db_version=self.db_version,
            flavors=self.flavors,
            group_type=self.group_type,
            id=self.id,
            instance_mode=self.instance_mode,
            memory=self.memory,
            region=self.region,
            vcpus=self.vcpus)


def get_flavors(availability_zone: Optional[_builtins.str] = None,
                db_type: Optional[_builtins.str] = None,
                db_version: Optional[_builtins.str] = None,
                group_type: Optional[_builtins.str] = None,
                instance_mode: Optional[_builtins.str] = None,
                memory: Optional[_builtins.int] = None,
                region: Optional[_builtins.str] = None,
                vcpus: Optional[_builtins.int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get available SberCloud rds flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.Rds.get_flavors(db_type="PostgreSQL",
        db_version="12",
        instance_mode="ha")
    ```


    :param _builtins.str availability_zone: Specifies the availability zone which the RDS flavor belongs to.
    :param _builtins.str db_type: Specifies the DB engine. Value: MySQL, PostgreSQL, SQLServer.
    :param _builtins.str db_version: Specifies the database version. Available value:
           
           type | version
           ---- | ---
           MySQL| 5.6 <br>5.7 <br>8.0
           PostgreSQL | 9.5 <br> 9.6 <br>10 <br>11 <br>12 <br>13 <br>14
           SQLServer| 2012_SE <br>2014_SE <br>2016_SE <br>2017_SE <br>2012_EE <br>2014_EE <br>2016_EE <br>2017_EE <br>2017_WEB
    :param _builtins.str group_type: Specifies the performance specification, the valid values are as follows:
           + **normal**: General enhanced.
           + **normal2**: General enhanced type II.
    :param _builtins.str instance_mode: The mode of instance. Value: *ha*(indicates primary/standby instance),
           *single*(indicates single instance) and *replica*(indicates read replicas).
    :param _builtins.int memory: Specifies the memory size(GB) in the RDS flavor.
    :param _builtins.str region: The region in which to obtain the RDS flavors. If omitted, the provider-level region will be used.
    :param _builtins.int vcpus: Specifies the number of vCPUs in the RDS flavor.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['dbType'] = db_type
    __args__['dbVersion'] = db_version
    __args__['groupType'] = group_type
    __args__['instanceMode'] = instance_mode
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Rds/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        db_type=pulumi.get(__ret__, 'db_type'),
        db_version=pulumi.get(__ret__, 'db_version'),
        flavors=pulumi.get(__ret__, 'flavors'),
        group_type=pulumi.get(__ret__, 'group_type'),
        id=pulumi.get(__ret__, 'id'),
        instance_mode=pulumi.get(__ret__, 'instance_mode'),
        memory=pulumi.get(__ret__, 'memory'),
        region=pulumi.get(__ret__, 'region'),
        vcpus=pulumi.get(__ret__, 'vcpus'))
def get_flavors_output(availability_zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       db_type: Optional[pulumi.Input[_builtins.str]] = None,
                       db_version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       group_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       instance_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       memory: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vcpus: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get available SberCloud rds flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.Rds.get_flavors(db_type="PostgreSQL",
        db_version="12",
        instance_mode="ha")
    ```


    :param _builtins.str availability_zone: Specifies the availability zone which the RDS flavor belongs to.
    :param _builtins.str db_type: Specifies the DB engine. Value: MySQL, PostgreSQL, SQLServer.
    :param _builtins.str db_version: Specifies the database version. Available value:
           
           type | version
           ---- | ---
           MySQL| 5.6 <br>5.7 <br>8.0
           PostgreSQL | 9.5 <br> 9.6 <br>10 <br>11 <br>12 <br>13 <br>14
           SQLServer| 2012_SE <br>2014_SE <br>2016_SE <br>2017_SE <br>2012_EE <br>2014_EE <br>2016_EE <br>2017_EE <br>2017_WEB
    :param _builtins.str group_type: Specifies the performance specification, the valid values are as follows:
           + **normal**: General enhanced.
           + **normal2**: General enhanced type II.
    :param _builtins.str instance_mode: The mode of instance. Value: *ha*(indicates primary/standby instance),
           *single*(indicates single instance) and *replica*(indicates read replicas).
    :param _builtins.int memory: Specifies the memory size(GB) in the RDS flavor.
    :param _builtins.str region: The region in which to obtain the RDS flavors. If omitted, the provider-level region will be used.
    :param _builtins.int vcpus: Specifies the number of vCPUs in the RDS flavor.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['dbType'] = db_type
    __args__['dbVersion'] = db_version
    __args__['groupType'] = group_type
    __args__['instanceMode'] = instance_mode
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Rds/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult)
    return __ret__.apply(lambda __response__: GetFlavorsResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        db_type=pulumi.get(__response__, 'db_type'),
        db_version=pulumi.get(__response__, 'db_version'),
        flavors=pulumi.get(__response__, 'flavors'),
        group_type=pulumi.get(__response__, 'group_type'),
        id=pulumi.get(__response__, 'id'),
        instance_mode=pulumi.get(__response__, 'instance_mode'),
        memory=pulumi.get(__response__, 'memory'),
        region=pulumi.get(__response__, 'region'),
        vcpus=pulumi.get(__response__, 'vcpus')))
