# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, datastore_type=None, enterprise_project_id=None, id=None, instances=None, name=None, region=None, subnet_id=None, type=None, vpc_id=None):
        if datastore_type and not isinstance(datastore_type, str):
            raise TypeError("Expected argument 'datastore_type' to be a str")
        pulumi.set(__self__, "datastore_type", datastore_type)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "datastore_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        Indicates the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        An array of available instances.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the node name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region of the instance.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        Indicates the network ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Indicates the volume type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        Indicates the VPC ID.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            datastore_type=self.datastore_type,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            instances=self.instances,
            name=self.name,
            region=self.region,
            subnet_id=self.subnet_id,
            type=self.type,
            vpc_id=self.vpc_id)


def get_instances(datastore_type: Optional[_builtins.str] = None,
                  enterprise_project_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  subnet_id: Optional[_builtins.str] = None,
                  type: Optional[_builtins.str] = None,
                  vpc_id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to list all available RDS instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    this = sbercloud.Rds.get_instances(name="rds-instance")
    ```


    :param _builtins.str datastore_type: Specifies the type of the database. Valid values are: MySQL, PostgreSQL, and SQLServer.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project id.
    :param _builtins.str name: Specifies the name of the instance.
    :param _builtins.str region: The region in which to obtain the instances. If omitted, the provider-level region will
           be used.
    :param _builtins.str subnet_id: Specifies the network ID of a subnet.
    :param _builtins.str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
    :param _builtins.str vpc_id: Specifies the VPC ID.
    """
    __args__ = dict()
    __args__['datastoreType'] = datastore_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['subnetId'] = subnet_id
    __args__['type'] = type
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Rds/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        datastore_type=pulumi.get(__ret__, 'datastore_type'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        type=pulumi.get(__ret__, 'type'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_instances_output(datastore_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         subnet_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to list all available RDS instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    this = sbercloud.Rds.get_instances(name="rds-instance")
    ```


    :param _builtins.str datastore_type: Specifies the type of the database. Valid values are: MySQL, PostgreSQL, and SQLServer.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project id.
    :param _builtins.str name: Specifies the name of the instance.
    :param _builtins.str region: The region in which to obtain the instances. If omitted, the provider-level region will
           be used.
    :param _builtins.str subnet_id: Specifies the network ID of a subnet.
    :param _builtins.str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
    :param _builtins.str vpc_id: Specifies the VPC ID.
    """
    __args__ = dict()
    __args__['datastoreType'] = datastore_type
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['subnetId'] = subnet_id
    __args__['type'] = type
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Rds/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        datastore_type=pulumi.get(__response__, 'datastore_type'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        subnet_id=pulumi.get(__response__, 'subnet_id'),
        type=pulumi.get(__response__, 'type'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
