# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetStorageTypesResult',
    'AwaitableGetStorageTypesResult',
    'get_storage_types',
    'get_storage_types_output',
]

@pulumi.output_type
class GetStorageTypesResult:
    """
    A collection of values returned by getStorageTypes.
    """
    def __init__(__self__, db_type=None, db_version=None, id=None, instance_mode=None, region=None, storage_types=None):
        if db_type and not isinstance(db_type, str):
            raise TypeError("Expected argument 'db_type' to be a str")
        pulumi.set(__self__, "db_type", db_type)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_mode and not isinstance(instance_mode, str):
            raise TypeError("Expected argument 'instance_mode' to be a str")
        pulumi.set(__self__, "instance_mode", instance_mode)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if storage_types and not isinstance(storage_types, list):
            raise TypeError("Expected argument 'storage_types' to be a list")
        pulumi.set(__self__, "storage_types", storage_types)

    @_builtins.property
    @pulumi.getter(name="dbType")
    def db_type(self) -> _builtins.str:
        return pulumi.get(self, "db_type")

    @_builtins.property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> _builtins.str:
        return pulumi.get(self, "db_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceMode")
    def instance_mode(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_mode")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageTypes")
    def storage_types(self) -> Sequence['outputs.GetStorageTypesStorageTypeResult']:
        """
        Storage type list. For details, see Data structure of the storage_type field.
        The storage_type structure is documented below.
        """
        return pulumi.get(self, "storage_types")


class AwaitableGetStorageTypesResult(GetStorageTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageTypesResult(
            db_type=self.db_type,
            db_version=self.db_version,
            id=self.id,
            instance_mode=self.instance_mode,
            region=self.region,
            storage_types=self.storage_types)


def get_storage_types(db_type: Optional[_builtins.str] = None,
                      db_version: Optional[_builtins.str] = None,
                      instance_mode: Optional[_builtins.str] = None,
                      region: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageTypesResult:
    """
    Use this data source to get the list of RDS storage types.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Rds.get_storage_types(db_type="MySQL",
        db_version="8.0")
    ```


    :param _builtins.str db_type: DB engine. The valid values are **MySQL**, **PostgreSQL**, **SQLServer**.
    :param _builtins.str db_version: DB version number.
    :param _builtins.str instance_mode: HA mode. The valid values are **single**, **ha**, **replica**.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['dbType'] = db_type
    __args__['dbVersion'] = db_version
    __args__['instanceMode'] = instance_mode
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Rds/getStorageTypes:getStorageTypes', __args__, opts=opts, typ=GetStorageTypesResult).value

    return AwaitableGetStorageTypesResult(
        db_type=pulumi.get(__ret__, 'db_type'),
        db_version=pulumi.get(__ret__, 'db_version'),
        id=pulumi.get(__ret__, 'id'),
        instance_mode=pulumi.get(__ret__, 'instance_mode'),
        region=pulumi.get(__ret__, 'region'),
        storage_types=pulumi.get(__ret__, 'storage_types'))
def get_storage_types_output(db_type: Optional[pulumi.Input[_builtins.str]] = None,
                             db_version: Optional[pulumi.Input[_builtins.str]] = None,
                             instance_mode: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStorageTypesResult]:
    """
    Use this data source to get the list of RDS storage types.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_id = config.require_object("instanceId")
    test = sbercloud.Rds.get_storage_types(db_type="MySQL",
        db_version="8.0")
    ```


    :param _builtins.str db_type: DB engine. The valid values are **MySQL**, **PostgreSQL**, **SQLServer**.
    :param _builtins.str db_version: DB version number.
    :param _builtins.str instance_mode: HA mode. The valid values are **single**, **ha**, **replica**.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['dbType'] = db_type
    __args__['dbVersion'] = db_version
    __args__['instanceMode'] = instance_mode
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Rds/getStorageTypes:getStorageTypes', __args__, opts=opts, typ=GetStorageTypesResult)
    return __ret__.apply(lambda __response__: GetStorageTypesResult(
        db_type=pulumi.get(__response__, 'db_type'),
        db_version=pulumi.get(__response__, 'db_version'),
        id=pulumi.get(__response__, 'id'),
        instance_mode=pulumi.get(__response__, 'instance_mode'),
        region=pulumi.get(__response__, 'region'),
        storage_types=pulumi.get(__response__, 'storage_types')))
