# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 db: pulumi.Input['InstanceDbArgs'],
                 flavor: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 volume: pulumi.Input['InstanceVolumeArgs'],
                 vpc_id: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 msdtc_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write_permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input['InstanceRestoreArgs']] = None,
                 rotate_day: Optional[pulumi.Input[_builtins.int]] = None,
                 seconds_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 seconds_level_monitoring_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_version: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_log_show_original_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 switch_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input['InstanceDbArgs'] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
               
               > **NOTE:** Services will be interrupted for 5 to 10 minutes when you change RDS instance flavor.If this parameter is
               changed, a temporary instance will be generated. This temporary instance will occupy the association of the VPC
               security group and cannot be deleted for 12 hours.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input['InstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specify the binlog retention period in hours. This parameter applies only to
               MySQL Server databases. Value range: **0** to **168 (7x24)**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The value consists of 0 to 64
               characters, including letters, digits, periods (.), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] dss_pool_id: Specifies the exclusive storage ID for Dec users. It is different for each az
               configuration. When creating an instance for Dec users, it is needed to be specified for all nodes of the instance
               and separated by commas if database instance type is not standalone or read-only.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the RDS instance.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance.
        :param pulumi.Input[_builtins.str] ha_replication_mode: Required for HA instances. Specifies the replication mode for the standby DB instance.
               + For MySQL, the value is **async** or **semisync**.
               + For PostgreSQL, the value is **async** or **sync**.
               + For Microsoft SQL Server, the value is **sync**.
               
               > **NOTE:** **async** indicates the asynchronous replication mode. **semisync** indicates the semi-synchronous
               replication mode. **sync** indicates the synchronous replication mode.
        :param pulumi.Input[_builtins.str] lower_case_table_names: Specifies the case-sensitive state of the database table name,
               the default value is "1". Changing this parameter will create a new resource.
               + 0: Table names are stored as fixed and table names are case-sensitive.
               + 1: Table names will be stored in lower case and table names are not case-sensitive.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which the maintenance time window starts, for example, **22:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which the maintenance time window ends, for example, **01:00**.
               
               > **Note** For RDS for MySQL and RDS for PostgreSQL databases, the maintenance begin time and end time must be on the
               hour, and the interval between them must be one to four hours.<br>
               For RDS for SQL Server databases, the interval between the maintenance begin time and end time must be four hours.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]] msdtc_hosts: Specify the host information for MSDTC.
               The msdtc_hosts structure is documented below.
               
               > **NOTE:** Only adding MSDTC hosts is supported, deletion is not allowed.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[_builtins.str] param_group_id: Specifies the parameter group ID.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Specify an array of one or more parameters to be set to the RDS instance after
               launched. You can check on console to see which parameters supported. Structure is documented below.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to **month**, the value ranges from `1` to `9`. If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               creates a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               Value options: **ON**, **OFF** and **REBOOT**.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_dns_name_prefix: Specifies the prefix of the private domain name. The value contains
               **8** to **64** characters. Only uppercase letters, lowercase letters, and digits are allowed.
        :param pulumi.Input[_builtins.str] read_write_permissions: Specifies the read write permissions of the instance. Valid values:
               + **readwrite**: read write permissions.
               + **readonly**: readonly permissions.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input['InstanceRestoreArgs'] restore: Specifies the restoration information. It only supported restore to postpaid
               instance. Structure is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] rotate_day: Specifies the rotation days of TDE rotation.
        :param pulumi.Input[_builtins.bool] seconds_level_monitoring_enabled: Specifies whether to enable seconds level monitoring.
        :param pulumi.Input[_builtins.int] seconds_level_monitoring_interval: Specifies the seconds level monitoring interval. Valid values:
               **1**, **5**. It is mandatory when `seconds_level_monitoring_enabled` is **true**.
        :param pulumi.Input[_builtins.str] secret_id: Specifies the key ID of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_name: Specifies the key name of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_version: Specifies the key version of TDE rotation.
               
               > **NOTE:** `rotate_day`, `secret_id`, `secret_name` and `secret_version` will only take effect when `tde_enabled`
               is **true**.
        :param pulumi.Input[_builtins.str] slow_log_show_original_status: Specifies the slow log show original status of the instance.
               Only **MySQL** and **PostgreSQL** are supported. Value options: **on**, **off**.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[_builtins.str] switch_strategy: Specifies the database switchover policy.
               + **reliability**: reliability first.
               + **availability**: availability first.
               
               Defaults to **reliability**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[_builtins.bool] tde_enabled: Specifies whether enable TDE for the instance.
               
               > **NOTE:** TDE cannot be disabled after being enabled.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "db", db)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "volume", volume)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if binlog_retention_hours is not None:
            pulumi.set(__self__, "binlog_retention_hours", binlog_retention_hours)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if ha_replication_mode is not None:
            pulumi.set(__self__, "ha_replication_mode", ha_replication_mode)
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if msdtc_hosts is not None:
            pulumi.set(__self__, "msdtc_hosts", msdtc_hosts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if param_group_id is not None:
            pulumi.set(__self__, "param_group_id", param_group_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if power_action is not None:
            pulumi.set(__self__, "power_action", power_action)
        if private_dns_name_prefix is not None:
            pulumi.set(__self__, "private_dns_name_prefix", private_dns_name_prefix)
        if read_write_permissions is not None:
            pulumi.set(__self__, "read_write_permissions", read_write_permissions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if rotate_day is not None:
            pulumi.set(__self__, "rotate_day", rotate_day)
        if seconds_level_monitoring_enabled is not None:
            pulumi.set(__self__, "seconds_level_monitoring_enabled", seconds_level_monitoring_enabled)
        if seconds_level_monitoring_interval is not None:
            pulumi.set(__self__, "seconds_level_monitoring_interval", seconds_level_monitoring_interval)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if slow_log_show_original_status is not None:
            pulumi.set(__self__, "slow_log_show_original_status", slow_log_show_original_status)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if switch_strategy is not None:
            pulumi.set(__self__, "switch_strategy", switch_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tde_enabled is not None:
            pulumi.set(__self__, "tde_enabled", tde_enabled)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter
    def db(self) -> pulumi.Input['InstanceDbArgs']:
        """
        Specifies the database information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "db")

    @db.setter
    def db(self, value: pulumi.Input['InstanceDbArgs']):
        pulumi.set(self, "db", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the specification code.

        > **NOTE:** Services will be interrupted for 5 to 10 minutes when you change RDS instance flavor.If this parameter is
        changed, a temporary instance will be generated. This temporary instance will occupy the association of the VPC
        security group and cannot be deleted for 12 hours.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the network id of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def volume(self) -> pulumi.Input['InstanceVolumeArgs']:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['InstanceVolumeArgs']):
        pulumi.set(self, "volume", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled. Valid values are "true" and "false".
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @_builtins.property
    @pulumi.getter(name="binlogRetentionHours")
    def binlog_retention_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the binlog retention period in hours. This parameter applies only to
        MySQL Server databases. Value range: **0** to **168 (7x24)**.
        """
        return pulumi.get(self, "binlog_retention_hours")

    @binlog_retention_hours.setter
    def binlog_retention_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "binlog_retention_hours", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the RDS DB instance. Valid values are
        **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the instance. The value consists of 0 to 64
        characters, including letters, digits, periods (.), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the exclusive storage ID for Dec users. It is different for each az
        configuration. When creating an instance for Dec users, it is needed to be specified for all nodes of the instance
        and separated by commas if database instance type is not standalone or read-only.
        """
        return pulumi.get(self, "dss_pool_id")

    @dss_pool_id.setter
    def dss_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dss_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the RDS instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an intranet floating IP address of RDS DB instance.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HA instances. Specifies the replication mode for the standby DB instance.
        + For MySQL, the value is **async** or **semisync**.
        + For PostgreSQL, the value is **async** or **sync**.
        + For Microsoft SQL Server, the value is **sync**.

        > **NOTE:** **async** indicates the asynchronous replication mode. **semisync** indicates the semi-synchronous
        replication mode. **sync** indicates the synchronous replication mode.
        """
        return pulumi.get(self, "ha_replication_mode")

    @ha_replication_mode.setter
    def ha_replication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_replication_mode", value)

    @_builtins.property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the case-sensitive state of the database table name,
        the default value is "1". Changing this parameter will create a new resource.
        + 0: Table names are stored as fixed and table names are case-sensitive.
        + 1: Table names will be stored in lower case and table names are not case-sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @lower_case_table_names.setter
    def lower_case_table_names(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lower_case_table_names", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which the maintenance time window starts, for example, **22:00**.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which the maintenance time window ends, for example, **01:00**.

        > **Note** For RDS for MySQL and RDS for PostgreSQL databases, the maintenance begin time and end time must be on the
        hour, and the interval between them must be one to four hours.<br>
        For RDS for SQL Server databases, the interval between the maintenance begin time and end time must be four hours.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter(name="msdtcHosts")
    def msdtc_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]]]:
        """
        Specify the host information for MSDTC.
        The msdtc_hosts structure is documented below.

        > **NOTE:** Only adding MSDTC hosts is supported, deletion is not allowed.
        """
        return pulumi.get(self, "msdtc_hosts")

    @msdtc_hosts.setter
    def msdtc_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]]]):
        pulumi.set(self, "msdtc_hosts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter group ID.
        """
        return pulumi.get(self, "param_group_id")

    @param_group_id.setter
    def param_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_group_id", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Specify an array of one or more parameters to be set to the RDS instance after
        launched. You can check on console to see which parameters supported. Structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the RDS DB instance. If `period_unit` is set
        to **month**, the value ranges from `1` to `9`. If `period_unit` is set to **year**, the value ranges from `1` to `3`.
        This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the RDS DB instance. Valid values
        are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the power action to be done for the instance.
        Value options: **ON**, **OFF** and **REBOOT**.

        > **NOTE:** The `power_action` is a one-time action.
        """
        return pulumi.get(self, "power_action")

    @power_action.setter
    def power_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_action", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsNamePrefix")
    def private_dns_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the prefix of the private domain name. The value contains
        **8** to **64** characters. Only uppercase letters, lowercase letters, and digits are allowed.
        """
        return pulumi.get(self, "private_dns_name_prefix")

    @private_dns_name_prefix.setter
    def private_dns_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="readWritePermissions")
    def read_write_permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the read write permissions of the instance. Valid values:
        + **readwrite**: read write permissions.
        + **readonly**: readonly permissions.
        """
        return pulumi.get(self, "read_write_permissions")

    @read_write_permissions.setter
    def read_write_permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_write_permissions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new rds instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['InstanceRestoreArgs']]:
        """
        Specifies the restoration information. It only supported restore to postpaid
        instance. Structure is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['InstanceRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="rotateDay")
    def rotate_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the rotation days of TDE rotation.
        """
        return pulumi.get(self, "rotate_day")

    @rotate_day.setter
    def rotate_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotate_day", value)

    @_builtins.property
    @pulumi.getter(name="secondsLevelMonitoringEnabled")
    def seconds_level_monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable seconds level monitoring.
        """
        return pulumi.get(self, "seconds_level_monitoring_enabled")

    @seconds_level_monitoring_enabled.setter
    def seconds_level_monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seconds_level_monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter(name="secondsLevelMonitoringInterval")
    def seconds_level_monitoring_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the seconds level monitoring interval. Valid values:
        **1**, **5**. It is mandatory when `seconds_level_monitoring_enabled` is **true**.
        """
        return pulumi.get(self, "seconds_level_monitoring_interval")

    @seconds_level_monitoring_interval.setter
    def seconds_level_monitoring_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "seconds_level_monitoring_interval", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key ID of TDE rotation.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key name of TDE rotation.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key version of TDE rotation.

        > **NOTE:** `rotate_day`, `secret_id`, `secret_name` and `secret_version` will only take effect when `tde_enabled`
        is **true**.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_version", value)

    @_builtins.property
    @pulumi.getter(name="slowLogShowOriginalStatus")
    def slow_log_show_original_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the slow log show original status of the instance.
        Only **MySQL** and **PostgreSQL** are supported. Value options: **on**, **off**.
        """
        return pulumi.get(self, "slow_log_show_original_status")

    @slow_log_show_original_status.setter
    def slow_log_show_original_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slow_log_show_original_status", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the SSL for MySQL database.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter(name="switchStrategy")
    def switch_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database switchover policy.
        + **reliability**: reliability first.
        + **availability**: availability first.

        Defaults to **reliability**.
        """
        return pulumi.get(self, "switch_strategy")

    @switch_strategy.setter
    def switch_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_strategy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
        pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tdeEnabled")
    def tde_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable TDE for the instance.

        > **NOTE:** TDE cannot be disabled after being enabled.
        """
        return pulumi.get(self, "tde_enabled")

    @tde_enabled.setter
    def tde_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tde_enabled", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
        and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
        Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
        zone is expressed as a character string.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 db: Optional[pulumi.Input['InstanceDbArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 msdtc_hosts: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]] = None,
                 param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 read_write_permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input['InstanceRestoreArgs']] = None,
                 rotate_day: Optional[pulumi.Input[_builtins.int]] = None,
                 seconds_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 seconds_level_monitoring_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_version: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_log_show_original_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input['InstanceVolumeArgs']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specify the binlog retention period in hours. This parameter applies only to
               MySQL Server databases. Value range: **0** to **168 (7x24)**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        :param pulumi.Input[_builtins.str] created: Indicates the creation time.
        :param pulumi.Input['InstanceDbArgs'] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The value consists of 0 to 64
               characters, including letters, digits, periods (.), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] dss_pool_id: Specifies the exclusive storage ID for Dec users. It is different for each az
               configuration. When creating an instance for Dec users, it is needed to be specified for all nodes of the instance
               and separated by commas if database instance type is not standalone or read-only.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the RDS instance.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
               
               > **NOTE:** Services will be interrupted for 5 to 10 minutes when you change RDS instance flavor.If this parameter is
               changed, a temporary instance will be generated. This temporary instance will occupy the association of the VPC
               security group and cannot be deleted for 12 hours.
        :param pulumi.Input[_builtins.str] ha_replication_mode: Required for HA instances. Specifies the replication mode for the standby DB instance.
               + For MySQL, the value is **async** or **semisync**.
               + For PostgreSQL, the value is **async** or **sync**.
               + For Microsoft SQL Server, the value is **sync**.
               
               > **NOTE:** **async** indicates the asynchronous replication mode. **semisync** indicates the semi-synchronous
               replication mode. **sync** indicates the synchronous replication mode.
        :param pulumi.Input[_builtins.str] lower_case_table_names: Specifies the case-sensitive state of the database table name,
               the default value is "1". Changing this parameter will create a new resource.
               + 0: Table names are stored as fixed and table names are case-sensitive.
               + 1: Table names will be stored in lower case and table names are not case-sensitive.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which the maintenance time window starts, for example, **22:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which the maintenance time window ends, for example, **01:00**.
               
               > **Note** For RDS for MySQL and RDS for PostgreSQL databases, the maintenance begin time and end time must be on the
               hour, and the interval between them must be one to four hours.<br>
               For RDS for SQL Server databases, the interval between the maintenance begin time and end time must be four hours.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]] msdtc_hosts: Specify the host information for MSDTC.
               The msdtc_hosts structure is documented below.
               
               > **NOTE:** Only adding MSDTC hosts is supported, deletion is not allowed.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[_builtins.str] param_group_id: Specifies the parameter group ID.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Specify an array of one or more parameters to be set to the RDS instance after
               launched. You can check on console to see which parameters supported. Structure is documented below.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to **month**, the value ranges from `1` to `9`. If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               creates a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               Value options: **ON**, **OFF** and **REBOOT**.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_dns_name_prefix: Specifies the prefix of the private domain name. The value contains
               **8** to **64** characters. Only uppercase letters, lowercase letters, and digits are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_dns_names: Indicates the private domain name list of the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Indicates the private IP address list. It is a blank string until an ECS is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[_builtins.str] read_write_permissions: Specifies the read write permissions of the instance. Valid values:
               + **readwrite**: read write permissions.
               + **readonly**: readonly permissions.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input['InstanceRestoreArgs'] restore: Specifies the restoration information. It only supported restore to postpaid
               instance. Structure is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] rotate_day: Specifies the rotation days of TDE rotation.
        :param pulumi.Input[_builtins.bool] seconds_level_monitoring_enabled: Specifies whether to enable seconds level monitoring.
        :param pulumi.Input[_builtins.int] seconds_level_monitoring_interval: Specifies the seconds level monitoring interval. Valid values:
               **1**, **5**. It is mandatory when `seconds_level_monitoring_enabled` is **true**.
        :param pulumi.Input[_builtins.str] secret_id: Specifies the key ID of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_name: Specifies the key name of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_version: Specifies the key version of TDE rotation.
               
               > **NOTE:** `rotate_day`, `secret_id`, `secret_name` and `secret_version` will only take effect when `tde_enabled`
               is **true**.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[_builtins.str] slow_log_show_original_status: Specifies the slow log show original status of the instance.
               Only **MySQL** and **PostgreSQL** are supported. Value options: **on**, **off**.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] switch_strategy: Specifies the database switchover policy.
               + **reliability**: reliability first.
               + **availability**: availability first.
               
               Defaults to **reliability**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[_builtins.bool] tde_enabled: Specifies whether enable TDE for the instance.
               
               > **NOTE:** TDE cannot be disabled after being enabled.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string.
        :param pulumi.Input['InstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if binlog_retention_hours is not None:
            pulumi.set(__self__, "binlog_retention_hours", binlog_retention_hours)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if db is not None:
            pulumi.set(__self__, "db", db)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if ha_replication_mode is not None:
            pulumi.set(__self__, "ha_replication_mode", ha_replication_mode)
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if msdtc_hosts is not None:
            pulumi.set(__self__, "msdtc_hosts", msdtc_hosts)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if param_group_id is not None:
            pulumi.set(__self__, "param_group_id", param_group_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if power_action is not None:
            pulumi.set(__self__, "power_action", power_action)
        if private_dns_name_prefix is not None:
            pulumi.set(__self__, "private_dns_name_prefix", private_dns_name_prefix)
        if private_dns_names is not None:
            pulumi.set(__self__, "private_dns_names", private_dns_names)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if read_write_permissions is not None:
            pulumi.set(__self__, "read_write_permissions", read_write_permissions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if rotate_day is not None:
            pulumi.set(__self__, "rotate_day", rotate_day)
        if seconds_level_monitoring_enabled is not None:
            pulumi.set(__self__, "seconds_level_monitoring_enabled", seconds_level_monitoring_enabled)
        if seconds_level_monitoring_interval is not None:
            pulumi.set(__self__, "seconds_level_monitoring_interval", seconds_level_monitoring_interval)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if slow_log_show_original_status is not None:
            pulumi.set(__self__, "slow_log_show_original_status", slow_log_show_original_status)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if switch_strategy is not None:
            pulumi.set(__self__, "switch_strategy", switch_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tde_enabled is not None:
            pulumi.set(__self__, "tde_enabled", tde_enabled)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled. Valid values are "true" and "false".
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @_builtins.property
    @pulumi.getter(name="binlogRetentionHours")
    def binlog_retention_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the binlog retention period in hours. This parameter applies only to
        MySQL Server databases. Value range: **0** to **168 (7x24)**.
        """
        return pulumi.get(self, "binlog_retention_hours")

    @binlog_retention_hours.setter
    def binlog_retention_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "binlog_retention_hours", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the RDS DB instance. Valid values are
        **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "collation", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the creation time.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def db(self) -> Optional[pulumi.Input['InstanceDbArgs']]:
        """
        Specifies the database information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "db")

    @db.setter
    def db(self, value: Optional[pulumi.Input['InstanceDbArgs']]):
        pulumi.set(self, "db", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the instance. The value consists of 0 to 64
        characters, including letters, digits, periods (.), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the exclusive storage ID for Dec users. It is different for each az
        configuration. When creating an instance for Dec users, it is needed to be specified for all nodes of the instance
        and separated by commas if database instance type is not standalone or read-only.
        """
        return pulumi.get(self, "dss_pool_id")

    @dss_pool_id.setter
    def dss_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dss_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the RDS instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies an intranet floating IP address of RDS DB instance.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the specification code.

        > **NOTE:** Services will be interrupted for 5 to 10 minutes when you change RDS instance flavor.If this parameter is
        changed, a temporary instance will be generated. This temporary instance will occupy the association of the VPC
        security group and cannot be deleted for 12 hours.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HA instances. Specifies the replication mode for the standby DB instance.
        + For MySQL, the value is **async** or **semisync**.
        + For PostgreSQL, the value is **async** or **sync**.
        + For Microsoft SQL Server, the value is **sync**.

        > **NOTE:** **async** indicates the asynchronous replication mode. **semisync** indicates the semi-synchronous
        replication mode. **sync** indicates the synchronous replication mode.
        """
        return pulumi.get(self, "ha_replication_mode")

    @ha_replication_mode.setter
    def ha_replication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ha_replication_mode", value)

    @_builtins.property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the case-sensitive state of the database table name,
        the default value is "1". Changing this parameter will create a new resource.
        + 0: Table names are stored as fixed and table names are case-sensitive.
        + 1: Table names will be stored in lower case and table names are not case-sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @lower_case_table_names.setter
    def lower_case_table_names(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lower_case_table_names", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which the maintenance time window starts, for example, **22:00**.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which the maintenance time window ends, for example, **01:00**.

        > **Note** For RDS for MySQL and RDS for PostgreSQL databases, the maintenance begin time and end time must be on the
        hour, and the interval between them must be one to four hours.<br>
        For RDS for SQL Server databases, the interval between the maintenance begin time and end time must be four hours.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter(name="msdtcHosts")
    def msdtc_hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]]]:
        """
        Specify the host information for MSDTC.
        The msdtc_hosts structure is documented below.

        > **NOTE:** Only adding MSDTC hosts is supported, deletion is not allowed.
        """
        return pulumi.get(self, "msdtc_hosts")

    @msdtc_hosts.setter
    def msdtc_hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMsdtcHostArgs']]]]):
        pulumi.set(self, "msdtc_hosts", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter group ID.
        """
        return pulumi.get(self, "param_group_id")

    @param_group_id.setter
    def param_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "param_group_id", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Specify an array of one or more parameters to be set to the RDS instance after
        launched. You can check on console to see which parameters supported. Structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the RDS DB instance. If `period_unit` is set
        to **month**, the value ranges from `1` to `9`. If `period_unit` is set to **year**, the value ranges from `1` to `3`.
        This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the RDS DB instance. Valid values
        are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the power action to be done for the instance.
        Value options: **ON**, **OFF** and **REBOOT**.

        > **NOTE:** The `power_action` is a one-time action.
        """
        return pulumi.get(self, "power_action")

    @power_action.setter
    def power_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_action", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsNamePrefix")
    def private_dns_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the prefix of the private domain name. The value contains
        **8** to **64** characters. Only uppercase letters, lowercase letters, and digits are allowed.
        """
        return pulumi.get(self, "private_dns_name_prefix")

    @private_dns_name_prefix.setter
    def private_dns_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsNames")
    def private_dns_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Indicates the private domain name list of the DB instance.
        """
        return pulumi.get(self, "private_dns_names")

    @private_dns_names.setter
    def private_dns_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_dns_names", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Indicates the private IP address list. It is a blank string until an ECS is created.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_ips", value)

    @_builtins.property
    @pulumi.getter(name="readWritePermissions")
    def read_write_permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the read write permissions of the instance. Valid values:
        + **readwrite**: read write permissions.
        + **readonly**: readonly permissions.
        """
        return pulumi.get(self, "read_write_permissions")

    @read_write_permissions.setter
    def read_write_permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_write_permissions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new rds instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['InstanceRestoreArgs']]:
        """
        Specifies the restoration information. It only supported restore to postpaid
        instance. Structure is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['InstanceRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @_builtins.property
    @pulumi.getter(name="rotateDay")
    def rotate_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the rotation days of TDE rotation.
        """
        return pulumi.get(self, "rotate_day")

    @rotate_day.setter
    def rotate_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotate_day", value)

    @_builtins.property
    @pulumi.getter(name="secondsLevelMonitoringEnabled")
    def seconds_level_monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable seconds level monitoring.
        """
        return pulumi.get(self, "seconds_level_monitoring_enabled")

    @seconds_level_monitoring_enabled.setter
    def seconds_level_monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "seconds_level_monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter(name="secondsLevelMonitoringInterval")
    def seconds_level_monitoring_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the seconds level monitoring interval. Valid values:
        **1**, **5**. It is mandatory when `seconds_level_monitoring_enabled` is **true**.
        """
        return pulumi.get(self, "seconds_level_monitoring_interval")

    @seconds_level_monitoring_interval.setter
    def seconds_level_monitoring_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "seconds_level_monitoring_interval", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key ID of TDE rotation.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key name of TDE rotation.
        """
        return pulumi.get(self, "secret_name")

    @secret_name.setter
    def secret_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_name", value)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the key version of TDE rotation.

        > **NOTE:** `rotate_day`, `secret_id`, `secret_name` and `secret_version` will only take effect when `tde_enabled`
        is **true**.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_version", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="slowLogShowOriginalStatus")
    def slow_log_show_original_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the slow log show original status of the instance.
        Only **MySQL** and **PostgreSQL** are supported. Value options: **on**, **off**.
        """
        return pulumi.get(self, "slow_log_show_original_status")

    @slow_log_show_original_status.setter
    def slow_log_show_original_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slow_log_show_original_status", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable the SSL for MySQL database.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network id of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="switchStrategy")
    def switch_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database switchover policy.
        + **reliability**: reliability first.
        + **availability**: availability first.

        Defaults to **reliability**.
        """
        return pulumi.get(self, "switch_strategy")

    @switch_strategy.setter
    def switch_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch_strategy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
        pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tdeEnabled")
    def tde_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether enable TDE for the instance.

        > **NOTE:** TDE cannot be disabled after being enabled.
        """
        return pulumi.get(self, "tde_enabled")

    @tde_enabled.setter
    def tde_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tde_enabled", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
        and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
        Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
        zone is expressed as a character string.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['InstanceVolumeArgs']]:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['InstanceVolumeArgs']]):
        pulumi.set(self, "volume", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Rds/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_strategy: Optional[pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']]] = None,
                 binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 db: Optional[pulumi.Input[Union['InstanceDbArgs', 'InstanceDbArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 msdtc_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMsdtcHostArgs', 'InstanceMsdtcHostArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write_permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['InstanceRestoreArgs', 'InstanceRestoreArgsDict']]] = None,
                 rotate_day: Optional[pulumi.Input[_builtins.int]] = None,
                 seconds_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 seconds_level_monitoring_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_version: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_log_show_original_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage RDS instance resource within SberCloud.

        ## Example Usage

        ### create a single db instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone = config.require_object("availabilityZone")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[availability_zone],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        ```

        ### create a primary/standby db instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone1 = config.require_object("availabilityZone1")
        availability_zone2 = config.require_object("availabilityZone2")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2.ha",
            ha_replication_mode="async",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[
                availability_zone1_config,
                availability_zone2_config,
            ],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        ```

        ### create a single db instance with encrypted volume

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone = config.require_object("availabilityZone")
        kms_id = config.require_object("kmsId")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[availability_zone],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
                "disk_encryption_id": kms_id,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        ```

        ### create db instance with customized parameters

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone = config.require_object("availabilityZone")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[availability_zone],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            },
            parameters=[
                {
                    "name": "div_precision_increment",
                    "value": "12",
                },
                {
                    "name": "connect_timeout",
                    "value": "13",
                },
            ])
        ```

        ## Import

        RDS instance can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Rds/instance:Instance instance_1 52e4b497d2c94df88a2eb4c661314903in01
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `db`, `collation`, `availability_zone`,

        `lower_case_table_names`,`slow_log_show_original_status`. It is generally recommended running `pulumi preview` after

        importing a RDS instance. You can then decide if changes should be applied to the instance, or the resource definition

        should be updated to align with the instance. Also, you can ignore changes as below.

        hcl

        resource "sbercloud_rds_instance" "instance_1" {

          ...

          lifecycle {

            ignore_changes = [
            
              "db", "collation", "availability_zone", "lower_case_table_names", "slow_log_show_original_status"
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specify the binlog retention period in hours. This parameter applies only to
               MySQL Server databases. Value range: **0** to **168 (7x24)**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        :param pulumi.Input[Union['InstanceDbArgs', 'InstanceDbArgsDict']] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The value consists of 0 to 64
               characters, including letters, digits, periods (.), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] dss_pool_id: Specifies the exclusive storage ID for Dec users. It is different for each az
               configuration. When creating an instance for Dec users, it is needed to be specified for all nodes of the instance
               and separated by commas if database instance type is not standalone or read-only.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the RDS instance.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
               
               > **NOTE:** Services will be interrupted for 5 to 10 minutes when you change RDS instance flavor.If this parameter is
               changed, a temporary instance will be generated. This temporary instance will occupy the association of the VPC
               security group and cannot be deleted for 12 hours.
        :param pulumi.Input[_builtins.str] ha_replication_mode: Required for HA instances. Specifies the replication mode for the standby DB instance.
               + For MySQL, the value is **async** or **semisync**.
               + For PostgreSQL, the value is **async** or **sync**.
               + For Microsoft SQL Server, the value is **sync**.
               
               > **NOTE:** **async** indicates the asynchronous replication mode. **semisync** indicates the semi-synchronous
               replication mode. **sync** indicates the synchronous replication mode.
        :param pulumi.Input[_builtins.str] lower_case_table_names: Specifies the case-sensitive state of the database table name,
               the default value is "1". Changing this parameter will create a new resource.
               + 0: Table names are stored as fixed and table names are case-sensitive.
               + 1: Table names will be stored in lower case and table names are not case-sensitive.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which the maintenance time window starts, for example, **22:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which the maintenance time window ends, for example, **01:00**.
               
               > **Note** For RDS for MySQL and RDS for PostgreSQL databases, the maintenance begin time and end time must be on the
               hour, and the interval between them must be one to four hours.<br>
               For RDS for SQL Server databases, the interval between the maintenance begin time and end time must be four hours.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMsdtcHostArgs', 'InstanceMsdtcHostArgsDict']]]] msdtc_hosts: Specify the host information for MSDTC.
               The msdtc_hosts structure is documented below.
               
               > **NOTE:** Only adding MSDTC hosts is supported, deletion is not allowed.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[_builtins.str] param_group_id: Specifies the parameter group ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: Specify an array of one or more parameters to be set to the RDS instance after
               launched. You can check on console to see which parameters supported. Structure is documented below.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to **month**, the value ranges from `1` to `9`. If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               creates a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               Value options: **ON**, **OFF** and **REBOOT**.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_dns_name_prefix: Specifies the prefix of the private domain name. The value contains
               **8** to **64** characters. Only uppercase letters, lowercase letters, and digits are allowed.
        :param pulumi.Input[_builtins.str] read_write_permissions: Specifies the read write permissions of the instance. Valid values:
               + **readwrite**: read write permissions.
               + **readonly**: readonly permissions.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input[Union['InstanceRestoreArgs', 'InstanceRestoreArgsDict']] restore: Specifies the restoration information. It only supported restore to postpaid
               instance. Structure is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] rotate_day: Specifies the rotation days of TDE rotation.
        :param pulumi.Input[_builtins.bool] seconds_level_monitoring_enabled: Specifies whether to enable seconds level monitoring.
        :param pulumi.Input[_builtins.int] seconds_level_monitoring_interval: Specifies the seconds level monitoring interval. Valid values:
               **1**, **5**. It is mandatory when `seconds_level_monitoring_enabled` is **true**.
        :param pulumi.Input[_builtins.str] secret_id: Specifies the key ID of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_name: Specifies the key name of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_version: Specifies the key version of TDE rotation.
               
               > **NOTE:** `rotate_day`, `secret_id`, `secret_name` and `secret_version` will only take effect when `tde_enabled`
               is **true**.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[_builtins.str] slow_log_show_original_status: Specifies the slow log show original status of the instance.
               Only **MySQL** and **PostgreSQL** are supported. Value options: **on**, **off**.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] switch_strategy: Specifies the database switchover policy.
               + **reliability**: reliability first.
               + **availability**: availability first.
               
               Defaults to **reliability**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[_builtins.bool] tde_enabled: Specifies whether enable TDE for the instance.
               
               > **NOTE:** TDE cannot be disabled after being enabled.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string.
        :param pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage RDS instance resource within SberCloud.

        ## Example Usage

        ### create a single db instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone = config.require_object("availabilityZone")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[availability_zone],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        ```

        ### create a primary/standby db instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone1 = config.require_object("availabilityZone1")
        availability_zone2 = config.require_object("availabilityZone2")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2.ha",
            ha_replication_mode="async",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[
                availability_zone1_config,
                availability_zone2_config,
            ],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        ```

        ### create a single db instance with encrypted volume

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone = config.require_object("availabilityZone")
        kms_id = config.require_object("kmsId")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[availability_zone],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
                "disk_encryption_id": kms_id,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        ```

        ### create db instance with customized parameters

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        availability_zone = config.require_object("availabilityZone")
        postgre_sql_password = config.require_object("postgreSQLPassword")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.n1.large.2",
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id,
            availability_zones=[availability_zone],
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": postgre_sql_password,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 100,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            },
            parameters=[
                {
                    "name": "div_precision_increment",
                    "value": "12",
                },
                {
                    "name": "connect_timeout",
                    "value": "13",
                },
            ])
        ```

        ## Import

        RDS instance can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Rds/instance:Instance instance_1 52e4b497d2c94df88a2eb4c661314903in01
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `db`, `collation`, `availability_zone`,

        `lower_case_table_names`,`slow_log_show_original_status`. It is generally recommended running `pulumi preview` after

        importing a RDS instance. You can then decide if changes should be applied to the instance, or the resource definition

        should be updated to align with the instance. Also, you can ignore changes as below.

        hcl

        resource "sbercloud_rds_instance" "instance_1" {

          ...

          lifecycle {

            ignore_changes = [
            
              "db", "collation", "availability_zone", "lower_case_table_names", "slow_log_show_original_status"
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_strategy: Optional[pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']]] = None,
                 binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 collation: Optional[pulumi.Input[_builtins.str]] = None,
                 db: Optional[pulumi.Input[Union['InstanceDbArgs', 'InstanceDbArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 ha_replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 msdtc_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMsdtcHostArgs', 'InstanceMsdtcHostArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 read_write_permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['InstanceRestoreArgs', 'InstanceRestoreArgsDict']]] = None,
                 rotate_day: Optional[pulumi.Input[_builtins.int]] = None,
                 seconds_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 seconds_level_monitoring_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_version: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_log_show_original_status: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 switch_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tde_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["binlog_retention_hours"] = binlog_retention_hours
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["collation"] = collation
            if db is None and not opts.urn:
                raise TypeError("Missing required property 'db'")
            __props__.__dict__["db"] = db
            __props__.__dict__["description"] = description
            __props__.__dict__["dss_pool_id"] = dss_pool_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["fixed_ip"] = fixed_ip
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["ha_replication_mode"] = ha_replication_mode
            __props__.__dict__["lower_case_table_names"] = lower_case_table_names
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            __props__.__dict__["msdtc_hosts"] = msdtc_hosts
            __props__.__dict__["name"] = name
            __props__.__dict__["param_group_id"] = param_group_id
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["power_action"] = power_action
            __props__.__dict__["private_dns_name_prefix"] = private_dns_name_prefix
            __props__.__dict__["read_write_permissions"] = read_write_permissions
            __props__.__dict__["region"] = region
            __props__.__dict__["restore"] = restore
            __props__.__dict__["rotate_day"] = rotate_day
            __props__.__dict__["seconds_level_monitoring_enabled"] = seconds_level_monitoring_enabled
            __props__.__dict__["seconds_level_monitoring_interval"] = seconds_level_monitoring_interval
            __props__.__dict__["secret_id"] = secret_id
            __props__.__dict__["secret_name"] = secret_name
            __props__.__dict__["secret_version"] = secret_version
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["slow_log_show_original_status"] = slow_log_show_original_status
            __props__.__dict__["ssl_enable"] = ssl_enable
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["switch_strategy"] = switch_strategy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tde_enabled"] = tde_enabled
            __props__.__dict__["time_zone"] = time_zone
            if volume is None and not opts.urn:
                raise TypeError("Missing required property 'volume'")
            __props__.__dict__["volume"] = volume
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["private_dns_names"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["public_ips"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'sbercloud:Rds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_strategy: Optional[pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']]] = None,
            binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            collation: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            db: Optional[pulumi.Input[Union['InstanceDbArgs', 'InstanceDbArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[_builtins.str]] = None,
            ha_replication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            lower_case_table_names: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            msdtc_hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMsdtcHostArgs', 'InstanceMsdtcHostArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeArgs', 'InstanceNodeArgsDict']]]]] = None,
            param_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            power_action: Optional[pulumi.Input[_builtins.str]] = None,
            private_dns_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            private_dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            read_write_permissions: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            restore: Optional[pulumi.Input[Union['InstanceRestoreArgs', 'InstanceRestoreArgsDict']]] = None,
            rotate_day: Optional[pulumi.Input[_builtins.int]] = None,
            seconds_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            seconds_level_monitoring_interval: Optional[pulumi.Input[_builtins.int]] = None,
            secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            secret_name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_version: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            slow_log_show_original_status: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            switch_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tde_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            volume: Optional[pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specify the binlog retention period in hours. This parameter applies only to
               MySQL Server databases. Value range: **0** to **168 (7x24)**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the RDS DB instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] collation: Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        :param pulumi.Input[_builtins.str] created: Indicates the creation time.
        :param pulumi.Input[Union['InstanceDbArgs', 'InstanceDbArgsDict']] db: Specifies the database information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The value consists of 0 to 64
               characters, including letters, digits, periods (.), underscores (_), and hyphens (-).
        :param pulumi.Input[_builtins.str] dss_pool_id: Specifies the exclusive storage ID for Dec users. It is different for each az
               configuration. When creating an instance for Dec users, it is needed to be specified for all nodes of the instance
               and separated by commas if database instance type is not standalone or read-only.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the RDS instance.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies an intranet floating IP address of RDS DB instance.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
               
               > **NOTE:** Services will be interrupted for 5 to 10 minutes when you change RDS instance flavor.If this parameter is
               changed, a temporary instance will be generated. This temporary instance will occupy the association of the VPC
               security group and cannot be deleted for 12 hours.
        :param pulumi.Input[_builtins.str] ha_replication_mode: Required for HA instances. Specifies the replication mode for the standby DB instance.
               + For MySQL, the value is **async** or **semisync**.
               + For PostgreSQL, the value is **async** or **sync**.
               + For Microsoft SQL Server, the value is **sync**.
               
               > **NOTE:** **async** indicates the asynchronous replication mode. **semisync** indicates the semi-synchronous
               replication mode. **sync** indicates the synchronous replication mode.
        :param pulumi.Input[_builtins.str] lower_case_table_names: Specifies the case-sensitive state of the database table name,
               the default value is "1". Changing this parameter will create a new resource.
               + 0: Table names are stored as fixed and table names are case-sensitive.
               + 1: Table names will be stored in lower case and table names are not case-sensitive.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which the maintenance time window starts, for example, **22:00**.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which the maintenance time window ends, for example, **01:00**.
               
               > **Note** For RDS for MySQL and RDS for PostgreSQL databases, the maintenance begin time and end time must be on the
               hour, and the interval between them must be one to four hours.<br>
               For RDS for SQL Server databases, the interval between the maintenance begin time and end time must be four hours.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMsdtcHostArgs', 'InstanceMsdtcHostArgsDict']]]] msdtc_hosts: Specify the host information for MSDTC.
               The msdtc_hosts structure is documented below.
               
               > **NOTE:** Only adding MSDTC hosts is supported, deletion is not allowed.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeArgs', 'InstanceNodeArgsDict']]]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[_builtins.str] param_group_id: Specifies the parameter group ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceParameterArgs', 'InstanceParameterArgsDict']]]] parameters: Specify an array of one or more parameters to be set to the RDS instance after
               launched. You can check on console to see which parameters supported. Structure is documented below.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the RDS DB instance. If `period_unit` is set
               to **month**, the value ranges from `1` to `9`. If `period_unit` is set to **year**, the value ranges from `1` to `3`.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the RDS DB instance. Valid values
               are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
               creates a new resource.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               Value options: **ON**, **OFF** and **REBOOT**.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_dns_name_prefix: Specifies the prefix of the private domain name. The value contains
               **8** to **64** characters. Only uppercase letters, lowercase letters, and digits are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_dns_names: Indicates the private domain name list of the DB instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Indicates the private IP address list. It is a blank string until an ECS is created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[_builtins.str] read_write_permissions: Specifies the read write permissions of the instance. Valid values:
               + **readwrite**: read write permissions.
               + **readonly**: readonly permissions.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new rds instance resource.
        :param pulumi.Input[Union['InstanceRestoreArgs', 'InstanceRestoreArgsDict']] restore: Specifies the restoration information. It only supported restore to postpaid
               instance. Structure is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] rotate_day: Specifies the rotation days of TDE rotation.
        :param pulumi.Input[_builtins.bool] seconds_level_monitoring_enabled: Specifies whether to enable seconds level monitoring.
        :param pulumi.Input[_builtins.int] seconds_level_monitoring_interval: Specifies the seconds level monitoring interval. Valid values:
               **1**, **5**. It is mandatory when `seconds_level_monitoring_enabled` is **true**.
        :param pulumi.Input[_builtins.str] secret_id: Specifies the key ID of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_name: Specifies the key name of TDE rotation.
        :param pulumi.Input[_builtins.str] secret_version: Specifies the key version of TDE rotation.
               
               > **NOTE:** `rotate_day`, `secret_id`, `secret_name` and `secret_version` will only take effect when `tde_enabled`
               is **true**.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group which the RDS DB instance belongs to.
        :param pulumi.Input[_builtins.str] slow_log_show_original_status: Specifies the slow log show original status of the instance.
               Only **MySQL** and **PostgreSQL** are supported. Value options: **on**, **off**.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable the SSL for MySQL database.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the network id of a subnet. Changing this parameter will create a
               new resource.
        :param pulumi.Input[_builtins.str] switch_strategy: Specifies the database switchover policy.
               + **reliability**: reliability first.
               + **availability**: availability first.
               
               Defaults to **reliability**.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
               pair.
        :param pulumi.Input[_builtins.bool] tde_enabled: Specifies whether enable TDE for the instance.
               
               > **NOTE:** TDE cannot be disabled after being enabled.
        :param pulumi.Input[_builtins.str] time_zone: Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
               and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
               Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
               zone is expressed as a character string.
        :param pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']] volume: Specifies the volume information. Structure is documented below.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["binlog_retention_hours"] = binlog_retention_hours
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["collation"] = collation
        __props__.__dict__["created"] = created
        __props__.__dict__["db"] = db
        __props__.__dict__["description"] = description
        __props__.__dict__["dss_pool_id"] = dss_pool_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["ha_replication_mode"] = ha_replication_mode
        __props__.__dict__["lower_case_table_names"] = lower_case_table_names
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["msdtc_hosts"] = msdtc_hosts
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["param_group_id"] = param_group_id
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["power_action"] = power_action
        __props__.__dict__["private_dns_name_prefix"] = private_dns_name_prefix
        __props__.__dict__["private_dns_names"] = private_dns_names
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["public_ips"] = public_ips
        __props__.__dict__["read_write_permissions"] = read_write_permissions
        __props__.__dict__["region"] = region
        __props__.__dict__["restore"] = restore
        __props__.__dict__["rotate_day"] = rotate_day
        __props__.__dict__["seconds_level_monitoring_enabled"] = seconds_level_monitoring_enabled
        __props__.__dict__["seconds_level_monitoring_interval"] = seconds_level_monitoring_interval
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["secret_name"] = secret_name
        __props__.__dict__["secret_version"] = secret_version
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["slow_log_show_original_status"] = slow_log_show_original_status
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["switch_strategy"] = switch_strategy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tde_enabled"] = tde_enabled
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["volume"] = volume
        __props__.__dict__["vpc_id"] = vpc_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled. Valid values are "true" and "false".
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output['outputs.InstanceBackupStrategy']:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @_builtins.property
    @pulumi.getter(name="binlogRetentionHours")
    def binlog_retention_hours(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specify the binlog retention period in hours. This parameter applies only to
        MySQL Server databases. Value range: **0** to **168 (7x24)**.
        """
        return pulumi.get(self, "binlog_retention_hours")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the RDS DB instance. Valid values are
        **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter
    def collation(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Character Set, only available to Microsoft SQL Server DB instances.
        """
        return pulumi.get(self, "collation")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the creation time.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def db(self) -> pulumi.Output['outputs.InstanceDb']:
        """
        Specifies the database information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "db")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the instance. The value consists of 0 to 64
        characters, including letters, digits, periods (.), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the exclusive storage ID for Dec users. It is different for each az
        configuration. When creating an instance for Dec users, it is needed to be specified for all nodes of the instance
        and separated by commas if database instance type is not standalone or read-only.
        """
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the RDS instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies an intranet floating IP address of RDS DB instance.
        """
        return pulumi.get(self, "fixed_ip")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the specification code.

        > **NOTE:** Services will be interrupted for 5 to 10 minutes when you change RDS instance flavor.If this parameter is
        changed, a temporary instance will be generated. This temporary instance will occupy the association of the VPC
        security group and cannot be deleted for 12 hours.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Required for HA instances. Specifies the replication mode for the standby DB instance.
        + For MySQL, the value is **async** or **semisync**.
        + For PostgreSQL, the value is **async** or **sync**.
        + For Microsoft SQL Server, the value is **sync**.

        > **NOTE:** **async** indicates the asynchronous replication mode. **semisync** indicates the semi-synchronous
        replication mode. **sync** indicates the synchronous replication mode.
        """
        return pulumi.get(self, "ha_replication_mode")

    @_builtins.property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the case-sensitive state of the database table name,
        the default value is "1". Changing this parameter will create a new resource.
        + 0: Table names are stored as fixed and table names are case-sensitive.
        + 1: Table names will be stored in lower case and table names are not case-sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time at which the maintenance time window starts, for example, **22:00**.
        """
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time at which the maintenance time window ends, for example, **01:00**.

        > **Note** For RDS for MySQL and RDS for PostgreSQL databases, the maintenance begin time and end time must be on the
        hour, and the interval between them must be one to four hours.<br>
        For RDS for SQL Server databases, the interval between the maintenance begin time and end time must be four hours.
        """
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter(name="msdtcHosts")
    def msdtc_hosts(self) -> pulumi.Output[Sequence['outputs.InstanceMsdtcHost']]:
        """
        Specify the host information for MSDTC.
        The msdtc_hosts structure is documented below.

        > **NOTE:** Only adding MSDTC hosts is supported, deletion is not allowed.
        """
        return pulumi.get(self, "msdtc_hosts")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.InstanceNode']]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the parameter group ID.
        """
        return pulumi.get(self, "param_group_id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.InstanceParameter']]:
        """
        Specify an array of one or more parameters to be set to the RDS instance after
        launched. You can check on console to see which parameters supported. Structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the RDS DB instance. If `period_unit` is set
        to **month**, the value ranges from `1` to `9`. If `period_unit` is set to **year**, the value ranges from `1` to `3`.
        This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the RDS DB instance. Valid values
        are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the power action to be done for the instance.
        Value options: **ON**, **OFF** and **REBOOT**.

        > **NOTE:** The `power_action` is a one-time action.
        """
        return pulumi.get(self, "power_action")

    @_builtins.property
    @pulumi.getter(name="privateDnsNamePrefix")
    def private_dns_name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the prefix of the private domain name. The value contains
        **8** to **64** characters. Only uppercase letters, lowercase letters, and digits are allowed.
        """
        return pulumi.get(self, "private_dns_name_prefix")

    @_builtins.property
    @pulumi.getter(name="privateDnsNames")
    def private_dns_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Indicates the private domain name list of the DB instance.
        """
        return pulumi.get(self, "private_dns_names")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Indicates the private IP address list. It is a blank string until an ECS is created.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter(name="readWritePermissions")
    def read_write_permissions(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the read write permissions of the instance. Valid values:
        + **readwrite**: read write permissions.
        + **readonly**: readonly permissions.
        """
        return pulumi.get(self, "read_write_permissions")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new rds instance resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.InstanceRestore']]:
        """
        Specifies the restoration information. It only supported restore to postpaid
        instance. Structure is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "restore")

    @_builtins.property
    @pulumi.getter(name="rotateDay")
    def rotate_day(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the rotation days of TDE rotation.
        """
        return pulumi.get(self, "rotate_day")

    @_builtins.property
    @pulumi.getter(name="secondsLevelMonitoringEnabled")
    def seconds_level_monitoring_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable seconds level monitoring.
        """
        return pulumi.get(self, "seconds_level_monitoring_enabled")

    @_builtins.property
    @pulumi.getter(name="secondsLevelMonitoringInterval")
    def seconds_level_monitoring_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the seconds level monitoring interval. Valid values:
        **1**, **5**. It is mandatory when `seconds_level_monitoring_enabled` is **true**.
        """
        return pulumi.get(self, "seconds_level_monitoring_interval")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the key ID of TDE rotation.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the key name of TDE rotation.
        """
        return pulumi.get(self, "secret_name")

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the key version of TDE rotation.

        > **NOTE:** `rotate_day`, `secret_id`, `secret_name` and `secret_version` will only take effect when `tde_enabled`
        is **true**.
        """
        return pulumi.get(self, "secret_version")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="slowLogShowOriginalStatus")
    def slow_log_show_original_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the slow log show original status of the instance.
        Only **MySQL** and **PostgreSQL** are supported. Value options: **on**, **off**.
        """
        return pulumi.get(self, "slow_log_show_original_status")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable the SSL for MySQL database.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the network id of a subnet. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="switchStrategy")
    def switch_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database switchover policy.
        + **reliability**: reliability first.
        + **availability**: availability first.

        Defaults to **reliability**.
        """
        return pulumi.get(self, "switch_strategy")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the RDS instance. Each tag is represented by one key-value
        pair.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tdeEnabled")
    def tde_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether enable TDE for the instance.

        > **NOTE:** TDE cannot be disabled after being enabled.
        """
        return pulumi.get(self, "tde_enabled")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the UTC time zone. For MySQL and PostgreSQL Chinese mainland site
        and international site use UTC by default. The value ranges from UTC-12:00 to UTC+12:00 at the full hour. For
        Microsoft SQL Server international site use UTC by default and Chinese mainland site use China Standard Time. The time
        zone is expressed as a character string.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def volume(self) -> pulumi.Output['outputs.InstanceVolume']:
        """
        Specifies the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volume")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

