# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['InstanceEipAssociateArgs', 'InstanceEipAssociate']

@pulumi.input_type
class InstanceEipAssociateArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 public_ip: pulumi.Input[_builtins.str],
                 public_ip_id: pulumi.Input[_builtins.str],
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceEipAssociate resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of an RDS instance.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to be bound.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the EIP ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ip_id", public_ip_id)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of an RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the EIP address to be bound.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the EIP ID.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_ip_id", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _InstanceEipAssociateState:
    def __init__(__self__, *,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceEipAssociate resources.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of an RDS instance.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to be bound.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the EIP ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of an RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the EIP address to be bound.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the EIP ID.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Rds/instanceEipAssociate:InstanceEipAssociate")
class InstanceEipAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an RDS instance EIP associate resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        public_ip = config.require_object("publicIp")
        public_ip_id = config.require_object("publicIpId")
        test = sbercloud.rds.InstanceEipAssociate("test",
            instance_id=instance_id,
            public_ip=public_ip,
            public_ip_id=node_id)
        ```

        ## Import

        The RDS instance eip associate can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/instanceEipAssociate:InstanceEipAssociate test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of an RDS instance.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to be bound.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the EIP ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceEipAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an RDS instance EIP associate resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        public_ip = config.require_object("publicIp")
        public_ip_id = config.require_object("publicIpId")
        test = sbercloud.rds.InstanceEipAssociate("test",
            instance_id=instance_id,
            public_ip=public_ip,
            public_ip_id=node_id)
        ```

        ## Import

        The RDS instance eip associate can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/instanceEipAssociate:InstanceEipAssociate test <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceEipAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceEipAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceEipAssociateArgs.__new__(InstanceEipAssociateArgs)

            __props__.__dict__["enable_force_new"] = enable_force_new
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if public_ip is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip'")
            __props__.__dict__["public_ip"] = public_ip
            if public_ip_id is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip_id'")
            __props__.__dict__["public_ip_id"] = public_ip_id
            __props__.__dict__["region"] = region
        super(InstanceEipAssociate, __self__).__init__(
            'sbercloud:Rds/instanceEipAssociate:InstanceEipAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceEipAssociate':
        """
        Get an existing InstanceEipAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of an RDS instance.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to be bound.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the EIP ID.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceEipAssociateState.__new__(_InstanceEipAssociateState)

        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["public_ip_id"] = public_ip_id
        __props__.__dict__["region"] = region
        return InstanceEipAssociate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of an RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the EIP address to be bound.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the EIP ID.
        """
        return pulumi.get(self, "public_ip_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

