# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MysqlBinlogArgs', 'MysqlBinlog']

@pulumi.input_type
class MysqlBinlogArgs:
    def __init__(__self__, *,
                 binlog_retention_hours: pulumi.Input[_builtins.int],
                 instance_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MysqlBinlog resource.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specifies the binlog retention period. Value range: `1` to `168` (7x24).
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS MySQL instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS binlog resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "binlog_retention_hours", binlog_retention_hours)
        pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="binlogRetentionHours")
    def binlog_retention_hours(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the binlog retention period. Value range: `1` to `168` (7x24).
        """
        return pulumi.get(self, "binlog_retention_hours")

    @binlog_retention_hours.setter
    def binlog_retention_hours(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "binlog_retention_hours", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the RDS MySQL instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the RDS binlog resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MysqlBinlogState:
    def __init__(__self__, *,
                 binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MysqlBinlog resources.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specifies the binlog retention period. Value range: `1` to `168` (7x24).
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS MySQL instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS binlog resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        if binlog_retention_hours is not None:
            pulumi.set(__self__, "binlog_retention_hours", binlog_retention_hours)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="binlogRetentionHours")
    def binlog_retention_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the binlog retention period. Value range: `1` to `168` (7x24).
        """
        return pulumi.get(self, "binlog_retention_hours")

    @binlog_retention_hours.setter
    def binlog_retention_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "binlog_retention_hours", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the RDS MySQL instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the RDS binlog resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Rds/mysqlBinlog:MysqlBinlog")
class MysqlBinlog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages RDS MySQL binlog resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlBinlog("test",
            instance_id=instance_id,
            binlog_retention_hours=6)
        ```

        ## Import

        RDS MySQL binlog can be imported using the `instance id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/mysqlBinlog:MysqlBinlog test <instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specifies the binlog retention period. Value range: `1` to `168` (7x24).
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS MySQL instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS binlog resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlBinlogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS MySQL binlog resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlBinlog("test",
            instance_id=instance_id,
            binlog_retention_hours=6)
        ```

        ## Import

        RDS MySQL binlog can be imported using the `instance id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/mysqlBinlog:MysqlBinlog test <instance_id>
        ```

        :param str resource_name: The name of the resource.
        :param MysqlBinlogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlBinlogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlBinlogArgs.__new__(MysqlBinlogArgs)

            if binlog_retention_hours is None and not opts.urn:
                raise TypeError("Missing required property 'binlog_retention_hours'")
            __props__.__dict__["binlog_retention_hours"] = binlog_retention_hours
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
        super(MysqlBinlog, __self__).__init__(
            'sbercloud:Rds/mysqlBinlog:MysqlBinlog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            binlog_retention_hours: Optional[pulumi.Input[_builtins.int]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'MysqlBinlog':
        """
        Get an existing MysqlBinlog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] binlog_retention_hours: Specifies the binlog retention period. Value range: `1` to `168` (7x24).
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS MySQL instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS binlog resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlBinlogState.__new__(_MysqlBinlogState)

        __props__.__dict__["binlog_retention_hours"] = binlog_retention_hours
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        return MysqlBinlog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="binlogRetentionHours")
    def binlog_retention_hours(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the binlog retention period. Value range: `1` to `168` (7x24).
        """
        return pulumi.get(self, "binlog_retention_hours")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the RDS MySQL instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the RDS binlog resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

