# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MysqlDatabaseArgs', 'MysqlDatabase']

@pulumi.input_type
class MysqlDatabaseArgs:
    def __init__(__self__, *,
                 character_set: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MysqlDatabase resource.
        :param pulumi.Input[_builtins.str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value can contain `0` to `512` characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name contains `1` to `64`
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed `10`. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "instance_id", instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the character set used by the database, For example **utf8**,
        **gbk**, **ascii**, etc. Changing this will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database description. The value can contain `0` to `512` characters.
        This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
        or **8.0.21.4**.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The database name contains `1` to `64`
        characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
        ($). The total number of hyphens (-) and dollar signs ($) cannot exceed `10`. RDS for **MySQL 8.0** does not
        support dollar signs ($). Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the RDS database resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MysqlDatabaseState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MysqlDatabase resources.
        :param pulumi.Input[_builtins.str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value can contain `0` to `512` characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name contains `1` to `64`
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed `10`. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the character set used by the database, For example **utf8**,
        **gbk**, **ascii**, etc. Changing this will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database description. The value can contain `0` to `512` characters.
        This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
        or **8.0.21.4**.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The database name contains `1` to `64`
        characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
        ($). The total number of hyphens (-) and dollar signs ($) cannot exceed `10`. RDS for **MySQL 8.0** does not
        support dollar signs ($). Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the RDS database resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Rds/mysqlDatabase:MysqlDatabase")
class MysqlDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages RDS Mysql database resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlDatabase("test",
            instance_id=instance_id,
            name="test",
            character_set="utf8",
            description="test database")
        ```

        ## Import

        RDS database can be imported using the `instance id` and `name` separated by slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/mysqlDatabase:MysqlDatabase database_1 <instance_id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value can contain `0` to `512` characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name contains `1` to `64`
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed `10`. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS Mysql database resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlDatabase("test",
            instance_id=instance_id,
            name="test",
            character_set="utf8",
            description="test database")
        ```

        ## Import

        RDS database can be imported using the `instance id` and `name` separated by slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/mysqlDatabase:MysqlDatabase database_1 <instance_id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param MysqlDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlDatabaseArgs.__new__(MysqlDatabaseArgs)

            if character_set is None and not opts.urn:
                raise TypeError("Missing required property 'character_set'")
            __props__.__dict__["character_set"] = character_set
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
        super(MysqlDatabase, __self__).__init__(
            'sbercloud:Rds/mysqlDatabase:MysqlDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'MysqlDatabase':
        """
        Get an existing MysqlDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set: Specifies the character set used by the database, For example **utf8**,
               **gbk**, **ascii**, etc. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value can contain `0` to `512` characters.
               This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
               or **8.0.21.4**.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name contains `1` to `64`
               characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
               ($). The total number of hyphens (-) and dollar signs ($) cannot exceed `10`. RDS for **MySQL 8.0** does not
               support dollar signs ($). Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlDatabaseState.__new__(_MysqlDatabaseState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return MysqlDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the character set used by the database, For example **utf8**,
        **gbk**, **ascii**, etc. Changing this will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the database description. The value can contain `0` to `512` characters.
        This parameter takes effect only for DB instances whose kernel versions are at least **5.6.51.3**, **5.7.33.1**,
        or **8.0.21.4**.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database name. The database name contains `1` to `64`
        characters. The name can only consist of lowercase letters, digits, hyphens (-), underscores (_) and dollar signs
        ($). The total number of hyphens (-) and dollar signs ($) cannot exceed `10`. RDS for **MySQL 8.0** does not
        support dollar signs ($). Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the RDS database resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

