# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MysqlDatabasePrivilegeArgs', 'MysqlDatabasePrivilege']

@pulumi.input_type
class MysqlDatabasePrivilegeArgs:
    def __init__(__self__, *,
                 db_name: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 users: pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MysqlDatabasePrivilege resource.
        :param pulumi.Input[_builtins.str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]] users: Specifies the account that associated with the database. Structure is documented below.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "users", users)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the database name. Changing this creates a new resource.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]]:
        """
        Specifies the account that associated with the database. Structure is documented below.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the RDS database privilege resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _MysqlDatabasePrivilegeState:
    def __init__(__self__, *,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering MysqlDatabasePrivilege resources.
        :param pulumi.Input[_builtins.str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]] users: Specifies the account that associated with the database. Structure is documented below.
        """
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. Changing this creates a new resource.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the RDS database privilege resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]]]:
        """
        Specifies the account that associated with the database. Structure is documented below.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabasePrivilegeUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("sbercloud:Rds/mysqlDatabasePrivilege:MysqlDatabasePrivilege")
class MysqlDatabasePrivilege(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabasePrivilegeUserArgs', 'MysqlDatabasePrivilegeUserArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages RDS Mysql database privilege resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        db_name = config.require_object("dbName")
        user_name1 = config.require_object("userName1")
        user_name2 = config.require_object("userName2")
        test = sbercloud.rds.MysqlDatabasePrivilege("test",
            instance_id=instance_id,
            db_name=db_name,
            users=[
                {
                    "name": user_name1,
                    "readonly": True,
                },
                {
                    "name": user_name2,
                    "readonly": False,
                },
            ])
        ```

        ## Import

        RDS database privilege can be imported using the `instance id` and `db_name`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/mysqlDatabasePrivilege:MysqlDatabasePrivilege test <instance_id>/<db_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabasePrivilegeUserArgs', 'MysqlDatabasePrivilegeUserArgsDict']]]] users: Specifies the account that associated with the database. Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlDatabasePrivilegeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS Mysql database privilege resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        db_name = config.require_object("dbName")
        user_name1 = config.require_object("userName1")
        user_name2 = config.require_object("userName2")
        test = sbercloud.rds.MysqlDatabasePrivilege("test",
            instance_id=instance_id,
            db_name=db_name,
            users=[
                {
                    "name": user_name1,
                    "readonly": True,
                },
                {
                    "name": user_name2,
                    "readonly": False,
                },
            ])
        ```

        ## Import

        RDS database privilege can be imported using the `instance id` and `db_name`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/mysqlDatabasePrivilege:MysqlDatabasePrivilege test <instance_id>/<db_name>
        ```

        :param str resource_name: The name of the resource.
        :param MysqlDatabasePrivilegeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlDatabasePrivilegeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabasePrivilegeUserArgs', 'MysqlDatabasePrivilegeUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlDatabasePrivilegeArgs.__new__(MysqlDatabasePrivilegeArgs)

            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
        super(MysqlDatabasePrivilege, __self__).__init__(
            'sbercloud:Rds/mysqlDatabasePrivilege:MysqlDatabasePrivilege',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabasePrivilegeUserArgs', 'MysqlDatabasePrivilegeUserArgsDict']]]]] = None) -> 'MysqlDatabasePrivilege':
        """
        Get an existing MysqlDatabasePrivilege resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabasePrivilegeUserArgs', 'MysqlDatabasePrivilegeUserArgsDict']]]] users: Specifies the account that associated with the database. Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlDatabasePrivilegeState.__new__(_MysqlDatabasePrivilegeState)

        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["users"] = users
        return MysqlDatabasePrivilege(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database name. Changing this creates a new resource.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the RDS database privilege resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence['outputs.MysqlDatabasePrivilegeUser']]:
        """
        Specifies the account that associated with the database. Structure is documented below.
        """
        return pulumi.get(self, "users")

