# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MysqlDatabaseTableRestoreArgs', 'MysqlDatabaseTableRestore']

@pulumi.input_type
class MysqlDatabaseTableRestoreArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 restore_time: pulumi.Input[_builtins.int],
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]]] = None,
                 is_fast_restore: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_tables: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]]] = None):
        """
        The set of arguments for constructing a MysqlDatabaseTableRestore resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS MySQL instance.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] restore_time: Specifies the restoration time point. A timestamp in milliseconds is used.
               
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]] databases: Specifies the databases that will be restored.
               The databases structure is documented below.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] is_fast_restore: Specifies whether to use fast restoration.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]] restore_tables: Specifies the tables that will be restored.
               The restore_tables structure is documented below.
               
               Changing this creates a new resource.
               
               > Exactly one of `databases` and `restore_tables` must be set.
               
               <a name="databases_struct"></a>
               The `databases` block supports:
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "restore_time", restore_time)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if is_fast_restore is not None:
            pulumi.set(__self__, "is_fast_restore", is_fast_restore)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restore_tables is not None:
            pulumi.set(__self__, "restore_tables", restore_tables)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of RDS MySQL instance.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the restoration time point. A timestamp in milliseconds is used.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "restore_time", value)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]]]:
        """
        Specifies the databases that will be restored.
        The databases structure is documented below.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="isFastRestore")
    def is_fast_restore(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use fast restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "is_fast_restore")

    @is_fast_restore.setter
    def is_fast_restore(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_fast_restore", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="restoreTables")
    def restore_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]]]:
        """
        Specifies the tables that will be restored.
        The restore_tables structure is documented below.

        Changing this creates a new resource.

        > Exactly one of `databases` and `restore_tables` must be set.

        <a name="databases_struct"></a>
        The `databases` block supports:
        """
        return pulumi.get(self, "restore_tables")

    @restore_tables.setter
    def restore_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]]]):
        pulumi.set(self, "restore_tables", value)


@pulumi.input_type
class _MysqlDatabaseTableRestoreState:
    def __init__(__self__, *,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_fast_restore: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_tables: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering MysqlDatabaseTableRestore resources.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]] databases: Specifies the databases that will be restored.
               The databases structure is documented below.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS MySQL instance.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] is_fast_restore: Specifies whether to use fast restoration.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]] restore_tables: Specifies the tables that will be restored.
               The restore_tables structure is documented below.
               
               Changing this creates a new resource.
               
               > Exactly one of `databases` and `restore_tables` must be set.
               
               <a name="databases_struct"></a>
               The `databases` block supports:
        :param pulumi.Input[_builtins.int] restore_time: Specifies the restoration time point. A timestamp in milliseconds is used.
               
               Changing this creates a new resource.
        """
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_fast_restore is not None:
            pulumi.set(__self__, "is_fast_restore", is_fast_restore)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restore_tables is not None:
            pulumi.set(__self__, "restore_tables", restore_tables)
        if restore_time is not None:
            pulumi.set(__self__, "restore_time", restore_time)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]]]:
        """
        Specifies the databases that will be restored.
        The databases structure is documented below.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of RDS MySQL instance.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isFastRestore")
    def is_fast_restore(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use fast restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "is_fast_restore")

    @is_fast_restore.setter
    def is_fast_restore(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_fast_restore", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="restoreTables")
    def restore_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]]]:
        """
        Specifies the tables that will be restored.
        The restore_tables structure is documented below.

        Changing this creates a new resource.

        > Exactly one of `databases` and `restore_tables` must be set.

        <a name="databases_struct"></a>
        The `databases` block supports:
        """
        return pulumi.get(self, "restore_tables")

    @restore_tables.setter
    def restore_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MysqlDatabaseTableRestoreRestoreTableArgs']]]]):
        pulumi.set(self, "restore_tables", value)

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the restoration time point. A timestamp in milliseconds is used.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "restore_time")

    @restore_time.setter
    def restore_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "restore_time", value)


@pulumi.type_token("sbercloud:Rds/mysqlDatabaseTableRestore:MysqlDatabaseTableRestore")
class MysqlDatabaseTableRestore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreDatabaseArgs', 'MysqlDatabaseTableRestoreDatabaseArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_fast_restore: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreRestoreTableArgs', 'MysqlDatabaseTableRestoreRestoreTableArgsDict']]]]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an RDS instance MySQL database table restore resource within SberCloud.

        ## Example Usage

        ### MySQL databases restore

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlDatabaseTableRestore("test",
            restore_time=1673852043000,
            instance_id=instance_id,
            databases=[{
                "old_name": "test111",
                "new_name": "test111_update",
            }])
        ```

        ### MySQL tables restore

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlDatabaseTableRestore("test",
            restore_time=1673852043000,
            instance_id=instance_id,
            restore_tables=[{
                "database": "test111",
                "tables": [{
                    "old_name": "table111",
                    "new_name": "table111_update",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreDatabaseArgs', 'MysqlDatabaseTableRestoreDatabaseArgsDict']]]] databases: Specifies the databases that will be restored.
               The databases structure is documented below.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS MySQL instance.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] is_fast_restore: Specifies whether to use fast restoration.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreRestoreTableArgs', 'MysqlDatabaseTableRestoreRestoreTableArgsDict']]]] restore_tables: Specifies the tables that will be restored.
               The restore_tables structure is documented below.
               
               Changing this creates a new resource.
               
               > Exactly one of `databases` and `restore_tables` must be set.
               
               <a name="databases_struct"></a>
               The `databases` block supports:
        :param pulumi.Input[_builtins.int] restore_time: Specifies the restoration time point. A timestamp in milliseconds is used.
               
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MysqlDatabaseTableRestoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an RDS instance MySQL database table restore resource within SberCloud.

        ## Example Usage

        ### MySQL databases restore

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlDatabaseTableRestore("test",
            restore_time=1673852043000,
            instance_id=instance_id,
            databases=[{
                "old_name": "test111",
                "new_name": "test111_update",
            }])
        ```

        ### MySQL tables restore

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.MysqlDatabaseTableRestore("test",
            restore_time=1673852043000,
            instance_id=instance_id,
            restore_tables=[{
                "database": "test111",
                "tables": [{
                    "old_name": "table111",
                    "new_name": "table111_update",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param MysqlDatabaseTableRestoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MysqlDatabaseTableRestoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreDatabaseArgs', 'MysqlDatabaseTableRestoreDatabaseArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_fast_restore: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restore_tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreRestoreTableArgs', 'MysqlDatabaseTableRestoreRestoreTableArgsDict']]]]] = None,
                 restore_time: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MysqlDatabaseTableRestoreArgs.__new__(MysqlDatabaseTableRestoreArgs)

            __props__.__dict__["databases"] = databases
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_fast_restore"] = is_fast_restore
            __props__.__dict__["region"] = region
            __props__.__dict__["restore_tables"] = restore_tables
            if restore_time is None and not opts.urn:
                raise TypeError("Missing required property 'restore_time'")
            __props__.__dict__["restore_time"] = restore_time
        super(MysqlDatabaseTableRestore, __self__).__init__(
            'sbercloud:Rds/mysqlDatabaseTableRestore:MysqlDatabaseTableRestore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreDatabaseArgs', 'MysqlDatabaseTableRestoreDatabaseArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_fast_restore: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            restore_tables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreRestoreTableArgs', 'MysqlDatabaseTableRestoreRestoreTableArgsDict']]]]] = None,
            restore_time: Optional[pulumi.Input[_builtins.int]] = None) -> 'MysqlDatabaseTableRestore':
        """
        Get an existing MysqlDatabaseTableRestore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreDatabaseArgs', 'MysqlDatabaseTableRestoreDatabaseArgsDict']]]] databases: Specifies the databases that will be restored.
               The databases structure is documented below.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS MySQL instance.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] is_fast_restore: Specifies whether to use fast restoration.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds instance resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MysqlDatabaseTableRestoreRestoreTableArgs', 'MysqlDatabaseTableRestoreRestoreTableArgsDict']]]] restore_tables: Specifies the tables that will be restored.
               The restore_tables structure is documented below.
               
               Changing this creates a new resource.
               
               > Exactly one of `databases` and `restore_tables` must be set.
               
               <a name="databases_struct"></a>
               The `databases` block supports:
        :param pulumi.Input[_builtins.int] restore_time: Specifies the restoration time point. A timestamp in milliseconds is used.
               
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MysqlDatabaseTableRestoreState.__new__(_MysqlDatabaseTableRestoreState)

        __props__.__dict__["databases"] = databases
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_fast_restore"] = is_fast_restore
        __props__.__dict__["region"] = region
        __props__.__dict__["restore_tables"] = restore_tables
        __props__.__dict__["restore_time"] = restore_time
        return MysqlDatabaseTableRestore(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.MysqlDatabaseTableRestoreDatabase']]]:
        """
        Specifies the databases that will be restored.
        The databases structure is documented below.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of RDS MySQL instance.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isFastRestore")
    def is_fast_restore(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to use fast restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "is_fast_restore")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the rds instance resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restoreTables")
    def restore_tables(self) -> pulumi.Output[Optional[Sequence['outputs.MysqlDatabaseTableRestoreRestoreTable']]]:
        """
        Specifies the tables that will be restored.
        The restore_tables structure is documented below.

        Changing this creates a new resource.

        > Exactly one of `databases` and `restore_tables` must be set.

        <a name="databases_struct"></a>
        The `databases` block supports:
        """
        return pulumi.get(self, "restore_tables")

    @_builtins.property
    @pulumi.getter(name="restoreTime")
    def restore_time(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the restoration time point. A timestamp in milliseconds is used.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "restore_time")

