# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BackupDatabase',
    'InstanceBackupStrategy',
    'InstanceDb',
    'InstanceMsdtcHost',
    'InstanceNode',
    'InstanceParameter',
    'InstanceRestore',
    'InstanceVolume',
    'MysqlDatabasePrivilegeUser',
    'MysqlDatabaseTableRestoreDatabase',
    'MysqlDatabaseTableRestoreRestoreTable',
    'MysqlDatabaseTableRestoreRestoreTableTable',
    'ParametergroupConfigurationParameter',
    'ParametergroupDatastore',
    'PgAccountAttribute',
    'PgHbaHostBasedAuthentication',
    'ReadReplicaInstanceDb',
    'ReadReplicaInstanceParameter',
    'ReadReplicaInstanceVolume',
    'SqlserverDatabasePrivilegeUser',
    'GetBackupsBackupResult',
    'GetBackupsBackupDatabaseResult',
    'GetBackupsBackupDatastoreResult',
    'GetEngineVersionsVersionResult',
    'GetFlavorsFlavorResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceBackupStrategyResult',
    'GetInstancesInstanceDbResult',
    'GetInstancesInstanceNodeResult',
    'GetInstancesInstanceVolumeResult',
    'GetPgAccountsUserResult',
    'GetPgAccountsUserAttributeResult',
    'GetPgDatabasesDatabaseResult',
    'GetPgPluginsPluginResult',
    'GetPgSqlLimitsSqlLimitResult',
    'GetStorageTypesStorageTypeResult',
]

@pulumi.output_type
class BackupDatabase(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Database to be backed up for Microsoft SQL Server.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Database to be backed up for Microsoft SQL Server.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: _builtins.str,
                 keep_days: Optional[_builtins.int] = None,
                 period: Optional[_builtins.str] = None):
        """
        :param _builtins.str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the **hh:mm-HH:MM**
               format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
               MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
               00.
        :param _builtins.int keep_days: Specifies the retention days for specific backup files. The value range is from 0 to 732.
               
               > **NOTE:** Primary/standby DB instances of Microsoft SQL Server do not support disabling the automated backup
               policy.
        :param _builtins.str period: Specifies the backup cycle. Automatic backups will be performed on the specified days of
               the week, except when disabling the automatic backup policy. The value range is a comma-separated number, where each
               number represents a day of the week. For example, a value of 1,2,3,4 would set the backup cycle to Monday, Tuesday,
               Wednesday, and Thursday. The default value is 1,2,3,4,5,6,7.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the **hh:mm-HH:MM**
        format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
        MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
        00.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[_builtins.int]:
        """
        Specifies the retention days for specific backup files. The value range is from 0 to 732.

        > **NOTE:** Primary/standby DB instances of Microsoft SQL Server do not support disabling the automated backup
        policy.
        """
        return pulumi.get(self, "keep_days")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.str]:
        """
        Specifies the backup cycle. Automatic backups will be performed on the specified days of
        the week, except when disabling the automatic backup policy. The value range is a comma-separated number, where each
        number represents a day of the week. For example, a value of 1,2,3,4 would set the backup cycle to Monday, Tuesday,
        Wednesday, and Thursday. The default value is 1,2,3,4,5,6,7.
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class InstanceDb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 version: _builtins.str,
                 password: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the DB engine. Available value are **MySQL**, **PostgreSQL**
               and **SQLServer**. Changing this parameter will create a new resource.
        :param _builtins.str version: Specifies the database version. Changing this parameter will create a new
               resource.
        :param _builtins.str password: Specifies the database password. The value should contain 8 to 32 characters,
               including uppercase and lowercase letters, digits, and the following special characters: ~!@#%^*-_=+? You are advised
               to enter a strong password to improve security, preventing security risks such as brute force cracking.
        :param _builtins.int port: Specifies the database port.
               + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
               and cannot be used). The default value is 3306.
               + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
               + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
               default value is 1433.
               + The MariaDB database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
               and cannot be used). The default value is 3306.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the DB engine. Available value are **MySQL**, **PostgreSQL**
        and **SQLServer**. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the database version. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Specifies the database password. The value should contain 8 to 32 characters,
        including uppercase and lowercase letters, digits, and the following special characters: ~!@#%^*-_=+? You are advised
        to enter a strong password to improve security, preventing security risks such as brute force cracking.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Specifies the database port.
        + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
        + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
        default value is 1433.
        + The MariaDB database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class InstanceMsdtcHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMsdtcHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMsdtcHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMsdtcHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: _builtins.str,
                 ip: _builtins.str,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str host_name: Specifies the host name.
        :param _builtins.str ip: Specifies the host IP address.
        :param _builtins.str id: Indicates the host ID.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "ip", ip)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        Specifies the host name.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        Specifies the host IP address.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Indicates the host ID.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class InstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str availability_zone: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param _builtins.str id: Indicates the host ID.
        :param _builtins.str name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param _builtins.str role: Indicates the node type. The value can be master or slave, indicating the primary node or standby node
               respectively.
        :param _builtins.str status: Indicates the node status.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Indicates the host ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        Indicates the node type. The value can be master or slave, indicating the primary node or standby node
        respectively.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Specifies the parameter name. Some of them needs the instance to be restarted
               to take effect.
        :param _builtins.str value: Specifies the parameter value.
               
               <a name="RdsInstance_MsdtcHosts"></a>
               The `msdtc_hosts` block supports:
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the parameter name. Some of them needs the instance to be restarted
        to take effect.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Specifies the parameter value.

        <a name="RdsInstance_MsdtcHosts"></a>
        The `msdtc_hosts` block supports:
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstanceRestore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupId":
            suggest = "backup_id"
        elif key == "instanceId":
            suggest = "instance_id"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceRestore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceRestore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceRestore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_id: _builtins.str,
                 instance_id: _builtins.str,
                 database_name: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str backup_id: Specifies the ID of the backup used to restore data. Changing this
               parameter will create a new resource.
        :param _builtins.str instance_id: Specifies the source DB instance ID. Changing this parameter will create
               a new resource.
        :param Mapping[str, _builtins.str] database_name: Specifies the database to be restored. This parameter applies only to
               Microsoft SQL Server databases. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "backup_id", backup_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)

    @_builtins.property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> _builtins.str:
        """
        Specifies the ID of the backup used to restore data. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "backup_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Specifies the source DB instance ID. Changing this parameter will create
        a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies the database to be restored. This parameter applies only to
        Microsoft SQL Server databases. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "database_name")


@pulumi.output_type
class InstanceVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionId":
            suggest = "disk_encryption_id"
        elif key == "limitSize":
            suggest = "limit_size"
        elif key == "triggerThreshold":
            suggest = "trigger_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: _builtins.int,
                 type: _builtins.str,
                 disk_encryption_id: Optional[_builtins.str] = None,
                 limit_size: Optional[_builtins.int] = None,
                 trigger_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int size: Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
               multiple of 10 and greater than the original size.
        :param _builtins.str type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + **CLOUDSSD**: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances (MySQL and PostreSQL).
               + **ESSD**: extreme SSD storage. Supported by: MySQL primary/standby, PostgeSQL (both single and primary/standby).
               + **ULTRAHIGH** the only storage type for SQLServer, not supported by other DB engines.
               
               Changing this parameter will create a new resource.
        :param _builtins.str disk_encryption_id: Specifies the key ID for disk encryption.
               Changing this parameter will create a new resource.
        :param _builtins.int limit_size: Specifies the upper limit of automatic expansion of storage, in GB.
        :param _builtins.int trigger_threshold: Specifies the threshold to trigger automatic expansion.  
               If the available storage drops to this threshold or `10` GB, the automatic expansion is triggered.
               The valid values are as follows:
               + **10**
               + **15**
               + **20**
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if limit_size is not None:
            pulumi.set(__self__, "limit_size", limit_size)
        if trigger_threshold is not None:
            pulumi.set(__self__, "trigger_threshold", trigger_threshold)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
        multiple of 10 and greater than the original size.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + **CLOUDSSD**: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances (MySQL and PostreSQL).
        + **ESSD**: extreme SSD storage. Supported by: MySQL primary/standby, PostgeSQL (both single and primary/standby).
        + **ULTRAHIGH** the only storage type for SQLServer, not supported by other DB engines.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[_builtins.str]:
        """
        Specifies the key ID for disk encryption.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "disk_encryption_id")

    @_builtins.property
    @pulumi.getter(name="limitSize")
    def limit_size(self) -> Optional[_builtins.int]:
        """
        Specifies the upper limit of automatic expansion of storage, in GB.
        """
        return pulumi.get(self, "limit_size")

    @_builtins.property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> Optional[_builtins.int]:
        """
        Specifies the threshold to trigger automatic expansion.  
        If the available storage drops to this threshold or `10` GB, the automatic expansion is triggered.
        The valid values are as follows:
        + **10**
        + **15**
        + **20**
        """
        return pulumi.get(self, "trigger_threshold")


@pulumi.output_type
class MysqlDatabasePrivilegeUser(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 readonly: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Specifies the username of the database account.
        :param _builtins.bool readonly: Specifies the read-only permission. The value can be:
               + **true**: indicates the read-only permission.
               + **false**: indicates the read and write permission.
               
               The default value is **false**.
        """
        pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the username of the database account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def readonly(self) -> Optional[_builtins.bool]:
        """
        Specifies the read-only permission. The value can be:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.

        The default value is **false**.
        """
        return pulumi.get(self, "readonly")


@pulumi.output_type
class MysqlDatabaseTableRestoreDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newName":
            suggest = "new_name"
        elif key == "oldName":
            suggest = "old_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDatabaseTableRestoreDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDatabaseTableRestoreDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDatabaseTableRestoreDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_name: _builtins.str,
                 old_name: _builtins.str):
        """
        :param _builtins.str new_name: Specifies the name of the table after restoration.
               
               Changing this creates a new resource.
        :param _builtins.str old_name: Specifies the name of the table before restoration.
               
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "new_name", new_name)
        pulumi.set(__self__, "old_name", old_name)

    @_builtins.property
    @pulumi.getter(name="newName")
    def new_name(self) -> _builtins.str:
        """
        Specifies the name of the table after restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "new_name")

    @_builtins.property
    @pulumi.getter(name="oldName")
    def old_name(self) -> _builtins.str:
        """
        Specifies the name of the table before restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "old_name")


@pulumi.output_type
class MysqlDatabaseTableRestoreRestoreTable(dict):
    def __init__(__self__, *,
                 database: _builtins.str,
                 tables: Sequence['outputs.MysqlDatabaseTableRestoreRestoreTableTable']):
        """
        :param _builtins.str database: Specifies the database name.
               
               Changing this creates a new resource.
        :param Sequence['MysqlDatabaseTableRestoreRestoreTableTableArgs'] tables: Specifies the tables.
               The tables structure is documented below.
               
               Changing this creates a new resource.
               
               <a name="tables_struct"></a>
               The `tables` block supports:
        """
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "tables", tables)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        Specifies the database name.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def tables(self) -> Sequence['outputs.MysqlDatabaseTableRestoreRestoreTableTable']:
        """
        Specifies the tables.
        The tables structure is documented below.

        Changing this creates a new resource.

        <a name="tables_struct"></a>
        The `tables` block supports:
        """
        return pulumi.get(self, "tables")


@pulumi.output_type
class MysqlDatabaseTableRestoreRestoreTableTable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newName":
            suggest = "new_name"
        elif key == "oldName":
            suggest = "old_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlDatabaseTableRestoreRestoreTableTable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlDatabaseTableRestoreRestoreTableTable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlDatabaseTableRestoreRestoreTableTable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_name: _builtins.str,
                 old_name: _builtins.str):
        """
        :param _builtins.str new_name: Specifies the name of the table after restoration.
               
               Changing this creates a new resource.
        :param _builtins.str old_name: Specifies the name of the table before restoration.
               
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "new_name", new_name)
        pulumi.set(__self__, "old_name", old_name)

    @_builtins.property
    @pulumi.getter(name="newName")
    def new_name(self) -> _builtins.str:
        """
        Specifies the name of the table after restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "new_name")

    @_builtins.property
    @pulumi.getter(name="oldName")
    def old_name(self) -> _builtins.str:
        """
        Specifies the name of the table before restoration.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "old_name")


@pulumi.output_type
class ParametergroupConfigurationParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restartRequired":
            suggest = "restart_required"
        elif key == "valueRange":
            suggest = "value_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParametergroupConfigurationParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParametergroupConfigurationParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParametergroupConfigurationParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 readonly: Optional[_builtins.bool] = None,
                 restart_required: Optional[_builtins.bool] = None,
                 type: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None,
                 value_range: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: The parameter group description. It contains a maximum of 256 characters and cannot contain the following special characters:>!<"&'= the value is left blank by default.
        :param _builtins.str name: The parameter group name. It contains a maximum of 64 characters.
        :param _builtins.bool readonly: Indicates whether the parameter is read-only.
        :param _builtins.bool restart_required: Indicates whether a restart is required.
        :param _builtins.str type: Indicates the parameter type.
        :param _builtins.str value: Indicates the parameter value.
        :param _builtins.str value_range: Indicates the parameter value range.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if restart_required is not None:
            pulumi.set(__self__, "restart_required", restart_required)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_range is not None:
            pulumi.set(__self__, "value_range", value_range)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The parameter group description. It contains a maximum of 256 characters and cannot contain the following special characters:>!<"&'= the value is left blank by default.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def readonly(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the parameter is read-only.
        """
        return pulumi.get(self, "readonly")

    @_builtins.property
    @pulumi.getter(name="restartRequired")
    def restart_required(self) -> Optional[_builtins.bool]:
        """
        Indicates whether a restart is required.
        """
        return pulumi.get(self, "restart_required")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Indicates the parameter type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Indicates the parameter value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueRange")
    def value_range(self) -> Optional[_builtins.str]:
        """
        Indicates the parameter value range.
        """
        return pulumi.get(self, "value_range")


@pulumi.output_type
class ParametergroupDatastore(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str type: The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The value is case-insensitive and can be mysql, postgresql, or sqlserver.
        :param _builtins.str version: Specifies the database version.
               
               * MySQL databases support MySQL 5.6, 5.7 and 8.0. Example value: 5.7.
               * PostgreSQL databases support PostgreSQL 9.5, 9.6, 10, 11 and 12. Example value: 9.5.
               * Microsoft SQL Server databases support 2012_SE, 2014_SE, 2016_SE, 2012_EE, 2014_EE, 2016_EE and 2017_EE. Example value: 2014_SE.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The value is case-insensitive and can be mysql, postgresql, or sqlserver.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the database version.

        * MySQL databases support MySQL 5.6, 5.7 and 8.0. Example value: 5.7.
        * PostgreSQL databases support PostgreSQL 9.5, 9.6, 10, 11 and 12. Example value: 9.5.
        * Microsoft SQL Server databases support 2012_SE, 2014_SE, 2016_SE, 2012_EE, 2014_EE, 2016_EE and 2017_EE. Example value: 2014_SE.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PgAccountAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rolBypassRls":
            suggest = "rol_bypass_rls"
        elif key == "rolCanLogin":
            suggest = "rol_can_login"
        elif key == "rolConnLimit":
            suggest = "rol_conn_limit"
        elif key == "rolCreateDb":
            suggest = "rol_create_db"
        elif key == "rolCreateRole":
            suggest = "rol_create_role"
        elif key == "rolInherit":
            suggest = "rol_inherit"
        elif key == "rolReplication":
            suggest = "rol_replication"
        elif key == "rolSuper":
            suggest = "rol_super"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PgAccountAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PgAccountAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PgAccountAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 rol_bypass_rls: Optional[_builtins.bool] = None,
                 rol_can_login: Optional[_builtins.bool] = None,
                 rol_conn_limit: Optional[_builtins.int] = None,
                 rol_create_db: Optional[_builtins.bool] = None,
                 rol_create_role: Optional[_builtins.bool] = None,
                 rol_inherit: Optional[_builtins.bool] = None,
                 rol_replication: Optional[_builtins.bool] = None,
                 rol_super: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool rol_bypass_rls: Indicates whether a user bypasses each row-level security policy.
        :param _builtins.bool rol_can_login: Indicates whether a user can log in to the database.
        :param _builtins.int rol_conn_limit: Indicates the maximum number of concurrent connections to a DB instance.
        :param _builtins.bool rol_create_db: Indicates whether a user can create a database.
        :param _builtins.bool rol_create_role: Indicates whether a user can create other sub-users.
        :param _builtins.bool rol_inherit: Indicates whether a user automatically inherits the permissions of the role to which the user belongs.
        :param _builtins.bool rol_replication: Indicates whether the user is a replication role.
        :param _builtins.bool rol_super: Indicates whether a user has the super-user permission.
        """
        if rol_bypass_rls is not None:
            pulumi.set(__self__, "rol_bypass_rls", rol_bypass_rls)
        if rol_can_login is not None:
            pulumi.set(__self__, "rol_can_login", rol_can_login)
        if rol_conn_limit is not None:
            pulumi.set(__self__, "rol_conn_limit", rol_conn_limit)
        if rol_create_db is not None:
            pulumi.set(__self__, "rol_create_db", rol_create_db)
        if rol_create_role is not None:
            pulumi.set(__self__, "rol_create_role", rol_create_role)
        if rol_inherit is not None:
            pulumi.set(__self__, "rol_inherit", rol_inherit)
        if rol_replication is not None:
            pulumi.set(__self__, "rol_replication", rol_replication)
        if rol_super is not None:
            pulumi.set(__self__, "rol_super", rol_super)

    @_builtins.property
    @pulumi.getter(name="rolBypassRls")
    def rol_bypass_rls(self) -> Optional[_builtins.bool]:
        """
        Indicates whether a user bypasses each row-level security policy.
        """
        return pulumi.get(self, "rol_bypass_rls")

    @_builtins.property
    @pulumi.getter(name="rolCanLogin")
    def rol_can_login(self) -> Optional[_builtins.bool]:
        """
        Indicates whether a user can log in to the database.
        """
        return pulumi.get(self, "rol_can_login")

    @_builtins.property
    @pulumi.getter(name="rolConnLimit")
    def rol_conn_limit(self) -> Optional[_builtins.int]:
        """
        Indicates the maximum number of concurrent connections to a DB instance.
        """
        return pulumi.get(self, "rol_conn_limit")

    @_builtins.property
    @pulumi.getter(name="rolCreateDb")
    def rol_create_db(self) -> Optional[_builtins.bool]:
        """
        Indicates whether a user can create a database.
        """
        return pulumi.get(self, "rol_create_db")

    @_builtins.property
    @pulumi.getter(name="rolCreateRole")
    def rol_create_role(self) -> Optional[_builtins.bool]:
        """
        Indicates whether a user can create other sub-users.
        """
        return pulumi.get(self, "rol_create_role")

    @_builtins.property
    @pulumi.getter(name="rolInherit")
    def rol_inherit(self) -> Optional[_builtins.bool]:
        """
        Indicates whether a user automatically inherits the permissions of the role to which the user belongs.
        """
        return pulumi.get(self, "rol_inherit")

    @_builtins.property
    @pulumi.getter(name="rolReplication")
    def rol_replication(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the user is a replication role.
        """
        return pulumi.get(self, "rol_replication")

    @_builtins.property
    @pulumi.getter(name="rolSuper")
    def rol_super(self) -> Optional[_builtins.bool]:
        """
        Indicates whether a user has the super-user permission.
        """
        return pulumi.get(self, "rol_super")


@pulumi.output_type
class PgHbaHostBasedAuthentication(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 database: _builtins.str,
                 method: _builtins.str,
                 type: _builtins.str,
                 user: _builtins.str,
                 mask: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: Specifies the client IP address.
        :param _builtins.str database: Specifies the database name.
        :param _builtins.str method: Specifies the authentication mode.
        :param _builtins.str type: Specifies the connection type.
        :param _builtins.str user: Specifies the Name of a user.
        :param _builtins.str mask: Specifies the subnet mask.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)
        if mask is not None:
            pulumi.set(__self__, "mask", mask)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Specifies the client IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        Specifies the database name.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def method(self) -> _builtins.str:
        """
        Specifies the authentication mode.
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the connection type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> _builtins.str:
        """
        Specifies the Name of a user.
        """
        return pulumi.get(self, "user")

    @_builtins.property
    @pulumi.getter
    def mask(self) -> Optional[_builtins.str]:
        """
        Specifies the subnet mask.
        """
        return pulumi.get(self, "mask")


@pulumi.output_type
class ReadReplicaInstanceDb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaInstanceDb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaInstanceDb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaInstanceDb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.int port: Indicates the database port information.
        :param _builtins.str type: Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        :param _builtins.str user_name: Indicates the default user name of database.
        :param _builtins.str version: Indicates the database version.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Indicates the database port information.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        Indicates the default user name of database.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ReadReplicaInstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Specifies the DB instance name. The DB instance name of the same type
               must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
               It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the DB instance name. The DB instance name of the same type
        must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
        It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ReadReplicaInstanceVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionId":
            suggest = "disk_encryption_id"
        elif key == "limitSize":
            suggest = "limit_size"
        elif key == "triggerThreshold":
            suggest = "trigger_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaInstanceVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaInstanceVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaInstanceVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 disk_encryption_id: Optional[_builtins.str] = None,
                 limit_size: Optional[_builtins.int] = None,
                 size: Optional[_builtins.int] = None,
                 trigger_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.str type: Specifies the volume type. Its value can be any of the following and is case-sensitive:
               - *ESSD* - ultrahigh I/O.
               - *CLOUDSSD* - high I/O.
               
               Changing this parameter will create a new resource.
        :param _builtins.str disk_encryption_id: Specifies the key ID for disk encryption.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if limit_size is not None:
            pulumi.set(__self__, "limit_size", limit_size)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if trigger_threshold is not None:
            pulumi.set(__self__, "trigger_threshold", trigger_threshold)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the volume type. Its value can be any of the following and is case-sensitive:
        - *ESSD* - ultrahigh I/O.
        - *CLOUDSSD* - high I/O.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[_builtins.str]:
        """
        Specifies the key ID for disk encryption.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "disk_encryption_id")

    @_builtins.property
    @pulumi.getter(name="limitSize")
    def limit_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "limit_size")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="triggerThreshold")
    def trigger_threshold(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "trigger_threshold")


@pulumi.output_type
class SqlserverDatabasePrivilegeUser(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 readonly: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: Specifies the username of the database account.
        :param _builtins.bool readonly: Specifies the read-only permission. Value options:
               + **true**: indicates the read-only permission.
               + **false**: indicates the read and write permission.
               
               Defaults to **false**.
        """
        pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the username of the database account.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def readonly(self) -> Optional[_builtins.bool]:
        """
        Specifies the read-only permission. Value options:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.

        Defaults to **false**.
        """
        return pulumi.get(self, "readonly")


@pulumi.output_type
class GetBackupsBackupResult(dict):
    def __init__(__self__, *,
                 associated_with_ddm: _builtins.bool,
                 begin_time: _builtins.str,
                 databases: Sequence['outputs.GetBackupsBackupDatabaseResult'],
                 datastores: Sequence['outputs.GetBackupsBackupDatastoreResult'],
                 end_time: _builtins.str,
                 id: _builtins.str,
                 instance_id: _builtins.str,
                 name: _builtins.str,
                 size: _builtins.int,
                 status: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.bool associated_with_ddm: Whether a DDM instance has been associated.
        :param _builtins.str begin_time: Start time in the "yyyy-mm-ddThh:mm:ssZ" format.
        :param Sequence['GetBackupsBackupDatabaseArgs'] databases: Database been backed up.
               The databases structure is documented below.
        :param Sequence['GetBackupsBackupDatastoreArgs'] datastores: The database information.
               The datastore structure is documented below.
        :param _builtins.str end_time: End time in the "yyyy-mm-ddThh:mm:ssZ" format.
        :param _builtins.str id: Backup ID.
        :param _builtins.str instance_id: Instance ID.
        :param _builtins.str name: Backup name.
        :param _builtins.int size: Backup size in KB.
        :param _builtins.str status: Backup status.  
               The options are as follows:
               - **BUILDING**: Backup in progress.
               - **COMPLETED**: Backup completed.
               - **FAILED**: Backup failed.
               - **DELETING**: Backup being deleted.
        :param _builtins.str type: DB engine.  
               The value can be: **MySQL**, **PostgreSQL**, **SQLServer**.
        """
        pulumi.set(__self__, "associated_with_ddm", associated_with_ddm)
        pulumi.set(__self__, "begin_time", begin_time)
        pulumi.set(__self__, "databases", databases)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="associatedWithDdm")
    def associated_with_ddm(self) -> _builtins.bool:
        """
        Whether a DDM instance has been associated.
        """
        return pulumi.get(self, "associated_with_ddm")

    @_builtins.property
    @pulumi.getter(name="beginTime")
    def begin_time(self) -> _builtins.str:
        """
        Start time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "begin_time")

    @_builtins.property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetBackupsBackupDatabaseResult']:
        """
        Database been backed up.
        The databases structure is documented below.
        """
        return pulumi.get(self, "databases")

    @_builtins.property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetBackupsBackupDatastoreResult']:
        """
        The database information.
        The datastore structure is documented below.
        """
        return pulumi.get(self, "datastores")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        End time in the "yyyy-mm-ddThh:mm:ssZ" format.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Backup ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Backup name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Backup size in KB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Backup status.  
        The options are as follows:
        - **BUILDING**: Backup in progress.
        - **COMPLETED**: Backup completed.
        - **FAILED**: Backup failed.
        - **DELETING**: Backup being deleted.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        DB engine.  
        The value can be: **MySQL**, **PostgreSQL**, **SQLServer**.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBackupsBackupDatabaseResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Backup name.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Backup name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetBackupsBackupDatastoreResult(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str type: DB engine.  
               The value can be: **MySQL**, **PostgreSQL**, **SQLServer**.
        :param _builtins.str version: DB engine version.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        DB engine.  
        The value can be: **MySQL**, **PostgreSQL**, **SQLServer**.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        DB engine version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetEngineVersionsVersionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: Version ID.
        :param _builtins.str name: Version name.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Version ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Version name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[_builtins.str],
                 db_versions: Sequence[_builtins.str],
                 group_type: _builtins.str,
                 id: _builtins.str,
                 instance_mode: _builtins.str,
                 memory: _builtins.int,
                 mode: _builtins.str,
                 name: _builtins.str,
                 vcpus: _builtins.int):
        """
        :param Sequence[_builtins.str] availability_zones: The availability zones which the RDS flavor belongs to.
        :param Sequence[_builtins.str] db_versions: The Available versions of the database.
        :param _builtins.str group_type: Specifies the performance specification, the valid values are as follows:
               + **normal**: General enhanced.
               + **normal2**: General enhanced type II.
        :param _builtins.str id: The ID of the rds flavor.
        :param _builtins.str instance_mode: The mode of instance. Value: *ha*(indicates primary/standby instance),
               *single*(indicates single instance) and *replica*(indicates read replicas).
        :param _builtins.int memory: Specifies the memory size(GB) in the RDS flavor.
        :param _builtins.str mode: See 'instance_mode' above.
        :param _builtins.str name: The name of the rds flavor.
        :param _builtins.int vcpus: Specifies the number of vCPUs in the RDS flavor.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "db_versions", db_versions)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_mode", instance_mode)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vcpus", vcpus)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        The availability zones which the RDS flavor belongs to.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="dbVersions")
    def db_versions(self) -> Sequence[_builtins.str]:
        """
        The Available versions of the database.
        """
        return pulumi.get(self, "db_versions")

    @_builtins.property
    @pulumi.getter(name="groupType")
    def group_type(self) -> _builtins.str:
        """
        Specifies the performance specification, the valid values are as follows:
        + **normal**: General enhanced.
        + **normal2**: General enhanced type II.
        """
        return pulumi.get(self, "group_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the rds flavor.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceMode")
    def instance_mode(self) -> _builtins.str:
        """
        The mode of instance. Value: *ha*(indicates primary/standby instance),
        *single*(indicates single instance) and *replica*(indicates read replicas).
        """
        return pulumi.get(self, "instance_mode")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        Specifies the memory size(GB) in the RDS flavor.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use instance_mode instead""")
    def mode(self) -> _builtins.str:
        """
        See 'instance_mode' above.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the rds flavor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> _builtins.int:
        """
        Specifies the number of vCPUs in the RDS flavor.
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[_builtins.str],
                 backup_strategies: Sequence['outputs.GetInstancesInstanceBackupStrategyResult'],
                 created: _builtins.str,
                 dbs: Sequence['outputs.GetInstancesInstanceDbResult'],
                 enterprise_project_id: _builtins.str,
                 fixed_ip: _builtins.str,
                 flavor: _builtins.str,
                 ha_replication_mode: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 nodes: Sequence['outputs.GetInstancesInstanceNodeResult'],
                 param_group_id: _builtins.str,
                 private_ips: Sequence[_builtins.str],
                 public_ips: Sequence[_builtins.str],
                 region: _builtins.str,
                 security_group_id: _builtins.str,
                 ssl_enable: _builtins.bool,
                 status: _builtins.str,
                 subnet_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 time_zone: _builtins.str,
                 volumes: Sequence['outputs.GetInstancesInstanceVolumeResult'],
                 vpc_id: _builtins.str):
        """
        :param Sequence[_builtins.str] availability_zones: Indicates the availability zone where the node resides.
        :param Sequence['GetInstancesInstanceBackupStrategyArgs'] backup_strategies: Indicates the advanced backup policy. Structure is documented below.
        :param _builtins.str created: Indicates the creation time.
        :param Sequence['GetInstancesInstanceDbArgs'] dbs: Indicates the database information. Structure is documented below.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project id.
        :param _builtins.str fixed_ip: Indicates the intranet floating IP address of the instance.
        :param _builtins.str flavor: Indicates the instance specifications.
        :param _builtins.str ha_replication_mode: Indicates the replication mode for the standby DB instance.
        :param _builtins.str id: Indicates the node ID.
        :param _builtins.str name: Specifies the name of the instance.
        :param Sequence['GetInstancesInstanceNodeArgs'] nodes: Indicates the instance nodes information. Structure is documented below.
        :param _builtins.str param_group_id: Indicates the configuration ID.
        :param Sequence[_builtins.str] private_ips: Indicates the private ips in list.
        :param Sequence[_builtins.str] public_ips: Indicates the public ips in list.
        :param _builtins.str region: The region in which to obtain the instances. If omitted, the provider-level region will
               be used.
        :param _builtins.str security_group_id: Indicates the security group ID.
        :param _builtins.bool ssl_enable: Indicates whether to enable SSL.
        :param _builtins.str status: Indicates the node status.
        :param _builtins.str subnet_id: Specifies the network ID of a subnet.
        :param Mapping[str, _builtins.str] tags: Indicates the tags of the instance.
        :param _builtins.str time_zone: Indicates the time zone.
        :param Sequence['GetInstancesInstanceVolumeArgs'] volumes: Indicates the volume information. Structure is documented below.
        :param _builtins.str vpc_id: Specifies the VPC ID.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "backup_strategies", backup_strategies)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "dbs", dbs)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "fixed_ip", fixed_ip)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "ha_replication_mode", ha_replication_mode)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "param_group_id", param_group_id)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "public_ips", public_ips)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "ssl_enable", ssl_enable)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="backupStrategies")
    def backup_strategies(self) -> Sequence['outputs.GetInstancesInstanceBackupStrategyResult']:
        """
        Indicates the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategies")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        Indicates the creation time.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def dbs(self) -> Sequence['outputs.GetInstancesInstanceDbResult']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "dbs")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> _builtins.str:
        """
        Indicates the intranet floating IP address of the instance.
        """
        return pulumi.get(self, "fixed_ip")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> _builtins.str:
        """
        Indicates the instance specifications.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> _builtins.str:
        """
        Indicates the replication mode for the standby DB instance.
        """
        return pulumi.get(self, "ha_replication_mode")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetInstancesInstanceNodeResult']:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> _builtins.str:
        """
        Indicates the configuration ID.
        """
        return pulumi.get(self, "param_group_id")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[_builtins.str]:
        """
        Indicates the private ips in list.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence[_builtins.str]:
        """
        Indicates the public ips in list.
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region in which to obtain the instances. If omitted, the provider-level region will
        be used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        Indicates the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> _builtins.bool:
        """
        Indicates whether to enable SSL.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Specifies the network ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Indicates the tags of the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        Indicates the time zone.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetInstancesInstanceVolumeResult']:
        """
        Indicates the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Specifies the VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetInstancesInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: _builtins.int,
                 start_time: _builtins.str):
        """
        :param _builtins.int keep_days: Indicates the number of days to retain the generated.
        :param _builtins.str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> _builtins.int:
        """
        Indicates the number of days to retain the generated.
        """
        return pulumi.get(self, "keep_days")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetInstancesInstanceDbResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 type: _builtins.str,
                 user_name: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.int port: Indicates the database port.
        :param _builtins.str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        :param _builtins.str user_name: Indicates the database user name.
        :param _builtins.str version: Indicates the database version.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        Indicates the database user name.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetInstancesInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 role: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str availability_zone: Indicates the availability zone where the node resides.
        :param _builtins.str id: Indicates the node ID.
        :param _builtins.str name: Specifies the name of the instance.
        :param _builtins.str role: Indicates the node type.
        :param _builtins.str status: Indicates the node status.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> _builtins.str:
        """
        Indicates the node type.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstancesInstanceVolumeResult(dict):
    def __init__(__self__, *,
                 disk_encryption_id: _builtins.str,
                 size: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.str disk_encryption_id: Indicates the kms key id.
        :param _builtins.int size: Indicates the volume size.
        :param _builtins.str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        """
        pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> _builtins.str:
        """
        Indicates the kms key id.
        """
        return pulumi.get(self, "disk_encryption_id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Indicates the volume size.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetPgAccountsUserResult(dict):
    def __init__(__self__, *,
                 attributes: Sequence['outputs.GetPgAccountsUserAttributeResult'],
                 description: _builtins.str,
                 memberofs: Sequence[_builtins.str],
                 name: _builtins.str):
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "memberofs", memberofs)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Sequence['outputs.GetPgAccountsUserAttributeResult']:
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def memberofs(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "memberofs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPgAccountsUserAttributeResult(dict):
    def __init__(__self__, *,
                 rolbypassrls: _builtins.bool,
                 rolcanlogin: _builtins.bool,
                 rolconnlimit: _builtins.int,
                 rolcreatedb: _builtins.bool,
                 rolcreaterole: _builtins.bool,
                 rolinherit: _builtins.bool,
                 rolreplication: _builtins.bool,
                 rolsuper: _builtins.bool):
        pulumi.set(__self__, "rolbypassrls", rolbypassrls)
        pulumi.set(__self__, "rolcanlogin", rolcanlogin)
        pulumi.set(__self__, "rolconnlimit", rolconnlimit)
        pulumi.set(__self__, "rolcreatedb", rolcreatedb)
        pulumi.set(__self__, "rolcreaterole", rolcreaterole)
        pulumi.set(__self__, "rolinherit", rolinherit)
        pulumi.set(__self__, "rolreplication", rolreplication)
        pulumi.set(__self__, "rolsuper", rolsuper)

    @_builtins.property
    @pulumi.getter
    def rolbypassrls(self) -> _builtins.bool:
        return pulumi.get(self, "rolbypassrls")

    @_builtins.property
    @pulumi.getter
    def rolcanlogin(self) -> _builtins.bool:
        return pulumi.get(self, "rolcanlogin")

    @_builtins.property
    @pulumi.getter
    def rolconnlimit(self) -> _builtins.int:
        return pulumi.get(self, "rolconnlimit")

    @_builtins.property
    @pulumi.getter
    def rolcreatedb(self) -> _builtins.bool:
        return pulumi.get(self, "rolcreatedb")

    @_builtins.property
    @pulumi.getter
    def rolcreaterole(self) -> _builtins.bool:
        return pulumi.get(self, "rolcreaterole")

    @_builtins.property
    @pulumi.getter
    def rolinherit(self) -> _builtins.bool:
        return pulumi.get(self, "rolinherit")

    @_builtins.property
    @pulumi.getter
    def rolreplication(self) -> _builtins.bool:
        return pulumi.get(self, "rolreplication")

    @_builtins.property
    @pulumi.getter
    def rolsuper(self) -> _builtins.bool:
        return pulumi.get(self, "rolsuper")


@pulumi.output_type
class GetPgDatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 character_set: _builtins.str,
                 description: _builtins.str,
                 lc_collate: _builtins.str,
                 name: _builtins.str,
                 owner: _builtins.str,
                 size: _builtins.int):
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "lc_collate", lc_collate)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> _builtins.str:
        return pulumi.get(self, "character_set")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="lcCollate")
    def lc_collate(self) -> _builtins.str:
        return pulumi.get(self, "lc_collate")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> _builtins.str:
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        return pulumi.get(self, "size")


@pulumi.output_type
class GetPgPluginsPluginResult(dict):
    def __init__(__self__, *,
                 created: _builtins.bool,
                 description: _builtins.str,
                 name: _builtins.str,
                 shared_preload_libraries: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.bool created: Indicates whether the plugin has been created.
        :param _builtins.str description: Indicates the plugin description.
        :param _builtins.str name: Indicates the plugin name.
        :param _builtins.str shared_preload_libraries: Indicates the dependent preloaded library.
        :param _builtins.str version: Indicates the plugin version.
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "shared_preload_libraries", shared_preload_libraries)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.bool:
        """
        Indicates whether the plugin has been created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Indicates the plugin description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Indicates the plugin name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sharedPreloadLibraries")
    def shared_preload_libraries(self) -> _builtins.str:
        """
        Indicates the dependent preloaded library.
        """
        return pulumi.get(self, "shared_preload_libraries")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Indicates the plugin version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetPgSqlLimitsSqlLimitResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 is_effective: _builtins.bool,
                 max_concurrency: _builtins.int,
                 max_waiting: _builtins.int,
                 query_id: _builtins.str,
                 query_string: _builtins.str,
                 search_path: _builtins.str):
        """
        :param _builtins.str id: Indicates the ID of SQL limit.
        :param _builtins.bool is_effective: Indicates whether the SQL limit is effective.
        :param _builtins.int max_concurrency: Indicates the number of SQL statements executed simultaneously.
        :param _builtins.int max_waiting: Indicates the max waiting time in seconds.
        :param _builtins.str query_id: Indicates the query ID.
        :param _builtins.str query_string: Indicates the text form of SQL statement.
        :param _builtins.str search_path: Indicates the query order for names that are not schema qualified.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_effective", is_effective)
        pulumi.set(__self__, "max_concurrency", max_concurrency)
        pulumi.set(__self__, "max_waiting", max_waiting)
        pulumi.set(__self__, "query_id", query_id)
        pulumi.set(__self__, "query_string", query_string)
        pulumi.set(__self__, "search_path", search_path)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Indicates the ID of SQL limit.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isEffective")
    def is_effective(self) -> _builtins.bool:
        """
        Indicates whether the SQL limit is effective.
        """
        return pulumi.get(self, "is_effective")

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> _builtins.int:
        """
        Indicates the number of SQL statements executed simultaneously.
        """
        return pulumi.get(self, "max_concurrency")

    @_builtins.property
    @pulumi.getter(name="maxWaiting")
    def max_waiting(self) -> _builtins.int:
        """
        Indicates the max waiting time in seconds.
        """
        return pulumi.get(self, "max_waiting")

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> _builtins.str:
        """
        Indicates the query ID.
        """
        return pulumi.get(self, "query_id")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> _builtins.str:
        """
        Indicates the text form of SQL statement.
        """
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter(name="searchPath")
    def search_path(self) -> _builtins.str:
        """
        Indicates the query order for names that are not schema qualified.
        """
        return pulumi.get(self, "search_path")


@pulumi.output_type
class GetStorageTypesStorageTypeResult(dict):
    def __init__(__self__, *,
                 az_status: Mapping[str, _builtins.str],
                 name: _builtins.str,
                 support_compute_group_types: Sequence[_builtins.str]):
        """
        :param Mapping[str, _builtins.str] az_status: The status details of the AZs to which the specification belongs.
               Key indicates the AZ ID, and value indicates the specification status in the AZ.
               The options of value are as follows:
               - **normal**: The specifications in the AZ are available.
               - **unsupported**: The specifications are not supported by the AZ.
               - **sellout**: The specifications in the AZ are sold out.
        :param _builtins.str name: Storage type.  
               The options are as follows:
               - **ULTRAHIGH**: SSD storage.
               - **LOCALSSD**: Local SSD storage.
               - **CLOUDSSD**: Cloud SSD storage.
               This storage type is supported only with general-purpose and dedicated DB instances.
               - **ESSD**: extreme SSD storage.
               This storage type is supported only with dedicated DB instances.
        :param Sequence[_builtins.str] support_compute_group_types: Performance specifications.
               The options are as follows:
               - **normal**: General-enhanced.
               - **normal2**: General-enhanced II.
               - **armFlavors**: Kunpeng general-enhanced.
               - **dedicicatenormal**: Exclusive x86.
               - **armlocalssd**: Standard Kunpeng.
               - **normallocalssd**: Standard x86.
               - **general**: General-purpose.
               - **dedicated**: Dedicated, which is only supported for cloud SSDs.
               - **rapid**: Dedicated, which is only supported for extreme SSDs.
               - **bigmen**: Large-memory.
        """
        pulumi.set(__self__, "az_status", az_status)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "support_compute_group_types", support_compute_group_types)

    @_builtins.property
    @pulumi.getter(name="azStatus")
    def az_status(self) -> Mapping[str, _builtins.str]:
        """
        The status details of the AZs to which the specification belongs.
        Key indicates the AZ ID, and value indicates the specification status in the AZ.
        The options of value are as follows:
        - **normal**: The specifications in the AZ are available.
        - **unsupported**: The specifications are not supported by the AZ.
        - **sellout**: The specifications in the AZ are sold out.
        """
        return pulumi.get(self, "az_status")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Storage type.  
        The options are as follows:
        - **ULTRAHIGH**: SSD storage.
        - **LOCALSSD**: Local SSD storage.
        - **CLOUDSSD**: Cloud SSD storage.
        This storage type is supported only with general-purpose and dedicated DB instances.
        - **ESSD**: extreme SSD storage.
        This storage type is supported only with dedicated DB instances.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="supportComputeGroupTypes")
    def support_compute_group_types(self) -> Sequence[_builtins.str]:
        """
        Performance specifications.
        The options are as follows:
        - **normal**: General-enhanced.
        - **normal2**: General-enhanced II.
        - **armFlavors**: Kunpeng general-enhanced.
        - **dedicicatenormal**: Exclusive x86.
        - **armlocalssd**: Standard Kunpeng.
        - **normallocalssd**: Standard x86.
        - **general**: General-purpose.
        - **dedicated**: Dedicated, which is only supported for cloud SSDs.
        - **rapid**: Dedicated, which is only supported for extreme SSDs.
        - **bigmen**: Large-memory.
        """
        return pulumi.get(self, "support_compute_group_types")


