# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PgAccountArgs', 'PgAccount']

@pulumi.input_type
class PgAccountArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 memberofs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PgAccount resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DB account. The value must be 8 to 32 characters long
               and contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special
               characters (~!@#%^*-_=+?,). The value cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.str] description: Specifies the remarks of the DB account. The parameter must be 1 to 512 characters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] memberofs: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Specifies the username of the DB account. The username contains 1 to 63
               characters, including letters, digits, and underscores (_). It cannot start with pg or a digit and must be different
               from system usernames. System users include **rdsAdmin**, **rdsMetric**, **rdsBackup**, **rdsRepl**, **rdsProxy**,
               and **rdsDdm**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "password", password)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if memberofs is not None:
            pulumi.set(__self__, "memberofs", memberofs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the password of the DB account. The value must be 8 to 32 characters long
        and contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special
        characters (~!@#%^*-_=+?,). The value cannot contain the username or the username spelled backwards.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the remarks of the DB account. The parameter must be 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def memberofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "memberofs")

    @memberofs.setter
    def memberofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "memberofs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username of the DB account. The username contains 1 to 63
        characters, including letters, digits, and underscores (_). It cannot start with pg or a digit and must be different
        from system usernames. System users include **rdsAdmin**, **rdsMetric**, **rdsBackup**, **rdsRepl**, **rdsProxy**,
        and **rdsDdm**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PgAccountState:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['PgAccountAttributeArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 memberofs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PgAccount resources.
        :param pulumi.Input[Sequence[pulumi.Input['PgAccountAttributeArgs']]] attributes: Indicates the permission attributes of a user.
               The attributes structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the remarks of the DB account. The parameter must be 1 to 512 characters.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] memberofs: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Specifies the username of the DB account. The username contains 1 to 63
               characters, including letters, digits, and underscores (_). It cannot start with pg or a digit and must be different
               from system usernames. System users include **rdsAdmin**, **rdsMetric**, **rdsBackup**, **rdsRepl**, **rdsProxy**,
               and **rdsDdm**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DB account. The value must be 8 to 32 characters long
               and contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special
               characters (~!@#%^*-_=+?,). The value cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if memberofs is not None:
            pulumi.set(__self__, "memberofs", memberofs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PgAccountAttributeArgs']]]]:
        """
        Indicates the permission attributes of a user.
        The attributes structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PgAccountAttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the remarks of the DB account. The parameter must be 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RDS PostgreSQL instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def memberofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "memberofs")

    @memberofs.setter
    def memberofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "memberofs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username of the DB account. The username contains 1 to 63
        characters, including letters, digits, and underscores (_). It cannot start with pg or a digit and must be different
        from system usernames. System users include **rdsAdmin**, **rdsMetric**, **rdsBackup**, **rdsRepl**, **rdsProxy**,
        and **rdsDdm**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of the DB account. The value must be 8 to 32 characters long
        and contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special
        characters (~!@#%^*-_=+?,). The value cannot contain the username or the username spelled backwards.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Rds/pgAccount:PgAccount")
class PgAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 memberofs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages RDS PostgreSQL account resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        account_password = config.require_object("accountPassword")
        test = sbercloud.rds.PgAccount("test",
            instance_id=instance_id,
            name="test_account_name",
            password=account_password)
        ```

        ## Import

        The RDS PostgreSQL account can be imported using the `instance_id` and `name` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/pgAccount:PgAccount test <instance_id>/<name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `password`. It is generally recommended

        running `pulumi preview` after importing the RDS PostgreSQL account. You can then decide if changes should be applied to

        the RDS PostgreSQL account, or the resource definition should be updated to align with the RDS PostgreSQL account. Also

        you can ignore changes as below.

        hcl

        resource "sbercloud_rds_pg_account" "account_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the remarks of the DB account. The parameter must be 1 to 512 characters.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] memberofs: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Specifies the username of the DB account. The username contains 1 to 63
               characters, including letters, digits, and underscores (_). It cannot start with pg or a digit and must be different
               from system usernames. System users include **rdsAdmin**, **rdsMetric**, **rdsBackup**, **rdsRepl**, **rdsProxy**,
               and **rdsDdm**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DB account. The value must be 8 to 32 characters long
               and contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special
               characters (~!@#%^*-_=+?,). The value cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PgAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS PostgreSQL account resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        account_password = config.require_object("accountPassword")
        test = sbercloud.rds.PgAccount("test",
            instance_id=instance_id,
            name="test_account_name",
            password=account_password)
        ```

        ## Import

        The RDS PostgreSQL account can be imported using the `instance_id` and `name` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/pgAccount:PgAccount test <instance_id>/<name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `password`. It is generally recommended

        running `pulumi preview` after importing the RDS PostgreSQL account. You can then decide if changes should be applied to

        the RDS PostgreSQL account, or the resource definition should be updated to align with the RDS PostgreSQL account. Also

        you can ignore changes as below.

        hcl

        resource "sbercloud_rds_pg_account" "account_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param PgAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PgAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 memberofs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PgAccountArgs.__new__(PgAccountArgs)

            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["memberofs"] = memberofs
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["region"] = region
            __props__.__dict__["attributes"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PgAccount, __self__).__init__(
            'sbercloud:Rds/pgAccount:PgAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PgAccountAttributeArgs', 'PgAccountAttributeArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            memberofs: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'PgAccount':
        """
        Get an existing PgAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PgAccountAttributeArgs', 'PgAccountAttributeArgsDict']]]] attributes: Indicates the permission attributes of a user.
               The attributes structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the remarks of the DB account. The parameter must be 1 to 512 characters.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] memberofs: schema: Deprecated
        :param pulumi.Input[_builtins.str] name: Specifies the username of the DB account. The username contains 1 to 63
               characters, including letters, digits, and underscores (_). It cannot start with pg or a digit and must be different
               from system usernames. System users include **rdsAdmin**, **rdsMetric**, **rdsBackup**, **rdsRepl**, **rdsProxy**,
               and **rdsDdm**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DB account. The value must be 8 to 32 characters long
               and contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special
               characters (~!@#%^*-_=+?,). The value cannot contain the username or the username spelled backwards.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PgAccountState.__new__(_PgAccountState)

        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["memberofs"] = memberofs
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        return PgAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence['outputs.PgAccountAttribute']]:
        """
        Indicates the permission attributes of a user.
        The attributes structure is documented below.
        """
        return pulumi.get(self, "attributes")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the remarks of the DB account. The parameter must be 1 to 512 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def memberofs(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "memberofs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the username of the DB account. The username contains 1 to 63
        characters, including letters, digits, and underscores (_). It cannot start with pg or a digit and must be different
        from system usernames. System users include **rdsAdmin**, **rdsMetric**, **rdsBackup**, **rdsRepl**, **rdsProxy**,
        and **rdsDdm**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the password of the DB account. The value must be 8 to 32 characters long
        and contain at least three types of the following characters: uppercase letters, lowercase letters, digits, and special
        characters (~!@#%^*-_=+?,). The value cannot contain the username or the username spelled backwards.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

