# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PgDatabaseArgs', 'PgDatabase']

@pulumi.input_type
class PgDatabaseArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_revoke_public_privilege: Optional[pulumi.Input[_builtins.bool]] = None,
                 lc_collate: Optional[pulumi.Input[_builtins.str]] = None,
                 lc_ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PgDatabase resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] character_set: Specifies the database character set.
               For details, see [documentation](https://www.postgresql.org/docs/16/infoschema-character-sets.html).
               Defaults to **UTF8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value contains 0 to 512 characters.
        :param pulumi.Input[_builtins.bool] is_revoke_public_privilege: Specifies whether to revoke the PUBLIC CREATE permission of
               the public schema.
               + **true**: indicates that the permission will be revoked.
               + **false**: indicates that the permission will not be revoked.
               
               Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_collate: Specifies the database collocation.
               Defaults to **en_US.UTF-8**.
               
               > **NOTE:** For different collation rules, the execution result of a statement may be different.
               <br/> For example, the execution result of select 'a'>'A'; is false when this parameter is set to
               **en_US.utf8** and is true when this parameter is set to 'C'. If a database is migrated from "O" to
               PostgreSQL, this parameter needs to be set to 'C' to meet your expectations. You can query the supported
               collation rules from the pg_collation table.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_ctype: Specifies the database classification.
               Defaults to: **en_US.UTF-8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The value contains 1 to 63 characters, including
               letters, digits, and underscores (_). It cannot start with pg or a digit, and must be different from RDS for
               PostgreSQL template library names. RDS for PostgreSQL template libraries include **postgres**, **template0**, and
               **template1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the database user. The value must be an existing username and must be different
               from system usernames. Defaults to **root**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] template: Specifies the name of the database template. Value options: **template0**,
               **template1**. Defaults to **template1**.
               
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_revoke_public_privilege is not None:
            pulumi.set(__self__, "is_revoke_public_privilege", is_revoke_public_privilege)
        if lc_collate is not None:
            pulumi.set(__self__, "lc_collate", lc_collate)
        if lc_ctype is not None:
            pulumi.set(__self__, "lc_ctype", lc_ctype)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database character set.
        For details, see [documentation](https://www.postgresql.org/docs/16/infoschema-character-sets.html).
        Defaults to **UTF8**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database description. The value contains 0 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isRevokePublicPrivilege")
    def is_revoke_public_privilege(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to revoke the PUBLIC CREATE permission of
        the public schema.
        + **true**: indicates that the permission will be revoked.
        + **false**: indicates that the permission will not be revoked.

        Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "is_revoke_public_privilege")

    @is_revoke_public_privilege.setter
    def is_revoke_public_privilege(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_revoke_public_privilege", value)

    @_builtins.property
    @pulumi.getter(name="lcCollate")
    def lc_collate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database collocation.
        Defaults to **en_US.UTF-8**.

        > **NOTE:** For different collation rules, the execution result of a statement may be different.
        <br/> For example, the execution result of select 'a'>'A'; is false when this parameter is set to
        **en_US.utf8** and is true when this parameter is set to 'C'. If a database is migrated from "O" to
        PostgreSQL, this parameter needs to be set to 'C' to meet your expectations. You can query the supported
        collation rules from the pg_collation table.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lc_collate")

    @lc_collate.setter
    def lc_collate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lc_collate", value)

    @_builtins.property
    @pulumi.getter(name="lcCtype")
    def lc_ctype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database classification.
        Defaults to: **en_US.UTF-8**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lc_ctype")

    @lc_ctype.setter
    def lc_ctype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lc_ctype", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The value contains 1 to 63 characters, including
        letters, digits, and underscores (_). It cannot start with pg or a digit, and must be different from RDS for
        PostgreSQL template library names. RDS for PostgreSQL template libraries include **postgres**, **template0**, and
        **template1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database user. The value must be an existing username and must be different
        from system usernames. Defaults to **root**.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the database template. Value options: **template0**,
        **template1**. Defaults to **template1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class _PgDatabaseState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_revoke_public_privilege: Optional[pulumi.Input[_builtins.bool]] = None,
                 lc_collate: Optional[pulumi.Input[_builtins.str]] = None,
                 lc_ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PgDatabase resources.
        :param pulumi.Input[_builtins.str] character_set: Specifies the database character set.
               For details, see [documentation](https://www.postgresql.org/docs/16/infoschema-character-sets.html).
               Defaults to **UTF8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value contains 0 to 512 characters.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_revoke_public_privilege: Specifies whether to revoke the PUBLIC CREATE permission of
               the public schema.
               + **true**: indicates that the permission will be revoked.
               + **false**: indicates that the permission will not be revoked.
               
               Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_collate: Specifies the database collocation.
               Defaults to **en_US.UTF-8**.
               
               > **NOTE:** For different collation rules, the execution result of a statement may be different.
               <br/> For example, the execution result of select 'a'>'A'; is false when this parameter is set to
               **en_US.utf8** and is true when this parameter is set to 'C'. If a database is migrated from "O" to
               PostgreSQL, this parameter needs to be set to 'C' to meet your expectations. You can query the supported
               collation rules from the pg_collation table.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_ctype: Specifies the database classification.
               Defaults to: **en_US.UTF-8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The value contains 1 to 63 characters, including
               letters, digits, and underscores (_). It cannot start with pg or a digit, and must be different from RDS for
               PostgreSQL template library names. RDS for PostgreSQL template libraries include **postgres**, **template0**, and
               **template1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the database user. The value must be an existing username and must be different
               from system usernames. Defaults to **root**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] size: Indicates the database size, in bytes.
        :param pulumi.Input[_builtins.str] template: Specifies the name of the database template. Value options: **template0**,
               **template1**. Defaults to **template1**.
               
               Changing this parameter will create a new resource.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_revoke_public_privilege is not None:
            pulumi.set(__self__, "is_revoke_public_privilege", is_revoke_public_privilege)
        if lc_collate is not None:
            pulumi.set(__self__, "lc_collate", lc_collate)
        if lc_ctype is not None:
            pulumi.set(__self__, "lc_ctype", lc_ctype)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database character set.
        For details, see [documentation](https://www.postgresql.org/docs/16/infoschema-character-sets.html).
        Defaults to **UTF8**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database description. The value contains 0 to 512 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RDS PostgreSQL instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isRevokePublicPrivilege")
    def is_revoke_public_privilege(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to revoke the PUBLIC CREATE permission of
        the public schema.
        + **true**: indicates that the permission will be revoked.
        + **false**: indicates that the permission will not be revoked.

        Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "is_revoke_public_privilege")

    @is_revoke_public_privilege.setter
    def is_revoke_public_privilege(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_revoke_public_privilege", value)

    @_builtins.property
    @pulumi.getter(name="lcCollate")
    def lc_collate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database collocation.
        Defaults to **en_US.UTF-8**.

        > **NOTE:** For different collation rules, the execution result of a statement may be different.
        <br/> For example, the execution result of select 'a'>'A'; is false when this parameter is set to
        **en_US.utf8** and is true when this parameter is set to 'C'. If a database is migrated from "O" to
        PostgreSQL, this parameter needs to be set to 'C' to meet your expectations. You can query the supported
        collation rules from the pg_collation table.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lc_collate")

    @lc_collate.setter
    def lc_collate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lc_collate", value)

    @_builtins.property
    @pulumi.getter(name="lcCtype")
    def lc_ctype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database classification.
        Defaults to: **en_US.UTF-8**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lc_ctype")

    @lc_ctype.setter
    def lc_ctype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lc_ctype", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The value contains 1 to 63 characters, including
        letters, digits, and underscores (_). It cannot start with pg or a digit, and must be different from RDS for
        PostgreSQL template library names. RDS for PostgreSQL template libraries include **postgres**, **template0**, and
        **template1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database user. The value must be an existing username and must be different
        from system usernames. Defaults to **root**.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the database size, in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the database template. Value options: **template0**,
        **template1**. Defaults to **template1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template", value)


@pulumi.type_token("sbercloud:Rds/pgDatabase:PgDatabase")
class PgDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_revoke_public_privilege: Optional[pulumi.Input[_builtins.bool]] = None,
                 lc_collate: Optional[pulumi.Input[_builtins.str]] = None,
                 lc_ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages RDS PostgreSQL database resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.PgDatabase("test",
            instance_id=instance_id,
            name="test")
        ```

        ## Import

        The RDS postgresql database can be imported using the `instance_id` and `name` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/pgDatabase:PgDatabase test <instance_id>/<name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `template`, `is_revoke_public_privilege`

        `lc_ctype`. It is generally recommended running `pulumi preview` after importing the RDS PostgreSQL database. You can

        then decide if changes should be applied to the RDS PostgreSQL database, or the resource definition should be updated

        to align with the RDS PostgreSQL database. Also you can ignore changes as below.

        hcl

        resource "sbercloud_rds_pg_database" "account_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              template, is_revoke_public_privilege, lc_ctype,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set: Specifies the database character set.
               For details, see [documentation](https://www.postgresql.org/docs/16/infoschema-character-sets.html).
               Defaults to **UTF8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value contains 0 to 512 characters.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_revoke_public_privilege: Specifies whether to revoke the PUBLIC CREATE permission of
               the public schema.
               + **true**: indicates that the permission will be revoked.
               + **false**: indicates that the permission will not be revoked.
               
               Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_collate: Specifies the database collocation.
               Defaults to **en_US.UTF-8**.
               
               > **NOTE:** For different collation rules, the execution result of a statement may be different.
               <br/> For example, the execution result of select 'a'>'A'; is false when this parameter is set to
               **en_US.utf8** and is true when this parameter is set to 'C'. If a database is migrated from "O" to
               PostgreSQL, this parameter needs to be set to 'C' to meet your expectations. You can query the supported
               collation rules from the pg_collation table.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_ctype: Specifies the database classification.
               Defaults to: **en_US.UTF-8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The value contains 1 to 63 characters, including
               letters, digits, and underscores (_). It cannot start with pg or a digit, and must be different from RDS for
               PostgreSQL template library names. RDS for PostgreSQL template libraries include **postgres**, **template0**, and
               **template1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the database user. The value must be an existing username and must be different
               from system usernames. Defaults to **root**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] template: Specifies the name of the database template. Value options: **template0**,
               **template1**. Defaults to **template1**.
               
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PgDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS PostgreSQL database resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.PgDatabase("test",
            instance_id=instance_id,
            name="test")
        ```

        ## Import

        The RDS postgresql database can be imported using the `instance_id` and `name` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/pgDatabase:PgDatabase test <instance_id>/<name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `template`, `is_revoke_public_privilege`

        `lc_ctype`. It is generally recommended running `pulumi preview` after importing the RDS PostgreSQL database. You can

        then decide if changes should be applied to the RDS PostgreSQL database, or the resource definition should be updated

        to align with the RDS PostgreSQL database. Also you can ignore changes as below.

        hcl

        resource "sbercloud_rds_pg_database" "account_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              template, is_revoke_public_privilege, lc_ctype,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param PgDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PgDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_revoke_public_privilege: Optional[pulumi.Input[_builtins.bool]] = None,
                 lc_collate: Optional[pulumi.Input[_builtins.str]] = None,
                 lc_ctype: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PgDatabaseArgs.__new__(PgDatabaseArgs)

            __props__.__dict__["character_set"] = character_set
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_revoke_public_privilege"] = is_revoke_public_privilege
            __props__.__dict__["lc_collate"] = lc_collate
            __props__.__dict__["lc_ctype"] = lc_ctype
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["region"] = region
            __props__.__dict__["template"] = template
            __props__.__dict__["size"] = None
        super(PgDatabase, __self__).__init__(
            'sbercloud:Rds/pgDatabase:PgDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_revoke_public_privilege: Optional[pulumi.Input[_builtins.bool]] = None,
            lc_collate: Optional[pulumi.Input[_builtins.str]] = None,
            lc_ctype: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            template: Optional[pulumi.Input[_builtins.str]] = None) -> 'PgDatabase':
        """
        Get an existing PgDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set: Specifies the database character set.
               For details, see [documentation](https://www.postgresql.org/docs/16/infoschema-character-sets.html).
               Defaults to **UTF8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the database description. The value contains 0 to 512 characters.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] is_revoke_public_privilege: Specifies whether to revoke the PUBLIC CREATE permission of
               the public schema.
               + **true**: indicates that the permission will be revoked.
               + **false**: indicates that the permission will not be revoked.
               
               Defaults to **false**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_collate: Specifies the database collocation.
               Defaults to **en_US.UTF-8**.
               
               > **NOTE:** For different collation rules, the execution result of a statement may be different.
               <br/> For example, the execution result of select 'a'>'A'; is false when this parameter is set to
               **en_US.utf8** and is true when this parameter is set to 'C'. If a database is migrated from "O" to
               PostgreSQL, this parameter needs to be set to 'C' to meet your expectations. You can query the supported
               collation rules from the pg_collation table.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] lc_ctype: Specifies the database classification.
               Defaults to: **en_US.UTF-8**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The value contains 1 to 63 characters, including
               letters, digits, and underscores (_). It cannot start with pg or a digit, and must be different from RDS for
               PostgreSQL template library names. RDS for PostgreSQL template libraries include **postgres**, **template0**, and
               **template1**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the database user. The value must be an existing username and must be different
               from system usernames. Defaults to **root**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] size: Indicates the database size, in bytes.
        :param pulumi.Input[_builtins.str] template: Specifies the name of the database template. Value options: **template0**,
               **template1**. Defaults to **template1**.
               
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PgDatabaseState.__new__(_PgDatabaseState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_revoke_public_privilege"] = is_revoke_public_privilege
        __props__.__dict__["lc_collate"] = lc_collate
        __props__.__dict__["lc_ctype"] = lc_ctype
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["template"] = template
        return PgDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database character set.
        For details, see [documentation](https://www.postgresql.org/docs/16/infoschema-character-sets.html).
        Defaults to **UTF8**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "character_set")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the database description. The value contains 0 to 512 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isRevokePublicPrivilege")
    def is_revoke_public_privilege(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to revoke the PUBLIC CREATE permission of
        the public schema.
        + **true**: indicates that the permission will be revoked.
        + **false**: indicates that the permission will not be revoked.

        Defaults to **false**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "is_revoke_public_privilege")

    @_builtins.property
    @pulumi.getter(name="lcCollate")
    def lc_collate(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database collocation.
        Defaults to **en_US.UTF-8**.

        > **NOTE:** For different collation rules, the execution result of a statement may be different.
        <br/> For example, the execution result of select 'a'>'A'; is false when this parameter is set to
        **en_US.utf8** and is true when this parameter is set to 'C'. If a database is migrated from "O" to
        PostgreSQL, this parameter needs to be set to 'C' to meet your expectations. You can query the supported
        collation rules from the pg_collation table.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lc_collate")

    @_builtins.property
    @pulumi.getter(name="lcCtype")
    def lc_ctype(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database classification.
        Defaults to: **en_US.UTF-8**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "lc_ctype")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database name. The value contains 1 to 63 characters, including
        letters, digits, and underscores (_). It cannot start with pg or a digit, and must be different from RDS for
        PostgreSQL template library names. RDS for PostgreSQL template libraries include **postgres**, **template0**, and
        **template1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database user. The value must be an existing username and must be different
        from system usernames. Defaults to **root**.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the database size, in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the database template. Value options: **template0**,
        **template1**. Defaults to **template1**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "template")

