# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PgHbaArgs', 'PgHba']

@pulumi.input_type
class PgHbaArgs:
    def __init__(__self__, *,
                 host_based_authentications: pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]],
                 instance_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PgHba resource.
        :param pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]] host_based_authentications: Specifies the list of host based authentications.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        """
        pulumi.set(__self__, "host_based_authentications", host_based_authentications)
        pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="hostBasedAuthentications")
    def host_based_authentications(self) -> pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]]:
        """
        Specifies the list of host based authentications.
        """
        return pulumi.get(self, "host_based_authentications")

    @host_based_authentications.setter
    def host_based_authentications(self, value: pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]]):
        pulumi.set(self, "host_based_authentications", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PgHbaState:
    def __init__(__self__, *,
                 host_based_authentications: Optional[pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PgHba resources.
        :param pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]] host_based_authentications: Specifies the list of host based authentications.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        """
        if host_based_authentications is not None:
            pulumi.set(__self__, "host_based_authentications", host_based_authentications)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="hostBasedAuthentications")
    def host_based_authentications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]]]:
        """
        Specifies the list of host based authentications.
        """
        return pulumi.get(self, "host_based_authentications")

    @host_based_authentications.setter
    def host_based_authentications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PgHbaHostBasedAuthenticationArgs']]]]):
        pulumi.set(self, "host_based_authentications", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RDS PostgreSQL instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Rds/pgHba:PgHba")
class PgHba(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_based_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PgHbaHostBasedAuthenticationArgs', 'PgHbaHostBasedAuthenticationArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a PgHba resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PgHbaHostBasedAuthenticationArgs', 'PgHbaHostBasedAuthenticationArgsDict']]]] host_based_authentications: Specifies the list of host based authentications.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PgHbaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PgHba resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PgHbaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PgHbaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 host_based_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PgHbaHostBasedAuthenticationArgs', 'PgHbaHostBasedAuthenticationArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PgHbaArgs.__new__(PgHbaArgs)

            if host_based_authentications is None and not opts.urn:
                raise TypeError("Missing required property 'host_based_authentications'")
            __props__.__dict__["host_based_authentications"] = host_based_authentications
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
        super(PgHba, __self__).__init__(
            'sbercloud:Rds/pgHba:PgHba',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            host_based_authentications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PgHbaHostBasedAuthenticationArgs', 'PgHbaHostBasedAuthenticationArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'PgHba':
        """
        Get an existing PgHba resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PgHbaHostBasedAuthenticationArgs', 'PgHbaHostBasedAuthenticationArgsDict']]]] host_based_authentications: Specifies the list of host based authentications.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PgHbaState.__new__(_PgHbaState)

        __props__.__dict__["host_based_authentications"] = host_based_authentications
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        return PgHba(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="hostBasedAuthentications")
    def host_based_authentications(self) -> pulumi.Output[Sequence['outputs.PgHbaHostBasedAuthentication']]:
        """
        Specifies the list of host based authentications.
        """
        return pulumi.get(self, "host_based_authentications")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

