# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PgPluginParameterArgs', 'PgPluginParameter']

@pulumi.input_type
class PgPluginParameterArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PgPluginParameter resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: Specifies the list of plugin parameter values.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the plugin parameter.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "values", values)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of plugin parameter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "values", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the plugin parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PgPluginParameterState:
    def __init__(__self__, *,
                 default_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PgPluginParameter resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_values: Indicates the default values of the plugin parameter.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS instance.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the plugin parameter.
        :param pulumi.Input[_builtins.bool] restart_required: Indicates whether a reboot is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: Specifies the list of plugin parameter values.
        """
        if default_values is not None:
            pulumi.set(__self__, "default_values", default_values)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if restart_required is not None:
            pulumi.set(__self__, "restart_required", restart_required)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="defaultValues")
    def default_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Indicates the default values of the plugin parameter.
        """
        return pulumi.get(self, "default_values")

    @default_values.setter
    def default_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "default_values", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the plugin parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="restartRequired")
    def restart_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a reboot is required.
        """
        return pulumi.get(self, "restart_required")

    @restart_required.setter
    def restart_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restart_required", value)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of plugin parameter values.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "values", value)


@pulumi.type_token("sbercloud:Rds/pgPluginParameter:PgPluginParameter")
class PgPluginParameter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Create a PgPluginParameter resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS instance.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the plugin parameter.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: Specifies the list of plugin parameter values.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PgPluginParameterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PgPluginParameter resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PgPluginParameterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PgPluginParameterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PgPluginParameterArgs.__new__(PgPluginParameterArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if values is None and not opts.urn:
                raise TypeError("Missing required property 'values'")
            __props__.__dict__["values"] = values
            __props__.__dict__["default_values"] = None
            __props__.__dict__["restart_required"] = None
        super(PgPluginParameter, __self__).__init__(
            'sbercloud:Rds/pgPluginParameter:PgPluginParameter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            restart_required: Optional[pulumi.Input[_builtins.bool]] = None,
            values: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'PgPluginParameter':
        """
        Get an existing PgPluginParameter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] default_values: Indicates the default values of the plugin parameter.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of RDS instance.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the plugin parameter.
        :param pulumi.Input[_builtins.bool] restart_required: Indicates whether a reboot is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] values: Specifies the list of plugin parameter values.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PgPluginParameterState.__new__(_PgPluginParameterState)

        __props__.__dict__["default_values"] = default_values
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["restart_required"] = restart_required
        __props__.__dict__["values"] = values
        return PgPluginParameter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultValues")
    def default_values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Indicates the default values of the plugin parameter.
        """
        return pulumi.get(self, "default_values")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the plugin parameter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restartRequired")
    def restart_required(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether a reboot is required.
        """
        return pulumi.get(self, "restart_required")

    @_builtins.property
    @pulumi.getter
    def values(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of plugin parameter values.
        """
        return pulumi.get(self, "values")

