# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PgPluginUpdateArgs', 'PgPluginUpdate']

@pulumi.input_type
class PgPluginUpdateArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[_builtins.str],
                 extension_name: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PgPluginUpdate resource.
        :param pulumi.Input[_builtins.str] database_name: Specifies the database name.
        :param pulumi.Input[_builtins.str] extension_name: Specifies the extension name.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "extension_name", extension_name)
        pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the extension name.
        """
        return pulumi.get(self, "extension_name")

    @extension_name.setter
    def extension_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "extension_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PgPluginUpdateState:
    def __init__(__self__, *,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PgPluginUpdate resources.
        :param pulumi.Input[_builtins.str] database_name: Specifies the database name.
        :param pulumi.Input[_builtins.str] extension_name: Specifies the extension name.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
        """
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if extension_name is not None:
            pulumi.set(__self__, "extension_name", extension_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the extension name.
        """
        return pulumi.get(self, "extension_name")

    @extension_name.setter
    def extension_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "extension_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Rds/pgPluginUpdate:PgPluginUpdate")
class PgPluginUpdate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a PgPluginUpdate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_name: Specifies the database name.
        :param pulumi.Input[_builtins.str] extension_name: Specifies the extension name.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PgPluginUpdateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PgPluginUpdate resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PgPluginUpdateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PgPluginUpdateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 extension_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PgPluginUpdateArgs.__new__(PgPluginUpdateArgs)

            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            if extension_name is None and not opts.urn:
                raise TypeError("Missing required property 'extension_name'")
            __props__.__dict__["extension_name"] = extension_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
        super(PgPluginUpdate, __self__).__init__(
            'sbercloud:Rds/pgPluginUpdate:PgPluginUpdate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            extension_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'PgPluginUpdate':
        """
        Get an existing PgPluginUpdate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_name: Specifies the database name.
        :param pulumi.Input[_builtins.str] extension_name: Specifies the extension name.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PgPluginUpdateState.__new__(_PgPluginUpdateState)

        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["extension_name"] = extension_name
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        return PgPluginUpdate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database name.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="extensionName")
    def extension_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the extension name.
        """
        return pulumi.get(self, "extension_name")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

