# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PgSqlLimitArgs', 'PgSqlLimit']

@pulumi.input_type
class PgSqlLimitArgs:
    def __init__(__self__, *,
                 db_name: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 max_concurrency: pulumi.Input[_builtins.int],
                 max_waiting: pulumi.Input[_builtins.int],
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 switch: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PgSqlLimit resource.
        :param pulumi.Input[_builtins.str] db_name: Specifies the name of the database.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        :param pulumi.Input[_builtins.int] max_concurrency: Specifies the number of SQL statements executed simultaneously
        :param pulumi.Input[_builtins.int] max_waiting: Specifies the max waiting time in seconds.
        :param pulumi.Input[_builtins.str] query_id: Specifies the query ID
        :param pulumi.Input[_builtins.str] query_string: Specifies the text form of SQL statement.
        :param pulumi.Input[_builtins.str] search_path: Specifies the query order for names that are not schema qualified.
        :param pulumi.Input[_builtins.str] switch: Specifies the SQL limit switch.
        """
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "max_concurrency", max_concurrency)
        pulumi.set(__self__, "max_waiting", max_waiting)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if search_path is not None:
            pulumi.set(__self__, "search_path", search_path)
        if switch is not None:
            pulumi.set(__self__, "switch", switch)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the database.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of SQL statements executed simultaneously
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="maxWaiting")
    def max_waiting(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the max waiting time in seconds.
        """
        return pulumi.get(self, "max_waiting")

    @max_waiting.setter
    def max_waiting(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_waiting", value)

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the query ID
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_id", value)

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the text form of SQL statement.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="searchPath")
    def search_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the query order for names that are not schema qualified.
        """
        return pulumi.get(self, "search_path")

    @search_path.setter
    def search_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_path", value)

    @_builtins.property
    @pulumi.getter
    def switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SQL limit switch.
        """
        return pulumi.get(self, "switch")

    @switch.setter
    def switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch", value)


@pulumi.input_type
class _PgSqlLimitState:
    def __init__(__self__, *,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_effective: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 max_waiting: Optional[pulumi.Input[_builtins.int]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 sql_limit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 switch: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PgSqlLimit resources.
        :param pulumi.Input[_builtins.str] db_name: Specifies the name of the database.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        :param pulumi.Input[_builtins.bool] is_effective: Indicates whether the SQL limit is effective.
        :param pulumi.Input[_builtins.int] max_concurrency: Specifies the number of SQL statements executed simultaneously
        :param pulumi.Input[_builtins.int] max_waiting: Specifies the max waiting time in seconds.
        :param pulumi.Input[_builtins.str] query_id: Specifies the query ID
        :param pulumi.Input[_builtins.str] query_string: Specifies the text form of SQL statement.
        :param pulumi.Input[_builtins.str] search_path: Specifies the query order for names that are not schema qualified.
        :param pulumi.Input[_builtins.str] sql_limit_id: Indicates the ID of SQL limit.
        :param pulumi.Input[_builtins.str] switch: Specifies the SQL limit switch.
        """
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_effective is not None:
            pulumi.set(__self__, "is_effective", is_effective)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_waiting is not None:
            pulumi.set(__self__, "max_waiting", max_waiting)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if search_path is not None:
            pulumi.set(__self__, "search_path", search_path)
        if sql_limit_id is not None:
            pulumi.set(__self__, "sql_limit_id", sql_limit_id)
        if switch is not None:
            pulumi.set(__self__, "switch", switch)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the database.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RDS PostgreSQL instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isEffective")
    def is_effective(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the SQL limit is effective.
        """
        return pulumi.get(self, "is_effective")

    @is_effective.setter
    def is_effective(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_effective", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of SQL statements executed simultaneously
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrency", value)

    @_builtins.property
    @pulumi.getter(name="maxWaiting")
    def max_waiting(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the max waiting time in seconds.
        """
        return pulumi.get(self, "max_waiting")

    @max_waiting.setter
    def max_waiting(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_waiting", value)

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the query ID
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_id", value)

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the text form of SQL statement.
        """
        return pulumi.get(self, "query_string")

    @query_string.setter
    def query_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_string", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="searchPath")
    def search_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the query order for names that are not schema qualified.
        """
        return pulumi.get(self, "search_path")

    @search_path.setter
    def search_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "search_path", value)

    @_builtins.property
    @pulumi.getter(name="sqlLimitId")
    def sql_limit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the ID of SQL limit.
        """
        return pulumi.get(self, "sql_limit_id")

    @sql_limit_id.setter
    def sql_limit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sql_limit_id", value)

    @_builtins.property
    @pulumi.getter
    def switch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SQL limit switch.
        """
        return pulumi.get(self, "switch")

    @switch.setter
    def switch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "switch", value)


@pulumi.type_token("sbercloud:Rds/pgSqlLimit:PgSqlLimit")
class PgSqlLimit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 max_waiting: Optional[pulumi.Input[_builtins.int]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 switch: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a PgSqlLimit resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_name: Specifies the name of the database.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        :param pulumi.Input[_builtins.int] max_concurrency: Specifies the number of SQL statements executed simultaneously
        :param pulumi.Input[_builtins.int] max_waiting: Specifies the max waiting time in seconds.
        :param pulumi.Input[_builtins.str] query_id: Specifies the query ID
        :param pulumi.Input[_builtins.str] query_string: Specifies the text form of SQL statement.
        :param pulumi.Input[_builtins.str] search_path: Specifies the query order for names that are not schema qualified.
        :param pulumi.Input[_builtins.str] switch: Specifies the SQL limit switch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PgSqlLimitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a PgSqlLimit resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param PgSqlLimitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PgSqlLimitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
                 max_waiting: Optional[pulumi.Input[_builtins.int]] = None,
                 query_id: Optional[pulumi.Input[_builtins.str]] = None,
                 query_string: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 search_path: Optional[pulumi.Input[_builtins.str]] = None,
                 switch: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PgSqlLimitArgs.__new__(PgSqlLimitArgs)

            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if max_concurrency is None and not opts.urn:
                raise TypeError("Missing required property 'max_concurrency'")
            __props__.__dict__["max_concurrency"] = max_concurrency
            if max_waiting is None and not opts.urn:
                raise TypeError("Missing required property 'max_waiting'")
            __props__.__dict__["max_waiting"] = max_waiting
            __props__.__dict__["query_id"] = query_id
            __props__.__dict__["query_string"] = query_string
            __props__.__dict__["region"] = region
            __props__.__dict__["search_path"] = search_path
            __props__.__dict__["switch"] = switch
            __props__.__dict__["is_effective"] = None
            __props__.__dict__["sql_limit_id"] = None
        super(PgSqlLimit, __self__).__init__(
            'sbercloud:Rds/pgSqlLimit:PgSqlLimit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_effective: Optional[pulumi.Input[_builtins.bool]] = None,
            max_concurrency: Optional[pulumi.Input[_builtins.int]] = None,
            max_waiting: Optional[pulumi.Input[_builtins.int]] = None,
            query_id: Optional[pulumi.Input[_builtins.str]] = None,
            query_string: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            search_path: Optional[pulumi.Input[_builtins.str]] = None,
            sql_limit_id: Optional[pulumi.Input[_builtins.str]] = None,
            switch: Optional[pulumi.Input[_builtins.str]] = None) -> 'PgSqlLimit':
        """
        Get an existing PgSqlLimit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] db_name: Specifies the name of the database.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS PostgreSQL instance.
        :param pulumi.Input[_builtins.bool] is_effective: Indicates whether the SQL limit is effective.
        :param pulumi.Input[_builtins.int] max_concurrency: Specifies the number of SQL statements executed simultaneously
        :param pulumi.Input[_builtins.int] max_waiting: Specifies the max waiting time in seconds.
        :param pulumi.Input[_builtins.str] query_id: Specifies the query ID
        :param pulumi.Input[_builtins.str] query_string: Specifies the text form of SQL statement.
        :param pulumi.Input[_builtins.str] search_path: Specifies the query order for names that are not schema qualified.
        :param pulumi.Input[_builtins.str] sql_limit_id: Indicates the ID of SQL limit.
        :param pulumi.Input[_builtins.str] switch: Specifies the SQL limit switch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PgSqlLimitState.__new__(_PgSqlLimitState)

        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_effective"] = is_effective
        __props__.__dict__["max_concurrency"] = max_concurrency
        __props__.__dict__["max_waiting"] = max_waiting
        __props__.__dict__["query_id"] = query_id
        __props__.__dict__["query_string"] = query_string
        __props__.__dict__["region"] = region
        __props__.__dict__["search_path"] = search_path
        __props__.__dict__["sql_limit_id"] = sql_limit_id
        __props__.__dict__["switch"] = switch
        return PgSqlLimit(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the database.
        """
        return pulumi.get(self, "db_name")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RDS PostgreSQL instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isEffective")
    def is_effective(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the SQL limit is effective.
        """
        return pulumi.get(self, "is_effective")

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of SQL statements executed simultaneously
        """
        return pulumi.get(self, "max_concurrency")

    @_builtins.property
    @pulumi.getter(name="maxWaiting")
    def max_waiting(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the max waiting time in seconds.
        """
        return pulumi.get(self, "max_waiting")

    @_builtins.property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the query ID
        """
        return pulumi.get(self, "query_id")

    @_builtins.property
    @pulumi.getter(name="queryString")
    def query_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the text form of SQL statement.
        """
        return pulumi.get(self, "query_string")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="searchPath")
    def search_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the query order for names that are not schema qualified.
        """
        return pulumi.get(self, "search_path")

    @_builtins.property
    @pulumi.getter(name="sqlLimitId")
    def sql_limit_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the ID of SQL limit.
        """
        return pulumi.get(self, "sql_limit_id")

    @_builtins.property
    @pulumi.getter
    def switch(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SQL limit switch.
        """
        return pulumi.get(self, "switch")

