# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReadReplicaInstanceArgs', 'ReadReplicaInstance']

@pulumi.input_type
class ReadReplicaInstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[_builtins.str],
                 flavor: pulumi.Input[_builtins.str],
                 primary_instance_id: pulumi.Input[_builtins.str],
                 volume: pulumi.Input['ReadReplicaInstanceVolumeArgs'],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db: Optional[pulumi.Input['ReadReplicaInstanceDbArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ReadReplicaInstance resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the AZ name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
        :param pulumi.Input[_builtins.str] primary_instance_id: Specifies the DB instance ID, which is used to create a read replica.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ReadReplicaInstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ReadReplicaInstanceDbArgs'] db: Indicates the database information. Structure is documented below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type
               must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
               It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds read replica instance resource.
               If omitted, the provider-level region will be used.
               
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group which the RDS DB instance belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one key-value pair.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "primary_instance_id", primary_instance_id)
        pulumi.set(__self__, "volume", volume)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if db is not None:
            pulumi.set(__self__, "db", db)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the AZ name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="primaryInstanceId")
    def primary_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the DB instance ID, which is used to create a read replica.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "primary_instance_id")

    @primary_instance_id.setter
    def primary_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "primary_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def volume(self) -> pulumi.Input['ReadReplicaInstanceVolumeArgs']:
        """
        Specifies the volume information. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['ReadReplicaInstanceVolumeArgs']):
        pulumi.set(self, "volume", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def db(self) -> Optional[pulumi.Input['ReadReplicaInstanceDbArgs']]:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "db")

    @db.setter
    def db(self, value: Optional[pulumi.Input['ReadReplicaInstanceDbArgs']]):
        pulumi.set(self, "db", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the read replica instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type
        must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
        It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceParameterArgs']]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the rds read replica instance resource.
        If omitted, the provider-level region will be used.

        Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ReadReplicaInstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db: Optional[pulumi.Input['ReadReplicaInstanceDbArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceParameterArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input['ReadReplicaInstanceVolumeArgs']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReadReplicaInstance resources.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the AZ name.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ReadReplicaInstanceDbArgs'] db: Indicates the database information. Structure is documented below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type
               must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
               It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] primary_instance_id: Specifies the DB instance ID, which is used to create a read replica.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Indicates the private IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds read replica instance resource.
               If omitted, the provider-level region will be used.
               
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group which the RDS DB instance belongs to.
        :param pulumi.Input[_builtins.str] status: Indicates the instance status.
        :param pulumi.Input[_builtins.str] subnet_id: Indicates the subnet id.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one key-value pair.
        :param pulumi.Input[_builtins.str] type: Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        :param pulumi.Input['ReadReplicaInstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Indicates the VPC ID.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if db is not None:
            pulumi.set(__self__, "db", db)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if primary_instance_id is not None:
            pulumi.set(__self__, "primary_instance_id", primary_instance_id)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the AZ name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def db(self) -> Optional[pulumi.Input['ReadReplicaInstanceDbArgs']]:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "db")

    @db.setter
    def db(self, value: Optional[pulumi.Input['ReadReplicaInstanceDbArgs']]):
        pulumi.set(self, "db", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the read replica instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type
        must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
        It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceParameterArgs']]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="primaryInstanceId")
    def primary_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance ID, which is used to create a read replica.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "primary_instance_id")

    @primary_instance_id.setter
    def primary_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Indicates the private IP address list.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_ips", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the rds read replica instance resource.
        If omitted, the provider-level region will be used.

        Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the instance status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['ReadReplicaInstanceVolumeArgs']]:
        """
        Specifies the volume information. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['ReadReplicaInstanceVolumeArgs']]):
        pulumi.set(self, "volume", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Rds/readReplicaInstance:ReadReplicaInstance")
class ReadReplicaInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db: Optional[pulumi.Input[Union['ReadReplicaInstanceDbArgs', 'ReadReplicaInstanceDbArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReadReplicaInstanceParameterArgs', 'ReadReplicaInstanceParameterArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 volume: Optional[pulumi.Input[Union['ReadReplicaInstanceVolumeArgs', 'ReadReplicaInstanceVolumeArgsDict']]] = None,
                 __props__=None):
        """
        Manages RDS Read Replica Instance resource.

        ## Example Usage

        ### Create a Rds read replica instance
        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        secgroup = sbercloud.vpc.Secgroup("secgroup",
            name="test_sg_for_rds",
            description="security group for rds read replica instance")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.c6.large.4",
            availability_zones=["{{ availability_zone }}"],
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            enterprise_project_id="{{ enterprise_project_id }}",
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": "Huangwei!120521",
                "port": 8635,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 50,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        replica_instance = sbercloud.rds.ReadReplicaInstance("replica_instance",
            name="test_rds_readonly_instance",
            flavor="rds.pg.c6.large.4.rr",
            primary_instance_id=instance.id,
            availability_zone="{{ availability_zone }}",
            enterprise_project_id="{{ enterprise_project_id }}",
            volume={
                "type": "ULTRAHIGH",
            })
        ```

        ## Import

        RDS read replica instance can be imported by `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Rds/readReplicaInstance:ReadReplicaInstance replica_instance 92302c133d13424cbe357506ce057ea5in03
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the AZ name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['ReadReplicaInstanceDbArgs', 'ReadReplicaInstanceDbArgsDict']] db: Indicates the database information. Structure is documented below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type
               must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
               It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] primary_instance_id: Specifies the DB instance ID, which is used to create a read replica.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds read replica instance resource.
               If omitted, the provider-level region will be used.
               
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group which the RDS DB instance belongs to.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one key-value pair.
        :param pulumi.Input[Union['ReadReplicaInstanceVolumeArgs', 'ReadReplicaInstanceVolumeArgsDict']] volume: Specifies the volume information. Structure is documented below.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReadReplicaInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS Read Replica Instance resource.

        ## Example Usage

        ### Create a Rds read replica instance
        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        secgroup = sbercloud.vpc.Secgroup("secgroup",
            name="test_sg_for_rds",
            description="security group for rds read replica instance")
        instance = sbercloud.rds.Instance("instance",
            name="terraform_test_rds_instance",
            flavor="rds.pg.c6.large.4",
            availability_zones=["{{ availability_zone }}"],
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            enterprise_project_id="{{ enterprise_project_id }}",
            db={
                "type": "PostgreSQL",
                "version": "12",
                "password": "Huangwei!120521",
                "port": 8635,
            },
            volume={
                "type": "ULTRAHIGH",
                "size": 50,
            },
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 1,
            })
        replica_instance = sbercloud.rds.ReadReplicaInstance("replica_instance",
            name="test_rds_readonly_instance",
            flavor="rds.pg.c6.large.4.rr",
            primary_instance_id=instance.id,
            availability_zone="{{ availability_zone }}",
            enterprise_project_id="{{ enterprise_project_id }}",
            volume={
                "type": "ULTRAHIGH",
            })
        ```

        ## Import

        RDS read replica instance can be imported by `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Rds/readReplicaInstance:ReadReplicaInstance replica_instance 92302c133d13424cbe357506ce057ea5in03
        ```

        :param str resource_name: The name of the resource.
        :param ReadReplicaInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReadReplicaInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 db: Optional[pulumi.Input[Union['ReadReplicaInstanceDbArgs', 'ReadReplicaInstanceDbArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReadReplicaInstanceParameterArgs', 'ReadReplicaInstanceParameterArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 volume: Optional[pulumi.Input[Union['ReadReplicaInstanceVolumeArgs', 'ReadReplicaInstanceVolumeArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReadReplicaInstanceArgs.__new__(ReadReplicaInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["db"] = db
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["fixed_ip"] = fixed_ip
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            if primary_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'primary_instance_id'")
            __props__.__dict__["primary_instance_id"] = primary_instance_id
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl_enable"] = ssl_enable
            __props__.__dict__["tags"] = tags
            if volume is None and not opts.urn:
                raise TypeError("Missing required property 'volume'")
            __props__.__dict__["volume"] = volume
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["public_ips"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_id"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vpc_id"] = None
        super(ReadReplicaInstance, __self__).__init__(
            'sbercloud:Rds/readReplicaInstance:ReadReplicaInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            db: Optional[pulumi.Input[Union['ReadReplicaInstanceDbArgs', 'ReadReplicaInstanceDbArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReadReplicaInstanceParameterArgs', 'ReadReplicaInstanceParameterArgsDict']]]]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            primary_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            volume: Optional[pulumi.Input[Union['ReadReplicaInstanceVolumeArgs', 'ReadReplicaInstanceVolumeArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReadReplicaInstance':
        """
        Get an existing ReadReplicaInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the AZ name.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Union['ReadReplicaInstanceDbArgs', 'ReadReplicaInstanceDbArgsDict']] db: Indicates the database information. Structure is documented below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor: Specifies the specification code.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type
               must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
               It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] primary_instance_id: Specifies the DB instance ID, which is used to create a read replica.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: Indicates the private IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[_builtins.str] region: The region in which to create the rds read replica instance resource.
               If omitted, the provider-level region will be used.
               
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[_builtins.str] security_group_id: Indicates the security group which the RDS DB instance belongs to.
        :param pulumi.Input[_builtins.str] status: Indicates the instance status.
        :param pulumi.Input[_builtins.str] subnet_id: Indicates the subnet id.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one key-value pair.
        :param pulumi.Input[_builtins.str] type: Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        :param pulumi.Input[Union['ReadReplicaInstanceVolumeArgs', 'ReadReplicaInstanceVolumeArgsDict']] volume: Specifies the volume information. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Indicates the VPC ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReadReplicaInstanceState.__new__(_ReadReplicaInstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["db"] = db
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["primary_instance_id"] = primary_instance_id
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["public_ips"] = public_ips
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["volume"] = volume
        __props__.__dict__["vpc_id"] = vpc_id
        return ReadReplicaInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the AZ name.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter
    def db(self) -> pulumi.Output['outputs.ReadReplicaInstanceDb']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "db")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the read replica instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "fixed_ip")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the DB instance name. The DB instance name of the same type
        must be unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter.
        It is case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.ReadReplicaInstanceParameter']]:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="primaryInstanceId")
    def primary_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the DB instance ID, which is used to create a read replica.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "primary_instance_id")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Indicates the private IP address list.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the rds read replica instance resource.
        If omitted, the provider-level region will be used.

        Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the instance status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one key-value pair.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the DB engine. Value: MySQL, PostgreSQL, SQLServer.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def volume(self) -> pulumi.Output['outputs.ReadReplicaInstanceVolume']:
        """
        Specifies the volume information. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "volume")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the VPC ID.
        """
        return pulumi.get(self, "vpc_id")

