# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlAuditArgs', 'SqlAudit']

@pulumi.input_type
class SqlAuditArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 keep_days: pulumi.Input[_builtins.int],
                 audit_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve_auditlogs: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SqlAudit resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] keep_days: Specifies the number of days for storing audit logs. Value ranges from `1` to `732`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_types: Specifies the list of audit types. Value options: **CREATE_USER**, **DROP_USER**,
               **RENAME_USER**, **GRANT**, **REVOKE**, **CREATE**, **ALTER**, **DROP**, **RENAME**, **TRUNCATE**, **INSERT**,
               **DELETE**, **UPDATE**, **REPLACE**, **SELECT**, **BEGIN/COMMIT/ROLLBACK**, **PREPARED_STATEMENT**.
               It is not supported for PostgreSQL.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] reserve_auditlogs: Specifies whether the historical audit logs will be reserved for some time
               when SQL audit is disabled. It is valid only when SQL audit is disabled.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "keep_days", keep_days)
        if audit_types is not None:
            pulumi.set(__self__, "audit_types", audit_types)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserve_auditlogs is not None:
            pulumi.set(__self__, "reserve_auditlogs", reserve_auditlogs)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RDS instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the number of days for storing audit logs. Value ranges from `1` to `732`.
        """
        return pulumi.get(self, "keep_days")

    @keep_days.setter
    def keep_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "keep_days", value)

    @_builtins.property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of audit types. Value options: **CREATE_USER**, **DROP_USER**,
        **RENAME_USER**, **GRANT**, **REVOKE**, **CREATE**, **ALTER**, **DROP**, **RENAME**, **TRUNCATE**, **INSERT**,
        **DELETE**, **UPDATE**, **REPLACE**, **SELECT**, **BEGIN/COMMIT/ROLLBACK**, **PREPARED_STATEMENT**.
        It is not supported for PostgreSQL.
        """
        return pulumi.get(self, "audit_types")

    @audit_types.setter
    def audit_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_types", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reserveAuditlogs")
    def reserve_auditlogs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the historical audit logs will be reserved for some time
        when SQL audit is disabled. It is valid only when SQL audit is disabled.
        """
        return pulumi.get(self, "reserve_auditlogs")

    @reserve_auditlogs.setter
    def reserve_auditlogs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reserve_auditlogs", value)


@pulumi.input_type
class _SqlAuditState:
    def __init__(__self__, *,
                 audit_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_days: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve_auditlogs: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SqlAudit resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_types: Specifies the list of audit types. Value options: **CREATE_USER**, **DROP_USER**,
               **RENAME_USER**, **GRANT**, **REVOKE**, **CREATE**, **ALTER**, **DROP**, **RENAME**, **TRUNCATE**, **INSERT**,
               **DELETE**, **UPDATE**, **REPLACE**, **SELECT**, **BEGIN/COMMIT/ROLLBACK**, **PREPARED_STATEMENT**.
               It is not supported for PostgreSQL.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] keep_days: Specifies the number of days for storing audit logs. Value ranges from `1` to `732`.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] reserve_auditlogs: Specifies whether the historical audit logs will be reserved for some time
               when SQL audit is disabled. It is valid only when SQL audit is disabled.
        """
        if audit_types is not None:
            pulumi.set(__self__, "audit_types", audit_types)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if reserve_auditlogs is not None:
            pulumi.set(__self__, "reserve_auditlogs", reserve_auditlogs)

    @_builtins.property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of audit types. Value options: **CREATE_USER**, **DROP_USER**,
        **RENAME_USER**, **GRANT**, **REVOKE**, **CREATE**, **ALTER**, **DROP**, **RENAME**, **TRUNCATE**, **INSERT**,
        **DELETE**, **UPDATE**, **REPLACE**, **SELECT**, **BEGIN/COMMIT/ROLLBACK**, **PREPARED_STATEMENT**.
        It is not supported for PostgreSQL.
        """
        return pulumi.get(self, "audit_types")

    @audit_types.setter
    def audit_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "audit_types", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RDS instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of days for storing audit logs. Value ranges from `1` to `732`.
        """
        return pulumi.get(self, "keep_days")

    @keep_days.setter
    def keep_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "keep_days", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="reserveAuditlogs")
    def reserve_auditlogs(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the historical audit logs will be reserved for some time
        when SQL audit is disabled. It is valid only when SQL audit is disabled.
        """
        return pulumi.get(self, "reserve_auditlogs")

    @reserve_auditlogs.setter
    def reserve_auditlogs(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reserve_auditlogs", value)


@pulumi.type_token("sbercloud:Rds/sqlAudit:SqlAudit")
class SqlAudit(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_days: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve_auditlogs: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages RDS SQL audit resource within SberCloud.

        > **NOTE:** Only MySQL and PostgreSQL engines are supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.SqlAudit("test",
            instance_id=instance_id,
            keep_days=5)
        ```

        ## Import

        The RDS SQL audit can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/sqlAudit:SqlAudit test <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_types: Specifies the list of audit types. Value options: **CREATE_USER**, **DROP_USER**,
               **RENAME_USER**, **GRANT**, **REVOKE**, **CREATE**, **ALTER**, **DROP**, **RENAME**, **TRUNCATE**, **INSERT**,
               **DELETE**, **UPDATE**, **REPLACE**, **SELECT**, **BEGIN/COMMIT/ROLLBACK**, **PREPARED_STATEMENT**.
               It is not supported for PostgreSQL.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] keep_days: Specifies the number of days for storing audit logs. Value ranges from `1` to `732`.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] reserve_auditlogs: Specifies whether the historical audit logs will be reserved for some time
               when SQL audit is disabled. It is valid only when SQL audit is disabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlAuditArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS SQL audit resource within SberCloud.

        > **NOTE:** Only MySQL and PostgreSQL engines are supported.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.SqlAudit("test",
            instance_id=instance_id,
            keep_days=5)
        ```

        ## Import

        The RDS SQL audit can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/sqlAudit:SqlAudit test <id>
        ```

        :param str resource_name: The name of the resource.
        :param SqlAuditArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlAuditArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keep_days: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 reserve_auditlogs: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlAuditArgs.__new__(SqlAuditArgs)

            __props__.__dict__["audit_types"] = audit_types
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if keep_days is None and not opts.urn:
                raise TypeError("Missing required property 'keep_days'")
            __props__.__dict__["keep_days"] = keep_days
            __props__.__dict__["region"] = region
            __props__.__dict__["reserve_auditlogs"] = reserve_auditlogs
        super(SqlAudit, __self__).__init__(
            'sbercloud:Rds/sqlAudit:SqlAudit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            keep_days: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            reserve_auditlogs: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SqlAudit':
        """
        Get an existing SqlAudit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] audit_types: Specifies the list of audit types. Value options: **CREATE_USER**, **DROP_USER**,
               **RENAME_USER**, **GRANT**, **REVOKE**, **CREATE**, **ALTER**, **DROP**, **RENAME**, **TRUNCATE**, **INSERT**,
               **DELETE**, **UPDATE**, **REPLACE**, **SELECT**, **BEGIN/COMMIT/ROLLBACK**, **PREPARED_STATEMENT**.
               It is not supported for PostgreSQL.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] keep_days: Specifies the number of days for storing audit logs. Value ranges from `1` to `732`.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] reserve_auditlogs: Specifies whether the historical audit logs will be reserved for some time
               when SQL audit is disabled. It is valid only when SQL audit is disabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlAuditState.__new__(_SqlAuditState)

        __props__.__dict__["audit_types"] = audit_types
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["keep_days"] = keep_days
        __props__.__dict__["region"] = region
        __props__.__dict__["reserve_auditlogs"] = reserve_auditlogs
        return SqlAudit(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of audit types. Value options: **CREATE_USER**, **DROP_USER**,
        **RENAME_USER**, **GRANT**, **REVOKE**, **CREATE**, **ALTER**, **DROP**, **RENAME**, **TRUNCATE**, **INSERT**,
        **DELETE**, **UPDATE**, **REPLACE**, **SELECT**, **BEGIN/COMMIT/ROLLBACK**, **PREPARED_STATEMENT**.
        It is not supported for PostgreSQL.
        """
        return pulumi.get(self, "audit_types")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RDS instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of days for storing audit logs. Value ranges from `1` to `732`.
        """
        return pulumi.get(self, "keep_days")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="reserveAuditlogs")
    def reserve_auditlogs(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the historical audit logs will be reserved for some time
        when SQL audit is disabled. It is valid only when SQL audit is disabled.
        """
        return pulumi.get(self, "reserve_auditlogs")

