# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlserverDatabaseArgs', 'SqlserverDatabase']

@pulumi.input_type
class SqlserverDatabaseArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlserverDatabase resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS SQLServer instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name can contain 1 to 64 characters,
               and can include letters, digits, hyphens (-), underscores (_), and periods (.). It cannot start or end with an RDS for
               SQL Server system database name. RDS for SQL Server system databases include **master**, **msdb**, **model**,
               **tempdb**, **resource**, and **rdsadmin**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RDS SQLServer instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The database name can contain 1 to 64 characters,
        and can include letters, digits, hyphens (-), underscores (_), and periods (.). It cannot start or end with an RDS for
        SQL Server system database name. RDS for SQL Server system databases include **master**, **msdb**, **model**,
        **tempdb**, **resource**, and **rdsadmin**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SqlserverDatabaseState:
    def __init__(__self__, *,
                 character_set: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlserverDatabase resources.
        :param pulumi.Input[_builtins.str] character_set: Indicates the character set used by the database.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS SQLServer instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name can contain 1 to 64 characters,
               and can include letters, digits, hyphens (-), underscores (_), and periods (.). It cannot start or end with an RDS for
               SQL Server system database name. RDS for SQL Server system databases include **master**, **msdb**, **model**,
               **tempdb**, **resource**, and **rdsadmin**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] state: Indicates the database status. Its value can be any of the following:
               + **Creating**: The database is being created.
               + **Running**: The database is running.
               + **Deleting**: The database is being deleted.
               + **Not Exists**: The database does not exist.
        """
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the character set used by the database.
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "character_set", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RDS SQLServer instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The database name can contain 1 to 64 characters,
        and can include letters, digits, hyphens (-), underscores (_), and periods (.). It cannot start or end with an RDS for
        SQL Server system database name. RDS for SQL Server system databases include **master**, **msdb**, **model**,
        **tempdb**, **resource**, and **rdsadmin**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the database status. Its value can be any of the following:
        + **Creating**: The database is being created.
        + **Running**: The database is running.
        + **Deleting**: The database is being deleted.
        + **Not Exists**: The database does not exist.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("sbercloud:Rds/sqlserverDatabase:SqlserverDatabase")
class SqlserverDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages RDS SQLServer database resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.SqlserverDatabase("test",
            instance_id=instance_id,
            name="test")
        ```

        ## Import

        The RDS sqlserver database can be imported using the `instance_id` and `name` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/sqlserverDatabase:SqlserverDatabase test <instance_id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS SQLServer instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name can contain 1 to 64 characters,
               and can include letters, digits, hyphens (-), underscores (_), and periods (.). It cannot start or end with an RDS for
               SQL Server system database name. RDS for SQL Server system databases include **master**, **msdb**, **model**,
               **tempdb**, **resource**, and **rdsadmin**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlserverDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS SQLServer database resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.rds.SqlserverDatabase("test",
            instance_id=instance_id,
            name="test")
        ```

        ## Import

        The RDS sqlserver database can be imported using the `instance_id` and `name` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Rds/sqlserverDatabase:SqlserverDatabase test <instance_id>/<name>
        ```

        :param str resource_name: The name of the resource.
        :param SqlserverDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlserverDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlserverDatabaseArgs.__new__(SqlserverDatabaseArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["character_set"] = None
            __props__.__dict__["state"] = None
        super(SqlserverDatabase, __self__).__init__(
            'sbercloud:Rds/sqlserverDatabase:SqlserverDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            character_set: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlserverDatabase':
        """
        Get an existing SqlserverDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] character_set: Indicates the character set used by the database.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RDS SQLServer instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The database name can contain 1 to 64 characters,
               and can include letters, digits, hyphens (-), underscores (_), and periods (.). It cannot start or end with an RDS for
               SQL Server system database name. RDS for SQL Server system databases include **master**, **msdb**, **model**,
               **tempdb**, **resource**, and **rdsadmin**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] state: Indicates the database status. Its value can be any of the following:
               + **Creating**: The database is being created.
               + **Running**: The database is running.
               + **Deleting**: The database is being deleted.
               + **Not Exists**: The database does not exist.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlserverDatabaseState.__new__(_SqlserverDatabaseState)

        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        return SqlserverDatabase(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the character set used by the database.
        """
        return pulumi.get(self, "character_set")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RDS SQLServer instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database name. The database name can contain 1 to 64 characters,
        and can include letters, digits, hyphens (-), underscores (_), and periods (.). It cannot start or end with an RDS for
        SQL Server system database name. RDS for SQL Server system databases include **master**, **msdb**, **model**,
        **tempdb**, **resource**, and **rdsadmin**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the database status. Its value can be any of the following:
        + **Creating**: The database is being created.
        + **Running**: The database is running.
        + **Deleting**: The database is being deleted.
        + **Not Exists**: The database does not exist.
        """
        return pulumi.get(self, "state")

