# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FileSystemArgs', 'FileSystem']

@pulumi.input_type
class FileSystemArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[_builtins.int],
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_to: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_proto: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FileSystem resource.
        :param pulumi.Input[_builtins.int] size: The size (GB) of the shared file system.
        :param pulumi.Input[_builtins.str] access_level: Specifies the access level of the shared file system. Possible values are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] access_to: Specifies the value that defines the access rule. The value contains 1 to 255 characters.
               Changing this will create a new access rule. The value varies according to the scenario:
               - Set the VPC ID in VPC authorization scenarios.
               - Set this parameter in IP address authorization scenario.
               
               - For an NFS shared file system, the value in the format of *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
               
               - For a CIFS shared file system, the value in the format of *VPC_ID#IP_address#priority*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#0.
               
               > **NOTE:** If you want to create more access rules, please using sbercloud_sfs_access_rule.
        :param pulumi.Input[_builtins.str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone name. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Describes the shared file system.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the shared file system. Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the shared file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key and value pairs as a dictionary of strings.
               The supported metadata keys are "#sfs_crypt_key_id", "#sfs_crypt_domain_id" and "#sfs_crypt_alias",
               and the keys should be exist at the same time to enable the data encryption function.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the shared file system.
        :param pulumi.Input[_builtins.str] region: The region in which to create the sfs resource. If omitted, the provider-level region will be used. Changing this creates a new sfs resource.
        :param pulumi.Input[_builtins.str] share_proto: The protocol for sharing file systems. The default value is NFS.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the shared file system.
        """
        pulumi.set(__self__, "size", size)
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_to is not None:
            pulumi.set(__self__, "access_to", access_to)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_proto is not None:
            pulumi.set(__self__, "share_proto", share_proto)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        The size (GB) of the shared file system.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access level of the shared file system. Possible values are *ro* (read-only)
        and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the value that defines the access rule. The value contains 1 to 255 characters.
        Changing this will create a new access rule. The value varies according to the scenario:
        - Set the VPC ID in VPC authorization scenarios.
        - Set this parameter in IP address authorization scenario.

        - For an NFS shared file system, the value in the format of *VPC_ID#IP_address#priority#user_permission*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.

        - For a CIFS shared file system, the value in the format of *VPC_ID#IP_address#priority*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#0.

        > **NOTE:** If you want to create more access rules, please using sbercloud_sfs_access_rule.
        """
        return pulumi.get(self, "access_to")

    @access_to.setter
    def access_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_to", value)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the share access rule. The default value is *cert*.
        Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the shared file system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the shared file system. Changing this creates a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The level of visibility for the shared file system.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata key and value pairs as a dictionary of strings.
        The supported metadata keys are "#sfs_crypt_key_id", "#sfs_crypt_domain_id" and "#sfs_crypt_alias",
        and the keys should be exist at the same time to enable the data encryption function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the shared file system.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the sfs resource. If omitted, the provider-level region will be used. Changing this creates a new sfs resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol for sharing file systems. The default value is NFS.
        """
        return pulumi.get(self, "share_proto")

    @share_proto.setter
    def share_proto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_proto", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the shared file system.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FileSystemState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_rule_status: Optional[pulumi.Input[_builtins.str]] = None,
                 access_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemAccessRuleArgs']]]] = None,
                 access_to: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 export_location: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_access_id: Optional[pulumi.Input[_builtins.str]] = None,
                 share_proto: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FileSystem resources.
        :param pulumi.Input[_builtins.str] access_level: Specifies the access level of the shared file system. Possible values are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] access_rule_status: The status of the share access rule.
        :param pulumi.Input[Sequence[pulumi.Input['FileSystemAccessRuleArgs']]] access_rules: All access rules of the shared file system. The object includes the following:
        :param pulumi.Input[_builtins.str] access_to: Specifies the value that defines the access rule. The value contains 1 to 255 characters.
               Changing this will create a new access rule. The value varies according to the scenario:
               - Set the VPC ID in VPC authorization scenarios.
               - Set this parameter in IP address authorization scenario.
               
               - For an NFS shared file system, the value in the format of *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
               
               - For a CIFS shared file system, the value in the format of *VPC_ID#IP_address#priority*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#0.
               
               > **NOTE:** If you want to create more access rules, please using sbercloud_sfs_access_rule.
        :param pulumi.Input[_builtins.str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone name. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Describes the shared file system.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the shared file system. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] export_location: The address for accessing the shared file system.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the shared file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key and value pairs as a dictionary of strings.
               The supported metadata keys are "#sfs_crypt_key_id", "#sfs_crypt_domain_id" and "#sfs_crypt_alias",
               and the keys should be exist at the same time to enable the data encryption function.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the shared file system.
        :param pulumi.Input[_builtins.str] region: The region in which to create the sfs resource. If omitted, the provider-level region will be used. Changing this creates a new sfs resource.
        :param pulumi.Input[_builtins.str] share_access_id: The UUID of the share access rule.
        :param pulumi.Input[_builtins.str] share_proto: The protocol for sharing file systems. The default value is NFS.
        :param pulumi.Input[_builtins.int] size: The size (GB) of the shared file system.
        :param pulumi.Input[_builtins.str] status: The status of the share access rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the shared file system.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_rule_status is not None:
            pulumi.set(__self__, "access_rule_status", access_rule_status)
        if access_rules is not None:
            pulumi.set(__self__, "access_rules", access_rules)
        if access_to is not None:
            pulumi.set(__self__, "access_to", access_to)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if export_location is not None:
            pulumi.set(__self__, "export_location", export_location)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_access_id is not None:
            pulumi.set(__self__, "share_access_id", share_access_id)
        if share_proto is not None:
            pulumi.set(__self__, "share_proto", share_proto)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the access level of the shared file system. Possible values are *ro* (read-only)
        and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_level", value)

    @_builtins.property
    @pulumi.getter(name="accessRuleStatus")
    def access_rule_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the share access rule.
        """
        return pulumi.get(self, "access_rule_status")

    @access_rule_status.setter
    def access_rule_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_rule_status", value)

    @_builtins.property
    @pulumi.getter(name="accessRules")
    def access_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemAccessRuleArgs']]]]:
        """
        All access rules of the shared file system. The object includes the following:
        """
        return pulumi.get(self, "access_rules")

    @access_rules.setter
    def access_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileSystemAccessRuleArgs']]]]):
        pulumi.set(self, "access_rules", value)

    @_builtins.property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the value that defines the access rule. The value contains 1 to 255 characters.
        Changing this will create a new access rule. The value varies according to the scenario:
        - Set the VPC ID in VPC authorization scenarios.
        - Set this parameter in IP address authorization scenario.

        - For an NFS shared file system, the value in the format of *VPC_ID#IP_address#priority#user_permission*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.

        - For a CIFS shared file system, the value in the format of *VPC_ID#IP_address#priority*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#0.

        > **NOTE:** If you want to create more access rules, please using sbercloud_sfs_access_rule.
        """
        return pulumi.get(self, "access_to")

    @access_to.setter
    def access_to(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_to", value)

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of the share access rule. The default value is *cert*.
        Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_type")

    @access_type.setter
    def access_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_type", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Describes the shared file system.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the shared file system. Changing this creates a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="exportLocation")
    def export_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address for accessing the shared file system.
        """
        return pulumi.get(self, "export_location")

    @export_location.setter
    def export_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export_location", value)

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The level of visibility for the shared file system.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Metadata key and value pairs as a dictionary of strings.
        The supported metadata keys are "#sfs_crypt_key_id", "#sfs_crypt_domain_id" and "#sfs_crypt_alias",
        and the keys should be exist at the same time to enable the data encryption function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the shared file system.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the sfs resource. If omitted, the provider-level region will be used. Changing this creates a new sfs resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shareAccessId")
    def share_access_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the share access rule.
        """
        return pulumi.get(self, "share_access_id")

    @share_access_id.setter
    def share_access_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_access_id", value)

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol for sharing file systems. The default value is NFS.
        """
        return pulumi.get(self, "share_proto")

    @share_proto.setter
    def share_proto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_proto", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size (GB) of the shared file system.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the share access rule.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the shared file system.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("sbercloud:Sfs/fileSystem:FileSystem")
class FileSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_to: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_proto: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Shared File System (SFS) resource.

        ## Example Usage

        ### basic example

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        share_name = config.require_object("shareName")
        share_description = config.require_object("shareDescription")
        vpc_id = config.require_object("vpcId")
        share_file = sbercloud.sfs.FileSystem("share-file",
            name=share_name,
            size=100,
            share_proto="NFS",
            access_level="rw",
            access_to=vpc_id,
            description=share_description,
            tags={
                "key": "value",
            })
        ```

        ### sfs with data encryption

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        share_name = config.require_object("shareName")
        share_description = config.require_object("shareDescription")
        vpc_id = config.require_object("vpcId")
        mykey = sbercloud.dew.Key("mykey",
            key_alias="kms_sfs",
            pending_days="7")
        share_file = sbercloud.sfs.FileSystem("share-file",
            name=share_name,
            size=100,
            share_proto="NFS",
            access_level="rw",
            access_to=vpc_id,
            description=share_description,
            metadata={
                "#sfs_crypt_key_id": mykey.id,
                "#sfs_crypt_domain_id": mykey.domain_id,
                "#sfs_crypt_alias": mykey.key_alias,
            },
            tags={
                "function": "encryption",
            })
        ```

        ## Import

        SFS can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Sfs/fileSystem:FileSystem sbercloud_sfs_file_system 4779ab1c-7c1a-44b1-a02e-93dfc361b32d
        ```

        Please importing them by sbercloud_sfs_access_rule.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: Specifies the access level of the shared file system. Possible values are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] access_to: Specifies the value that defines the access rule. The value contains 1 to 255 characters.
               Changing this will create a new access rule. The value varies according to the scenario:
               - Set the VPC ID in VPC authorization scenarios.
               - Set this parameter in IP address authorization scenario.
               
               - For an NFS shared file system, the value in the format of *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
               
               - For a CIFS shared file system, the value in the format of *VPC_ID#IP_address#priority*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#0.
               
               > **NOTE:** If you want to create more access rules, please using sbercloud_sfs_access_rule.
        :param pulumi.Input[_builtins.str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone name. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Describes the shared file system.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the shared file system. Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the shared file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key and value pairs as a dictionary of strings.
               The supported metadata keys are "#sfs_crypt_key_id", "#sfs_crypt_domain_id" and "#sfs_crypt_alias",
               and the keys should be exist at the same time to enable the data encryption function.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the shared file system.
        :param pulumi.Input[_builtins.str] region: The region in which to create the sfs resource. If omitted, the provider-level region will be used. Changing this creates a new sfs resource.
        :param pulumi.Input[_builtins.str] share_proto: The protocol for sharing file systems. The default value is NFS.
        :param pulumi.Input[_builtins.int] size: The size (GB) of the shared file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the shared file system.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Shared File System (SFS) resource.

        ## Example Usage

        ### basic example

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        share_name = config.require_object("shareName")
        share_description = config.require_object("shareDescription")
        vpc_id = config.require_object("vpcId")
        share_file = sbercloud.sfs.FileSystem("share-file",
            name=share_name,
            size=100,
            share_proto="NFS",
            access_level="rw",
            access_to=vpc_id,
            description=share_description,
            tags={
                "key": "value",
            })
        ```

        ### sfs with data encryption

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        share_name = config.require_object("shareName")
        share_description = config.require_object("shareDescription")
        vpc_id = config.require_object("vpcId")
        mykey = sbercloud.dew.Key("mykey",
            key_alias="kms_sfs",
            pending_days="7")
        share_file = sbercloud.sfs.FileSystem("share-file",
            name=share_name,
            size=100,
            share_proto="NFS",
            access_level="rw",
            access_to=vpc_id,
            description=share_description,
            metadata={
                "#sfs_crypt_key_id": mykey.id,
                "#sfs_crypt_domain_id": mykey.domain_id,
                "#sfs_crypt_alias": mykey.key_alias,
            },
            tags={
                "function": "encryption",
            })
        ```

        ## Import

        SFS can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Sfs/fileSystem:FileSystem sbercloud_sfs_file_system 4779ab1c-7c1a-44b1-a02e-93dfc361b32d
        ```

        Please importing them by sbercloud_sfs_access_rule.

        :param str resource_name: The name of the resource.
        :param FileSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[_builtins.str]] = None,
                 access_to: Optional[pulumi.Input[_builtins.str]] = None,
                 access_type: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_proto: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileSystemArgs.__new__(FileSystemArgs)

            __props__.__dict__["access_level"] = access_level
            __props__.__dict__["access_to"] = access_to
            __props__.__dict__["access_type"] = access_type
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["is_public"] = is_public
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["share_proto"] = share_proto
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["access_rule_status"] = None
            __props__.__dict__["access_rules"] = None
            __props__.__dict__["export_location"] = None
            __props__.__dict__["share_access_id"] = None
            __props__.__dict__["status"] = None
        super(FileSystem, __self__).__init__(
            'sbercloud:Sfs/fileSystem:FileSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[_builtins.str]] = None,
            access_rule_status: Optional[pulumi.Input[_builtins.str]] = None,
            access_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FileSystemAccessRuleArgs', 'FileSystemAccessRuleArgsDict']]]]] = None,
            access_to: Optional[pulumi.Input[_builtins.str]] = None,
            access_type: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            export_location: Optional[pulumi.Input[_builtins.str]] = None,
            is_public: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            share_access_id: Optional[pulumi.Input[_builtins.str]] = None,
            share_proto: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'FileSystem':
        """
        Get an existing FileSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_level: Specifies the access level of the shared file system. Possible values are *ro* (read-only)
               and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] access_rule_status: The status of the share access rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FileSystemAccessRuleArgs', 'FileSystemAccessRuleArgsDict']]]] access_rules: All access rules of the shared file system. The object includes the following:
        :param pulumi.Input[_builtins.str] access_to: Specifies the value that defines the access rule. The value contains 1 to 255 characters.
               Changing this will create a new access rule. The value varies according to the scenario:
               - Set the VPC ID in VPC authorization scenarios.
               - Set this parameter in IP address authorization scenario.
               
               - For an NFS shared file system, the value in the format of *VPC_ID#IP_address#priority#user_permission*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.
               
               - For a CIFS shared file system, the value in the format of *VPC_ID#IP_address#priority*.
               For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#0.
               
               > **NOTE:** If you want to create more access rules, please using sbercloud_sfs_access_rule.
        :param pulumi.Input[_builtins.str] access_type: Specifies the type of the share access rule. The default value is *cert*.
               Changing this will create a new access rule.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone name. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Describes the shared file system.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the shared file system. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] export_location: The address for accessing the shared file system.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the shared file system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: Metadata key and value pairs as a dictionary of strings.
               The supported metadata keys are "#sfs_crypt_key_id", "#sfs_crypt_domain_id" and "#sfs_crypt_alias",
               and the keys should be exist at the same time to enable the data encryption function.
               Changing this will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the shared file system.
        :param pulumi.Input[_builtins.str] region: The region in which to create the sfs resource. If omitted, the provider-level region will be used. Changing this creates a new sfs resource.
        :param pulumi.Input[_builtins.str] share_access_id: The UUID of the share access rule.
        :param pulumi.Input[_builtins.str] share_proto: The protocol for sharing file systems. The default value is NFS.
        :param pulumi.Input[_builtins.int] size: The size (GB) of the shared file system.
        :param pulumi.Input[_builtins.str] status: The status of the share access rule.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the shared file system.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileSystemState.__new__(_FileSystemState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["access_rule_status"] = access_rule_status
        __props__.__dict__["access_rules"] = access_rules
        __props__.__dict__["access_to"] = access_to
        __props__.__dict__["access_type"] = access_type
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["export_location"] = export_location
        __props__.__dict__["is_public"] = is_public
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["share_access_id"] = share_access_id
        __props__.__dict__["share_proto"] = share_proto
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return FileSystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the access level of the shared file system. Possible values are *ro* (read-only)
        and *rw* (read-write). The default value is *rw* (read/write). Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="accessRuleStatus")
    def access_rule_status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the share access rule.
        """
        return pulumi.get(self, "access_rule_status")

    @_builtins.property
    @pulumi.getter(name="accessRules")
    def access_rules(self) -> pulumi.Output[Sequence['outputs.FileSystemAccessRule']]:
        """
        All access rules of the shared file system. The object includes the following:
        """
        return pulumi.get(self, "access_rules")

    @_builtins.property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the value that defines the access rule. The value contains 1 to 255 characters.
        Changing this will create a new access rule. The value varies according to the scenario:
        - Set the VPC ID in VPC authorization scenarios.
        - Set this parameter in IP address authorization scenario.

        - For an NFS shared file system, the value in the format of *VPC_ID#IP_address#priority#user_permission*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#100#all_squash,root_squash.

        - For a CIFS shared file system, the value in the format of *VPC_ID#IP_address#priority*.
        For example, 0157b53f-4974-4e80-91c9-098532bcaf00#2.2.2.2/16#0.

        > **NOTE:** If you want to create more access rules, please using sbercloud_sfs_access_rule.
        """
        return pulumi.get(self, "access_to")

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of the share access rule. The default value is *cert*.
        Changing this will create a new access rule.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The availability zone name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Describes the shared file system.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the shared file system. Changing this creates a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="exportLocation")
    def export_location(self) -> pulumi.Output[_builtins.str]:
        """
        The address for accessing the shared file system.
        """
        return pulumi.get(self, "export_location")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The level of visibility for the shared file system.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Metadata key and value pairs as a dictionary of strings.
        The supported metadata keys are "#sfs_crypt_key_id", "#sfs_crypt_domain_id" and "#sfs_crypt_alias",
        and the keys should be exist at the same time to enable the data encryption function.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the shared file system.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the sfs resource. If omitted, the provider-level region will be used. Changing this creates a new sfs resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shareAccessId")
    def share_access_id(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the share access rule.
        """
        return pulumi.get(self, "share_access_id")

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The protocol for sharing file systems. The default value is NFS.
        """
        return pulumi.get(self, "share_proto")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The size (GB) of the shared file system.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the share access rule.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the shared file system.
        """
        return pulumi.get(self, "tags")

