# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFileSystemResult',
    'AwaitableGetFileSystemResult',
    'get_file_system',
    'get_file_system_output',
]

@pulumi.output_type
class GetFileSystemResult:
    """
    A collection of values returned by getFileSystem.
    """
    def __init__(__self__, access_level=None, access_to=None, access_type=None, availability_zone=None, description=None, export_location=None, id=None, is_public=None, metadata=None, mount_id=None, name=None, preferred=None, region=None, share_access_id=None, share_instance_id=None, share_proto=None, size=None, state=None, status=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if access_to and not isinstance(access_to, str):
            raise TypeError("Expected argument 'access_to' to be a str")
        pulumi.set(__self__, "access_to", access_to)
        if access_type and not isinstance(access_type, str):
            raise TypeError("Expected argument 'access_type' to be a str")
        pulumi.set(__self__, "access_type", access_type)
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if export_location and not isinstance(export_location, str):
            raise TypeError("Expected argument 'export_location' to be a str")
        pulumi.set(__self__, "export_location", export_location)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_public and not isinstance(is_public, bool):
            raise TypeError("Expected argument 'is_public' to be a bool")
        pulumi.set(__self__, "is_public", is_public)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if mount_id and not isinstance(mount_id, str):
            raise TypeError("Expected argument 'mount_id' to be a str")
        pulumi.set(__self__, "mount_id", mount_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if preferred and not isinstance(preferred, bool):
            raise TypeError("Expected argument 'preferred' to be a bool")
        pulumi.set(__self__, "preferred", preferred)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if share_access_id and not isinstance(share_access_id, str):
            raise TypeError("Expected argument 'share_access_id' to be a str")
        pulumi.set(__self__, "share_access_id", share_access_id)
        if share_instance_id and not isinstance(share_instance_id, str):
            raise TypeError("Expected argument 'share_instance_id' to be a str")
        pulumi.set(__self__, "share_instance_id", share_instance_id)
        if share_proto and not isinstance(share_proto, str):
            raise TypeError("Expected argument 'share_proto' to be a str")
        pulumi.set(__self__, "share_proto", share_proto)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> _builtins.str:
        """
        The level of the access rule.
        """
        return pulumi.get(self, "access_level")

    @_builtins.property
    @pulumi.getter(name="accessTo")
    def access_to(self) -> _builtins.str:
        """
        The access that the back end grants or denies.
        """
        return pulumi.get(self, "access_to")

    @_builtins.property
    @pulumi.getter(name="accessType")
    def access_type(self) -> _builtins.str:
        """
        The type of the share access rule.
        """
        return pulumi.get(self, "access_type")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone name.
        *
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the shared file system.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="exportLocation")
    def export_location(self) -> _builtins.str:
        """
        The path for accessing the shared file system.
        """
        return pulumi.get(self, "export_location")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> _builtins.bool:
        """
        The level of visibility for the shared file system.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        Metadata key and value pairs as a dictionary of strings.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="mountId")
    def mount_id(self) -> _builtins.str:
        """
        The UUID of the mount location of the shared file system.
        """
        return pulumi.get(self, "mount_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def preferred(self) -> _builtins.bool:
        """
        Identifies which mount locations are most efficient and are used preferentially when multiple mount locations exist.
        """
        return pulumi.get(self, "preferred")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shareAccessId")
    def share_access_id(self) -> _builtins.str:
        """
        The UUID of the share access rule.
        """
        return pulumi.get(self, "share_access_id")

    @_builtins.property
    @pulumi.getter(name="shareInstanceId")
    def share_instance_id(self) -> _builtins.str:
        """
        The access that the back end grants or denies.
        """
        return pulumi.get(self, "share_instance_id")

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> _builtins.str:
        """
        The protocol for sharing file systems.
        """
        return pulumi.get(self, "share_proto")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The size (GB) of the shared file system.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the shared file system.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the shared file system.
        """
        return pulumi.get(self, "status")


class AwaitableGetFileSystemResult(GetFileSystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileSystemResult(
            access_level=self.access_level,
            access_to=self.access_to,
            access_type=self.access_type,
            availability_zone=self.availability_zone,
            description=self.description,
            export_location=self.export_location,
            id=self.id,
            is_public=self.is_public,
            metadata=self.metadata,
            mount_id=self.mount_id,
            name=self.name,
            preferred=self.preferred,
            region=self.region,
            share_access_id=self.share_access_id,
            share_instance_id=self.share_instance_id,
            share_proto=self.share_proto,
            size=self.size,
            state=self.state,
            status=self.status)


def get_file_system(id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    status: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileSystemResult:
    """
    Provides information about a Shared File System (SFS).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    share_name = config.require_object("shareName")
    share_id = config.require_object("shareId")
    shares = sbercloud.Sfs.get_file_system(name=share_name,
        id=share_id)
    ```


    :param _builtins.str id: The UUID of the shared file system.
    :param _builtins.str name: The name of the shared file system.
    :param _builtins.str region: Specifies the region in which to obtain the shared file system.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: The status of the shared file system.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Sfs/getFileSystem:getFileSystem', __args__, opts=opts, typ=GetFileSystemResult).value

    return AwaitableGetFileSystemResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        access_to=pulumi.get(__ret__, 'access_to'),
        access_type=pulumi.get(__ret__, 'access_type'),
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        description=pulumi.get(__ret__, 'description'),
        export_location=pulumi.get(__ret__, 'export_location'),
        id=pulumi.get(__ret__, 'id'),
        is_public=pulumi.get(__ret__, 'is_public'),
        metadata=pulumi.get(__ret__, 'metadata'),
        mount_id=pulumi.get(__ret__, 'mount_id'),
        name=pulumi.get(__ret__, 'name'),
        preferred=pulumi.get(__ret__, 'preferred'),
        region=pulumi.get(__ret__, 'region'),
        share_access_id=pulumi.get(__ret__, 'share_access_id'),
        share_instance_id=pulumi.get(__ret__, 'share_instance_id'),
        share_proto=pulumi.get(__ret__, 'share_proto'),
        size=pulumi.get(__ret__, 'size'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'))
def get_file_system_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFileSystemResult]:
    """
    Provides information about a Shared File System (SFS).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    share_name = config.require_object("shareName")
    share_id = config.require_object("shareId")
    shares = sbercloud.Sfs.get_file_system(name=share_name,
        id=share_id)
    ```


    :param _builtins.str id: The UUID of the shared file system.
    :param _builtins.str name: The name of the shared file system.
    :param _builtins.str region: Specifies the region in which to obtain the shared file system.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: The status of the shared file system.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Sfs/getFileSystem:getFileSystem', __args__, opts=opts, typ=GetFileSystemResult)
    return __ret__.apply(lambda __response__: GetFileSystemResult(
        access_level=pulumi.get(__response__, 'access_level'),
        access_to=pulumi.get(__response__, 'access_to'),
        access_type=pulumi.get(__response__, 'access_type'),
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        description=pulumi.get(__response__, 'description'),
        export_location=pulumi.get(__response__, 'export_location'),
        id=pulumi.get(__response__, 'id'),
        is_public=pulumi.get(__response__, 'is_public'),
        metadata=pulumi.get(__response__, 'metadata'),
        mount_id=pulumi.get(__response__, 'mount_id'),
        name=pulumi.get(__response__, 'name'),
        preferred=pulumi.get(__response__, 'preferred'),
        region=pulumi.get(__response__, 'region'),
        share_access_id=pulumi.get(__response__, 'share_access_id'),
        share_instance_id=pulumi.get(__response__, 'share_instance_id'),
        share_proto=pulumi.get(__response__, 'share_proto'),
        size=pulumi.get(__response__, 'size'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status')))
