# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTurbosResult',
    'AwaitableGetTurbosResult',
    'get_turbos',
    'get_turbos_output',
]

@pulumi.output_type
class GetTurbosResult:
    """
    A collection of values returned by getTurbos.
    """
    def __init__(__self__, enterprise_project_id=None, id=None, name=None, region=None, share_proto=None, share_type=None, size=None, turbos=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if share_proto and not isinstance(share_proto, str):
            raise TypeError("Expected argument 'share_proto' to be a str")
        pulumi.set(__self__, "share_proto", share_proto)
        if share_type and not isinstance(share_type, str):
            raise TypeError("Expected argument 'share_type' to be a str")
        pulumi.set(__self__, "share_type", share_type)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if turbos and not isinstance(turbos, list):
            raise TypeError("Expected argument 'turbos' to be a list")
        pulumi.set(__self__, "turbos", turbos)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project ID of the SFS turbo file system.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the SFS turbo file system.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> Optional[_builtins.str]:
        """
        The protocol of the SFS turbo file system.
        """
        return pulumi.get(self, "share_proto")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[_builtins.str]:
        """
        The type of the SFS turbo file system.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The capacity of the SFS turbo file system.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def turbos(self) -> Sequence['outputs.GetTurbosTurboResult']:
        """
        The list of the SFS turbo file systems. The object structure is documented below.
        """
        return pulumi.get(self, "turbos")


class AwaitableGetTurbosResult(GetTurbosResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTurbosResult(
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            share_proto=self.share_proto,
            share_type=self.share_type,
            size=self.size,
            turbos=self.turbos)


def get_turbos(enterprise_project_id: Optional[_builtins.str] = None,
               name: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               share_proto: Optional[_builtins.str] = None,
               share_type: Optional[_builtins.str] = None,
               size: Optional[_builtins.int] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTurbosResult:
    """
    Use this data source to get the list of the available SFS turbos.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    sfs_turbo_name = config.require_object("sfsTurboName")
    test = sbercloud.Sfs.get_turbos(name=sfs_turbo_name)
    ```


    :param _builtins.str enterprise_project_id: The enterprise project ID of the SFS turbo file system.
    :param _builtins.str name: Specifies the name of the SFS turbo file system.
    :param _builtins.str region: Specifies the region in which to obtain the SFS turbo file systems.
           If omitted, the provider-level region will be used.
    :param _builtins.str share_proto: Specifies the protocol of the SFS turbo file system. The valid value is **NFS**.
    :param _builtins.str share_type: Specifies the type of the SFS turbo file system.
           The valid values are **STANDARD** and **PERFORMANCE**.
    :param _builtins.int size: Specifies the capacity of the SFS turbo file system, in GB.
           The value ranges from `500` to `32,768`, and must be large than `10,240` for an enhanced file system.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['shareProto'] = share_proto
    __args__['shareType'] = share_type
    __args__['size'] = size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Sfs/getTurbos:getTurbos', __args__, opts=opts, typ=GetTurbosResult).value

    return AwaitableGetTurbosResult(
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        share_proto=pulumi.get(__ret__, 'share_proto'),
        share_type=pulumi.get(__ret__, 'share_type'),
        size=pulumi.get(__ret__, 'size'),
        turbos=pulumi.get(__ret__, 'turbos'))
def get_turbos_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      share_proto: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      share_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTurbosResult]:
    """
    Use this data source to get the list of the available SFS turbos.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    sfs_turbo_name = config.require_object("sfsTurboName")
    test = sbercloud.Sfs.get_turbos(name=sfs_turbo_name)
    ```


    :param _builtins.str enterprise_project_id: The enterprise project ID of the SFS turbo file system.
    :param _builtins.str name: Specifies the name of the SFS turbo file system.
    :param _builtins.str region: Specifies the region in which to obtain the SFS turbo file systems.
           If omitted, the provider-level region will be used.
    :param _builtins.str share_proto: Specifies the protocol of the SFS turbo file system. The valid value is **NFS**.
    :param _builtins.str share_type: Specifies the type of the SFS turbo file system.
           The valid values are **STANDARD** and **PERFORMANCE**.
    :param _builtins.int size: Specifies the capacity of the SFS turbo file system, in GB.
           The value ranges from `500` to `32,768`, and must be large than `10,240` for an enhanced file system.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['shareProto'] = share_proto
    __args__['shareType'] = share_type
    __args__['size'] = size
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Sfs/getTurbos:getTurbos', __args__, opts=opts, typ=GetTurbosResult)
    return __ret__.apply(lambda __response__: GetTurbosResult(
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        share_proto=pulumi.get(__response__, 'share_proto'),
        share_type=pulumi.get(__response__, 'share_type'),
        size=pulumi.get(__response__, 'size'),
        turbos=pulumi.get(__response__, 'turbos')))
