# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SfsTurboDirArgs', 'SfsTurboDir']

@pulumi.input_type
class SfsTurboDirArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 share_id: pulumi.Input[_builtins.str],
                 gid: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a SfsTurboDir resource.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of SFS Turbo directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        :param pulumi.Input[_builtins.int] gid: Specifies the group ID of the SFS Turbo directory.
        :param pulumi.Input[_builtins.int] mode: Specifies the SFS Turbo directory permissions.
        :param pulumi.Input[_builtins.int] uid: Specifies the user ID of the SFS Turbo directory.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "share_id", share_id)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the valid full path of SFS Turbo directory.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SFS Turbo ID.
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_id", value)

    @_builtins.property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the group ID of the SFS Turbo directory.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "gid", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the SFS Turbo directory permissions.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the user ID of the SFS Turbo directory.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class _SfsTurboDirState:
    def __init__(__self__, *,
                 gid: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SfsTurboDir resources.
        :param pulumi.Input[_builtins.int] gid: Specifies the group ID of the SFS Turbo directory.
        :param pulumi.Input[_builtins.int] mode: Specifies the SFS Turbo directory permissions.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of SFS Turbo directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        :param pulumi.Input[_builtins.int] uid: Specifies the user ID of the SFS Turbo directory.
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_id is not None:
            pulumi.set(__self__, "share_id", share_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the group ID of the SFS Turbo directory.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "gid", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the SFS Turbo directory permissions.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the valid full path of SFS Turbo directory.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SFS Turbo ID.
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_id", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the user ID of the SFS Turbo directory.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("sbercloud:index/sfsTurboDir:SfsTurboDir")
class SfsTurboDir(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gid: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Create a SfsTurboDir resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] gid: Specifies the group ID of the SFS Turbo directory.
        :param pulumi.Input[_builtins.int] mode: Specifies the SFS Turbo directory permissions.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of SFS Turbo directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        :param pulumi.Input[_builtins.int] uid: Specifies the user ID of the SFS Turbo directory.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SfsTurboDirArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SfsTurboDir resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SfsTurboDirArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SfsTurboDirArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gid: Optional[pulumi.Input[_builtins.int]] = None,
                 mode: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SfsTurboDirArgs.__new__(SfsTurboDirArgs)

            __props__.__dict__["gid"] = gid
            __props__.__dict__["mode"] = mode
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["region"] = region
            if share_id is None and not opts.urn:
                raise TypeError("Missing required property 'share_id'")
            __props__.__dict__["share_id"] = share_id
            __props__.__dict__["uid"] = uid
        super(SfsTurboDir, __self__).__init__(
            'sbercloud:index/sfsTurboDir:SfsTurboDir',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gid: Optional[pulumi.Input[_builtins.int]] = None,
            mode: Optional[pulumi.Input[_builtins.int]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            share_id: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.int]] = None) -> 'SfsTurboDir':
        """
        Get an existing SfsTurboDir resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] gid: Specifies the group ID of the SFS Turbo directory.
        :param pulumi.Input[_builtins.int] mode: Specifies the SFS Turbo directory permissions.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of SFS Turbo directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        :param pulumi.Input[_builtins.int] uid: Specifies the user ID of the SFS Turbo directory.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SfsTurboDirState.__new__(_SfsTurboDirState)

        __props__.__dict__["gid"] = gid
        __props__.__dict__["mode"] = mode
        __props__.__dict__["path"] = path
        __props__.__dict__["region"] = region
        __props__.__dict__["share_id"] = share_id
        __props__.__dict__["uid"] = uid
        return SfsTurboDir(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def gid(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the group ID of the SFS Turbo directory.
        """
        return pulumi.get(self, "gid")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the SFS Turbo directory permissions.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the valid full path of SFS Turbo directory.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SFS Turbo ID.
        """
        return pulumi.get(self, "share_id")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the user ID of the SFS Turbo directory.
        """
        return pulumi.get(self, "uid")

