# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SfsTurboDirQuotaArgs', 'SfsTurboDirQuota']

@pulumi.input_type
class SfsTurboDirQuotaArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[_builtins.str],
                 share_id: pulumi.Input[_builtins.str],
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 inode: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SfsTurboDirQuota resource.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of an existing directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        :param pulumi.Input[_builtins.int] capacity: Specifies the size of the directory.
        :param pulumi.Input[_builtins.int] inode: Specifies the maximum number of inodes allowed in the directory.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "share_id", share_id)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if inode is not None:
            pulumi.set(__self__, "inode", inode)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the valid full path of an existing directory.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SFS Turbo ID.
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_id", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the directory.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def inode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of inodes allowed in the directory.
        """
        return pulumi.get(self, "inode")

    @inode.setter
    def inode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "inode", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SfsTurboDirQuotaState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 inode: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 used_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 used_inode: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SfsTurboDirQuota resources.
        :param pulumi.Input[_builtins.int] capacity: Specifies the size of the directory.
        :param pulumi.Input[_builtins.int] inode: Specifies the maximum number of inodes allowed in the directory.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of an existing directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        :param pulumi.Input[_builtins.int] used_capacity: Specifies the size of the used directory.
        :param pulumi.Input[_builtins.int] used_inode: Specifies the number of used inodes in the directory.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if inode is not None:
            pulumi.set(__self__, "inode", inode)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_id is not None:
            pulumi.set(__self__, "share_id", share_id)
        if used_capacity is not None:
            pulumi.set(__self__, "used_capacity", used_capacity)
        if used_inode is not None:
            pulumi.set(__self__, "used_inode", used_inode)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the directory.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def inode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of inodes allowed in the directory.
        """
        return pulumi.get(self, "inode")

    @inode.setter
    def inode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "inode", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the valid full path of an existing directory.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SFS Turbo ID.
        """
        return pulumi.get(self, "share_id")

    @share_id.setter
    def share_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_id", value)

    @_builtins.property
    @pulumi.getter(name="usedCapacity")
    def used_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the used directory.
        """
        return pulumi.get(self, "used_capacity")

    @used_capacity.setter
    def used_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_capacity", value)

    @_builtins.property
    @pulumi.getter(name="usedInode")
    def used_inode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of used inodes in the directory.
        """
        return pulumi.get(self, "used_inode")

    @used_inode.setter
    def used_inode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_inode", value)


@pulumi.type_token("sbercloud:index/sfsTurboDirQuota:SfsTurboDirQuota")
class SfsTurboDirQuota(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 inode: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a SfsTurboDirQuota resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity: Specifies the size of the directory.
        :param pulumi.Input[_builtins.int] inode: Specifies the maximum number of inodes allowed in the directory.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of an existing directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SfsTurboDirQuotaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SfsTurboDirQuota resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SfsTurboDirQuotaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SfsTurboDirQuotaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 inode: Optional[pulumi.Input[_builtins.int]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SfsTurboDirQuotaArgs.__new__(SfsTurboDirQuotaArgs)

            __props__.__dict__["capacity"] = capacity
            __props__.__dict__["inode"] = inode
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["region"] = region
            if share_id is None and not opts.urn:
                raise TypeError("Missing required property 'share_id'")
            __props__.__dict__["share_id"] = share_id
            __props__.__dict__["used_capacity"] = None
            __props__.__dict__["used_inode"] = None
        super(SfsTurboDirQuota, __self__).__init__(
            'sbercloud:index/sfsTurboDirQuota:SfsTurboDirQuota',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[_builtins.int]] = None,
            inode: Optional[pulumi.Input[_builtins.int]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            share_id: Optional[pulumi.Input[_builtins.str]] = None,
            used_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            used_inode: Optional[pulumi.Input[_builtins.int]] = None) -> 'SfsTurboDirQuota':
        """
        Get an existing SfsTurboDirQuota resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] capacity: Specifies the size of the directory.
        :param pulumi.Input[_builtins.int] inode: Specifies the maximum number of inodes allowed in the directory.
        :param pulumi.Input[_builtins.str] path: Specifies the valid full path of an existing directory.
        :param pulumi.Input[_builtins.str] share_id: Specifies the SFS Turbo ID.
        :param pulumi.Input[_builtins.int] used_capacity: Specifies the size of the used directory.
        :param pulumi.Input[_builtins.int] used_inode: Specifies the number of used inodes in the directory.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SfsTurboDirQuotaState.__new__(_SfsTurboDirQuotaState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["inode"] = inode
        __props__.__dict__["path"] = path
        __props__.__dict__["region"] = region
        __props__.__dict__["share_id"] = share_id
        __props__.__dict__["used_capacity"] = used_capacity
        __props__.__dict__["used_inode"] = used_inode
        return SfsTurboDirQuota(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the size of the directory.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def inode(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum number of inodes allowed in the directory.
        """
        return pulumi.get(self, "inode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the valid full path of an existing directory.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shareId")
    def share_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SFS Turbo ID.
        """
        return pulumi.get(self, "share_id")

    @_builtins.property
    @pulumi.getter(name="usedCapacity")
    def used_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the size of the used directory.
        """
        return pulumi.get(self, "used_capacity")

    @_builtins.property
    @pulumi.getter(name="usedInode")
    def used_inode(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of used inodes in the directory.
        """
        return pulumi.get(self, "used_inode")

