# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 url_domains: Optional[pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the group belongs.
        :param pulumi.Input[_builtins.str] description: The group description.
        :param pulumi.Input[_builtins.bool] domain_access_enabled: Specifies whether to use the debugging domain name to access the APIs within the group.
        :param pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]] environments: The array of one or more environments of the associated group.
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to delete all sub-resources (for API) from this group.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.  
               If omitted, the provider-level region will be used. Changing this creates a new gateway group resource.
        :param pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]] url_domains: The associated domain information of the group.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_access_enabled is not None:
            pulumi.set(__self__, "domain_access_enabled", domain_access_enabled)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if url_domains is not None:
            pulumi.set(__self__, "url_domains", url_domains)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the group belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainAccessEnabled")
    def domain_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the debugging domain name to access the APIs within the group.
        """
        return pulumi.get(self, "domain_access_enabled")

    @domain_access_enabled.setter
    def domain_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "domain_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]:
        """
        The array of one or more environments of the associated group.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete all sub-resources (for API) from this group.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the dedicated instance is located.  
        If omitted, the provider-level region will be used. Changing this creates a new gateway group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="urlDomains")
    def url_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]]]:
        """
        The associated domain information of the group.
        """
        return pulumi.get(self, "url_domains")

    @url_domains.setter
    def url_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]]]):
        pulumi.set(self, "url_domains", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 registration_time: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 url_domains: Optional[pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the group, in RFC3339 format.
        :param pulumi.Input[_builtins.str] description: The group description.
        :param pulumi.Input[_builtins.bool] domain_access_enabled: Specifies whether to use the debugging domain name to access the APIs within the group.
        :param pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]] environments: The array of one or more environments of the associated group.
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to delete all sub-resources (for API) from this group.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the group belongs.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.  
               If omitted, the provider-level region will be used. Changing this creates a new gateway group resource.
        :param pulumi.Input[_builtins.str] registration_time: The registration time.
        :param pulumi.Input[_builtins.str] update_time: The latest update time of the group.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the group, in RFC3339 format.
        :param pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]] url_domains: The associated domain information of the group.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_access_enabled is not None:
            pulumi.set(__self__, "domain_access_enabled", domain_access_enabled)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registration_time is not None:
            pulumi.set(__self__, "registration_time", registration_time)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if url_domains is not None:
            pulumi.set(__self__, "url_domains", url_domains)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the group, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="domainAccessEnabled")
    def domain_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to use the debugging domain name to access the APIs within the group.
        """
        return pulumi.get(self, "domain_access_enabled")

    @domain_access_enabled.setter
    def domain_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "domain_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]:
        """
        The array of one or more environments of the associated group.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to delete all sub-resources (for API) from this group.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the group belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the dedicated instance is located.  
        If omitted, the provider-level region will be used. Changing this creates a new gateway group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registrationTime")
    def registration_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registration time.
        """
        return pulumi.get(self, "registration_time")

    @registration_time.setter
    def registration_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registration_time", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the group.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the group, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="urlDomains")
    def url_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]]]:
        """
        The associated domain information of the group.
        """
        return pulumi.get(self, "url_domains")

    @url_domains.setter
    def url_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupUrlDomainArgs']]]]):
        pulumi.set(self, "url_domains", value)


@pulumi.type_token("sbercloud:SharedApig/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupEnvironmentArgs', 'GroupEnvironmentArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 url_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupUrlDomainArgs', 'GroupUrlDomainArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides an API gateway group resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The group description.
        :param pulumi.Input[_builtins.bool] domain_access_enabled: Specifies whether to use the debugging domain name to access the APIs within the group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupEnvironmentArgs', 'GroupEnvironmentArgsDict']]]] environments: The array of one or more environments of the associated group.
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to delete all sub-resources (for API) from this group.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the group belongs.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.  
               If omitted, the provider-level region will be used. Changing this creates a new gateway group resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupUrlDomainArgs', 'GroupUrlDomainArgsDict']]]] url_domains: The associated domain information of the group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an API gateway group resource.

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupEnvironmentArgs', 'GroupEnvironmentArgsDict']]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 url_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupUrlDomainArgs', 'GroupUrlDomainArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["domain_access_enabled"] = domain_access_enabled
            __props__.__dict__["environments"] = environments
            __props__.__dict__["force_destroy"] = force_destroy
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["url_domains"] = url_domains
            __props__.__dict__["created_at"] = None
            __props__.__dict__["registration_time"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["updated_at"] = None
        super(Group, __self__).__init__(
            'sbercloud:SharedApig/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domain_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            environments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupEnvironmentArgs', 'GroupEnvironmentArgsDict']]]]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            registration_time: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            url_domains: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupUrlDomainArgs', 'GroupUrlDomainArgsDict']]]]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the group, in RFC3339 format.
        :param pulumi.Input[_builtins.str] description: The group description.
        :param pulumi.Input[_builtins.bool] domain_access_enabled: Specifies whether to use the debugging domain name to access the APIs within the group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupEnvironmentArgs', 'GroupEnvironmentArgsDict']]]] environments: The array of one or more environments of the associated group.
        :param pulumi.Input[_builtins.bool] force_destroy: Whether to delete all sub-resources (for API) from this group.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the group belongs.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[_builtins.str] region: The region where the dedicated instance is located.  
               If omitted, the provider-level region will be used. Changing this creates a new gateway group resource.
        :param pulumi.Input[_builtins.str] registration_time: The registration time.
        :param pulumi.Input[_builtins.str] update_time: The latest update time of the group.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the group, in RFC3339 format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupUrlDomainArgs', 'GroupUrlDomainArgsDict']]]] url_domains: The associated domain information of the group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_access_enabled"] = domain_access_enabled
        __props__.__dict__["environments"] = environments
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["registration_time"] = registration_time
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["url_domains"] = url_domains
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the group, in RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The group description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainAccessEnabled")
    def domain_access_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to use the debugging domain name to access the APIs within the group.
        """
        return pulumi.get(self, "domain_access_enabled")

    @_builtins.property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Sequence['outputs.GroupEnvironment']]:
        """
        The array of one or more environments of the associated group.
        """
        return pulumi.get(self, "environments")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to delete all sub-resources (for API) from this group.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the group belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the dedicated instance is located.  
        If omitted, the provider-level region will be used. Changing this creates a new gateway group resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registrationTime")
    def registration_time(self) -> pulumi.Output[_builtins.str]:
        """
        The registration time.
        """
        return pulumi.get(self, "registration_time")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the group.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the group, in RFC3339 format.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="urlDomains")
    def url_domains(self) -> pulumi.Output[Sequence['outputs.GroupUrlDomain']]:
        """
        The associated domain information of the group.
        """
        return pulumi.get(self, "url_domains")

