# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApiBackendParam',
    'ApiFuncGraph',
    'ApiFuncGraphPolicy',
    'ApiFuncGraphPolicyBackendParam',
    'ApiFuncGraphPolicyCondition',
    'ApiMock',
    'ApiMockPolicy',
    'ApiMockPolicyBackendParam',
    'ApiMockPolicyCondition',
    'ApiRequestParam',
    'ApiWeb',
    'ApiWebPolicy',
    'ApiWebPolicyBackendParam',
    'ApiWebPolicyCondition',
    'GroupEnvironment',
    'GroupEnvironmentVariable',
    'GroupUrlDomain',
]

@pulumi.output_type
class ApiBackendParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemParamType":
            suggest = "system_param_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiBackendParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiBackendParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiBackendParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 system_param_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str location: Where the parameter is located.
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str type: The parameter type.
        :param _builtins.str value: The value of the parameter
        :param _builtins.str description: Specifies the description of the API. The description cannot exceed 255 characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if system_param_type is not None:
            pulumi.set(__self__, "system_param_type", system_param_type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Where the parameter is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The parameter type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="systemParamType")
    def system_param_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "system_param_type")


@pulumi.output_type
class ApiFuncGraph(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionUrn":
            suggest = "function_urn"
        elif key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "functionAliasUrn":
            suggest = "function_alias_urn"
        elif key == "invocationType":
            suggest = "invocation_type"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "requestProtocol":
            suggest = "request_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFuncGraph. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFuncGraph.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFuncGraph.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_urn: _builtins.str,
                 authorizer_id: Optional[_builtins.str] = None,
                 function_alias_urn: Optional[_builtins.str] = None,
                 invocation_type: Optional[_builtins.str] = None,
                 network_type: Optional[_builtins.str] = None,
                 request_protocol: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str function_urn: The URN of the FunctionGraph function.
        :param _builtins.str authorizer_id: The ID of the backend custom authorization.
        :param _builtins.str function_alias_urn: The alias URN of the FunctionGraph function.
        :param _builtins.str invocation_type: The invocation type.
        :param _builtins.str network_type: The network architecture (framework) type of the FunctionGraph function.
        :param _builtins.str request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param _builtins.int timeout: The timeout for API requests to backend service.
        :param _builtins.str version: Specifies the version of the API. A maximum of 16 characters are allowed.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if function_alias_urn is not None:
            pulumi.set(__self__, "function_alias_urn", function_alias_urn)
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> _builtins.str:
        """
        The URN of the FunctionGraph function.
        """
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @_builtins.property
    @pulumi.getter(name="functionAliasUrn")
    def function_alias_urn(self) -> Optional[_builtins.str]:
        """
        The alias URN of the FunctionGraph function.
        """
        return pulumi.get(self, "function_alias_urn")

    @_builtins.property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional[_builtins.str]:
        """
        The invocation type.
        """
        return pulumi.get(self, "invocation_type")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        The network architecture (framework) type of the FunctionGraph function.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[_builtins.str]:
        """
        Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
        which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        """
        return pulumi.get(self, "request_protocol")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        The timeout for API requests to backend service.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Specifies the version of the API. A maximum of 16 characters are allowed.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ApiFuncGraphPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionUrn":
            suggest = "function_urn"
        elif key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendParams":
            suggest = "backend_params"
        elif key == "effectiveMode":
            suggest = "effective_mode"
        elif key == "functionAliasUrn":
            suggest = "function_alias_urn"
        elif key == "invocationMode":
            suggest = "invocation_mode"
        elif key == "invocationType":
            suggest = "invocation_type"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "requestProtocol":
            suggest = "request_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFuncGraphPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFuncGraphPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFuncGraphPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.ApiFuncGraphPolicyCondition'],
                 function_urn: _builtins.str,
                 name: _builtins.str,
                 authorizer_id: Optional[_builtins.str] = None,
                 backend_params: Optional[Sequence['outputs.ApiFuncGraphPolicyBackendParam']] = None,
                 effective_mode: Optional[_builtins.str] = None,
                 function_alias_urn: Optional[_builtins.str] = None,
                 invocation_mode: Optional[_builtins.str] = None,
                 invocation_type: Optional[_builtins.str] = None,
                 network_type: Optional[_builtins.str] = None,
                 request_protocol: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param Sequence['ApiFuncGraphPolicyConditionArgs'] conditions: The policy conditions.
        :param _builtins.str function_urn: The URN of the FunctionGraph function.
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str authorizer_id: The ID of the backend custom authorization.
        :param Sequence['ApiFuncGraphPolicyBackendParamArgs'] backend_params: The configaiton list of the backend parameters.
        :param _builtins.str effective_mode: The effective mode of the backend policy.
        :param _builtins.str function_alias_urn: The alias URN of the FunctionGraph function.
        :param _builtins.str invocation_mode: The invocation mode of the FunctionGraph function.
        :param _builtins.str invocation_type: The invocation mode of the FunctionGraph function.
        :param _builtins.str network_type: The network (framework) type of the FunctionGraph function.
        :param _builtins.str request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param _builtins.int timeout: The timeout for API requests to backend service.
        :param _builtins.str version: Specifies the version of the API. A maximum of 16 characters are allowed.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "name", name)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if function_alias_urn is not None:
            pulumi.set(__self__, "function_alias_urn", function_alias_urn)
        if invocation_mode is not None:
            pulumi.set(__self__, "invocation_mode", invocation_mode)
        if invocation_type is not None:
            pulumi.set(__self__, "invocation_type", invocation_type)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ApiFuncGraphPolicyCondition']:
        """
        The policy conditions.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> _builtins.str:
        """
        The URN of the FunctionGraph function.
        """
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @_builtins.property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[Sequence['outputs.ApiFuncGraphPolicyBackendParam']]:
        """
        The configaiton list of the backend parameters.
        """
        return pulumi.get(self, "backend_params")

    @_builtins.property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[_builtins.str]:
        """
        The effective mode of the backend policy.
        """
        return pulumi.get(self, "effective_mode")

    @_builtins.property
    @pulumi.getter(name="functionAliasUrn")
    def function_alias_urn(self) -> Optional[_builtins.str]:
        """
        The alias URN of the FunctionGraph function.
        """
        return pulumi.get(self, "function_alias_urn")

    @_builtins.property
    @pulumi.getter(name="invocationMode")
    def invocation_mode(self) -> Optional[_builtins.str]:
        """
        The invocation mode of the FunctionGraph function.
        """
        return pulumi.get(self, "invocation_mode")

    @_builtins.property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> Optional[_builtins.str]:
        """
        The invocation mode of the FunctionGraph function.
        """
        return pulumi.get(self, "invocation_type")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[_builtins.str]:
        """
        The network (framework) type of the FunctionGraph function.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[_builtins.str]:
        """
        Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
        which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        """
        return pulumi.get(self, "request_protocol")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        The timeout for API requests to backend service.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Specifies the version of the API. A maximum of 16 characters are allowed.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ApiFuncGraphPolicyBackendParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemParamType":
            suggest = "system_param_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFuncGraphPolicyBackendParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFuncGraphPolicyBackendParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFuncGraphPolicyBackendParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 system_param_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str location: Where the parameter is located.
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str type: The parameter type.
        :param _builtins.str value: The value of the parameter
        :param _builtins.str description: Specifies the description of the API. The description cannot exceed 255 characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if system_param_type is not None:
            pulumi.set(__self__, "system_param_type", system_param_type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Where the parameter is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The parameter type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="systemParamType")
    def system_param_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "system_param_type")


@pulumi.output_type
class ApiFuncGraphPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"
        elif key == "frontendAuthorizerName":
            suggest = "frontend_authorizer_name"
        elif key == "mappedParamLocation":
            suggest = "mapped_param_location"
        elif key == "mappedParamName":
            suggest = "mapped_param_name"
        elif key == "paramName":
            suggest = "param_name"
        elif key == "sysName":
            suggest = "sys_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFuncGraphPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFuncGraphPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFuncGraphPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: _builtins.str,
                 cookie_name: Optional[_builtins.str] = None,
                 frontend_authorizer_name: Optional[_builtins.str] = None,
                 mapped_param_location: Optional[_builtins.str] = None,
                 mapped_param_name: Optional[_builtins.str] = None,
                 param_name: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None,
                 sys_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: The value of the backend policy.
        :param _builtins.str cookie_name: The cookie parameter name.
        :param _builtins.str frontend_authorizer_name: The frontend authentication parameter name.
        :param _builtins.str mapped_param_location: The location of a parameter generated after orchestration.
        :param _builtins.str mapped_param_name: The name of a parameter generated after orchestration.
        :param _builtins.str param_name: The request parameter name.
        :param _builtins.str source: The type of the backend policy.
        :param _builtins.str sys_name: The gateway built-in parameter name.
        :param _builtins.str type: The condition type.
        """
        pulumi.set(__self__, "value", value)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if frontend_authorizer_name is not None:
            pulumi.set(__self__, "frontend_authorizer_name", frontend_authorizer_name)
        if mapped_param_location is not None:
            pulumi.set(__self__, "mapped_param_location", mapped_param_location)
        if mapped_param_name is not None:
            pulumi.set(__self__, "mapped_param_name", mapped_param_name)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sys_name is not None:
            pulumi.set(__self__, "sys_name", sys_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the backend policy.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        The cookie parameter name.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="frontendAuthorizerName")
    def frontend_authorizer_name(self) -> Optional[_builtins.str]:
        """
        The frontend authentication parameter name.
        """
        return pulumi.get(self, "frontend_authorizer_name")

    @_builtins.property
    @pulumi.getter(name="mappedParamLocation")
    def mapped_param_location(self) -> Optional[_builtins.str]:
        """
        The location of a parameter generated after orchestration.
        """
        return pulumi.get(self, "mapped_param_location")

    @_builtins.property
    @pulumi.getter(name="mappedParamName")
    def mapped_param_name(self) -> Optional[_builtins.str]:
        """
        The name of a parameter generated after orchestration.
        """
        return pulumi.get(self, "mapped_param_name")

    @_builtins.property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[_builtins.str]:
        """
        The request parameter name.
        """
        return pulumi.get(self, "param_name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        The type of the backend policy.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sysName")
    def sys_name(self) -> Optional[_builtins.str]:
        """
        The gateway built-in parameter name.
        """
        return pulumi.get(self, "sys_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The condition type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiMock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_id: Optional[_builtins.str] = None,
                 response: Optional[_builtins.str] = None,
                 status_code: Optional[_builtins.int] = None):
        """
        :param _builtins.str authorizer_id: The ID of the backend custom authorization.
        :param _builtins.str response: The response content of the mock.
        :param _builtins.int status_code: The custom status code of the mock response.
        """
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional[_builtins.str]:
        """
        The response content of the mock.
        """
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[_builtins.int]:
        """
        The custom status code of the mock response.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ApiMockPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendParams":
            suggest = "backend_params"
        elif key == "effectiveMode":
            suggest = "effective_mode"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.ApiMockPolicyCondition'],
                 name: _builtins.str,
                 authorizer_id: Optional[_builtins.str] = None,
                 backend_params: Optional[Sequence['outputs.ApiMockPolicyBackendParam']] = None,
                 effective_mode: Optional[_builtins.str] = None,
                 response: Optional[_builtins.str] = None,
                 status_code: Optional[_builtins.int] = None):
        """
        :param Sequence['ApiMockPolicyConditionArgs'] conditions: The policy conditions.
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str authorizer_id: The ID of the backend custom authorization.
        :param Sequence['ApiMockPolicyBackendParamArgs'] backend_params: The configuration list of backend parameters.
        :param _builtins.str effective_mode: The effective mode of the backend policy.
        :param _builtins.str response: The response content of the mock.
        :param _builtins.int status_code: The custom status code of the mock response.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "name", name)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ApiMockPolicyCondition']:
        """
        The policy conditions.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @_builtins.property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[Sequence['outputs.ApiMockPolicyBackendParam']]:
        """
        The configuration list of backend parameters.
        """
        return pulumi.get(self, "backend_params")

    @_builtins.property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[_builtins.str]:
        """
        The effective mode of the backend policy.
        """
        return pulumi.get(self, "effective_mode")

    @_builtins.property
    @pulumi.getter
    def response(self) -> Optional[_builtins.str]:
        """
        The response content of the mock.
        """
        return pulumi.get(self, "response")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[_builtins.int]:
        """
        The custom status code of the mock response.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ApiMockPolicyBackendParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemParamType":
            suggest = "system_param_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockPolicyBackendParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockPolicyBackendParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockPolicyBackendParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 system_param_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str location: Where the parameter is located.
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str type: The parameter type.
        :param _builtins.str value: The value of the parameter
        :param _builtins.str description: Specifies the description of the API. The description cannot exceed 255 characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if system_param_type is not None:
            pulumi.set(__self__, "system_param_type", system_param_type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Where the parameter is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The parameter type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="systemParamType")
    def system_param_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "system_param_type")


@pulumi.output_type
class ApiMockPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"
        elif key == "frontendAuthorizerName":
            suggest = "frontend_authorizer_name"
        elif key == "mappedParamLocation":
            suggest = "mapped_param_location"
        elif key == "mappedParamName":
            suggest = "mapped_param_name"
        elif key == "paramName":
            suggest = "param_name"
        elif key == "sysName":
            suggest = "sys_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: _builtins.str,
                 cookie_name: Optional[_builtins.str] = None,
                 frontend_authorizer_name: Optional[_builtins.str] = None,
                 mapped_param_location: Optional[_builtins.str] = None,
                 mapped_param_name: Optional[_builtins.str] = None,
                 param_name: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None,
                 sys_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: The value of the backend policy.
        :param _builtins.str cookie_name: The cookie parameter name.
        :param _builtins.str frontend_authorizer_name: The frontend authentication parameter name.
        :param _builtins.str mapped_param_location: The location of a parameter generated after orchestration.
        :param _builtins.str mapped_param_name: The name of a parameter generated after orchestration.
        :param _builtins.str param_name: The request parameter name.
        :param _builtins.str source: The type of the backend policy.
        :param _builtins.str sys_name: The gateway built-in parameter name.
        :param _builtins.str type: The condition type.
        """
        pulumi.set(__self__, "value", value)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if frontend_authorizer_name is not None:
            pulumi.set(__self__, "frontend_authorizer_name", frontend_authorizer_name)
        if mapped_param_location is not None:
            pulumi.set(__self__, "mapped_param_location", mapped_param_location)
        if mapped_param_name is not None:
            pulumi.set(__self__, "mapped_param_name", mapped_param_name)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sys_name is not None:
            pulumi.set(__self__, "sys_name", sys_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the backend policy.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        The cookie parameter name.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="frontendAuthorizerName")
    def frontend_authorizer_name(self) -> Optional[_builtins.str]:
        """
        The frontend authentication parameter name.
        """
        return pulumi.get(self, "frontend_authorizer_name")

    @_builtins.property
    @pulumi.getter(name="mappedParamLocation")
    def mapped_param_location(self) -> Optional[_builtins.str]:
        """
        The location of a parameter generated after orchestration.
        """
        return pulumi.get(self, "mapped_param_location")

    @_builtins.property
    @pulumi.getter(name="mappedParamName")
    def mapped_param_name(self) -> Optional[_builtins.str]:
        """
        The name of a parameter generated after orchestration.
        """
        return pulumi.get(self, "mapped_param_name")

    @_builtins.property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[_builtins.str]:
        """
        The request parameter name.
        """
        return pulumi.get(self, "param_name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        The type of the backend policy.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sysName")
    def sys_name(self) -> Optional[_builtins.str]:
        """
        The gateway built-in parameter name.
        """
        return pulumi.get(self, "sys_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The condition type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiRequestParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "validEnable":
            suggest = "valid_enable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiRequestParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiRequestParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiRequestParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 default: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 enumeration: Optional[_builtins.str] = None,
                 example: Optional[_builtins.str] = None,
                 location: Optional[_builtins.str] = None,
                 maximum: Optional[_builtins.int] = None,
                 minimum: Optional[_builtins.int] = None,
                 orchestrations: Optional[Sequence[_builtins.str]] = None,
                 passthrough: Optional[_builtins.bool] = None,
                 required: Optional[_builtins.bool] = None,
                 type: Optional[_builtins.str] = None,
                 valid_enable: Optional[_builtins.int] = None):
        """
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str default: The default value of the parameter.
        :param _builtins.str description: Specifies the description of the API. The description cannot exceed 255 characters.
        :param _builtins.str enumeration: The enumerated value.
        :param _builtins.str example: The parameter example.
        :param _builtins.str location: Where this parameter is located.
        :param _builtins.int maximum: The maximum value or length (string parameter) for parameter.
        :param _builtins.int minimum: The minimum value or length (string parameter) for parameter.
        :param Sequence[_builtins.str] orchestrations: The list of orchestration rules that parameter used.
        :param _builtins.bool passthrough: Whether to transparently transfer the parameter.
        :param _builtins.bool required: Whether this parameter is required.
        :param _builtins.str type: The parameter type.
        :param _builtins.int valid_enable: Whether to enable the parameter validation.
        """
        pulumi.set(__self__, "name", name)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enumeration is not None:
            pulumi.set(__self__, "enumeration", enumeration)
        if example is not None:
            pulumi.set(__self__, "example", example)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)
        if orchestrations is not None:
            pulumi.set(__self__, "orchestrations", orchestrations)
        if passthrough is not None:
            pulumi.set(__self__, "passthrough", passthrough)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if valid_enable is not None:
            pulumi.set(__self__, "valid_enable", valid_enable)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def default(self) -> Optional[_builtins.str]:
        """
        The default value of the parameter.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enumeration(self) -> Optional[_builtins.str]:
        """
        The enumerated value.
        """
        return pulumi.get(self, "enumeration")

    @_builtins.property
    @pulumi.getter
    def example(self) -> Optional[_builtins.str]:
        """
        The parameter example.
        """
        return pulumi.get(self, "example")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        Where this parameter is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def maximum(self) -> Optional[_builtins.int]:
        """
        The maximum value or length (string parameter) for parameter.
        """
        return pulumi.get(self, "maximum")

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> Optional[_builtins.int]:
        """
        The minimum value or length (string parameter) for parameter.
        """
        return pulumi.get(self, "minimum")

    @_builtins.property
    @pulumi.getter
    def orchestrations(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of orchestration rules that parameter used.
        """
        return pulumi.get(self, "orchestrations")

    @_builtins.property
    @pulumi.getter
    def passthrough(self) -> Optional[_builtins.bool]:
        """
        Whether to transparently transfer the parameter.
        """
        return pulumi.get(self, "passthrough")

    @_builtins.property
    @pulumi.getter
    def required(self) -> Optional[_builtins.bool]:
        """
        Whether this parameter is required.
        """
        return pulumi.get(self, "required")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The parameter type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validEnable")
    def valid_enable(self) -> Optional[_builtins.int]:
        """
        Whether to enable the parameter validation.
        """
        return pulumi.get(self, "valid_enable")


@pulumi.output_type
class ApiWeb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendAddress":
            suggest = "backend_address"
        elif key == "hostHeader":
            suggest = "host_header"
        elif key == "requestMethod":
            suggest = "request_method"
        elif key == "requestProtocol":
            suggest = "request_protocol"
        elif key == "retryCount":
            suggest = "retry_count"
        elif key == "sslEnable":
            suggest = "ssl_enable"
        elif key == "vpcChannelId":
            suggest = "vpc_channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiWeb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiWeb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiWeb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 authorizer_id: Optional[_builtins.str] = None,
                 backend_address: Optional[_builtins.str] = None,
                 host_header: Optional[_builtins.str] = None,
                 request_method: Optional[_builtins.str] = None,
                 request_protocol: Optional[_builtins.str] = None,
                 retry_count: Optional[_builtins.int] = None,
                 ssl_enable: Optional[_builtins.bool] = None,
                 timeout: Optional[_builtins.int] = None,
                 vpc_channel_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: The backend request path.
        :param _builtins.str authorizer_id: The ID of the backend custom authorization.
        :param _builtins.str backend_address: The backend service address, which consists of a domain name or IP address, and a port number.
        :param _builtins.str host_header: The proxy host header.
        :param _builtins.str request_method: Specifies the request method, including 'GET','POST','PUT' and etc..
        :param _builtins.str request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param _builtins.int retry_count: The number of retry attempts to request the backend service.
        :param _builtins.bool ssl_enable: Whether to enable two-way authentication.
        :param _builtins.int timeout: The timeout for API requests to backend service.
        :param _builtins.str vpc_channel_id: The VPC channel ID.
        """
        pulumi.set(__self__, "path", path)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_address is not None:
            pulumi.set(__self__, "backend_address", backend_address)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if retry_count is not None:
            pulumi.set(__self__, "retry_count", retry_count)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_channel_id is not None:
            pulumi.set(__self__, "vpc_channel_id", vpc_channel_id)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The backend request path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @_builtins.property
    @pulumi.getter(name="backendAddress")
    def backend_address(self) -> Optional[_builtins.str]:
        """
        The backend service address, which consists of a domain name or IP address, and a port number.
        """
        return pulumi.get(self, "backend_address")

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[_builtins.str]:
        """
        The proxy host header.
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[_builtins.str]:
        """
        Specifies the request method, including 'GET','POST','PUT' and etc..
        """
        return pulumi.get(self, "request_method")

    @_builtins.property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[_builtins.str]:
        """
        Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
        which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        """
        return pulumi.get(self, "request_protocol")

    @_builtins.property
    @pulumi.getter(name="retryCount")
    def retry_count(self) -> Optional[_builtins.int]:
        """
        The number of retry attempts to request the backend service.
        """
        return pulumi.get(self, "retry_count")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[_builtins.bool]:
        """
        Whether to enable two-way authentication.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        The timeout for API requests to backend service.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="vpcChannelId")
    def vpc_channel_id(self) -> Optional[_builtins.str]:
        """
        The VPC channel ID.
        """
        return pulumi.get(self, "vpc_channel_id")


@pulumi.output_type
class ApiWebPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestMethod":
            suggest = "request_method"
        elif key == "authorizerId":
            suggest = "authorizer_id"
        elif key == "backendAddress":
            suggest = "backend_address"
        elif key == "backendParams":
            suggest = "backend_params"
        elif key == "effectiveMode":
            suggest = "effective_mode"
        elif key == "hostHeader":
            suggest = "host_header"
        elif key == "requestProtocol":
            suggest = "request_protocol"
        elif key == "retryCount":
            suggest = "retry_count"
        elif key == "vpcChannelId":
            suggest = "vpc_channel_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiWebPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiWebPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiWebPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditions: Sequence['outputs.ApiWebPolicyCondition'],
                 name: _builtins.str,
                 path: _builtins.str,
                 request_method: _builtins.str,
                 authorizer_id: Optional[_builtins.str] = None,
                 backend_address: Optional[_builtins.str] = None,
                 backend_params: Optional[Sequence['outputs.ApiWebPolicyBackendParam']] = None,
                 effective_mode: Optional[_builtins.str] = None,
                 host_header: Optional[_builtins.str] = None,
                 request_protocol: Optional[_builtins.str] = None,
                 retry_count: Optional[_builtins.int] = None,
                 timeout: Optional[_builtins.int] = None,
                 vpc_channel_id: Optional[_builtins.str] = None):
        """
        :param Sequence['ApiWebPolicyConditionArgs'] conditions: The policy conditions.
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str path: The backend request address.
        :param _builtins.str request_method: Specifies the request method, including 'GET','POST','PUT' and etc..
        :param _builtins.str authorizer_id: The ID of the backend custom authorization.
        :param _builtins.str backend_address: The backend service address
        :param Sequence['ApiWebPolicyBackendParamArgs'] backend_params: The configuration list of the backend parameters.
        :param _builtins.str effective_mode: The effective mode of the backend policy.
        :param _builtins.str host_header: The proxy host header.
        :param _builtins.str request_protocol: Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
               which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        :param _builtins.int retry_count: The number of retry attempts to request the backend service.
        :param _builtins.int timeout: The timeout for API requests to backend service.
        :param _builtins.str vpc_channel_id: The VPC channel ID.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "request_method", request_method)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_address is not None:
            pulumi.set(__self__, "backend_address", backend_address)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if effective_mode is not None:
            pulumi.set(__self__, "effective_mode", effective_mode)
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if retry_count is not None:
            pulumi.set(__self__, "retry_count", retry_count)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if vpc_channel_id is not None:
            pulumi.set(__self__, "vpc_channel_id", vpc_channel_id)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ApiWebPolicyCondition']:
        """
        The policy conditions.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The backend request address.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> _builtins.str:
        """
        Specifies the request method, including 'GET','POST','PUT' and etc..
        """
        return pulumi.get(self, "request_method")

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[_builtins.str]:
        """
        The ID of the backend custom authorization.
        """
        return pulumi.get(self, "authorizer_id")

    @_builtins.property
    @pulumi.getter(name="backendAddress")
    def backend_address(self) -> Optional[_builtins.str]:
        """
        The backend service address
        """
        return pulumi.get(self, "backend_address")

    @_builtins.property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[Sequence['outputs.ApiWebPolicyBackendParam']]:
        """
        The configuration list of the backend parameters.
        """
        return pulumi.get(self, "backend_params")

    @_builtins.property
    @pulumi.getter(name="effectiveMode")
    def effective_mode(self) -> Optional[_builtins.str]:
        """
        The effective mode of the backend policy.
        """
        return pulumi.get(self, "effective_mode")

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional[_builtins.str]:
        """
        The proxy host header.
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[_builtins.str]:
        """
        Specifies the request protocol. The value can be 'HTTP', 'HTTPS', and 'BOTH'
        which means the API can be accessed through both 'HTTP' and 'HTTPS'. Defaults to 'HTTPS'.
        """
        return pulumi.get(self, "request_protocol")

    @_builtins.property
    @pulumi.getter(name="retryCount")
    def retry_count(self) -> Optional[_builtins.int]:
        """
        The number of retry attempts to request the backend service.
        """
        return pulumi.get(self, "retry_count")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        The timeout for API requests to backend service.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="vpcChannelId")
    def vpc_channel_id(self) -> Optional[_builtins.str]:
        """
        The VPC channel ID.
        """
        return pulumi.get(self, "vpc_channel_id")


@pulumi.output_type
class ApiWebPolicyBackendParam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemParamType":
            suggest = "system_param_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiWebPolicyBackendParam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiWebPolicyBackendParam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiWebPolicyBackendParam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: _builtins.str,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str,
                 description: Optional[_builtins.str] = None,
                 system_param_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str location: Where the parameter is located.
        :param _builtins.str name: Specifies the name of the API. An API name consists of 3–64 characters, starting with a
               letter. Only letters, digits, and underscores (_) are allowed.
        :param _builtins.str type: The parameter type.
        :param _builtins.str value: The value of the parameter
        :param _builtins.str description: Specifies the description of the API. The description cannot exceed 255 characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if system_param_type is not None:
            pulumi.set(__self__, "system_param_type", system_param_type)

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        Where the parameter is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the API. An API name consists of 3–64 characters, starting with a
        letter. Only letters, digits, and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The parameter type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the parameter
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the description of the API. The description cannot exceed 255 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="systemParamType")
    def system_param_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "system_param_type")


@pulumi.output_type
class ApiWebPolicyCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"
        elif key == "frontendAuthorizerName":
            suggest = "frontend_authorizer_name"
        elif key == "mappedParamLocation":
            suggest = "mapped_param_location"
        elif key == "mappedParamName":
            suggest = "mapped_param_name"
        elif key == "paramName":
            suggest = "param_name"
        elif key == "sysName":
            suggest = "sys_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiWebPolicyCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiWebPolicyCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiWebPolicyCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: _builtins.str,
                 cookie_name: Optional[_builtins.str] = None,
                 frontend_authorizer_name: Optional[_builtins.str] = None,
                 mapped_param_location: Optional[_builtins.str] = None,
                 mapped_param_name: Optional[_builtins.str] = None,
                 param_name: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None,
                 sys_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: The value of the backend policy.
        :param _builtins.str cookie_name: The cookie parameter name.
        :param _builtins.str frontend_authorizer_name: The frontend authentication parameter name.
        :param _builtins.str mapped_param_location: The location of a parameter generated after orchestration.
        :param _builtins.str mapped_param_name: The name of a parameter generated after orchestration.
        :param _builtins.str param_name: The request parameter name.
        :param _builtins.str source: The type of the backend policy.
        :param _builtins.str sys_name: The gateway built-in parameter name.
        :param _builtins.str type: The condition type.
        """
        pulumi.set(__self__, "value", value)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if frontend_authorizer_name is not None:
            pulumi.set(__self__, "frontend_authorizer_name", frontend_authorizer_name)
        if mapped_param_location is not None:
            pulumi.set(__self__, "mapped_param_location", mapped_param_location)
        if mapped_param_name is not None:
            pulumi.set(__self__, "mapped_param_name", mapped_param_name)
        if param_name is not None:
            pulumi.set(__self__, "param_name", param_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if sys_name is not None:
            pulumi.set(__self__, "sys_name", sys_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the backend policy.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        The cookie parameter name.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="frontendAuthorizerName")
    def frontend_authorizer_name(self) -> Optional[_builtins.str]:
        """
        The frontend authentication parameter name.
        """
        return pulumi.get(self, "frontend_authorizer_name")

    @_builtins.property
    @pulumi.getter(name="mappedParamLocation")
    def mapped_param_location(self) -> Optional[_builtins.str]:
        """
        The location of a parameter generated after orchestration.
        """
        return pulumi.get(self, "mapped_param_location")

    @_builtins.property
    @pulumi.getter(name="mappedParamName")
    def mapped_param_name(self) -> Optional[_builtins.str]:
        """
        The name of a parameter generated after orchestration.
        """
        return pulumi.get(self, "mapped_param_name")

    @_builtins.property
    @pulumi.getter(name="paramName")
    def param_name(self) -> Optional[_builtins.str]:
        """
        The request parameter name.
        """
        return pulumi.get(self, "param_name")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        The type of the backend policy.
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sysName")
    def sys_name(self) -> Optional[_builtins.str]:
        """
        The gateway built-in parameter name.
        """
        return pulumi.get(self, "sys_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The condition type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GroupEnvironment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentId":
            suggest = "environment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupEnvironment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupEnvironment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupEnvironment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment_id: _builtins.str,
                 variables: Sequence['outputs.GroupEnvironmentVariable']):
        """
        :param _builtins.str environment_id: The ID of the environment to which the variables belongs.
        :param Sequence['GroupEnvironmentVariableArgs'] variables: The array of one or more environment variables. Each `variable` block supports the following:
        """
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "variables", variables)

    @_builtins.property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> _builtins.str:
        """
        The ID of the environment to which the variables belongs.
        """
        return pulumi.get(self, "environment_id")

    @_builtins.property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GroupEnvironmentVariable']:
        """
        The array of one or more environment variables. Each `variable` block supports the following:
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class GroupEnvironmentVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variableId":
            suggest = "variable_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupEnvironmentVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupEnvironmentVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupEnvironmentVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 variable_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The variable name.
        :param _builtins.str value: The variable value.
        :param _builtins.str id: The ID of the variable that the group has.
        :param _builtins.str variable_id: The ID of the variable that the group has.  
               _Deprecated: Use `id` instead._
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if variable_id is not None:
            pulumi.set(__self__, "variable_id", variable_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The variable name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The variable value.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the variable that the group has.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="variableId")
    @_utilities.deprecated("""Use 'id' instead""")
    def variable_id(self) -> Optional[_builtins.str]:
        """
        The ID of the variable that the group has.  
        _Deprecated: Use `id` instead._
        """
        return pulumi.get(self, "variable_id")


@pulumi.output_type
class GroupUrlDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isHttpRedirectToHttps":
            suggest = "is_http_redirect_to_https"
        elif key == "minSslVersion":
            suggest = "min_ssl_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupUrlDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupUrlDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupUrlDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 is_http_redirect_to_https: Optional[_builtins.bool] = None,
                 min_ssl_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The group name.
        :param _builtins.bool is_http_redirect_to_https: Whether to enable redirection from HTTP to HTTPS.
        :param _builtins.str min_ssl_version: The minimum SSL protocol version.
        """
        pulumi.set(__self__, "name", name)
        if is_http_redirect_to_https is not None:
            pulumi.set(__self__, "is_http_redirect_to_https", is_http_redirect_to_https)
        if min_ssl_version is not None:
            pulumi.set(__self__, "min_ssl_version", min_ssl_version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="isHttpRedirectToHttps")
    def is_http_redirect_to_https(self) -> Optional[_builtins.bool]:
        """
        Whether to enable redirection from HTTP to HTTPS.
        """
        return pulumi.get(self, "is_http_redirect_to_https")

    @_builtins.property
    @pulumi.getter(name="minSslVersion")
    def min_ssl_version(self) -> Optional[_builtins.str]:
        """
        The minimum SSL protocol version.
        """
        return pulumi.get(self, "min_ssl_version")


