# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SmnMessageDetectionArgs', 'SmnMessageDetection']

@pulumi.input_type
class SmnMessageDetectionArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 topic_urn: pulumi.Input[_builtins.str],
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SmnMessageDetection resource.
        :param pulumi.Input[_builtins.str] endpoint: Specifies the endpoint address to be detected.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type.
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the resource identifier of a topic.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extension: Specifies the extended key/value for subscriptions over HTTP or HTTPS.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "topic_urn", topic_urn)
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the endpoint address to be detected.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the protocol type.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource identifier of a topic.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic_urn", value)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the extended key/value for subscriptions over HTTP or HTTPS.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SmnMessageDetectionState:
    def __init__(__self__, *,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 result: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SmnMessageDetection resources.
        :param pulumi.Input[_builtins.str] endpoint: Specifies the endpoint address to be detected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extension: Specifies the extended key/value for subscriptions over HTTP or HTTPS.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type.
        :param pulumi.Input[_builtins.str] result: The message detection result.
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the resource identifier of a topic.
        """
        if enable_force_new is not None:
            pulumi.set(__self__, "enable_force_new", enable_force_new)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if result is not None:
            pulumi.set(__self__, "result", result)
        if topic_urn is not None:
            pulumi.set(__self__, "topic_urn", topic_urn)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @enable_force_new.setter
    def enable_force_new(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enable_force_new", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the endpoint address to be detected.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the extended key/value for subscriptions over HTTP or HTTPS.
        """
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol type.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def result(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The message detection result.
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "result", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource identifier of a topic.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_urn", value)


@pulumi.type_token("sbercloud:index/smnMessageDetection:SmnMessageDetection")
class SmnMessageDetection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a SmnMessageDetection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: Specifies the endpoint address to be detected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extension: Specifies the extended key/value for subscriptions over HTTP or HTTPS.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type.
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the resource identifier of a topic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SmnMessageDetectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a SmnMessageDetection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param SmnMessageDetectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmnMessageDetectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmnMessageDetectionArgs.__new__(SmnMessageDetectionArgs)

            __props__.__dict__["enable_force_new"] = enable_force_new
            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["extension"] = extension
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            if topic_urn is None and not opts.urn:
                raise TypeError("Missing required property 'topic_urn'")
            __props__.__dict__["topic_urn"] = topic_urn
            __props__.__dict__["result"] = None
        super(SmnMessageDetection, __self__).__init__(
            'sbercloud:index/smnMessageDetection:SmnMessageDetection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_force_new: Optional[pulumi.Input[_builtins.str]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            extension: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            result: Optional[pulumi.Input[_builtins.str]] = None,
            topic_urn: Optional[pulumi.Input[_builtins.str]] = None) -> 'SmnMessageDetection':
        """
        Get an existing SmnMessageDetection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: Specifies the endpoint address to be detected.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] extension: Specifies the extended key/value for subscriptions over HTTP or HTTPS.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol type.
        :param pulumi.Input[_builtins.str] result: The message detection result.
        :param pulumi.Input[_builtins.str] topic_urn: Specifies the resource identifier of a topic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmnMessageDetectionState.__new__(_SmnMessageDetectionState)

        __props__.__dict__["enable_force_new"] = enable_force_new
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["extension"] = extension
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["result"] = result
        __props__.__dict__["topic_urn"] = topic_urn
        return SmnMessageDetection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="enableForceNew")
    def enable_force_new(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "enable_force_new")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the endpoint address to be detected.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the extended key/value for subscriptions over HTTP or HTTPS.
        """
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def result(self) -> pulumi.Output[_builtins.str]:
        """
        The message detection result.
        """
        return pulumi.get(self, "result")

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource identifier of a topic.
        """
        return pulumi.get(self, "topic_urn")

