# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SmnSubscriptionArgs', 'SmnSubscription']

@pulumi.input_type
class SmnSubscriptionArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 topic_urn: pulumi.Input[_builtins.str],
                 extension: Optional[pulumi.Input['SmnSubscriptionExtensionArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SmnSubscription resource.
        :param pulumi.Input[_builtins.str] endpoint: Message endpoint.
               + **For an HTTP subscription**, the endpoint starts with `http://`.
               + **For an HTTPS subscription**, the endpoint starts with `https://`.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +7905xxx0000.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the message endpoint. Currently, email,
               sms, http, and https are supported.
        :param pulumi.Input[_builtins.str] topic_urn: Resource identifier of a topic, which is unique.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN subscription resource. If omitted, the provider-level region will be used. Changing this creates a new SMN subscription resource.
        :param pulumi.Input[_builtins.str] remark: Remark information. The remarks must be a UTF-8-coded
               character string containing 128 bytes.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "topic_urn", topic_urn)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Message endpoint.
        + **For an HTTP subscription**, the endpoint starts with `http://`.
        + **For an HTTPS subscription**, the endpoint starts with `https://`.
        + **For an email subscription**, the endpoint is an mail address.
        + **For an SMS message subscription**, the endpoint is a phone number,
        the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +7905xxx0000.
        + **For a functiongraph subscription**, the endpoint is a workflow ID.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        Protocol of the message endpoint. Currently, email,
        sms, http, and https are supported.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[_builtins.str]:
        """
        Resource identifier of a topic, which is unique.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic_urn", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['SmnSubscriptionExtensionArgs']]:
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['SmnSubscriptionExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the SMN subscription resource. If omitted, the provider-level region will be used. Changing this creates a new SMN subscription resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Remark information. The remarks must be a UTF-8-coded
        character string containing 128 bytes.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)


@pulumi.input_type
class _SmnSubscriptionState:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input['SmnSubscriptionExtensionArgs']] = None,
                 filter_policies: Optional[pulumi.Input[Sequence[pulumi.Input['SmnSubscriptionFilterPolicyArgs']]]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.int]] = None,
                 subscription_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SmnSubscription resources.
        :param pulumi.Input[_builtins.str] endpoint: Message endpoint.
               + **For an HTTP subscription**, the endpoint starts with `http://`.
               + **For an HTTPS subscription**, the endpoint starts with `https://`.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +7905xxx0000.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[Sequence[pulumi.Input['SmnSubscriptionFilterPolicyArgs']]] filter_policies: The message filter policies of a subscriber.
        :param pulumi.Input[_builtins.str] owner: Project ID of the topic creator.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the message endpoint. Currently, email,
               sms, http, and https are supported.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN subscription resource. If omitted, the provider-level region will be used. Changing this creates a new SMN subscription resource.
        :param pulumi.Input[_builtins.str] remark: Remark information. The remarks must be a UTF-8-coded
               character string containing 128 bytes.
        :param pulumi.Input[_builtins.int] status: Subscription status.
               + **0**: indicates that the subscription is not confirmed.
               + **1**: indicates that the subscription is confirmed.
               + **3**: indicates that the subscription is canceled.
        :param pulumi.Input[_builtins.str] subscription_urn: Resource identifier of a subscription, which is unique.
        :param pulumi.Input[_builtins.str] topic_urn: Resource identifier of a topic, which is unique.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if extension is not None:
            pulumi.set(__self__, "extension", extension)
        if filter_policies is not None:
            pulumi.set(__self__, "filter_policies", filter_policies)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_urn is not None:
            pulumi.set(__self__, "subscription_urn", subscription_urn)
        if topic_urn is not None:
            pulumi.set(__self__, "topic_urn", topic_urn)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message endpoint.
        + **For an HTTP subscription**, the endpoint starts with `http://`.
        + **For an HTTPS subscription**, the endpoint starts with `https://`.
        + **For an email subscription**, the endpoint is an mail address.
        + **For an SMS message subscription**, the endpoint is a phone number,
        the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +7905xxx0000.
        + **For a functiongraph subscription**, the endpoint is a workflow ID.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def extension(self) -> Optional[pulumi.Input['SmnSubscriptionExtensionArgs']]:
        return pulumi.get(self, "extension")

    @extension.setter
    def extension(self, value: Optional[pulumi.Input['SmnSubscriptionExtensionArgs']]):
        pulumi.set(self, "extension", value)

    @_builtins.property
    @pulumi.getter(name="filterPolicies")
    def filter_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmnSubscriptionFilterPolicyArgs']]]]:
        """
        The message filter policies of a subscriber.
        """
        return pulumi.get(self, "filter_policies")

    @filter_policies.setter
    def filter_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmnSubscriptionFilterPolicyArgs']]]]):
        pulumi.set(self, "filter_policies", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project ID of the topic creator.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol of the message endpoint. Currently, email,
        sms, http, and https are supported.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the SMN subscription resource. If omitted, the provider-level region will be used. Changing this creates a new SMN subscription resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Remark information. The remarks must be a UTF-8-coded
        character string containing 128 bytes.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remark", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Subscription status.
        + **0**: indicates that the subscription is not confirmed.
        + **1**: indicates that the subscription is confirmed.
        + **3**: indicates that the subscription is canceled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionUrn")
    def subscription_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource identifier of a subscription, which is unique.
        """
        return pulumi.get(self, "subscription_urn")

    @subscription_urn.setter
    def subscription_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_urn", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource identifier of a topic, which is unique.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_urn", value)


@pulumi.type_token("sbercloud:index/smnSubscription:SmnSubscription")
class SmnSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[Union['SmnSubscriptionExtensionArgs', 'SmnSubscriptionExtensionArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages SMN subscription resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        topic1 = sbercloud.SmnTopic("topic_1",
            name="topic_1",
            display_name="The display name of topic_1")
        subscription1 = sbercloud.SmnSubscription("subscription_1",
            topic_urn=topic1.id,
            endpoint="mailtest@gmail.com",
            protocol="email",
            remark="O&M")
        subscription2 = sbercloud.SmnSubscription("subscription_2",
            topic_urn=topic1.id,
            endpoint="13600000000",
            protocol="sms",
            remark="O&M")
        ```

        ## Import

        SMN subscription can be imported using the `id` (subscription urn), e.g.

        ```sh
        $ pulumi import sbercloud:index/smnSubscription:SmnSubscription subscription_1 urn:smn:ru-moscow-1:0f5181caba0024e72f89c0045e707b91:topic_1:9c06f9d90cc549359e3bf67860a0736a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: Message endpoint.
               + **For an HTTP subscription**, the endpoint starts with `http://`.
               + **For an HTTPS subscription**, the endpoint starts with `https://`.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +7905xxx0000.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the message endpoint. Currently, email,
               sms, http, and https are supported.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN subscription resource. If omitted, the provider-level region will be used. Changing this creates a new SMN subscription resource.
        :param pulumi.Input[_builtins.str] remark: Remark information. The remarks must be a UTF-8-coded
               character string containing 128 bytes.
        :param pulumi.Input[_builtins.str] topic_urn: Resource identifier of a topic, which is unique.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SmnSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages SMN subscription resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        topic1 = sbercloud.SmnTopic("topic_1",
            name="topic_1",
            display_name="The display name of topic_1")
        subscription1 = sbercloud.SmnSubscription("subscription_1",
            topic_urn=topic1.id,
            endpoint="mailtest@gmail.com",
            protocol="email",
            remark="O&M")
        subscription2 = sbercloud.SmnSubscription("subscription_2",
            topic_urn=topic1.id,
            endpoint="13600000000",
            protocol="sms",
            remark="O&M")
        ```

        ## Import

        SMN subscription can be imported using the `id` (subscription urn), e.g.

        ```sh
        $ pulumi import sbercloud:index/smnSubscription:SmnSubscription subscription_1 urn:smn:ru-moscow-1:0f5181caba0024e72f89c0045e707b91:topic_1:9c06f9d90cc549359e3bf67860a0736a
        ```

        :param str resource_name: The name of the resource.
        :param SmnSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmnSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 extension: Optional[pulumi.Input[Union['SmnSubscriptionExtensionArgs', 'SmnSubscriptionExtensionArgsDict']]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 remark: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmnSubscriptionArgs.__new__(SmnSubscriptionArgs)

            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["extension"] = extension
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["remark"] = remark
            if topic_urn is None and not opts.urn:
                raise TypeError("Missing required property 'topic_urn'")
            __props__.__dict__["topic_urn"] = topic_urn
            __props__.__dict__["filter_policies"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subscription_urn"] = None
        super(SmnSubscription, __self__).__init__(
            'sbercloud:index/smnSubscription:SmnSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            extension: Optional[pulumi.Input[Union['SmnSubscriptionExtensionArgs', 'SmnSubscriptionExtensionArgsDict']]] = None,
            filter_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmnSubscriptionFilterPolicyArgs', 'SmnSubscriptionFilterPolicyArgsDict']]]]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            remark: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.int]] = None,
            subscription_urn: Optional[pulumi.Input[_builtins.str]] = None,
            topic_urn: Optional[pulumi.Input[_builtins.str]] = None) -> 'SmnSubscription':
        """
        Get an existing SmnSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] endpoint: Message endpoint.
               + **For an HTTP subscription**, the endpoint starts with `http://`.
               + **For an HTTPS subscription**, the endpoint starts with `https://`.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +7905xxx0000.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmnSubscriptionFilterPolicyArgs', 'SmnSubscriptionFilterPolicyArgsDict']]]] filter_policies: The message filter policies of a subscriber.
        :param pulumi.Input[_builtins.str] owner: Project ID of the topic creator.
        :param pulumi.Input[_builtins.str] protocol: Protocol of the message endpoint. Currently, email,
               sms, http, and https are supported.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN subscription resource. If omitted, the provider-level region will be used. Changing this creates a new SMN subscription resource.
        :param pulumi.Input[_builtins.str] remark: Remark information. The remarks must be a UTF-8-coded
               character string containing 128 bytes.
        :param pulumi.Input[_builtins.int] status: Subscription status.
               + **0**: indicates that the subscription is not confirmed.
               + **1**: indicates that the subscription is confirmed.
               + **3**: indicates that the subscription is canceled.
        :param pulumi.Input[_builtins.str] subscription_urn: Resource identifier of a subscription, which is unique.
        :param pulumi.Input[_builtins.str] topic_urn: Resource identifier of a topic, which is unique.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmnSubscriptionState.__new__(_SmnSubscriptionState)

        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["extension"] = extension
        __props__.__dict__["filter_policies"] = filter_policies
        __props__.__dict__["owner"] = owner
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["remark"] = remark
        __props__.__dict__["status"] = status
        __props__.__dict__["subscription_urn"] = subscription_urn
        __props__.__dict__["topic_urn"] = topic_urn
        return SmnSubscription(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Message endpoint.
        + **For an HTTP subscription**, the endpoint starts with `http://`.
        + **For an HTTPS subscription**, the endpoint starts with `https://`.
        + **For an email subscription**, the endpoint is an mail address.
        + **For an SMS message subscription**, the endpoint is a phone number,
        the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +7905xxx0000.
        + **For a functiongraph subscription**, the endpoint is a workflow ID.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def extension(self) -> pulumi.Output['outputs.SmnSubscriptionExtension']:
        return pulumi.get(self, "extension")

    @_builtins.property
    @pulumi.getter(name="filterPolicies")
    def filter_policies(self) -> pulumi.Output[Sequence['outputs.SmnSubscriptionFilterPolicy']]:
        """
        The message filter policies of a subscriber.
        """
        return pulumi.get(self, "filter_policies")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Project ID of the topic creator.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        Protocol of the message endpoint. Currently, email,
        sms, http, and https are supported.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the SMN subscription resource. If omitted, the provider-level region will be used. Changing this creates a new SMN subscription resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def remark(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Remark information. The remarks must be a UTF-8-coded
        character string containing 128 bytes.
        """
        return pulumi.get(self, "remark")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.int]:
        """
        Subscription status.
        + **0**: indicates that the subscription is not confirmed.
        + **1**: indicates that the subscription is confirmed.
        + **3**: indicates that the subscription is canceled.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subscriptionUrn")
    def subscription_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Resource identifier of a subscription, which is unique.
        """
        return pulumi.get(self, "subscription_urn")

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Resource identifier of a topic, which is unique.
        """
        return pulumi.get(self, "topic_urn")

