# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SmnTopicArgs', 'SmnTopic']

@pulumi.input_type
class SmnTopicArgs:
    def __init__(__self__, *,
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 introduction: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 services_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 users_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SmnTopic resource.
        :param pulumi.Input[_builtins.str] access_policy: schema: Internal
        :param pulumi.Input[_builtins.str] display_name: Topic display name, which is presented as the
               name of the email sender in an email message.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the topic to be created.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN topic resource. If omitted, the provider-level region will be used. Changing this creates a new SMN Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        """
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if introduction is not None:
            pulumi.set(__self__, "introduction", introduction)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services_publish_allowed is not None:
            pulumi.set(__self__, "services_publish_allowed", services_publish_allowed)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if users_publish_allowed is not None:
            pulumi.set(__self__, "users_publish_allowed", users_publish_allowed)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Topic display name, which is presented as the
        name of the email sender in an email message.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the SMN Topic, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def introduction(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "introduction")

    @introduction.setter
    def introduction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "introduction", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the topic to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the SMN topic resource. If omitted, the provider-level region will be used. Changing this creates a new SMN Topic resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="servicesPublishAllowed")
    def services_publish_allowed(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "services_publish_allowed")

    @services_publish_allowed.setter
    def services_publish_allowed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "services_publish_allowed", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the SMN topic, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="usersPublishAllowed")
    def users_publish_allowed(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "users_publish_allowed")

    @users_publish_allowed.setter
    def users_publish_allowed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "users_publish_allowed", value)


@pulumi.input_type
class _SmnTopicState:
    def __init__(__self__, *,
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 introduction: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 push_policy: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 services_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 users_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SmnTopic resources.
        :param pulumi.Input[_builtins.str] access_policy: schema: Internal
        :param pulumi.Input[_builtins.str] create_time: Time when the topic was created.
        :param pulumi.Input[_builtins.str] display_name: Topic display name, which is presented as the
               name of the email sender in an email message.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the topic to be created.
        :param pulumi.Input[_builtins.int] push_policy: Message pushing policy.
               + **0**: indicates that the message sending fails and the message is cached in the queue.
               + **1**: indicates that the failed message is discarded.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN topic resource. If omitted, the provider-level region will be used. Changing this creates a new SMN Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        :param pulumi.Input[_builtins.str] topic_urn: Resource identifier of a topic, which is unique.
        :param pulumi.Input[_builtins.str] update_time: Time when the topic was updated.
        """
        if access_policy is not None:
            pulumi.set(__self__, "access_policy", access_policy)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if introduction is not None:
            pulumi.set(__self__, "introduction", introduction)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if push_policy is not None:
            pulumi.set(__self__, "push_policy", push_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services_publish_allowed is not None:
            pulumi.set(__self__, "services_publish_allowed", services_publish_allowed)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_urn is not None:
            pulumi.set(__self__, "topic_urn", topic_urn)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if users_publish_allowed is not None:
            pulumi.set(__self__, "users_publish_allowed", users_publish_allowed)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the topic was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Topic display name, which is presented as the
        name of the email sender in an email message.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the SMN Topic, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def introduction(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "introduction")

    @introduction.setter
    def introduction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "introduction", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the topic to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pushPolicy")
    def push_policy(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Message pushing policy.
        + **0**: indicates that the message sending fails and the message is cached in the queue.
        + **1**: indicates that the failed message is discarded.
        """
        return pulumi.get(self, "push_policy")

    @push_policy.setter
    def push_policy(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "push_policy", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the SMN topic resource. If omitted, the provider-level region will be used. Changing this creates a new SMN Topic resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="servicesPublishAllowed")
    def services_publish_allowed(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "services_publish_allowed")

    @services_publish_allowed.setter
    def services_publish_allowed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "services_publish_allowed", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the tags of the SMN topic, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource identifier of a topic, which is unique.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic_urn", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the topic was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="usersPublishAllowed")
    def users_publish_allowed(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "users_publish_allowed")

    @users_publish_allowed.setter
    def users_publish_allowed(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "users_publish_allowed", value)


@pulumi.type_token("sbercloud:index/smnTopic:SmnTopic")
class SmnTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 introduction: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 services_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 users_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a SMN Topic resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        topic1 = sbercloud.SmnTopic("topic_1",
            name="topic_1",
            display_name="The display name of topic_1")
        ```

        ## Import

        SMN topic can be imported using the `id` (topic urn), e.g.

        ```sh
        $ pulumi import sbercloud:index/smnTopic:SmnTopic topic_1 urn:smn:ru-moscow-1:0f5181caba0024e72f89c0045e707b91:topic_1:9c06f9d90cc549359e3bf67860a0736a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy: schema: Internal
        :param pulumi.Input[_builtins.str] display_name: Topic display name, which is presented as the
               name of the email sender in an email message.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the topic to be created.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN topic resource. If omitted, the provider-level region will be used. Changing this creates a new SMN Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SmnTopicArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SMN Topic resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        topic1 = sbercloud.SmnTopic("topic_1",
            name="topic_1",
            display_name="The display name of topic_1")
        ```

        ## Import

        SMN topic can be imported using the `id` (topic urn), e.g.

        ```sh
        $ pulumi import sbercloud:index/smnTopic:SmnTopic topic_1 urn:smn:ru-moscow-1:0f5181caba0024e72f89c0045e707b91:topic_1:9c06f9d90cc549359e3bf67860a0736a
        ```

        :param str resource_name: The name of the resource.
        :param SmnTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmnTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 introduction: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 services_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 users_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmnTopicArgs.__new__(SmnTopicArgs)

            __props__.__dict__["access_policy"] = access_policy
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["introduction"] = introduction
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["services_publish_allowed"] = services_publish_allowed
            __props__.__dict__["tags"] = tags
            __props__.__dict__["users_publish_allowed"] = users_publish_allowed
            __props__.__dict__["create_time"] = None
            __props__.__dict__["push_policy"] = None
            __props__.__dict__["topic_urn"] = None
            __props__.__dict__["update_time"] = None
        super(SmnTopic, __self__).__init__(
            'sbercloud:index/smnTopic:SmnTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            introduction: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            push_policy: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            services_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            topic_urn: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            users_publish_allowed: Optional[pulumi.Input[_builtins.str]] = None) -> 'SmnTopic':
        """
        Get an existing SmnTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy: schema: Internal
        :param pulumi.Input[_builtins.str] create_time: Time when the topic was created.
        :param pulumi.Input[_builtins.str] display_name: Topic display name, which is presented as the
               name of the email sender in an email message.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the SMN Topic, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: The name of the topic to be created.
        :param pulumi.Input[_builtins.int] push_policy: Message pushing policy.
               + **0**: indicates that the message sending fails and the message is cached in the queue.
               + **1**: indicates that the failed message is discarded.
        :param pulumi.Input[_builtins.str] region: The region in which to create the SMN topic resource. If omitted, the provider-level region will be used. Changing this creates a new SMN Topic resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the tags of the SMN topic, key/value pair format.
        :param pulumi.Input[_builtins.str] topic_urn: Resource identifier of a topic, which is unique.
        :param pulumi.Input[_builtins.str] update_time: Time when the topic was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmnTopicState.__new__(_SmnTopicState)

        __props__.__dict__["access_policy"] = access_policy
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["introduction"] = introduction
        __props__.__dict__["name"] = name
        __props__.__dict__["push_policy"] = push_policy
        __props__.__dict__["region"] = region
        __props__.__dict__["services_publish_allowed"] = services_publish_allowed
        __props__.__dict__["tags"] = tags
        __props__.__dict__["topic_urn"] = topic_urn
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["users_publish_allowed"] = users_publish_allowed
        return SmnTopic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "access_policy")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the topic was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Topic display name, which is presented as the
        name of the email sender in an email message.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the SMN Topic, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def introduction(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "introduction")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the topic to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pushPolicy")
    def push_policy(self) -> pulumi.Output[_builtins.int]:
        """
        Message pushing policy.
        + **0**: indicates that the message sending fails and the message is cached in the queue.
        + **1**: indicates that the failed message is discarded.
        """
        return pulumi.get(self, "push_policy")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the SMN topic resource. If omitted, the provider-level region will be used. Changing this creates a new SMN Topic resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="servicesPublishAllowed")
    def services_publish_allowed(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "services_publish_allowed")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the tags of the SMN topic, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Output[_builtins.str]:
        """
        Resource identifier of a topic, which is unique.
        """
        return pulumi.get(self, "topic_urn")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the topic was updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="usersPublishAllowed")
    def users_publish_allowed(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "users_publish_allowed")

