# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SwrOrganizationArgs', 'SwrOrganization']

@pulumi.input_type
class SwrOrganizationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SwrOrganization resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the organization. The organization name must be globally
               unique.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the organization. The organization name must be globally
        unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SwrOrganizationState:
    def __init__(__self__, *,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 login_server: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SwrOrganization resources.
        :param pulumi.Input[_builtins.str] creator: The creator user name of the organization.
        :param pulumi.Input[_builtins.str] login_server: The URL that can be used to log into the container registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the organization. The organization name must be globally
               unique.
        :param pulumi.Input[_builtins.str] permission: The permission of the organization, the value can be Manage, Write, and Read.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if login_server is not None:
            pulumi.set(__self__, "login_server", login_server)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator user name of the organization.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that can be used to log into the container registry.
        """
        return pulumi.get(self, "login_server")

    @login_server.setter
    def login_server(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_server", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the organization. The organization name must be globally
        unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permission of the organization, the value can be Manage, Write, and Read.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/swrOrganization:SwrOrganization")
class SwrOrganization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a SWR organization resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.SwrOrganization("test", name="terraform-test")
        ```

        ## Import

        Organizations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import sbercloud:index/swrOrganization:SwrOrganization test org-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the organization. The organization name must be globally
               unique.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SwrOrganizationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SWR organization resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        test = sbercloud.SwrOrganization("test", name="terraform-test")
        ```

        ## Import

        Organizations can be imported using the `name`, e.g.

        ```sh
        $ pulumi import sbercloud:index/swrOrganization:SwrOrganization test org-name
        ```

        :param str resource_name: The name of the resource.
        :param SwrOrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwrOrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwrOrganizationArgs.__new__(SwrOrganizationArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["creator"] = None
            __props__.__dict__["login_server"] = None
            __props__.__dict__["permission"] = None
        super(SwrOrganization, __self__).__init__(
            'sbercloud:index/swrOrganization:SwrOrganization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            login_server: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permission: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'SwrOrganization':
        """
        Get an existing SwrOrganization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creator: The creator user name of the organization.
        :param pulumi.Input[_builtins.str] login_server: The URL that can be used to log into the container registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the organization. The organization name must be globally
               unique.
        :param pulumi.Input[_builtins.str] permission: The permission of the organization, the value can be Manage, Write, and Read.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwrOrganizationState.__new__(_SwrOrganizationState)

        __props__.__dict__["creator"] = creator
        __props__.__dict__["login_server"] = login_server
        __props__.__dict__["name"] = name
        __props__.__dict__["permission"] = permission
        __props__.__dict__["region"] = region
        return SwrOrganization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        The creator user name of the organization.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> pulumi.Output[_builtins.str]:
        """
        The URL that can be used to log into the container registry.
        """
        return pulumi.get(self, "login_server")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the organization. The organization name must be globally
        unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Output[_builtins.str]:
        """
        The permission of the organization, the value can be Manage, Write, and Read.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

