# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwrOrganizationPermissionsArgs', 'SwrOrganizationPermissions']

@pulumi.input_type
class SwrOrganizationPermissionsArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[_builtins.str],
                 users: pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SwrOrganizationPermissions resource.
        :param pulumi.Input[_builtins.str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "users", users)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the organization (namespace) to be accessed.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]]:
        """
        Specifies the users to access to the organization (namespace).
        Structure is documented below.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]]):
        pulumi.set(self, "users", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SwrOrganizationPermissionsState:
    def __init__(__self__, *,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 self_permissions: Optional[pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsSelfPermissionArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering SwrOrganizationPermissions resources.
        :param pulumi.Input[_builtins.str] creator: The creator user name of the organization.
        :param pulumi.Input[_builtins.str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsSelfPermissionArgs']]] self_permissions: The permission informations of current user.
        :param pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        """
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_permissions is not None:
            pulumi.set(__self__, "self_permissions", self_permissions)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator user name of the organization.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the organization (namespace) to be accessed.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selfPermissions")
    def self_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsSelfPermissionArgs']]]]:
        """
        The permission informations of current user.
        """
        return pulumi.get(self, "self_permissions")

    @self_permissions.setter
    def self_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsSelfPermissionArgs']]]]):
        pulumi.set(self, "self_permissions", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]]]:
        """
        Specifies the users to access to the organization (namespace).
        Structure is documented below.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwrOrganizationPermissionsUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("sbercloud:index/swrOrganizationPermissions:SwrOrganizationPermissions")
class SwrOrganizationPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwrOrganizationPermissionsUserArgs', 'SwrOrganizationPermissionsUserArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages user permissions for the SWR organization resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        user1 = config.require_object("user1")
        user2 = config.require_object("user2")
        test = sbercloud.SwrOrganizationPermissions("test",
            organization=organization_name,
            users=[
                {
                    "user_name": user1["name"],
                    "user_id": user1["id"],
                    "permission": "Read",
                },
                {
                    "user_name": user2["name"],
                    "user_id": user2["id"],
                    "permission": "Read",
                },
            ])
        ```

        ## Import

        Organization Permissions can be imported using the `id` (organization name), e.g.

        ```sh
        $ pulumi import sbercloud:index/swrOrganizationPermissions:SwrOrganizationPermissions test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwrOrganizationPermissionsUserArgs', 'SwrOrganizationPermissionsUserArgsDict']]]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwrOrganizationPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages user permissions for the SWR organization resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        organization_name = config.require_object("organizationName")
        user1 = config.require_object("user1")
        user2 = config.require_object("user2")
        test = sbercloud.SwrOrganizationPermissions("test",
            organization=organization_name,
            users=[
                {
                    "user_name": user1["name"],
                    "user_id": user1["id"],
                    "permission": "Read",
                },
                {
                    "user_name": user2["name"],
                    "user_id": user2["id"],
                    "permission": "Read",
                },
            ])
        ```

        ## Import

        Organization Permissions can be imported using the `id` (organization name), e.g.

        ```sh
        $ pulumi import sbercloud:index/swrOrganizationPermissions:SwrOrganizationPermissions test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param SwrOrganizationPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwrOrganizationPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 organization: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwrOrganizationPermissionsUserArgs', 'SwrOrganizationPermissionsUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwrOrganizationPermissionsArgs.__new__(SwrOrganizationPermissionsArgs)

            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["region"] = region
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
            __props__.__dict__["creator"] = None
            __props__.__dict__["self_permissions"] = None
        super(SwrOrganizationPermissions, __self__).__init__(
            'sbercloud:index/swrOrganizationPermissions:SwrOrganizationPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            organization: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            self_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwrOrganizationPermissionsSelfPermissionArgs', 'SwrOrganizationPermissionsSelfPermissionArgsDict']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwrOrganizationPermissionsUserArgs', 'SwrOrganizationPermissionsUserArgsDict']]]]] = None) -> 'SwrOrganizationPermissions':
        """
        Get an existing SwrOrganizationPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creator: The creator user name of the organization.
        :param pulumi.Input[_builtins.str] organization: Specifies the name of the organization (namespace) to be accessed.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwrOrganizationPermissionsSelfPermissionArgs', 'SwrOrganizationPermissionsSelfPermissionArgsDict']]]] self_permissions: The permission informations of current user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwrOrganizationPermissionsUserArgs', 'SwrOrganizationPermissionsUserArgsDict']]]] users: Specifies the users to access to the organization (namespace).
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwrOrganizationPermissionsState.__new__(_SwrOrganizationPermissionsState)

        __props__.__dict__["creator"] = creator
        __props__.__dict__["organization"] = organization
        __props__.__dict__["region"] = region
        __props__.__dict__["self_permissions"] = self_permissions
        __props__.__dict__["users"] = users
        return SwrOrganizationPermissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        The creator user name of the organization.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter
    def organization(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the organization (namespace) to be accessed.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "organization")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfPermissions")
    def self_permissions(self) -> pulumi.Output[Sequence['outputs.SwrOrganizationPermissionsSelfPermission']]:
        """
        The permission informations of current user.
        """
        return pulumi.get(self, "self_permissions")

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence['outputs.SwrOrganizationPermissionsUser']]:
        """
        Specifies the users to access to the organization (namespace).
        Structure is documented below.
        """
        return pulumi.get(self, "users")

