# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AddressGroupIpExtraSetArgs',
    'AddressGroupIpExtraSetArgsDict',
    'BandwidthPublicipArgs',
    'BandwidthPublicipArgsDict',
    'EipBandwidthArgs',
    'EipBandwidthArgsDict',
    'EipPublicipArgs',
    'EipPublicipArgsDict',
    'RouteTableRouteArgs',
    'RouteTableRouteArgsDict',
    'SecgroupRuleArgs',
    'SecgroupRuleArgsDict',
    'VpcRouteArgs',
    'VpcRouteArgsDict',
]

MYPY = False

if not MYPY:
    class AddressGroupIpExtraSetArgsDict(TypedDict):
        ip: pulumi.Input[_builtins.str]
        remarks: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    AddressGroupIpExtraSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AddressGroupIpExtraSetArgs:
    def __init__(__self__, *,
                 ip: pulumi.Input[_builtins.str],
                 remarks: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "ip", ip)
        if remarks is not None:
            pulumi.set(__self__, "remarks", remarks)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "remarks")

    @remarks.setter
    def remarks(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remarks", value)


if not MYPY:
    class BandwidthPublicipArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the EIP or IPv6 port that uses the bandwidth.
        """
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv4 or IPv6 address.
        """
        ip_version: NotRequired[pulumi.Input[_builtins.int]]
        """
        The IP version, either 4 or 6.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The EIP type.
        """
elif False:
    BandwidthPublicipArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BandwidthPublicipArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The ID of the EIP or IPv6 port that uses the bandwidth.
        :param pulumi.Input[_builtins.str] ip_address: The IPv4 or IPv6 address.
        :param pulumi.Input[_builtins.int] ip_version: The IP version, either 4 or 6.
        :param pulumi.Input[_builtins.str] type: The EIP type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the EIP or IPv6 port that uses the bandwidth.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class EipBandwidthArgsDict(TypedDict):
        share_type: pulumi.Input[_builtins.str]
        """
        Whether the bandwidth is dedicated or shared. Changing this creates a new
        eip. Possible values are as follows:
        + *PER*: Dedicated bandwidth
        + *WHOLE*: Shared bandwidth
        """
        charge_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies whether the bandwidth is billed by traffic or by bandwidth
        size. The value can be *traffic* or *bandwidth*. Changing this creates a new eip.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The shared bandwidth id. This parameter is mandatory when
        `share_type` is set to *WHOLE*. Changing this creates a new eip.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to *PER*.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
        when `share_type` is set to *PER*.
        """
elif False:
    EipBandwidthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EipBandwidthArgs:
    def __init__(__self__, *,
                 share_type: pulumi.Input[_builtins.str],
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] share_type: Whether the bandwidth is dedicated or shared. Changing this creates a new
               eip. Possible values are as follows:
               + *PER*: Dedicated bandwidth
               + *WHOLE*: Shared bandwidth
        :param pulumi.Input[_builtins.str] charge_mode: Specifies whether the bandwidth is billed by traffic or by bandwidth
               size. The value can be *traffic* or *bandwidth*. Changing this creates a new eip.
        :param pulumi.Input[_builtins.str] id: The shared bandwidth id. This parameter is mandatory when
               `share_type` is set to *WHOLE*. Changing this creates a new eip.
        :param pulumi.Input[_builtins.str] name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to *PER*.
        :param pulumi.Input[_builtins.int] size: The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
               when `share_type` is set to *PER*.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Input[_builtins.str]:
        """
        Whether the bandwidth is dedicated or shared. Changing this creates a new
        eip. Possible values are as follows:
        + *PER*: Dedicated bandwidth
        + *WHOLE*: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_type", value)

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the bandwidth is billed by traffic or by bandwidth
        size. The value can be *traffic* or *bandwidth*. Changing this creates a new eip.
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_mode", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared bandwidth id. This parameter is mandatory when
        `share_type` is set to *WHOLE*. Changing this creates a new eip.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to *PER*.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
        when `share_type` is set to *PER*.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class EipPublicipArgsDict(TypedDict):
        ip_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The value must be a valid IP address in the available IP address segment.
        Changing this creates a new eip.
        """
        ip_version: NotRequired[pulumi.Input[_builtins.int]]
        """
        The IP version.
        """
        port_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The port id which this eip will associate with. If the value is "" or this not
        specified, the eip will be in unbind state.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of the eip. Changing this creates a new eip.
        """
elif False:
    EipPublicipArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EipPublicipArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_address: The value must be a valid IP address in the available IP address segment.
               Changing this creates a new eip.
        :param pulumi.Input[_builtins.int] ip_version: The IP version.
        :param pulumi.Input[_builtins.str] port_id: The port id which this eip will associate with. If the value is "" or this not
               specified, the eip will be in unbind state.
        :param pulumi.Input[_builtins.str] type: The type of the eip. Changing this creates a new eip.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The value must be a valid IP address in the available IP address segment.
        Changing this creates a new eip.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The IP version.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port id which this eip will associate with. If the value is "" or this not
        specified, the eip will be in unbind state.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the eip. Changing this creates a new eip.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class RouteTableRouteArgsDict(TypedDict):
        destination: pulumi.Input[_builtins.str]
        """
        Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
        with any subnet in the VPC.
        """
        nexthop: pulumi.Input[_builtins.str]
        """
        Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
elif False:
    RouteTableRouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RouteTableRouteArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[_builtins.str],
                 nexthop: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] destination: Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
               with any subnet in the VPC.
        :param pulumi.Input[_builtins.str] nexthop: Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param pulumi.Input[_builtins.str] type: Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
        with any subnet in the VPC.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nexthop", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class SecgroupRuleArgsDict(TypedDict):
        action: NotRequired[pulumi.Input[_builtins.str]]
        """
        The effective policy.
        """
        description: NotRequired[pulumi.Input[_builtins.str]]
        """
        Description of the security group.
        """
        direction: NotRequired[pulumi.Input[_builtins.str]]
        """
        The direction of the rule. The value can be *egress* or *ingress*.
        """
        ethertype: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP protocol version. The value can be *IPv4* or *IPv6*.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The security group rule ID.
        """
        port_range_max: NotRequired[pulumi.Input[_builtins.int]]
        """
        schema: Deprecated
        """
        port_range_min: NotRequired[pulumi.Input[_builtins.int]]
        """
        schema: Deprecated
        """
        ports: NotRequired[pulumi.Input[_builtins.str]]
        """
        The port value range.
        """
        priority: NotRequired[pulumi.Input[_builtins.int]]
        """
        The priority number.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol type.
        """
        remote_address_group_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the remote address group.
        """
        remote_group_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the peer security group.
        """
        remote_ip_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        The remote IP address. The value can be in the CIDR format or IP addresses.
        """
elif False:
    SecgroupRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecgroupRuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 ethertype: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_range_max: Optional[pulumi.Input[_builtins.int]] = None,
                 port_range_min: Optional[pulumi.Input[_builtins.int]] = None,
                 ports: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_address_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_ip_prefix: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: The effective policy.
        :param pulumi.Input[_builtins.str] description: Description of the security group.
        :param pulumi.Input[_builtins.str] direction: The direction of the rule. The value can be *egress* or *ingress*.
        :param pulumi.Input[_builtins.str] ethertype: The IP protocol version. The value can be *IPv4* or *IPv6*.
        :param pulumi.Input[_builtins.str] id: The security group rule ID.
        :param pulumi.Input[_builtins.int] port_range_max: schema: Deprecated
        :param pulumi.Input[_builtins.int] port_range_min: schema: Deprecated
        :param pulumi.Input[_builtins.str] ports: The port value range.
        :param pulumi.Input[_builtins.int] priority: The priority number.
        :param pulumi.Input[_builtins.str] protocol: The protocol type.
        :param pulumi.Input[_builtins.str] remote_address_group_id: The ID of the remote address group.
        :param pulumi.Input[_builtins.str] remote_group_id: The ID of the peer security group.
        :param pulumi.Input[_builtins.str] remote_ip_prefix: The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ethertype is not None:
            pulumi.set(__self__, "ethertype", ethertype)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port_range_max is not None:
            pulumi.set(__self__, "port_range_max", port_range_max)
        if port_range_min is not None:
            pulumi.set(__self__, "port_range_min", port_range_min)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_address_group_id is not None:
            pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        if remote_group_id is not None:
            pulumi.set(__self__, "remote_group_id", remote_group_id)
        if remote_ip_prefix is not None:
            pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The effective policy.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the security group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction of the rule. The value can be *egress* or *ingress*.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def ethertype(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP protocol version. The value can be *IPv4* or *IPv6*.
        """
        return pulumi.get(self, "ethertype")

    @ethertype.setter
    def ethertype(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ethertype", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "port_range_max")

    @port_range_max.setter
    def port_range_max(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port_range_max", value)

    @_builtins.property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "port_range_min")

    @port_range_min.setter
    def port_range_min(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port_range_min", value)

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port value range.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ports", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority number.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the remote address group.
        """
        return pulumi.get(self, "remote_address_group_id")

    @remote_address_group_id.setter
    def remote_address_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_address_group_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the peer security group.
        """
        return pulumi.get(self, "remote_group_id")

    @remote_group_id.setter
    def remote_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_group_id", value)

    @_builtins.property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        return pulumi.get(self, "remote_ip_prefix")

    @remote_ip_prefix.setter
    def remote_ip_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_ip_prefix", value)


if not MYPY:
    class VpcRouteArgsDict(TypedDict):
        destination: NotRequired[pulumi.Input[_builtins.str]]
        nexthop: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    VpcRouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcRouteArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 nexthop: Optional[pulumi.Input[_builtins.str]] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "nexthop")

    @nexthop.setter
    def nexthop(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nexthop", value)


