# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AddressGroupArgs', 'AddressGroup']

@pulumi.input_type
class AddressGroupArgs:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_extra_sets: Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpExtraSetArgs']]]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AddressGroup resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: Specifies an array of one or more IP addresses. The address can be a single IP
               address, IP address range or IP address CIDR. The maximum length is 20.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this creates a new address group.
        :param pulumi.Input[_builtins.str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if ip_extra_sets is not None:
            pulumi.set(__self__, "ip_extra_sets", ip_extra_sets)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more IP addresses. The address can be a single IP
        address, IP address range or IP address CIDR. The maximum length is 20.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "addresses", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the IP address group.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="ipExtraSets")
    def ip_extra_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpExtraSetArgs']]]]:
        return pulumi.get(self, "ip_extra_sets")

    @ip_extra_sets.setter
    def ip_extra_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpExtraSetArgs']]]]):
        pulumi.set(self, "ip_extra_sets", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IP version, either `4` (default) or `6`.
        Changing this creates a new address group.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), hyphens (-) and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the IP address group. If omitted, the
        provider-level region will be used. Changing this creates a new address group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AddressGroupState:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_extra_sets: Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpExtraSetArgs']]]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AddressGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: Specifies an array of one or more IP addresses. The address can be a single IP
               address, IP address range or IP address CIDR. The maximum length is 20.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this creates a new address group.
        :param pulumi.Input[_builtins.str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if ip_extra_sets is not None:
            pulumi.set(__self__, "ip_extra_sets", ip_extra_sets)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more IP addresses. The address can be a single IP
        address, IP address range or IP address CIDR. The maximum length is 20.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "addresses", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supplementary information about the IP address group.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="ipExtraSets")
    def ip_extra_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpExtraSetArgs']]]]:
        return pulumi.get(self, "ip_extra_sets")

    @ip_extra_sets.setter
    def ip_extra_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AddressGroupIpExtraSetArgs']]]]):
        pulumi.set(self, "ip_extra_sets", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the IP version, either `4` (default) or `6`.
        Changing this creates a new address group.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), hyphens (-) and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the IP address group. If omitted, the
        provider-level region will be used. Changing this creates a new address group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Vpc/addressGroup:AddressGroup")
class AddressGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_extra_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpExtraSetArgs', 'AddressGroupIpExtraSetArgsDict']]]]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPC IP address group resource within SberCloud.

        ## Example Usage

        ### IPv4 Address Group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        ipv4 = sbercloud.vpc.AddressGroup("ipv4",
            name="group-ipv4",
            addresses=[
                "192.168.10.10",
                "192.168.1.1-192.168.1.50",
            ])
        ```

        ### IPv6 Address Group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        ipv6 = sbercloud.vpc.AddressGroup("ipv6",
            name="group-ipv6",
            ip_version=6,
            addresses=["2001:db8:a583:6e::/64"])
        ```

        ## Import

        IP address groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/addressGroup:AddressGroup test bc96f6b0-ca2c-42ee-b719-0f26bc9c8661
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: Specifies an array of one or more IP addresses. The address can be a single IP
               address, IP address range or IP address CIDR. The maximum length is 20.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this creates a new address group.
        :param pulumi.Input[_builtins.str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AddressGroupArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC IP address group resource within SberCloud.

        ## Example Usage

        ### IPv4 Address Group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        ipv4 = sbercloud.vpc.AddressGroup("ipv4",
            name="group-ipv4",
            addresses=[
                "192.168.10.10",
                "192.168.1.1-192.168.1.50",
            ])
        ```

        ### IPv6 Address Group

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        ipv6 = sbercloud.vpc.AddressGroup("ipv6",
            name="group-ipv6",
            ip_version=6,
            addresses=["2001:db8:a583:6e::/64"])
        ```

        ## Import

        IP address groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/addressGroup:AddressGroup test bc96f6b0-ca2c-42ee-b719-0f26bc9c8661
        ```

        :param str resource_name: The name of the resource.
        :param AddressGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddressGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_extra_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpExtraSetArgs', 'AddressGroupIpExtraSetArgsDict']]]]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddressGroupArgs.__new__(AddressGroupArgs)

            __props__.__dict__["addresses"] = addresses
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["ip_extra_sets"] = ip_extra_sets
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["max_capacity"] = max_capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
        super(AddressGroup, __self__).__init__(
            'sbercloud:Vpc/addressGroup:AddressGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_extra_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AddressGroupIpExtraSetArgs', 'AddressGroupIpExtraSetArgsDict']]]]] = None,
            ip_version: Optional[pulumi.Input[_builtins.int]] = None,
            max_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'AddressGroup':
        """
        Get an existing AddressGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: Specifies an array of one or more IP addresses. The address can be a single IP
               address, IP address range or IP address CIDR. The maximum length is 20.
        :param pulumi.Input[_builtins.str] description: Specifies the supplementary information about the IP address group.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[_builtins.int] ip_version: Specifies the IP version, either `4` (default) or `6`.
               Changing this creates a new address group.
        :param pulumi.Input[_builtins.str] name: Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
               letters, digits, underscores (_), hyphens (-) and periods (.).
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the IP address group. If omitted, the
               provider-level region will be used. Changing this creates a new address group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddressGroupState.__new__(_AddressGroupState)

        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["ip_extra_sets"] = ip_extra_sets
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["max_capacity"] = max_capacity
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return AddressGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies an array of one or more IP addresses. The address can be a single IP
        address, IP address range or IP address CIDR. The maximum length is 20.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the supplementary information about the IP address group.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="ipExtraSets")
    def ip_extra_sets(self) -> pulumi.Output[Sequence['outputs.AddressGroupIpExtraSet']]:
        return pulumi.get(self, "ip_extra_sets")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the IP version, either `4` (default) or `6`.
        Changing this creates a new address group.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IP address group name. The value is a string of 1 to 64 characters that can contain
        letters, digits, underscores (_), hyphens (-) and periods (.).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the IP address group. If omitted, the
        provider-level region will be used. Changing this creates a new address group.
        """
        return pulumi.get(self, "region")

