# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BandwidthArgs', 'Bandwidth']

@pulumi.input_type
class BandwidthArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[_builtins.int],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Bandwidth resource.
        :param pulumi.Input[_builtins.int] size: The size of the Shared Bandwidth. The value ranges from 5 to 2000 G.
        :param pulumi.Input[_builtins.str] bandwidth_type: Indicates the bandwidth type.
        :param pulumi.Input[_builtins.str] charge_mode: Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the Shared Bandwidth. Changing
               this creates a new bandwidth.
        :param pulumi.Input[_builtins.str] name: The name of the Shared Bandwidth.
        :param pulumi.Input[_builtins.str] region: The region in which to create the Shared Bandwidth. If omitted, the
               provider-level region will be used. Changing this creates a new Shared Bandwidth resource.
        """
        pulumi.set(__self__, "size", size)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_border_group is not None:
            pulumi.set(__self__, "public_border_group", public_border_group)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the Shared Bandwidth. The value ranges from 5 to 2000 G.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the bandwidth type.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_type", value)

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_mode", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the Shared Bandwidth. Changing
        this creates a new bandwidth.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Shared Bandwidth.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_border_group")

    @public_border_group.setter
    def public_border_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_border_group", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the Shared Bandwidth. If omitted, the
        provider-level region will be used. Changing this creates a new Shared Bandwidth resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BandwidthState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 publicips: Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_type: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Bandwidth resources.
        :param pulumi.Input[_builtins.str] bandwidth_type: Indicates the bandwidth type.
        :param pulumi.Input[_builtins.str] charge_mode: Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the Shared Bandwidth. Changing
               this creates a new bandwidth.
        :param pulumi.Input[_builtins.str] name: The name of the Shared Bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]] publicips: An array of EIPs that use the bandwidth. The object includes the following:
        :param pulumi.Input[_builtins.str] region: The region in which to create the Shared Bandwidth. If omitted, the
               provider-level region will be used. Changing this creates a new Shared Bandwidth resource.
        :param pulumi.Input[_builtins.str] share_type: Indicates whether the bandwidth is shared or dedicated.
        :param pulumi.Input[_builtins.int] size: The size of the Shared Bandwidth. The value ranges from 5 to 2000 G.
        :param pulumi.Input[_builtins.str] status: Indicates the bandwidth status.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bandwidth_type is not None:
            pulumi.set(__self__, "bandwidth_type", bandwidth_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_border_group is not None:
            pulumi.set(__self__, "public_border_group", public_border_group)
        if publicips is not None:
            pulumi.set(__self__, "publicips", publicips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the bandwidth type.
        """
        return pulumi.get(self, "bandwidth_type")

    @bandwidth_type.setter
    def bandwidth_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_type", value)

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_mode", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the Shared Bandwidth. Changing
        this creates a new bandwidth.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Shared Bandwidth.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_border_group")

    @public_border_group.setter
    def public_border_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_border_group", value)

    @_builtins.property
    @pulumi.getter
    def publicips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]]]:
        """
        An array of EIPs that use the bandwidth. The object includes the following:
        """
        return pulumi.get(self, "publicips")

    @publicips.setter
    def publicips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPublicipArgs']]]]):
        pulumi.set(self, "publicips", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the Shared Bandwidth. If omitted, the
        provider-level region will be used. Changing this creates a new Shared Bandwidth resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the bandwidth is shared or dedicated.
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_type", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the Shared Bandwidth. The value ranges from 5 to 2000 G.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the bandwidth status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Vpc/bandwidth:Bandwidth")
class Bandwidth(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Shared Bandwidth resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bandwidth1 = sbercloud.vpc.Bandwidth("bandwidth_1",
            name="bandwidth_1",
            size=5)
        ```

        ## Import

        Shared Bandwidths can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/bandwidth:Bandwidth bandwidth_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth_type: Indicates the bandwidth type.
        :param pulumi.Input[_builtins.str] charge_mode: Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the Shared Bandwidth. Changing
               this creates a new bandwidth.
        :param pulumi.Input[_builtins.str] name: The name of the Shared Bandwidth.
        :param pulumi.Input[_builtins.str] region: The region in which to create the Shared Bandwidth. If omitted, the
               provider-level region will be used. Changing this creates a new Shared Bandwidth resource.
        :param pulumi.Input[_builtins.int] size: The size of the Shared Bandwidth. The value ranges from 5 to 2000 G.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BandwidthArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Shared Bandwidth resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bandwidth1 = sbercloud.vpc.Bandwidth("bandwidth_1",
            name="bandwidth_1",
            size=5)
        ```

        ## Import

        Shared Bandwidths can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/bandwidth:Bandwidth bandwidth_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param BandwidthArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BandwidthArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BandwidthArgs.__new__(BandwidthArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["bandwidth_type"] = bandwidth_type
            __props__.__dict__["charge_mode"] = charge_mode
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["public_border_group"] = public_border_group
            __props__.__dict__["region"] = region
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["created_at"] = None
            __props__.__dict__["publicips"] = None
            __props__.__dict__["share_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(Bandwidth, __self__).__init__(
            'sbercloud:Vpc/bandwidth:Bandwidth',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth_type: Optional[pulumi.Input[_builtins.str]] = None,
            charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            public_border_group: Optional[pulumi.Input[_builtins.str]] = None,
            publicips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BandwidthPublicipArgs', 'BandwidthPublicipArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            share_type: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Bandwidth':
        """
        Get an existing Bandwidth resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth_type: Indicates the bandwidth type.
        :param pulumi.Input[_builtins.str] charge_mode: Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the Shared Bandwidth. Changing
               this creates a new bandwidth.
        :param pulumi.Input[_builtins.str] name: The name of the Shared Bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BandwidthPublicipArgs', 'BandwidthPublicipArgsDict']]]] publicips: An array of EIPs that use the bandwidth. The object includes the following:
        :param pulumi.Input[_builtins.str] region: The region in which to create the Shared Bandwidth. If omitted, the
               provider-level region will be used. Changing this creates a new Shared Bandwidth resource.
        :param pulumi.Input[_builtins.str] share_type: Indicates whether the bandwidth is shared or dedicated.
        :param pulumi.Input[_builtins.int] size: The size of the Shared Bandwidth. The value ranges from 5 to 2000 G.
        :param pulumi.Input[_builtins.str] status: Indicates the bandwidth status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BandwidthState.__new__(_BandwidthState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["bandwidth_type"] = bandwidth_type
        __props__.__dict__["charge_mode"] = charge_mode
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["public_border_group"] = public_border_group
        __props__.__dict__["publicips"] = publicips
        __props__.__dict__["region"] = region
        __props__.__dict__["share_type"] = share_type
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        return Bandwidth(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="bandwidthType")
    def bandwidth_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the bandwidth type.
        """
        return pulumi.get(self, "bandwidth_type")

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether the billing is based on traffic, bandwidth, or 95th percentile bandwidth (enhanced).
        """
        return pulumi.get(self, "charge_mode")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the Shared Bandwidth. Changing
        this creates a new bandwidth.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Shared Bandwidth.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="publicBorderGroup")
    def public_border_group(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "public_border_group")

    @_builtins.property
    @pulumi.getter
    def publicips(self) -> pulumi.Output[Sequence['outputs.BandwidthPublicip']]:
        """
        An array of EIPs that use the bandwidth. The object includes the following:
        """
        return pulumi.get(self, "publicips")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the Shared Bandwidth. If omitted, the
        provider-level region will be used. Changing this creates a new Shared Bandwidth resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates whether the bandwidth is shared or dedicated.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the Shared Bandwidth. The value ranges from 5 to 2000 G.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the bandwidth status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

