# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EipArgs', 'Eip']

@pulumi.input_type
class EipArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input['EipBandwidthArgs'],
                 publicip: pulumi.Input['EipPublicipArgs'],
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Eip resource.
        :param pulumi.Input['EipBandwidthArgs'] bandwidth: The bandwidth object.
        :param pulumi.Input['EipPublicipArgs'] publicip: The elastic IP address object.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[_builtins.str] name: The name of the EIP.
        :param pulumi.Input[_builtins.str] region: The region in which to create the eip resource. If omitted, the provider-level
               region will be used. Changing this creates a new eip resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "publicip", publicip)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input['EipBandwidthArgs']:
        """
        The bandwidth object.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input['EipBandwidthArgs']):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter
    def publicip(self) -> pulumi.Input['EipPublicipArgs']:
        """
        The elastic IP address object.
        """
        return pulumi.get(self, "publicip")

    @publicip.setter
    def publicip(self, value: pulumi.Input['EipPublicipArgs']):
        pulumi.set(self, "publicip", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the elastic IP. Changing this
        creates a new eip.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the eip resource. If omitted, the provider-level
        region will be used. Changing this creates a new eip resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the elastic IP.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EipState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 associate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 associate_type: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input['EipBandwidthArgs']] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip: Optional[pulumi.Input['EipPublicipArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Eip resources.
        :param pulumi.Input[_builtins.str] address: The IP address of the eip.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input['EipBandwidthArgs'] bandwidth: The bandwidth object.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[_builtins.str] ipv6_address: The IPv6 address of the EIP.
        :param pulumi.Input[_builtins.str] name: The name of the EIP.
        :param pulumi.Input[_builtins.str] port_id: The port ID which the EIP associated with.
        :param pulumi.Input[_builtins.str] private_ip: The private IP address bound to the EIP.
        :param pulumi.Input['EipPublicipArgs'] publicip: The elastic IP address object.
        :param pulumi.Input[_builtins.str] region: The region in which to create the eip resource. If omitted, the provider-level
               region will be used. Changing this creates a new eip resource.
        :param pulumi.Input[_builtins.str] status: The status of eip.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if associate_id is not None:
            pulumi.set(__self__, "associate_id", associate_id)
        if associate_type is not None:
            pulumi.set(__self__, "associate_type", associate_type)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if publicip is not None:
            pulumi.set(__self__, "publicip", publicip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address of the eip.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter(name="associateId")
    def associate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "associate_id")

    @associate_id.setter
    def associate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associate_id", value)

    @_builtins.property
    @pulumi.getter(name="associateType")
    def associate_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "associate_type")

    @associate_type.setter
    def associate_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "associate_type", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['EipBandwidthArgs']]:
        """
        The bandwidth object.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['EipBandwidthArgs']]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the elastic IP. Changing this
        creates a new eip.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address of the EIP.
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port ID which the EIP associated with.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address bound to the EIP.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter
    def publicip(self) -> Optional[pulumi.Input['EipPublicipArgs']]:
        """
        The elastic IP address object.
        """
        return pulumi.get(self, "publicip")

    @publicip.setter
    def publicip(self, value: Optional[pulumi.Input['EipPublicipArgs']]):
        pulumi.set(self, "publicip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the eip resource. If omitted, the provider-level
        region will be used. Changing this creates a new eip resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of eip.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the elastic IP.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Vpc/eip:Eip")
class Eip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[Union['EipBandwidthArgs', 'EipBandwidthArgsDict']]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip: Optional[pulumi.Input[Union['EipPublicipArgs', 'EipPublicipArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an EIP resource within SberCloud.

        ## Example Usage

        ### EIP with Dedicated Bandwidth

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        eip1 = sbercloud.vpc.Eip("eip_1",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "share_type": "PER",
                "name": "test",
                "size": 10,
                "charge_mode": "traffic",
            })
        ```

        ### EIP with Shared Bandwidth

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bandwidth1 = sbercloud.vpc.Bandwidth("bandwidth_1",
            name="bandwidth_1",
            size=5)
        eip1 = sbercloud.vpc.Eip("eip_1",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "share_type": "WHOLE",
                "id": bandwidth1.id,
            })
        ```

        ## Import

        EIPs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/eip:Eip eip_1 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[Union['EipBandwidthArgs', 'EipBandwidthArgsDict']] bandwidth: The bandwidth object.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[_builtins.str] name: The name of the EIP.
        :param pulumi.Input[Union['EipPublicipArgs', 'EipPublicipArgsDict']] publicip: The elastic IP address object.
        :param pulumi.Input[_builtins.str] region: The region in which to create the eip resource. If omitted, the provider-level
               region will be used. Changing this creates a new eip resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an EIP resource within SberCloud.

        ## Example Usage

        ### EIP with Dedicated Bandwidth

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        eip1 = sbercloud.vpc.Eip("eip_1",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "share_type": "PER",
                "name": "test",
                "size": 10,
                "charge_mode": "traffic",
            })
        ```

        ### EIP with Shared Bandwidth

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        bandwidth1 = sbercloud.vpc.Bandwidth("bandwidth_1",
            name="bandwidth_1",
            size=5)
        eip1 = sbercloud.vpc.Eip("eip_1",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "share_type": "WHOLE",
                "id": bandwidth1.id,
            })
        ```

        ## Import

        EIPs can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/eip:Eip eip_1 2c7f39f3-702b-48d1-940c-b50384177ee1
        ```

        :param str resource_name: The name of the resource.
        :param EipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[Union['EipBandwidthArgs', 'EipBandwidthArgsDict']]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip: Optional[pulumi.Input[Union['EipPublicipArgs', 'EipPublicipArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipArgs.__new__(EipArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if bandwidth is None and not opts.urn:
                raise TypeError("Missing required property 'bandwidth'")
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            if publicip is None and not opts.urn:
                raise TypeError("Missing required property 'publicip'")
            __props__.__dict__["publicip"] = publicip
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["address"] = None
            __props__.__dict__["associate_id"] = None
            __props__.__dict__["associate_type"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["instance_type"] = None
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["port_id"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(Eip, __self__).__init__(
            'sbercloud:Vpc/eip:Eip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[_builtins.str]] = None,
            associate_id: Optional[pulumi.Input[_builtins.str]] = None,
            associate_type: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[Union['EipBandwidthArgs', 'EipBandwidthArgsDict']]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            port_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            publicip: Optional[pulumi.Input[Union['EipPublicipArgs', 'EipPublicipArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Eip':
        """
        Get an existing Eip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address: The IP address of the eip.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "
               false". Changing this creates a new resource.
        :param pulumi.Input[Union['EipBandwidthArgs', 'EipBandwidthArgsDict']] bandwidth: The bandwidth object.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the elastic IP. Changing this
               creates a new eip.
        :param pulumi.Input[_builtins.str] ipv6_address: The IPv6 address of the EIP.
        :param pulumi.Input[_builtins.str] name: The name of the EIP.
        :param pulumi.Input[_builtins.str] port_id: The port ID which the EIP associated with.
        :param pulumi.Input[_builtins.str] private_ip: The private IP address bound to the EIP.
        :param pulumi.Input[Union['EipPublicipArgs', 'EipPublicipArgsDict']] publicip: The elastic IP address object.
        :param pulumi.Input[_builtins.str] region: The region in which to create the eip resource. If omitted, the provider-level
               region will be used. Changing this creates a new eip resource.
        :param pulumi.Input[_builtins.str] status: The status of eip.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the elastic IP.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipState.__new__(_EipState)

        __props__.__dict__["address"] = address
        __props__.__dict__["associate_id"] = associate_id
        __props__.__dict__["associate_type"] = associate_type
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["publicip"] = publicip
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        return Eip(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def address(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address of the eip.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="associateId")
    def associate_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "associate_id")

    @_builtins.property
    @pulumi.getter(name="associateType")
    def associate_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "associate_type")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "
        false". Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output['outputs.EipBandwidth']:
        """
        The bandwidth object.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the elastic IP. Changing this
        creates a new eip.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[_builtins.str]:
        """
        The IPv6 address of the EIP.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[_builtins.str]:
        """
        The port ID which the EIP associated with.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The private IP address bound to the EIP.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter
    def publicip(self) -> pulumi.Output['outputs.EipPublicip']:
        """
        The elastic IP address object.
        """
        return pulumi.get(self, "publicip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the eip resource. If omitted, the provider-level
        region will be used. Changing this creates a new eip resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of eip.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the elastic IP.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

