# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddressGroupsResult',
    'AwaitableGetAddressGroupsResult',
    'get_address_groups',
    'get_address_groups_output',
]

@pulumi.output_type
class GetAddressGroupsResult:
    """
    A collection of values returned by getAddressGroups.
    """
    def __init__(__self__, address_groups=None, description=None, group_id=None, id=None, ip_version=None, name=None, region=None):
        if address_groups and not isinstance(address_groups, list):
            raise TypeError("Expected argument 'address_groups' to be a list")
        pulumi.set(__self__, "address_groups", address_groups)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="addressGroups")
    def address_groups(self) -> Sequence['outputs.GetAddressGroupsAddressGroupResult']:
        """
        The IP address groups.
        """
        return pulumi.get(self, "address_groups")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The supplementary information about the IP address group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.int]:
        """
        Whether it is an IPv4 or IPv6 address group.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        IP address group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetAddressGroupsResult(GetAddressGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressGroupsResult(
            address_groups=self.address_groups,
            description=self.description,
            group_id=self.group_id,
            id=self.id,
            ip_version=self.ip_version,
            name=self.name,
            region=self.region)


def get_address_groups(description: Optional[_builtins.str] = None,
                       group_id: Optional[_builtins.str] = None,
                       ip_version: Optional[_builtins.int] = None,
                       name: Optional[_builtins.str] = None,
                       region: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressGroupsResult:
    """
    Use this data source to get a list of VPC IP address groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    demo1 = sbercloud.Vpc.get_address_groups()
    ```


    :param _builtins.str description: Provides supplementary information about an IP address group,
           which can be used to filter the IP address group.
    :param _builtins.str group_id: Unique ID of an IP address group, which can be used to filter the IP address group.
    :param _builtins.int ip_version: Version of IP addresses in an IP address group,
           which can be used to filter the IP address group.
    :param _builtins.str name: Name of an IP address group, which can be used to filter the IP address group.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['groupId'] = group_id
    __args__['ipVersion'] = ip_version
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getAddressGroups:getAddressGroups', __args__, opts=opts, typ=GetAddressGroupsResult).value

    return AwaitableGetAddressGroupsResult(
        address_groups=pulumi.get(__ret__, 'address_groups'),
        description=pulumi.get(__ret__, 'description'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'))
def get_address_groups_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              group_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              ip_version: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                              name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressGroupsResult]:
    """
    Use this data source to get a list of VPC IP address groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    demo1 = sbercloud.Vpc.get_address_groups()
    ```


    :param _builtins.str description: Provides supplementary information about an IP address group,
           which can be used to filter the IP address group.
    :param _builtins.str group_id: Unique ID of an IP address group, which can be used to filter the IP address group.
    :param _builtins.int ip_version: Version of IP addresses in an IP address group,
           which can be used to filter the IP address group.
    :param _builtins.str name: Name of an IP address group, which can be used to filter the IP address group.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['groupId'] = group_id
    __args__['ipVersion'] = ip_version
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getAddressGroups:getAddressGroups', __args__, opts=opts, typ=GetAddressGroupsResult)
    return __ret__.apply(lambda __response__: GetAddressGroupsResult(
        address_groups=pulumi.get(__response__, 'address_groups'),
        description=pulumi.get(__response__, 'description'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        ip_version=pulumi.get(__response__, 'ip_version'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region')))
