# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPeeringConnectionResult',
    'AwaitableGetPeeringConnectionResult',
    'get_peering_connection',
    'get_peering_connection_output',
]

@pulumi.output_type
class GetPeeringConnectionResult:
    """
    A collection of values returned by getPeeringConnection.
    """
    def __init__(__self__, description=None, id=None, name=None, peer_tenant_id=None, peer_vpc_id=None, region=None, status=None, vpc_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if peer_tenant_id and not isinstance(peer_tenant_id, str):
            raise TypeError("Expected argument 'peer_tenant_id' to be a str")
        pulumi.set(__self__, "peer_tenant_id", peer_tenant_id)
        if peer_vpc_id and not isinstance(peer_vpc_id, str):
            raise TypeError("Expected argument 'peer_vpc_id' to be a str")
        pulumi.set(__self__, "peer_vpc_id", peer_vpc_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerTenantId")
    def peer_tenant_id(self) -> _builtins.str:
        return pulumi.get(self, "peer_tenant_id")

    @_builtins.property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> _builtins.str:
        return pulumi.get(self, "peer_vpc_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetPeeringConnectionResult(GetPeeringConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPeeringConnectionResult(
            description=self.description,
            id=self.id,
            name=self.name,
            peer_tenant_id=self.peer_tenant_id,
            peer_vpc_id=self.peer_vpc_id,
            region=self.region,
            status=self.status,
            vpc_id=self.vpc_id)


def get_peering_connection(id: Optional[_builtins.str] = None,
                           name: Optional[_builtins.str] = None,
                           peer_tenant_id: Optional[_builtins.str] = None,
                           peer_vpc_id: Optional[_builtins.str] = None,
                           region: Optional[_builtins.str] = None,
                           status: Optional[_builtins.str] = None,
                           vpc_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPeeringConnectionResult:
    """
    The VPC Peering Connection data source provides details about a specific VPC peering connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    vpc = sbercloud.Vpc.get_vpc(name="vpc")
    peer_vpc = sbercloud.Vpc.get_vpc(name="peer_vpc")
    peering = sbercloud.Vpc.get_peering_connection(vpc_id=vpc.id,
        peer_vpc_id=peer_vpc.id)
    vpc_route = sbercloud.vpc.Route("vpc_route",
        type="peering",
        nexthop=peering.id,
        destination="192.168.0.0/16",
        vpc_id=vpc.id)
    ```


    :param _builtins.str id: The ID of the specific VPC Peering Connection to retrieve.
    :param _builtins.str name: The name of the specific VPC Peering Connection to retrieve.
    :param _builtins.str peer_tenant_id: The Tenant ID of the accepter/peer VPC of the specific VPC Peering Connection to
           retrieve.
    :param _builtins.str peer_vpc_id: The ID of the accepter/peer VPC of the specific VPC Peering Connection to retrieve.
    :param _builtins.str region: The region in which to obtain the VPC Peering Connection. If omitted, the provider-level
           region will be used.
    :param _builtins.str status: The status of the specific VPC Peering Connection to retrieve.
    :param _builtins.str vpc_id: The ID of the requester VPC of the specific VPC Peering Connection to retrieve.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['peerTenantId'] = peer_tenant_id
    __args__['peerVpcId'] = peer_vpc_id
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getPeeringConnection:getPeeringConnection', __args__, opts=opts, typ=GetPeeringConnectionResult).value

    return AwaitableGetPeeringConnectionResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        peer_tenant_id=pulumi.get(__ret__, 'peer_tenant_id'),
        peer_vpc_id=pulumi.get(__ret__, 'peer_vpc_id'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_peering_connection_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  peer_tenant_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  peer_vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPeeringConnectionResult]:
    """
    The VPC Peering Connection data source provides details about a specific VPC peering connection.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    vpc = sbercloud.Vpc.get_vpc(name="vpc")
    peer_vpc = sbercloud.Vpc.get_vpc(name="peer_vpc")
    peering = sbercloud.Vpc.get_peering_connection(vpc_id=vpc.id,
        peer_vpc_id=peer_vpc.id)
    vpc_route = sbercloud.vpc.Route("vpc_route",
        type="peering",
        nexthop=peering.id,
        destination="192.168.0.0/16",
        vpc_id=vpc.id)
    ```


    :param _builtins.str id: The ID of the specific VPC Peering Connection to retrieve.
    :param _builtins.str name: The name of the specific VPC Peering Connection to retrieve.
    :param _builtins.str peer_tenant_id: The Tenant ID of the accepter/peer VPC of the specific VPC Peering Connection to
           retrieve.
    :param _builtins.str peer_vpc_id: The ID of the accepter/peer VPC of the specific VPC Peering Connection to retrieve.
    :param _builtins.str region: The region in which to obtain the VPC Peering Connection. If omitted, the provider-level
           region will be used.
    :param _builtins.str status: The status of the specific VPC Peering Connection to retrieve.
    :param _builtins.str vpc_id: The ID of the requester VPC of the specific VPC Peering Connection to retrieve.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['peerTenantId'] = peer_tenant_id
    __args__['peerVpcId'] = peer_vpc_id
    __args__['region'] = region
    __args__['status'] = status
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getPeeringConnection:getPeeringConnection', __args__, opts=opts, typ=GetPeeringConnectionResult)
    return __ret__.apply(lambda __response__: GetPeeringConnectionResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        peer_tenant_id=pulumi.get(__response__, 'peer_tenant_id'),
        peer_vpc_id=pulumi.get(__response__, 'peer_vpc_id'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
