# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouteTableResult',
    'AwaitableGetRouteTableResult',
    'get_route_table',
    'get_route_table_output',
]

@pulumi.output_type
class GetRouteTableResult:
    """
    A collection of values returned by getRouteTable.
    """
    def __init__(__self__, default=None, description=None, id=None, name=None, region=None, routes=None, subnets=None, vpc_id=None):
        if default and not isinstance(default, bool):
            raise TypeError("Expected argument 'default' to be a bool")
        pulumi.set(__self__, "default", default)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def default(self) -> _builtins.bool:
        """
        (Bool) - Whether the route table is default or not.
        """
        return pulumi.get(self, "default")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (String) - The description about the route.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetRouteTableRouteResult']:
        """
        (List) - The route object list. The route object is documented below.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence[_builtins.str]:
        """
        (List) - An array of one or more subnets associating with the route table.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetRouteTableResult(GetRouteTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteTableResult(
            default=self.default,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            routes=self.routes,
            subnets=self.subnets,
            vpc_id=self.vpc_id)


def get_route_table(id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    vpc_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteTableResult:
    """
    Provides details about a specific VPC route table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    vpc_id = config.require_object("vpcId")
    # get the default route table
    default = sbercloud.Vpc.get_route_table(vpc_id=vpc_id)
    # get a custom route table
    custom = sbercloud.Vpc.get_route_table(vpc_id=vpc_id,
        name="demo")
    ```


    :param _builtins.str id: Specifies the ID of the route table.
    :param _builtins.str name: Specifies the name of the route table.
    :param _builtins.str region: The region in which to query the vpc route table.
           If omitted, the provider-level region will be used.
    :param _builtins.str vpc_id: Specifies the VPC ID where the route table resides.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getRouteTable:getRouteTable', __args__, opts=opts, typ=GetRouteTableResult).value

    return AwaitableGetRouteTableResult(
        default=pulumi.get(__ret__, 'default'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        routes=pulumi.get(__ret__, 'routes'),
        subnets=pulumi.get(__ret__, 'subnets'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_route_table_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRouteTableResult]:
    """
    Provides details about a specific VPC route table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    vpc_id = config.require_object("vpcId")
    # get the default route table
    default = sbercloud.Vpc.get_route_table(vpc_id=vpc_id)
    # get a custom route table
    custom = sbercloud.Vpc.get_route_table(vpc_id=vpc_id,
        name="demo")
    ```


    :param _builtins.str id: Specifies the ID of the route table.
    :param _builtins.str name: Specifies the name of the route table.
    :param _builtins.str region: The region in which to query the vpc route table.
           If omitted, the provider-level region will be used.
    :param _builtins.str vpc_id: Specifies the VPC ID where the route table resides.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getRouteTable:getRouteTable', __args__, opts=opts, typ=GetRouteTableResult)
    return __ret__.apply(lambda __response__: GetRouteTableResult(
        default=pulumi.get(__response__, 'default'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        routes=pulumi.get(__response__, 'routes'),
        subnets=pulumi.get(__response__, 'subnets'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
