# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRoutesResult',
    'AwaitableGetRoutesResult',
    'get_routes',
    'get_routes_output',
]

@pulumi.output_type
class GetRoutesResult:
    """
    A collection of values returned by getRoutes.
    """
    def __init__(__self__, destination=None, id=None, region=None, routes=None, type=None, vpc_id=None):
        if destination and not isinstance(destination, str):
            raise TypeError("Expected argument 'destination' to be a str")
        pulumi.set(__self__, "destination", destination)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        The route destination.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetRoutesRouteResult']:
        """
        The list of routes.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The route type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC to which the route belongs.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetRoutesResult(GetRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRoutesResult(
            destination=self.destination,
            id=self.id,
            region=self.region,
            routes=self.routes,
            type=self.type,
            vpc_id=self.vpc_id)


def get_routes(destination: Optional[_builtins.str] = None,
               region: Optional[_builtins.str] = None,
               type: Optional[_builtins.str] = None,
               vpc_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRoutesResult:
    """
    Use this data source to get the list of VPC routes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Vpc.get_routes(type="peering")
    ```


    :param _builtins.str destination: Specifies the route destination.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the route type.
    :param _builtins.str vpc_id: Specifies the ID of the VPC to which the route belongs.
    """
    __args__ = dict()
    __args__['destination'] = destination
    __args__['region'] = region
    __args__['type'] = type
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getRoutes:getRoutes', __args__, opts=opts, typ=GetRoutesResult).value

    return AwaitableGetRoutesResult(
        destination=pulumi.get(__ret__, 'destination'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        routes=pulumi.get(__ret__, 'routes'),
        type=pulumi.get(__ret__, 'type'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_routes_output(destination: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRoutesResult]:
    """
    Use this data source to get the list of VPC routes.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    test = sbercloud.Vpc.get_routes(type="peering")
    ```


    :param _builtins.str destination: Specifies the route destination.
    :param _builtins.str region: Specifies the region in which to query the resource.
           If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the route type.
    :param _builtins.str vpc_id: Specifies the ID of the VPC to which the route belongs.
    """
    __args__ = dict()
    __args__['destination'] = destination
    __args__['region'] = region
    __args__['type'] = type
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getRoutes:getRoutes', __args__, opts=opts, typ=GetRoutesResult)
    return __ret__.apply(lambda __response__: GetRoutesResult(
        destination=pulumi.get(__response__, 'destination'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        routes=pulumi.get(__response__, 'routes'),
        type=pulumi.get(__response__, 'type'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
