# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSecgroupsResult',
    'AwaitableGetSecgroupsResult',
    'get_secgroups',
    'get_secgroups_output',
]

@pulumi.output_type
class GetSecgroupsResult:
    """
    A collection of values returned by getSecgroups.
    """
    def __init__(__self__, description=None, enterprise_project_id=None, id=None, name=None, region=None, security_groups=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of the security group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project ID of the security group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The security group ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the security group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence['outputs.GetSecgroupsSecurityGroupResult']:
        """
        The list of security groups. The object is documented below.
        """
        return pulumi.get(self, "security_groups")


class AwaitableGetSecgroupsResult(GetSecgroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecgroupsResult(
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            security_groups=self.security_groups)


def get_secgroups(description: Optional[_builtins.str] = None,
                  enterprise_project_id: Optional[_builtins.str] = None,
                  id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecgroupsResult:
    """
    Use this data source to get the list of the available SberCloud security groups.

    ## Example Usage

    ### Filter the list of security groups by a description keyword

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    key_word = config.require_object("keyWord")
    test = sbercloud.Vpc.get_secgroups(description=key_word)
    ```


    :param _builtins.str description: Specifies the description of the security group. The security groups can be
           filtered by keywords in the description.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the security group.
    :param _builtins.str id: Specifies the id of the desired security group.
    :param _builtins.str name: Specifies the name of the security group.
    :param _builtins.str region: Specifies the region in which to obtain the security group list.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getSecgroups:getSecgroups', __args__, opts=opts, typ=GetSecgroupsResult).value

    return AwaitableGetSecgroupsResult(
        description=pulumi.get(__ret__, 'description'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        security_groups=pulumi.get(__ret__, 'security_groups'))
def get_secgroups_output(description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecgroupsResult]:
    """
    Use this data source to get the list of the available SberCloud security groups.

    ## Example Usage

    ### Filter the list of security groups by a description keyword

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    key_word = config.require_object("keyWord")
    test = sbercloud.Vpc.get_secgroups(description=key_word)
    ```


    :param _builtins.str description: Specifies the description of the security group. The security groups can be
           filtered by keywords in the description.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the security group.
    :param _builtins.str id: Specifies the id of the desired security group.
    :param _builtins.str name: Specifies the name of the security group.
    :param _builtins.str region: Specifies the region in which to obtain the security group list.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getSecgroups:getSecgroups', __args__, opts=opts, typ=GetSecgroupsResult)
    return __ret__.apply(lambda __response__: GetSecgroupsResult(
        description=pulumi.get(__response__, 'description'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        security_groups=pulumi.get(__response__, 'security_groups')))
