# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubnetIdsResult',
    'AwaitableGetSubnetIdsResult',
    'get_subnet_ids',
    'get_subnet_ids_output',
]

@pulumi.output_type
class GetSubnetIdsResult:
    """
    A collection of values returned by getSubnetIds.
    """
    def __init__(__self__, id=None, ids=None, region=None, vpc_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A set of all the subnet ids found. This data source will fail if none are found.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetSubnetIdsResult(GetSubnetIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetIdsResult(
            id=self.id,
            ids=self.ids,
            region=self.region,
            vpc_id=self.vpc_id)


def get_subnet_ids(region: Optional[_builtins.str] = None,
                   vpc_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetIdsResult:
    """
    This resource can be useful for getting back a list of subnet ids for a vpc.

    ## Example Usage

    The following example shows outputing all cidr blocks for every subnet id in a vpc.

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    subnet_ids = sbercloud.Vpc.get_subnet_ids(vpc_id=vpc_id)
    subnet = [sbercloud.Vpc.get_subnet(id=subnet_ids.ids[__index]) for __index in len(subnet_ids.ids).apply(lambda length: range(length))]
    pulumi.export("subnetCidrBlocks", subnet.apply(lambda subnet: [f"{s.name}: {s.id}: {s.cidr}" for s in subnet]))
    ```


    :param _builtins.str region: The region in which to obtain the subnet ids. If omitted, the provider-level region will
           be used.
    :param _builtins.str vpc_id: Specifies the VPC ID used as the query filter.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getSubnetIds:getSubnetIds', __args__, opts=opts, typ=GetSubnetIdsResult).value

    return AwaitableGetSubnetIdsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        region=pulumi.get(__ret__, 'region'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_subnet_ids_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetIdsResult]:
    """
    This resource can be useful for getting back a list of subnet ids for a vpc.

    ## Example Usage

    The following example shows outputing all cidr blocks for every subnet id in a vpc.

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    subnet_ids = sbercloud.Vpc.get_subnet_ids(vpc_id=vpc_id)
    subnet = [sbercloud.Vpc.get_subnet(id=subnet_ids.ids[__index]) for __index in len(subnet_ids.ids).apply(lambda length: range(length))]
    pulumi.export("subnetCidrBlocks", subnet.apply(lambda subnet: [f"{s.name}: {s.id}: {s.cidr}" for s in subnet]))
    ```


    :param _builtins.str region: The region in which to obtain the subnet ids. If omitted, the provider-level region will
           be used.
    :param _builtins.str vpc_id: Specifies the VPC ID used as the query filter.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getSubnetIds:getSubnetIds', __args__, opts=opts, typ=GetSubnetIdsResult)
    return __ret__.apply(lambda __response__: GetSubnetIdsResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        region=pulumi.get(__response__, 'region'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
