# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcResult',
    'AwaitableGetVpcResult',
    'get_vpc',
    'get_vpc_output',
]

@pulumi.output_type
class GetVpcResult:
    """
    A collection of values returned by getVpc.
    """
    def __init__(__self__, cidr=None, description=None, enterprise_project_id=None, id=None, name=None, region=None, routes=None, secondary_cidrs=None, status=None, tags=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if secondary_cidrs and not isinstance(secondary_cidrs, list):
            raise TypeError("Expected argument 'secondary_cidrs' to be a list")
        pulumi.set(__self__, "secondary_cidrs", secondary_cidrs)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The supplementary information about the VPC. The value is a string of
        no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""use huaweicloud_vpc_route_table data source to get all routes""")
    def routes(self) -> Sequence['outputs.GetVpcRouteResult']:
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrs")
    def secondary_cidrs(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "secondary_cidrs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The key/value pairs to associate with the VPC.
        """
        return pulumi.get(self, "tags")


class AwaitableGetVpcResult(GetVpcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcResult(
            cidr=self.cidr,
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            routes=self.routes,
            secondary_cidrs=self.secondary_cidrs,
            status=self.status,
            tags=self.tags)


def get_vpc(cidr: Optional[_builtins.str] = None,
            enterprise_project_id: Optional[_builtins.str] = None,
            id: Optional[_builtins.str] = None,
            name: Optional[_builtins.str] = None,
            region: Optional[_builtins.str] = None,
            status: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcResult:
    """
    sbercloud_vpc provides details about a specific VPC.

    This resource can prove useful when a module accepts a vpc id as an input variable and needs to, for example, determine the CIDR block of that VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    vpc_name = config.require_object("vpcName")
    vpc = sbercloud.Vpc.get_vpc(name=vpc_name)
    ```


    :param _builtins.str cidr: Specifies the cidr block of the desired VPC.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired VPC belongs to.
    :param _builtins.str id: Specifies the id of the VPC to retrieve.
    :param _builtins.str name: Specifies an unique name for the VPC. The value is a string of no more than 64 characters
           and can contain digits, letters, underscores (_), and hyphens (-).
    :param _builtins.str region: Specifies the region in which to obtain the VPC. If omitted, the provider-level region
           will be used.
    :param _builtins.str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
    """
    __args__ = dict()
    __args__['cidr'] = cidr
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getVpc:getVpc', __args__, opts=opts, typ=GetVpcResult).value

    return AwaitableGetVpcResult(
        cidr=pulumi.get(__ret__, 'cidr'),
        description=pulumi.get(__ret__, 'description'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        routes=pulumi.get(__ret__, 'routes'),
        secondary_cidrs=pulumi.get(__ret__, 'secondary_cidrs'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_vpc_output(cidr: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcResult]:
    """
    sbercloud_vpc provides details about a specific VPC.

    This resource can prove useful when a module accepts a vpc id as an input variable and needs to, for example, determine the CIDR block of that VPC.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    vpc_name = config.require_object("vpcName")
    vpc = sbercloud.Vpc.get_vpc(name=vpc_name)
    ```


    :param _builtins.str cidr: Specifies the cidr block of the desired VPC.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired VPC belongs to.
    :param _builtins.str id: Specifies the id of the VPC to retrieve.
    :param _builtins.str name: Specifies an unique name for the VPC. The value is a string of no more than 64 characters
           and can contain digits, letters, underscores (_), and hyphens (-).
    :param _builtins.str region: Specifies the region in which to obtain the VPC. If omitted, the provider-level region
           will be used.
    :param _builtins.str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
    """
    __args__ = dict()
    __args__['cidr'] = cidr
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getVpc:getVpc', __args__, opts=opts, typ=GetVpcResult)
    return __ret__.apply(lambda __response__: GetVpcResult(
        cidr=pulumi.get(__response__, 'cidr'),
        description=pulumi.get(__response__, 'description'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        routes=pulumi.get(__response__, 'routes'),
        secondary_cidrs=pulumi.get(__response__, 'secondary_cidrs'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
