# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcsResult',
    'AwaitableGetVpcsResult',
    'get_vpcs',
    'get_vpcs_output',
]

@pulumi.output_type
class GetVpcsResult:
    """
    A collection of values returned by getVpcs.
    """
    def __init__(__self__, cidr=None, enterprise_project_id=None, id=None, name=None, region=None, status=None, tags=None, vpcs=None):
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if vpcs and not isinstance(vpcs, list):
            raise TypeError("Expected argument 'vpcs' to be a list")
        pulumi.set(__self__, "vpcs", vpcs)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> Optional[_builtins.str]:
        """
        Indicates the cidr block of the VPC.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        Indicates the the enterprise project ID of the VPC.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Indicates the ID of the VPC.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the name of the VPC.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Indicates the current status of the VPC.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Indicates the key/value pairs which associated with the VPC.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def vpcs(self) -> Sequence['outputs.GetVpcsVpcResult']:
        """
        Indicates a list of all VPCs found. Structure is documented below.
        """
        return pulumi.get(self, "vpcs")


class AwaitableGetVpcsResult(GetVpcsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcsResult(
            cidr=self.cidr,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            status=self.status,
            tags=self.tags,
            vpcs=self.vpcs)


def get_vpcs(cidr: Optional[_builtins.str] = None,
             enterprise_project_id: Optional[_builtins.str] = None,
             id: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             region: Optional[_builtins.str] = None,
             status: Optional[_builtins.str] = None,
             tags: Optional[Mapping[str, _builtins.str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcsResult:
    """
    Use this data source to get a list of VPC.


    :param _builtins.str cidr: Specifies the cidr block of the desired VPC.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired VPC belongs to.
    :param _builtins.str id: Specifies the id of the desired VPC.
    :param _builtins.str name: Specifies the name of the desired VPC. The value is a string of no more than 64 characters
           and can contain digits, letters, underscores (_) and hyphens (-).
    :param _builtins.str region: Specifies the region in which to obtain the VPC. If omitted, the provider-level region
           will be used.
    :param _builtins.str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
    :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired VPC.
           
           > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
           The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
           tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
           The values are in the OR relationship.
    """
    __args__ = dict()
    __args__['cidr'] = cidr
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Vpc/getVpcs:getVpcs', __args__, opts=opts, typ=GetVpcsResult).value

    return AwaitableGetVpcsResult(
        cidr=pulumi.get(__ret__, 'cidr'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        vpcs=pulumi.get(__ret__, 'vpcs'))
def get_vpcs_output(cidr: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcsResult]:
    """
    Use this data source to get a list of VPC.


    :param _builtins.str cidr: Specifies the cidr block of the desired VPC.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired VPC belongs to.
    :param _builtins.str id: Specifies the id of the desired VPC.
    :param _builtins.str name: Specifies the name of the desired VPC. The value is a string of no more than 64 characters
           and can contain digits, letters, underscores (_) and hyphens (-).
    :param _builtins.str region: Specifies the region in which to obtain the VPC. If omitted, the provider-level region
           will be used.
    :param _builtins.str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
    :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired VPC.
           
           > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
           The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
           tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
           The values are in the OR relationship.
    """
    __args__ = dict()
    __args__['cidr'] = cidr
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Vpc/getVpcs:getVpcs', __args__, opts=opts, typ=GetVpcsResult)
    return __ret__.apply(lambda __response__: GetVpcsResult(
        cidr=pulumi.get(__response__, 'cidr'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        vpcs=pulumi.get(__response__, 'vpcs')))
