# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AddressGroupIpExtraSet',
    'BandwidthPublicip',
    'EipBandwidth',
    'EipPublicip',
    'RouteTableRoute',
    'SecgroupRule',
    'VpcRoute',
    'GetAddressGroupsAddressGroupResult',
    'GetAddressGroupsAddressGroupIpExtraSetResult',
    'GetRouteTableRouteResult',
    'GetRoutesRouteResult',
    'GetSecgroupRuleResult',
    'GetSecgroupsSecurityGroupResult',
    'GetSubnetsSubnetResult',
    'GetVpcRouteResult',
    'GetVpcsVpcResult',
]

@pulumi.output_type
class AddressGroupIpExtraSet(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 remarks: Optional[_builtins.str] = None):
        pulumi.set(__self__, "ip", ip)
        if remarks is not None:
            pulumi.set(__self__, "remarks", remarks)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "remarks")


@pulumi.output_type
class BandwidthPublicip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipVersion":
            suggest = "ip_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BandwidthPublicip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BandwidthPublicip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BandwidthPublicip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 ip_version: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the EIP or IPv6 port that uses the bandwidth.
        :param _builtins.str ip_address: The IPv4 or IPv6 address.
        :param _builtins.int ip_version: The IP version, either 4 or 6.
        :param _builtins.str type: The EIP type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the EIP or IPv6 port that uses the bandwidth.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.int]:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The EIP type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EipBandwidth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareType":
            suggest = "share_type"
        elif key == "chargeMode":
            suggest = "charge_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EipBandwidth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EipBandwidth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EipBandwidth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_type: _builtins.str,
                 charge_mode: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str share_type: Whether the bandwidth is dedicated or shared. Changing this creates a new
               eip. Possible values are as follows:
               + *PER*: Dedicated bandwidth
               + *WHOLE*: Shared bandwidth
        :param _builtins.str charge_mode: Specifies whether the bandwidth is billed by traffic or by bandwidth
               size. The value can be *traffic* or *bandwidth*. Changing this creates a new eip.
        :param _builtins.str id: The shared bandwidth id. This parameter is mandatory when
               `share_type` is set to *WHOLE*. Changing this creates a new eip.
        :param _builtins.str name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to *PER*.
        :param _builtins.int size: The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
               when `share_type` is set to *PER*.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        Whether the bandwidth is dedicated or shared. Changing this creates a new
        eip. Possible values are as follows:
        + *PER*: Dedicated bandwidth
        + *WHOLE*: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[_builtins.str]:
        """
        Specifies whether the bandwidth is billed by traffic or by bandwidth
        size. The value can be *traffic* or *bandwidth*. Changing this creates a new eip.
        """
        return pulumi.get(self, "charge_mode")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The shared bandwidth id. This parameter is mandatory when
        `share_type` is set to *WHOLE*. Changing this creates a new eip.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to *PER*.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
        when `share_type` is set to *PER*.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class EipPublicip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "portId":
            suggest = "port_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EipPublicip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EipPublicip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EipPublicip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[_builtins.str] = None,
                 ip_version: Optional[_builtins.int] = None,
                 port_id: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_address: The value must be a valid IP address in the available IP address segment.
               Changing this creates a new eip.
        :param _builtins.int ip_version: The IP version.
        :param _builtins.str port_id: The port id which this eip will associate with. If the value is "" or this not
               specified, the eip will be in unbind state.
        :param _builtins.str type: The type of the eip. Changing this creates a new eip.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The value must be a valid IP address in the available IP address segment.
        Changing this creates a new eip.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[_builtins.int]:
        """
        The IP version.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[_builtins.str]:
        """
        The port id which this eip will associate with. If the value is "" or this not
        specified, the eip will be in unbind state.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the eip. Changing this creates a new eip.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RouteTableRoute(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 nexthop: _builtins.str,
                 type: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination: Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
               with any subnet in the VPC.
        :param _builtins.str nexthop: Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param _builtins.str type: Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param _builtins.str description: Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
        with any subnet in the VPC.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> _builtins.str:
        """
        Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        return pulumi.get(self, "nexthop")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class SecgroupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portRangeMax":
            suggest = "port_range_max"
        elif key == "portRangeMin":
            suggest = "port_range_min"
        elif key == "remoteAddressGroupId":
            suggest = "remote_address_group_id"
        elif key == "remoteGroupId":
            suggest = "remote_group_id"
        elif key == "remoteIpPrefix":
            suggest = "remote_ip_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecgroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecgroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecgroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 direction: Optional[_builtins.str] = None,
                 ethertype: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 port_range_max: Optional[_builtins.int] = None,
                 port_range_min: Optional[_builtins.int] = None,
                 ports: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 protocol: Optional[_builtins.str] = None,
                 remote_address_group_id: Optional[_builtins.str] = None,
                 remote_group_id: Optional[_builtins.str] = None,
                 remote_ip_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: The effective policy.
        :param _builtins.str description: Description of the security group.
        :param _builtins.str direction: The direction of the rule. The value can be *egress* or *ingress*.
        :param _builtins.str ethertype: The IP protocol version. The value can be *IPv4* or *IPv6*.
        :param _builtins.str id: The security group rule ID.
        :param _builtins.int port_range_max: schema: Deprecated
        :param _builtins.int port_range_min: schema: Deprecated
        :param _builtins.str ports: The port value range.
        :param _builtins.int priority: The priority number.
        :param _builtins.str protocol: The protocol type.
        :param _builtins.str remote_address_group_id: The ID of the remote address group.
        :param _builtins.str remote_group_id: The ID of the peer security group.
        :param _builtins.str remote_ip_prefix: The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ethertype is not None:
            pulumi.set(__self__, "ethertype", ethertype)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port_range_max is not None:
            pulumi.set(__self__, "port_range_max", port_range_max)
        if port_range_min is not None:
            pulumi.set(__self__, "port_range_min", port_range_min)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_address_group_id is not None:
            pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        if remote_group_id is not None:
            pulumi.set(__self__, "remote_group_id", remote_group_id)
        if remote_ip_prefix is not None:
            pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The effective policy.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        Description of the security group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[_builtins.str]:
        """
        The direction of the rule. The value can be *egress* or *ingress*.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def ethertype(self) -> Optional[_builtins.str]:
        """
        The IP protocol version. The value can be *IPv4* or *IPv6*.
        """
        return pulumi.get(self, "ethertype")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> Optional[_builtins.int]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "port_range_max")

    @_builtins.property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> Optional[_builtins.int]:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "port_range_min")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[_builtins.str]:
        """
        The port value range.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority number.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the remote address group.
        """
        return pulumi.get(self, "remote_address_group_id")

    @_builtins.property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of the peer security group.
        """
        return pulumi.get(self, "remote_group_id")

    @_builtins.property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> Optional[_builtins.str]:
        """
        The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        return pulumi.get(self, "remote_ip_prefix")


@pulumi.output_type
class VpcRoute(dict):
    def __init__(__self__, *,
                 destination: Optional[_builtins.str] = None,
                 nexthop: Optional[_builtins.str] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "nexthop")


@pulumi.output_type
class GetAddressGroupsAddressGroupResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence[_builtins.str],
                 created_at: _builtins.str,
                 description: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 id: _builtins.str,
                 ip_extra_sets: Sequence['outputs.GetAddressGroupsAddressGroupIpExtraSetResult'],
                 ip_version: _builtins.int,
                 max_capacity: _builtins.int,
                 name: _builtins.str,
                 status: _builtins.str,
                 status_message: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param Sequence[_builtins.str] addresses: IP address sets in an IP address group.
               Value range: a single IP address, IP address range, or CIDR block.
        :param _builtins.str created_at: Time when the IP address group is created.
        :param _builtins.str description: Provides supplementary information about an IP address group,
               which can be used to filter the IP address group.
        :param _builtins.str enterprise_project_id: Enterprise project ID.
        :param _builtins.str id: IP address group ID, which uniquely identifies the IP address group.
        :param Sequence['GetAddressGroupsAddressGroupIpExtraSetArgs'] ip_extra_sets: IP addresses and their remarks in an IP address group.
        :param _builtins.int ip_version: Version of IP addresses in an IP address group,
               which can be used to filter the IP address group.
        :param _builtins.int max_capacity: Maximum number of entries in an address group,
               which limits the number of addresses that can be contained in an address group.
        :param _builtins.str name: Name of an IP address group, which can be used to filter the IP address group.
        :param _builtins.str status: The status of IP address group.
               Valid values are:
               + `NORMAL`: normal status.
               + `UPDATING`: updating.
               + `UPDATE_FAILED`: update failed.
               When the status of IP address group is `UPDATING`, the IP address group cannot be updated again.
        :param _builtins.str status_message: The status details of IP address group.
        :param _builtins.str updated_at: Time when the IP address group was last updated.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_extra_sets", ip_extra_sets)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Sequence[_builtins.str]:
        """
        IP address sets in an IP address group.
        Value range: a single IP address, IP address range, or CIDR block.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Time when the IP address group is created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Provides supplementary information about an IP address group,
        which can be used to filter the IP address group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        IP address group ID, which uniquely identifies the IP address group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipExtraSets")
    def ip_extra_sets(self) -> Sequence['outputs.GetAddressGroupsAddressGroupIpExtraSetResult']:
        """
        IP addresses and their remarks in an IP address group.
        """
        return pulumi.get(self, "ip_extra_sets")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.int:
        """
        Version of IP addresses in an IP address group,
        which can be used to filter the IP address group.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> _builtins.int:
        """
        Maximum number of entries in an address group,
        which limits the number of addresses that can be contained in an address group.
        """
        return pulumi.get(self, "max_capacity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of an IP address group, which can be used to filter the IP address group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of IP address group.
        Valid values are:
        + `NORMAL`: normal status.
        + `UPDATING`: updating.
        + `UPDATE_FAILED`: update failed.
        When the status of IP address group is `UPDATING`, the IP address group cannot be updated again.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> _builtins.str:
        """
        The status details of IP address group.
        """
        return pulumi.get(self, "status_message")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Time when the IP address group was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetAddressGroupsAddressGroupIpExtraSetResult(dict):
    def __init__(__self__, *,
                 ip: _builtins.str,
                 remarks: _builtins.str):
        """
        :param _builtins.str ip: An IP address, IP address range, or CIDR block.
        :param _builtins.str remarks: Provides supplementary information about the IP address, IP address range, or CIDR block.
        """
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "remarks", remarks)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        An IP address, IP address range, or CIDR block.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def remarks(self) -> _builtins.str:
        """
        Provides supplementary information about the IP address, IP address range, or CIDR block.
        """
        return pulumi.get(self, "remarks")


@pulumi.output_type
class GetRouteTableRouteResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 destination: _builtins.str,
                 nexthop: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str description: (String) - The description about the route.
        :param _builtins.str destination: (String) - The destination address in the CIDR notation format
        :param _builtins.str nexthop: (String) - The next hop.
        :param _builtins.str type: (String) - The route type.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (String) - The description about the route.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        (String) - The destination address in the CIDR notation format
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> _builtins.str:
        """
        (String) - The next hop.
        """
        return pulumi.get(self, "nexthop")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        (String) - The route type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRoutesRouteResult(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 id: _builtins.str,
                 nexthop: _builtins.str,
                 type: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str destination: Specifies the route destination.
        :param _builtins.str id: The route ID.
        :param _builtins.str nexthop: The next hop of the route.
        :param _builtins.str type: Specifies the route type.
        :param _builtins.str vpc_id: Specifies the ID of the VPC to which the route belongs.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        Specifies the route destination.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The route ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> _builtins.str:
        """
        The next hop of the route.
        """
        return pulumi.get(self, "nexthop")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the route type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Specifies the ID of the VPC to which the route belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetSecgroupRuleResult(dict):
    def __init__(__self__, *,
                 action: _builtins.str,
                 description: _builtins.str,
                 direction: _builtins.str,
                 ethertype: _builtins.str,
                 id: _builtins.str,
                 port_range_max: _builtins.int,
                 port_range_min: _builtins.int,
                 ports: _builtins.str,
                 priority: _builtins.int,
                 protocol: _builtins.str,
                 remote_address_group_id: _builtins.str,
                 remote_group_id: _builtins.str,
                 remote_ip_prefix: _builtins.str):
        """
        :param _builtins.str action: The effective policy.
        :param _builtins.str description: The supplementary information about the security group rule.
        :param _builtins.str direction: The direction of the rule. The value can be *egress* or *ingress*.
        :param _builtins.str ethertype: The IP protocol version. The value can be *IPv4* or *IPv6*.
        :param _builtins.str id: The security group rule ID.
        :param _builtins.int port_range_max: schema: Deprecated
        :param _builtins.int port_range_min: schema: Deprecated
        :param _builtins.str ports: The port value range.
        :param _builtins.int priority: The priority number.
        :param _builtins.str protocol: The protocol type.
        :param _builtins.str remote_address_group_id: The ID of the remote address group.
        :param _builtins.str remote_group_id: The ID of the peer security group.
        :param _builtins.str remote_ip_prefix: The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "ethertype", ethertype)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port_range_max", port_range_max)
        pulumi.set(__self__, "port_range_min", port_range_min)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        pulumi.set(__self__, "remote_group_id", remote_group_id)
        pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)

    @_builtins.property
    @pulumi.getter
    def action(self) -> _builtins.str:
        """
        The effective policy.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The supplementary information about the security group rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> _builtins.str:
        """
        The direction of the rule. The value can be *egress* or *ingress*.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter
    def ethertype(self) -> _builtins.str:
        """
        The IP protocol version. The value can be *IPv4* or *IPv6*.
        """
        return pulumi.get(self, "ethertype")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> _builtins.int:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "port_range_max")

    @_builtins.property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> _builtins.int:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "port_range_min")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> _builtins.str:
        """
        The port value range.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> _builtins.int:
        """
        The priority number.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> _builtins.str:
        """
        The ID of the remote address group.
        """
        return pulumi.get(self, "remote_address_group_id")

    @_builtins.property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> _builtins.str:
        """
        The ID of the peer security group.
        """
        return pulumi.get(self, "remote_group_id")

    @_builtins.property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> _builtins.str:
        """
        The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        return pulumi.get(self, "remote_ip_prefix")


@pulumi.output_type
class GetSecgroupsSecurityGroupResult(dict):
    def __init__(__self__, *,
                 created_at: _builtins.str,
                 description: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 updated_at: _builtins.str):
        """
        :param _builtins.str created_at: The creation time, in UTC format.
        :param _builtins.str description: Specifies the description of the security group. The security groups can be
               filtered by keywords in the description.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project ID of the security group.
        :param _builtins.str id: Specifies the id of the desired security group.
        :param _builtins.str name: Specifies the name of the security group.
        :param _builtins.str updated_at: The last update time, in UTC format.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The creation time, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Specifies the description of the security group. The security groups can be
        filtered by keywords in the description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project ID of the security group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Specifies the id of the desired security group.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the security group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The last update time, in UTC format.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetSubnetsSubnetResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 cidr: _builtins.str,
                 description: _builtins.str,
                 dhcp_enable: _builtins.bool,
                 dns_lists: Sequence[_builtins.str],
                 gateway_ip: _builtins.str,
                 id: _builtins.str,
                 ipv4_subnet_id: _builtins.str,
                 ipv6_cidr: _builtins.str,
                 ipv6_enable: _builtins.bool,
                 ipv6_gateway: _builtins.str,
                 ipv6_subnet_id: _builtins.str,
                 name: _builtins.str,
                 primary_dns: _builtins.str,
                 secondary_dns: _builtins.str,
                 status: _builtins.str,
                 subnet_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 vpc_id: _builtins.str):
        """
        :param _builtins.str availability_zone: Specifies the availability zone (AZ) to which the desired subnet belongs to.
        :param _builtins.str cidr: Specifies the network segment of desired subnet. The value must be in CIDR format.
        :param _builtins.str gateway_ip: Specifies the subnet gateway address of desired subnet.
        :param _builtins.str id: Specifies the id of the desired subnet.
        :param _builtins.str name: Specifies the name of the desired subnet.
        :param _builtins.str primary_dns: Specifies the IP address of DNS server 1 on the desired subnet.
        :param _builtins.str secondary_dns: Specifies the IP address of DNS server 2 on the desired subnet.
        :param _builtins.str status: Specifies the current status of the desired subnet.
               the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
        :param _builtins.str subnet_id: schema: Deprecated
        :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired subnet.
               
               > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
               The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
               tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
               The values are in the OR relationship.
        :param _builtins.str vpc_id: Specifies the id of the VPC that the desired subnet belongs to.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dhcp_enable", dhcp_enable)
        pulumi.set(__self__, "dns_lists", dns_lists)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        pulumi.set(__self__, "ipv6_cidr", ipv6_cidr)
        pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        pulumi.set(__self__, "ipv6_subnet_id", ipv6_subnet_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_dns", primary_dns)
        pulumi.set(__self__, "secondary_dns", secondary_dns)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Specifies the availability zone (AZ) to which the desired subnet belongs to.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        Specifies the network segment of desired subnet. The value must be in CIDR format.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> _builtins.bool:
        return pulumi.get(self, "dhcp_enable")

    @_builtins.property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "dns_lists")

    @_builtins.property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> _builtins.str:
        """
        Specifies the subnet gateway address of desired subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Specifies the id of the desired subnet.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "ipv4_subnet_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Cidr")
    def ipv6_cidr(self) -> _builtins.str:
        return pulumi.get(self, "ipv6_cidr")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> _builtins.bool:
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> _builtins.str:
        return pulumi.get(self, "ipv6_gateway")

    @_builtins.property
    @pulumi.getter(name="ipv6SubnetId")
    def ipv6_subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "ipv6_subnet_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the desired subnet.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> _builtins.str:
        """
        Specifies the IP address of DNS server 1 on the desired subnet.
        """
        return pulumi.get(self, "primary_dns")

    @_builtins.property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> _builtins.str:
        """
        Specifies the IP address of DNS server 2 on the desired subnet.
        """
        return pulumi.get(self, "secondary_dns")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the current status of the desired subnet.
        the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        schema: Deprecated
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Specifies the included key/value pairs which associated with the desired subnet.

        > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
        The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
        tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
        The values are in the OR relationship.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        Specifies the id of the VPC that the desired subnet belongs to.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetVpcRouteResult(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 nexthop: _builtins.str):
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def nexthop(self) -> _builtins.str:
        return pulumi.get(self, "nexthop")


@pulumi.output_type
class GetVpcsVpcResult(dict):
    def __init__(__self__, *,
                 cidr: _builtins.str,
                 description: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 secondary_cidrs: Sequence[_builtins.str],
                 status: _builtins.str,
                 tags: Mapping[str, _builtins.str]):
        """
        :param _builtins.str cidr: Specifies the cidr block of the desired VPC.
        :param _builtins.str description: Indicates the description of the VPC.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project ID which the desired VPC belongs to.
        :param _builtins.str id: Specifies the id of the desired VPC.
        :param _builtins.str name: Specifies the name of the desired VPC. The value is a string of no more than 64 characters
               and can contain digits, letters, underscores (_) and hyphens (-).
        :param _builtins.str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
        :param Mapping[str, _builtins.str] tags: Specifies the included key/value pairs which associated with the desired VPC.
               
               > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
               The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
               tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
               The values are in the OR relationship.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secondary_cidrs", secondary_cidrs)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        """
        Specifies the cidr block of the desired VPC.
        """
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Indicates the description of the VPC.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project ID which the desired VPC belongs to.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Specifies the id of the desired VPC.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the desired VPC. The value is a string of no more than 64 characters
        and can contain digits, letters, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secondaryCidrs")
    def secondary_cidrs(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "secondary_cidrs")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        Specifies the included key/value pairs which associated with the desired VPC.

        > A maximum of 10 tag keys are allowed for each query operation. Each tag key can have up to 10 tag values.
        The tag key cannot be left blank or set to an empty string. Each tag key must be unique, and each tag value in a
        tag must be unique, use commas(,) to separate the multiple values. An empty for values indicates any value.
        The values are in the OR relationship.
        """
        return pulumi.get(self, "tags")


