# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PeeringConnectionArgs', 'PeeringConnection']

@pulumi.input_type
class PeeringConnectionArgs:
    def __init__(__self__, *,
                 peer_vpc_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PeeringConnection resource.
        :param pulumi.Input[_builtins.str] peer_vpc_id: Specifies the VPC ID of the accepter tenant. Changing this creates a new
               VPC peering connection.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC involved in a VPC peering connection. Changing this
               creates a new VPC peering connection.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC peering connection. The value can contain 1 to 64
               characters.
        :param pulumi.Input[_builtins.str] peer_tenant_id: Specified the Tenant Id of the accepter tenant. Changing this creates
               a new VPC peering connection.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC peering connection. If omitted, the
               provider-level region will be used. Changing this creates a new VPC peering connection resource.
        """
        pulumi.set(__self__, "peer_vpc_id", peer_vpc_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_tenant_id is not None:
            pulumi.set(__self__, "peer_tenant_id", peer_tenant_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the VPC ID of the accepter tenant. Changing this creates a new
        VPC peering connection.
        """
        return pulumi.get(self, "peer_vpc_id")

    @peer_vpc_id.setter
    def peer_vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a VPC involved in a VPC peering connection. Changing this
        creates a new VPC peering connection.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC peering connection. The value can contain 1 to 64
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerTenantId")
    def peer_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified the Tenant Id of the accepter tenant. Changing this creates
        a new VPC peering connection.
        """
        return pulumi.get(self, "peer_tenant_id")

    @peer_tenant_id.setter
    def peer_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC peering connection. If omitted, the
        provider-level region will be used. Changing this creates a new VPC peering connection resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PeeringConnectionState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PeeringConnection resources.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC peering connection. The value can contain 1 to 64
               characters.
        :param pulumi.Input[_builtins.str] peer_tenant_id: Specified the Tenant Id of the accepter tenant. Changing this creates
               a new VPC peering connection.
        :param pulumi.Input[_builtins.str] peer_vpc_id: Specifies the VPC ID of the accepter tenant. Changing this creates a new
               VPC peering connection.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC peering connection. If omitted, the
               provider-level region will be used. Changing this creates a new VPC peering connection resource.
        :param pulumi.Input[_builtins.str] status: The VPC peering connection status. The value can be PENDING_ACCEPTANCE, REJECTED, EXPIRED, DELETED, or
               ACTIVE.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC involved in a VPC peering connection. Changing this
               creates a new VPC peering connection.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_tenant_id is not None:
            pulumi.set(__self__, "peer_tenant_id", peer_tenant_id)
        if peer_vpc_id is not None:
            pulumi.set(__self__, "peer_vpc_id", peer_vpc_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the VPC peering connection. The value can contain 1 to 64
        characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerTenantId")
    def peer_tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified the Tenant Id of the accepter tenant. Changing this creates
        a new VPC peering connection.
        """
        return pulumi.get(self, "peer_tenant_id")

    @peer_tenant_id.setter
    def peer_tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC ID of the accepter tenant. Changing this creates a new
        VPC peering connection.
        """
        return pulumi.get(self, "peer_vpc_id")

    @peer_vpc_id.setter
    def peer_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the VPC peering connection. If omitted, the
        provider-level region will be used. Changing this creates a new VPC peering connection resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC peering connection status. The value can be PENDING_ACCEPTANCE, REJECTED, EXPIRED, DELETED, or
        ACTIVE.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a VPC involved in a VPC peering connection. Changing this
        creates a new VPC peering connection.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Vpc/peeringConnection:PeeringConnection")
class PeeringConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to manage a VPC Peering Connection resource.

        > **NOTE:** For cross-tenant (requester's tenant differs from the accepter's tenant) VPC Peering Connections, use
        the `Vpc.PeeringConnection` resource to manage the requester's side of the connection and use
        the `Vpc.PeeringConnectionAccepter` resource to manage the accepter's side of the connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        peering = sbercloud.vpc.PeeringConnection("peering",
           name=peer_conn_name,
           vpc_id=vpc_id,
           peer_vpc_id=accepter_vpc_id)
        ```

        ## Notes

        If you create a VPC peering connection with another VPC of your own, the connection is created without the need for you
        to accept the connection.

        ## Import

        VPC Peering resources can be imported using the `vpc peering id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/peeringConnection:PeeringConnection test_connection 22b76469-08e3-4937-8c1d-7aad34892be1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC peering connection. The value can contain 1 to 64
               characters.
        :param pulumi.Input[_builtins.str] peer_tenant_id: Specified the Tenant Id of the accepter tenant. Changing this creates
               a new VPC peering connection.
        :param pulumi.Input[_builtins.str] peer_vpc_id: Specifies the VPC ID of the accepter tenant. Changing this creates a new
               VPC peering connection.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC peering connection. If omitted, the
               provider-level region will be used. Changing this creates a new VPC peering connection resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC involved in a VPC peering connection. Changing this
               creates a new VPC peering connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeeringConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage a VPC Peering Connection resource.

        > **NOTE:** For cross-tenant (requester's tenant differs from the accepter's tenant) VPC Peering Connections, use
        the `Vpc.PeeringConnection` resource to manage the requester's side of the connection and use
        the `Vpc.PeeringConnectionAccepter` resource to manage the accepter's side of the connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        peering = sbercloud.vpc.PeeringConnection("peering",
           name=peer_conn_name,
           vpc_id=vpc_id,
           peer_vpc_id=accepter_vpc_id)
        ```

        ## Notes

        If you create a VPC peering connection with another VPC of your own, the connection is created without the need for you
        to accept the connection.

        ## Import

        VPC Peering resources can be imported using the `vpc peering id`, e.g.

        ```sh
        $ pulumi import sbercloud:Vpc/peeringConnection:PeeringConnection test_connection 22b76469-08e3-4937-8c1d-7aad34892be1
        ```

        :param str resource_name: The name of the resource.
        :param PeeringConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeeringConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeeringConnectionArgs.__new__(PeeringConnectionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["peer_tenant_id"] = peer_tenant_id
            if peer_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_vpc_id'")
            __props__.__dict__["peer_vpc_id"] = peer_vpc_id
            __props__.__dict__["region"] = region
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["status"] = None
        super(PeeringConnection, __self__).__init__(
            'sbercloud:Vpc/peeringConnection:PeeringConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peer_tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            peer_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PeeringConnection':
        """
        Get an existing PeeringConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the VPC peering connection. The value can contain 1 to 64
               characters.
        :param pulumi.Input[_builtins.str] peer_tenant_id: Specified the Tenant Id of the accepter tenant. Changing this creates
               a new VPC peering connection.
        :param pulumi.Input[_builtins.str] peer_vpc_id: Specifies the VPC ID of the accepter tenant. Changing this creates a new
               VPC peering connection.
        :param pulumi.Input[_builtins.str] region: The region in which to create the VPC peering connection. If omitted, the
               provider-level region will be used. Changing this creates a new VPC peering connection resource.
        :param pulumi.Input[_builtins.str] status: The VPC peering connection status. The value can be PENDING_ACCEPTANCE, REJECTED, EXPIRED, DELETED, or
               ACTIVE.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC involved in a VPC peering connection. Changing this
               creates a new VPC peering connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeeringConnectionState.__new__(_PeeringConnectionState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_tenant_id"] = peer_tenant_id
        __props__.__dict__["peer_vpc_id"] = peer_vpc_id
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        return PeeringConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the VPC peering connection. The value can contain 1 to 64
        characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerTenantId")
    def peer_tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specified the Tenant Id of the accepter tenant. Changing this creates
        a new VPC peering connection.
        """
        return pulumi.get(self, "peer_tenant_id")

    @_builtins.property
    @pulumi.getter(name="peerVpcId")
    def peer_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the VPC ID of the accepter tenant. Changing this creates a new
        VPC peering connection.
        """
        return pulumi.get(self, "peer_vpc_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the VPC peering connection. If omitted, the
        provider-level region will be used. Changing this creates a new VPC peering connection resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC peering connection status. The value can be PENDING_ACCEPTANCE, REJECTED, EXPIRED, DELETED, or
        ACTIVE.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a VPC involved in a VPC peering connection. Changing this
        creates a new VPC peering connection.
        """
        return pulumi.get(self, "vpc_id")

